/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.virtual;

import com.tridium.bacnet.job.BacnetDiscoveryUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.point.BBacnetTuningPolicy;
import javax.baja.bacnet.point.BBacnetTuningPolicyMap;
import javax.baja.bacnet.virtual.BBacnetVirtualGateway;
import javax.baja.bacnet.virtual.BBacnetVirtualProperty;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.virtual.BVirtualComponent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetVirtualObject
extends BVirtualComponent
implements BacnetConst {
    private static final BFacets UNINITIALIZED_FACETS = BFacets.make((String)"initialized", (BIDataValue)BBoolean.FALSE);
    public static final Property objectId = BBacnetVirtualObject.newProperty((int)5, (BValue)BBacnetObjectIdentifier.DEFAULT, null);
    public static final Property facets = BBacnetVirtualObject.newProperty((int)0, (BValue)UNINITIALIZED_FACETS, null);
    public static final Property tuningPolicyName = BBacnetVirtualObject.newProperty((int)0, (String)"defaultPolicy", (BFacets)BFacets.make((String)"fieldEditor", (String)"bacnet:VirtualTuningPolicyNameFE"));
    public static final Property writePriority = BBacnetVirtualObject.newProperty((int)0, (int)-1, null);
    public static final Property prioritizedPoint = BBacnetVirtualObject.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE;
    private static Log log;
    static final String POLICY_DEF = "policy=";
    static final int POLICY_DEF_LEN = 7;
    static final String PRIORITY_DEF = "priority=";
    static final int PRIORITY_DEF_LEN = 9;
    private BBacnetTuningPolicy cachedPolicy;
    static /* synthetic */ Class class$javax$baja$bacnet$virtual$BBacnetVirtualObject;
    static /* synthetic */ Class class$javax$baja$bacnet$virtual$BBacnetVirtualProperty;

    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    public void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.set(objectId, (BValue)bBacnetObjectIdentifier, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets bFacets) {
        this.set(facets, (BValue)bFacets, null);
    }

    public String getTuningPolicyName() {
        return this.getString(tuningPolicyName);
    }

    public void setTuningPolicyName(String string) {
        this.setString(tuningPolicyName, string, null);
    }

    public int getWritePriority() {
        return this.getInt(writePriority);
    }

    public void setWritePriority(int n) {
        this.setInt(writePriority, n, null);
    }

    public boolean getPrioritizedPoint() {
        return this.getBoolean(prioritizedPoint);
    }

    public void setPrioritizedPoint(boolean bl) {
        this.setBoolean(prioritizedPoint, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String toString(Context context) {
        return this.getObjectId().toString(context);
    }

    public void started() throws Exception {
        this.discoverFacets();
    }

    public boolean isChildLegal(BComponent bComponent) {
        return bComponent instanceof BBacnetVirtualProperty;
    }

    public BBacnetDevice device() {
        if (this.getVirtualGateway() == null) {
            return null;
        }
        return ((BBacnetVirtualGateway)this.getVirtualGateway()).device();
    }

    /*
     * Unable to fully structure code
     */
    public void updateStatus() {
        var1_1 = this.getProperties();
        if (true) ** GOTO lbl5
        do {
            ((BBacnetVirtualProperty)var1_1.get()).updateStatus();
lbl5:
            // 2 sources

            if ((v0 = BBacnetVirtualObject.class$javax$baja$bacnet$virtual$BBacnetVirtualProperty) != null) continue;
            v0 = BBacnetVirtualObject.class("[Ljavax.baja.bacnet.virtual.BBacnetVirtualProperty;", false);
        } while (var1_1.next(v0));
    }

    public BBacnetTuningPolicy getPolicy() {
        if (this.cachedPolicy == null) {
            String string = this.getTuningPolicyName();
            BBacnetTuningPolicyMap bBacnetTuningPolicyMap = this.getPolicyMap();
            BValue bValue = bBacnetTuningPolicyMap.get(string);
            if (bValue instanceof BBacnetTuningPolicy) {
                this.cachedPolicy = (BBacnetTuningPolicy)bValue;
            } else {
                log.warning("TuningPolicy not found: " + string);
                this.cachedPolicy = (BBacnetTuningPolicy)bBacnetTuningPolicyMap.getDefaultPolicy();
            }
        }
        return this.cachedPolicy;
    }

    protected void discoverFacets() {
        this.network().postAsync(new Runnable(){

            public final void run() {
                HashMap hashMap = BacnetDiscoveryUtil.discoverFacets(BBacnetVirtualObject.this.getObjectId(), BBacnetVirtualObject.this.device());
                BBacnetVirtualObject.this.setFacets(BFacets.make((Map)hashMap));
                int n = BBacnetVirtualObject.this.getObjectId().getObjectType();
                if (n == 1 || n == 4 || n == 14) {
                    BBacnetVirtualObject.this.setPrioritizedPoint(true);
                } else if (n == 2 || n == 5 || n == 19) {
                    BBacnetVirtualObject.this.setPrioritizedPoint(BacnetDiscoveryUtil.checkForPriorityArray(BBacnetVirtualObject.this.getObjectId(), BBacnetVirtualObject.this.device()).getBoolean());
                }
            }
        });
    }

    private final BBacnetNetwork network() {
        return ((BBacnetVirtualGateway)this.getVirtualGateway()).network();
    }

    private final BBacnetTuningPolicyMap getPolicyMap() {
        BBacnetTuningPolicyMap bBacnetTuningPolicyMap = (BBacnetTuningPolicyMap)this.network().get("tuningPolicies");
        if (bBacnetTuningPolicyMap != null) {
            return bBacnetTuningPolicyMap;
        }
        throw new IllegalStateException("Network missing tuningPolicies property");
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetVirtualObject", 2);
        spyWriter.prop((Object)"cachedPolicy", (Object)this.cachedPolicy);
        spyWriter.endProps();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.cachedPolicy = null;
    }

    public BBacnetVirtualObject() {
        this.this();
    }

    public BBacnetVirtualObject(String string) {
        this.this();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            BBacnetObjectIdentifier bBacnetObjectIdentifier = (BBacnetObjectIdentifier)BBacnetObjectIdentifier.DEFAULT.decodeFromString(stringTokenizer.nextToken());
            this.setObjectId(bBacnetObjectIdentifier);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.startsWith(POLICY_DEF)) {
                    this.setTuningPolicyName(string2.substring(7));
                    continue;
                }
                if (!string2.startsWith(PRIORITY_DEF)) continue;
                try {
                    int n = Integer.parseInt(string2.substring(9));
                    this.setWritePriority(n);
                }
                catch (Exception exception) {
                    System.out.println("Invalid priority: " + string2 + " in virtualPathName for " + string);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static {
        Class clazz = class$javax$baja$bacnet$virtual$BBacnetVirtualObject;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$virtual$BBacnetVirtualObject = BBacnetVirtualObject.class("[Ljavax.baja.bacnet.virtual.BBacnetVirtualObject;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"bacnet.virtual");
    }
}

