/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.virtual;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.job.BacnetDiscoveryUtil;
import com.tridium.bacnet.stack.BBacnetPoll;
import com.tridium.bacnet.stack.transport.TransactionException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.point.BBacnetTuningPolicy;
import javax.baja.bacnet.point.BBacnetTuningPolicyMap;
import javax.baja.bacnet.util.BIBacnetPollable;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.bacnet.util.MetaDataContext;
import javax.baja.bacnet.util.PollListEntry;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.bacnet.virtual.BBacnetVirtualArray;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.log.Log;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.ByteArrayUtil;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.virtual.BVirtualComponentSpace;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetVirtualComponent
extends BVirtualComponent
implements BIBacnetPollable,
BacnetConst {
    public static final Property facets = BBacnetVirtualComponent.newProperty((int)0, (BValue)BFacets.NULL, null);
    public static final Action subscribe = BBacnetVirtualComponent.newAction((int)20, null);
    public static final Type TYPE;
    private static AsnInputStream asnIn;
    private static Log log;
    static final String USE_FACETS = "useFacets";
    static final String PROPERTY_ID = "propertyId";
    public static final String INDEX = "index";
    static final String POLICY_DEF = "policy=";
    static final int POLICY_DEF_LEN = 7;
    static final String PRIORITY_DEF = "priority=";
    static final int PRIORITY_DEF_LEN = 9;
    static final String STATUS_TAG = "status=";
    static final int STATUS_TAG_LEN = 7;
    static final String STATUS_SOURCE_FACET = "statusSrc";
    private BBacnetObjectIdentifier objectId;
    private String tpName;
    private BBacnetTuningPolicy cachedPolicy;
    private int writePriority;
    private PollListEntry[] ples;
    private Hashtable propsMap;
    private Hashtable propsStatusMap;
    private boolean isPollSubscribed;
    static /* synthetic */ Class class$javax$baja$bacnet$virtual$BBacnetVirtualComponent;
    static /* synthetic */ Class class$javax$baja$bacnet$util$PollListEntry;
    static /* synthetic */ Class class$javax$baja$status$BStatusValue;

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets bFacets) {
        this.set(facets, (BValue)bFacets, null);
    }

    public void subscribe() {
        this.invoke(subscribe, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doSubscribe() {
        BBacnetPoll bBacnetPoll = (BBacnetPoll)this.network().getPollService(this);
        bBacnetPoll.subscribe(this);
        this.isPollSubscribed = true;
    }

    public String toString(Context context) {
        return this.getName() + " (V)";
    }

    public boolean isChildLegal(BComponent bComponent) {
        return true;
    }

    public void stopped() throws Exception {
        super.stopped();
        BBacnetPoll bBacnetPoll = (BBacnetPoll)this.network().getPollService(this);
        bBacnetPoll.unsubscribe(this);
    }

    public void added(Property property, Context context) {
        if (log.isTraceOn()) {
            BBacnetVirtualComponent.d(this + ".added(): " + property.getName() + " [" + property + "] cx=" + context + (this.isSubscribed() ? " subscribed" : " unsubscribed") + (this.ples != null ? "  ples:" + this.ples.length : " ples=null"));
        }
        if (!this.isRunning()) {
            return;
        }
        if (this.isSubscribed()) {
            Array array = null;
            if (this.ples == null) {
                Class clazz = class$javax$baja$bacnet$util$PollListEntry;
                if (clazz == null) {
                    clazz = class$javax$baja$bacnet$util$PollListEntry = BBacnetVirtualComponent.class("[Ljavax.baja.bacnet.util.PollListEntry;", false);
                }
                array = new Array(clazz);
            } else {
                array = new Array((Object[])this.ples);
            }
            this.addPolledProperty(property, array);
            if (array.size() > 0) {
                this.ples = (PollListEntry[])array.trim();
            }
            if (!this.isPollSubscribed) {
                this.subscribe();
            }
        }
    }

    public void removed(Property property, BValue bValue, Context context) {
        if (log.isTraceOn()) {
            BBacnetVirtualComponent.d(this + ".removed(): " + property.getName() + " [" + property + "] ov=" + bValue + " cx=" + context + (this.isSubscribed() ? " subscribed" : " unsubscribed"));
        }
        if (!this.isRunning()) {
            return;
        }
        if (this.isSubscribed()) {
            Array array = null;
            if (this.ples == null) {
                Class clazz = class$javax$baja$bacnet$util$PollListEntry;
                if (clazz == null) {
                    clazz = class$javax$baja$bacnet$util$PollListEntry = BBacnetVirtualComponent.class("[Ljavax.baja.bacnet.util.PollListEntry;", false);
                }
                array = new Array(clazz);
            } else {
                array = new Array((Object[])this.ples);
            }
            this.removePolledProperty(property, bValue, array);
            this.ples = (PollListEntry[])array.trim();
        }
    }

    public void subscribed() {
        if (log.isTraceOn()) {
            BBacnetVirtualComponent.d(this + ".subscribed(): path=" + this.getSlotPathOrd());
        }
        this.network().postAsync(new Runnable(){

            public final void run() {
                HashMap hashMap = BacnetDiscoveryUtil.discoverFacets(BBacnetVirtualComponent.this.objectId, BBacnetVirtualComponent.this.device());
                BBacnetVirtualComponent.this.setFacets(BFacets.make((Map)hashMap));
            }
        });
        if (this.getPollListEntries() != null) {
            this.isPollSubscribed = true;
            this.subscribe();
        }
    }

    public void unsubscribed() {
        if (log.isTraceOn()) {
            BBacnetVirtualComponent.d(this + ".unsubscribed(): path=" + this.getSlotPathOrd());
        }
        BBacnetPoll bBacnetPoll = (BBacnetPoll)this.network().getPollService(this);
        bBacnetPoll.unsubscribe(this);
        this.ples = null;
        this.isPollSubscribed = false;
        this.propsMap.clear();
    }

    public void changed(Property property, Context context) {
        BInteger bInteger;
        super.changed(property, context);
        if (context == BacnetConst.noWrite) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        BFacets bFacets = property.getFacets();
        if (log.isTraceOn()) {
            BBacnetVirtualComponent.d("changed(" + property + ", " + context + ") on " + this + " prop facets=" + bFacets);
        }
        if ((bInteger = (BInteger)bFacets.getFacet(PROPERTY_ID)) != null) {
            BStatusValue bStatusValue;
            Object object;
            BValue bValue = this.get(property);
            int n = -1;
            if (bValue instanceof BBacnetVirtualArray && context != null && (object = (BInteger)context.getFacet(INDEX)) != null) {
                n = object.getInt();
                bValue = ((BBacnetVirtualArray)bValue).getElement(n);
            }
            object = null;
            PropertyInfo propertyInfo = this.device().getPropertyInfo(this.objectId.getObjectType(), bInteger.getInt());
            object = bValue instanceof BStatusValue ? ((bStatusValue = (BStatusValue)bValue).getStatus().isNull() ? (Object)AsnUtil.toAsnNull() : (propertyInfo != null ? (Object)AsnUtil.toAsn(propertyInfo.getAsnType(), bStatusValue.getValueValue()) : (Object)AsnUtil.toAsn(bValue))) : (propertyInfo != null ? (Object)AsnUtil.toAsn(propertyInfo.getAsnType(), bValue) : (Object)AsnUtil.toAsn(bValue));
            this.network().postWrite(new Write(bInteger.getInt(), n, (byte[])object, this.writePriority));
        }
    }

    protected BBacnetObjectIdentifier getObjectId() {
        return this.objectId;
    }

    public int getWritePriority() {
        return this.writePriority;
    }

    public BBacnetTuningPolicy getPolicy() {
        if (this.cachedPolicy == null) {
            BBacnetTuningPolicyMap bBacnetTuningPolicyMap = this.getPolicyMap();
            BValue bValue = bBacnetTuningPolicyMap.get(this.tpName);
            if (bValue instanceof BBacnetTuningPolicy) {
                this.cachedPolicy = (BBacnetTuningPolicy)bValue;
            } else {
                log.warning("TuningPolicy not found: " + this.tpName);
                this.cachedPolicy = (BBacnetTuningPolicy)bBacnetTuningPolicyMap.getDefaultPolicy();
            }
        }
        return this.cachedPolicy;
    }

    public BFacets getSlotFacets(Slot slot) {
        BFacets bFacets = slot.getFacets();
        BBoolean bBoolean = (BBoolean)bFacets.getFacet(USE_FACETS);
        if (bBoolean != null && bBoolean.getBoolean()) {
            BFacets bFacets2 = this.getFacets();
            if (bFacets2.equals((Object)BFacets.NULL)) {
                return bFacets;
            }
            return bFacets2;
        }
        return bFacets;
    }

    public static boolean isStatusProp(String string) {
        boolean bl = false;
        if (string.indexOf(STATUS_TAG) > 0) {
            bl = true;
        }
        return bl;
    }

    public static BString getStatusSource(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2 == null || !string2.startsWith(STATUS_TAG)) continue;
            stringBuffer.append(string2.substring(7)).append(';');
        }
        return BString.make((String)stringBuffer.toString());
    }

    /*
     * Unable to fully structure code
     */
    public void updateStatus() {
        var1_1 = this.device().getStatus();
        var2_2 = this.getProperties();
        if (true) ** GOTO lbl13
        do {
            var3_3 = (BStatusValue)var2_2.get();
            var4_4 = var3_3.getStatus().getBits();
            var5_5 = var3_3.getStatus().getBits();
            var5_5 = var1_1.isDisabled() ? (var5_5 |= 1) : (var5_5 &= -2);
            var5_5 = var1_1.isDown() ? (var5_5 |= 4) : (var5_5 &= -5);
            var5_5 = var1_1.isFault() ? (var5_5 |= 2) : (var5_5 &= -3);
            if (var4_4 != var5_5) {
                var3_3.setStatus(BStatus.make((int)var5_5));
            }
lbl13:
            // 4 sources

            if ((v0 = BBacnetVirtualComponent.class$javax$baja$status$BStatusValue) != null) continue;
            v0 = BBacnetVirtualComponent.class("[Ljavax.baja.status.BStatusValue;", false);
        } while (var2_2.next(v0));
    }

    public BPollFrequency getPollFrequency() {
        BBacnetTuningPolicy bBacnetTuningPolicy = this.getPolicy();
        if (bBacnetTuningPolicy != null) {
            return bBacnetTuningPolicy.getPollFrequency();
        }
        return BPollFrequency.normal;
    }

    public BBacnetDevice device() {
        return (BBacnetDevice)((BVirtualComponentSpace)this.getComponentSpace()).getVirtualGateway().getParent();
    }

    public int getPollableType() {
        return 3;
    }

    public boolean poll() {
        return false;
    }

    public void readFail(String string) {
        log.trace("readFail(" + string + ") on " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fromEncodedValue(byte[] byArray, BStatus bStatus, Context context) {
        if (log.isTraceOn()) {
            log.trace(this + ".fromEncodedValue:" + ByteArrayUtil.toHexString((byte[])byArray) + " status=" + bStatus + "  cx=" + context);
        }
        try {
            PollListEntry pollListEntry = (PollListEntry)context;
            Context context2 = context.getBase();
            if (context2 instanceof MetaDataContext) {
                this.readMetaData(byArray, context, (MetaDataContext)context2);
                return;
            }
            Property property = this.getProperty(pollListEntry.getPropertyId(), pollListEntry.getPropertyArrayIndex());
            if (property == null) {
                this.readFail("No property in virtual point for " + pollListEntry);
                ((BBacnetPoll)this.network().getPollService(this)).removePLE(this, pollListEntry);
                return;
            }
            BValue bValue = this.get(property);
            BStatusValue bStatusValue = null;
            if (bValue instanceof BStatusValue) {
                bStatusValue = (BStatusValue)bValue.newCopy();
            }
            AsnInputStream asnInputStream = asnIn;
            synchronized (asnInputStream) {
                this.setProp(property, byArray, bValue, bStatusValue, pollListEntry.getPropertyArrayIndex());
                SlotCursor slotCursor = this.getProperties();
                String string = property.getName();
                while (true) {
                    if (!slotCursor.next()) {
                        // MONITOREXIT @DISABLED, blocks:[0, 2, 5, 7] lbl30 : MonitorExitStatement: MONITOREXIT : var9_10
                        this.readOk(property, pollListEntry);
                        return;
                    }
                    if (!slotCursor.property().getName().startsWith(string)) continue;
                    bValue = (BValue)slotCursor.get();
                    bStatusValue = null;
                    if (bValue instanceof BStatusValue) {
                        bStatusValue = (BStatusValue)bValue.newCopy();
                    }
                    this.setProp(slotCursor.property(), byArray, bValue, bStatusValue, pollListEntry.getPropertyArrayIndex());
                }
            }
        }
        catch (AsnException asnException) {
            this.readFail(asnException.toString());
            if (!log.isTraceOn()) return;
            log.trace("Exception decoding value for " + this + ':' + (Object)((Object)asnException) + " ev=" + ByteArrayUtil.toHexString((byte[])byArray), (Throwable)((Object)asnException));
        }
    }

    public PollListEntry[] getPollListEntries() {
        if (!this.isRunning()) {
            return null;
        }
        if (this.ples == null) {
            Class clazz = class$javax$baja$bacnet$util$PollListEntry;
            if (clazz == null) {
                clazz = class$javax$baja$bacnet$util$PollListEntry = BBacnetVirtualComponent.class("[Ljavax.baja.bacnet.util.PollListEntry;", false);
            }
            Array array = new Array(clazz);
            SlotCursor slotCursor = this.getProperties();
            while (slotCursor.next()) {
                this.addPolledProperty(slotCursor.property(), array);
            }
            if (array.size() > 0) {
                this.ples = (PollListEntry[])array.trim();
            }
        }
        return this.ples;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetVirtualComponent", 2);
        spyWriter.prop((Object)"objectId", (Object)this.objectId);
        spyWriter.prop((Object)"tpName", (Object)this.tpName);
        spyWriter.prop((Object)"cachedPolicy", (Object)this.cachedPolicy);
        spyWriter.prop((Object)"writePriority", this.writePriority);
        spyWriter.prop((Object)"isPollSubscribed", this.isPollSubscribed);
        if (this.ples != null) {
            spyWriter.prop((Object)"PollListEntries (unsynch)", this.ples.length);
            int n = 0;
            while (n < this.ples.length) {
                spyWriter.prop((Object)("  " + n), (Object)this.ples[n]);
                ++n;
            }
        }
        spyWriter.prop((Object)"props", this.propsMap.size());
        Enumeration enumeration = this.propsMap.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            spyWriter.prop((Object)(" " + k), this.propsMap.get(k));
        }
        spyWriter.endProps();
    }

    private final Property getProperty(int n, int n2) {
        return (Property)this.propsMap.get(String.valueOf(n << 16 | n2 & (char)-1));
    }

    private final BBacnetNetwork network() {
        return (BBacnetNetwork)this.device().getNetwork();
    }

    private final BBacnetTuningPolicyMap getPolicyMap() {
        BBacnetTuningPolicyMap bBacnetTuningPolicyMap = (BBacnetTuningPolicyMap)this.network().get("tuningPolicies");
        if (bBacnetTuningPolicyMap != null) {
            return bBacnetTuningPolicyMap;
        }
        throw new IllegalStateException("Network missing tuningPolicies property");
    }

    private final void readOk(Property property, PollListEntry pollListEntry) {
        if (this.get(property) instanceof BStatusValue) {
            this.updateStatus(property, pollListEntry, BStatus.ok);
        }
    }

    private final void addPolledProperty(Property property, Array array) {
        if (log.isTraceOn()) {
            BBacnetVirtualComponent.d(this + ".addPolledProperty(): " + property + " facets=" + this.getFacets());
        }
        int n = -1;
        BFacets bFacets = property.getFacets();
        BInteger bInteger = (BInteger)bFacets.getFacet(PROPERTY_ID);
        if (bInteger == null) {
            return;
        }
        BValue bValue = this.get(property);
        if (bValue instanceof BBacnetVirtualArray) {
            BBacnetVirtualArray bBacnetVirtualArray = (BBacnetVirtualArray)this.get(property);
            SlotCursor slotCursor = bBacnetVirtualArray.getProperties();
            slotCursor.next();
            slotCursor.next();
            while (slotCursor.next()) {
                n = BBacnetVirtualArray.index(slotCursor.property().getName());
                array.add((Object)new PollListEntry(this.objectId, bInteger.getInt(), n, this.device(), this));
                String string = String.valueOf(bInteger.getInt() << 16 | n & (char)-1);
                this.propsMap.put(string, slotCursor.property());
            }
        } else {
            BInteger bInteger2 = (BInteger)bFacets.getFacet(INDEX);
            if (bInteger2 != null) {
                n = bInteger2.getInt();
            }
            array.add((Object)new PollListEntry(this.objectId, bInteger.getInt(), n, this.device(), this));
            String string = String.valueOf(bInteger.getInt() << 16 | n & (char)-1);
            this.propsMap.put(string, property);
            BString bString = (BString)bFacets.getFacet(STATUS_SOURCE_FACET);
            if (bValue instanceof BStatusValue && bString != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(bString.getString(), ";");
                while (stringTokenizer.hasMoreTokens()) {
                    this.addDoprPLE(stringTokenizer.nextToken(), array, property);
                    string = property.getName();
                }
            }
            this.propsMap.put(string, property);
        }
    }

    private final void addDoprPLE(String string, Array array, Property property) {
        BBacnetDeviceObjectPropertyReference bBacnetDeviceObjectPropertyReference = BBacnetDeviceObjectPropertyReference.fromString(string);
        if (bBacnetDeviceObjectPropertyReference != null) {
            BBacnetObjectIdentifier bBacnetObjectIdentifier = bBacnetDeviceObjectPropertyReference.getDeviceId();
            if (!bBacnetDeviceObjectPropertyReference.isDeviceIdUsed() || bBacnetObjectIdentifier.hashCode() == this.device().getObjectId().hashCode()) {
                array.add((Object)new PollListEntry(bBacnetDeviceObjectPropertyReference.getObjectId(), bBacnetDeviceObjectPropertyReference.getPropertyId(), bBacnetDeviceObjectPropertyReference.getPropertyArrayIndex(), this.device(), this, (Context)new MetaDataContext(property.getName())));
                this.propsMap.put(property.getName(), property);
            } else {
                BBacnetDevice bBacnetDevice = this.network().doLookupDeviceById(bBacnetObjectIdentifier);
                if (bBacnetDevice != null) {
                    array.add((Object)new PollListEntry(bBacnetDeviceObjectPropertyReference.getObjectId(), bBacnetDeviceObjectPropertyReference.getPropertyId(), bBacnetDeviceObjectPropertyReference.getPropertyArrayIndex(), bBacnetDevice, this, (Context)new MetaDataContext(property.getName())));
                    this.propsMap.put(property.getName(), property);
                } else {
                    throw new IllegalStateException("Cannot find BACnet device for virtual component metadata:" + this + "  ref=" + bBacnetDeviceObjectPropertyReference);
                }
            }
        }
    }

    private final void removePolledProperty(Property property, BValue bValue, Array array) {
        if (log.isTraceOn()) {
            BBacnetVirtualComponent.d(this + ".removePolledProperty(): " + property);
        }
        int n = -1;
        BFacets bFacets = property.getFacets();
        BInteger bInteger = (BInteger)bFacets.getFacet(PROPERTY_ID);
        if (bInteger == null) {
            return;
        }
        PollListEntry pollListEntry = null;
        BBacnetPoll bBacnetPoll = (BBacnetPoll)this.network().getPollService(this);
        if (bValue instanceof BBacnetVirtualArray) {
            BBacnetVirtualArray bBacnetVirtualArray = (BBacnetVirtualArray)bValue;
            SlotCursor slotCursor = bBacnetVirtualArray.getProperties();
            slotCursor.next();
            slotCursor.next();
            while (slotCursor.next()) {
                n = Integer.parseInt(slotCursor.property().getName().substring(7));
                pollListEntry = new PollListEntry(this.objectId, bInteger.getInt(), n, this.device(), this);
                array.remove((Object)pollListEntry);
                this.propsMap.remove(String.valueOf(bInteger.getInt() << 16 | n & (char)-1));
                bBacnetPoll.removePLE(this, pollListEntry);
            }
        } else {
            BInteger bInteger2 = (BInteger)bFacets.getFacet(INDEX);
            if (bInteger2 != null) {
                n = bInteger2.getInt();
            }
            pollListEntry = new PollListEntry(this.objectId, bInteger.getInt(), n, this.device(), this);
            array.remove((Object)pollListEntry);
            this.propsMap.remove(String.valueOf(bInteger.getInt() << 16 | n & (char)-1));
            bBacnetPoll.removePLE(this, pollListEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void setProp(Property property, byte[] byArray, BValue bValue, BStatusValue bStatusValue, int n) throws AsnException {
        AsnInputStream asnInputStream = asnIn;
        synchronized (asnInputStream) {
            block8: {
                block7: {
                    asnIn.setBuffer(byArray);
                    if (!(bValue instanceof BBacnetVirtualArray)) break block7;
                    ((BBacnetVirtualArray)bValue).readAsn(asnIn, n);
                    break block8;
                }
                if (bValue instanceof BIBacnetDataType) {
                    BIBacnetDataType bIBacnetDataType = (BIBacnetDataType)bValue;
                    bIBacnetDataType.readAsn(asnIn);
                } else {
                    bValue = this.readAsn(bValue, bStatusValue, property.getFacets(), byArray);
                    if (bStatusValue != null) {
                        this.set(property, (BValue)bStatusValue, BacnetConst.noWrite);
                    } else {
                        this.set(property, bValue, BacnetConst.noWrite);
                    }
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readMetaData(byte[] byArray, Context context, MetaDataContext metaDataContext) throws AsnException {
        PollListEntry pollListEntry = (PollListEntry)context;
        Property property = this.getProperty(metaDataContext.getPropertyName());
        BStatus bStatus = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (pollListEntry.getObjectId().hashCode() != this.objectId.hashCode()) {
            stringBuffer.append(pollListEntry.getObjectId().toString(BacnetConst.facetsContext)).append('_');
        }
        stringBuffer.append(BBacnetPropertyIdentifier.tag(pollListEntry.getPropertyId()));
        String string = stringBuffer.toString();
        AsnInputStream asnInputStream = asnIn;
        synchronized (asnInputStream) {
            asnIn.setBuffer(byArray);
            bStatus = this.readAsnMetaData(byArray, pollListEntry.getObjectId(), pollListEntry.getPropertyId(), string);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl16 : MonitorExitStatement: MONITOREXIT : var9_9
            this.updateStatus(property, pollListEntry, bStatus);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final BValue readAsn(BValue bValue, BStatusValue bStatusValue, BFacets bFacets, byte[] byArray) throws AsnException {
        Object object = null;
        AsnInputStream asnInputStream = asnIn;
        synchronized (asnInputStream) {
            int n = asnIn.peekApplicationTag();
            switch (n) {
                case 0: {
                    object = BBacnetNull.DEFAULT;
                    this.setValueValue((BValue)object, bStatusValue, null);
                    break;
                }
                case 1: {
                    object = BBoolean.make((boolean)asnIn.readBoolean());
                    this.setValueValue((BValue)object, bStatusValue, null);
                    break;
                }
                case 2: {
                    BBacnetUnsigned bBacnetUnsigned = asnIn.readUnsigned();
                    object = bBacnetUnsigned;
                    if (bStatusValue == null) break;
                    bStatusValue.setStatusNull(false);
                    if (bStatusValue instanceof BStatusEnum) break;
                    bStatusValue.setValueValue((BValue)BString.make((String)object.toString()));
                    break;
                }
                case 3: {
                    object = asnIn.readSigned();
                    this.setValueValue((BValue)object, bStatusValue, null);
                    break;
                }
                case 4: {
                    object = BDouble.make((double)asnIn.readReal());
                    this.setValueValue((BValue)object, bStatusValue, null);
                    break;
                }
                case 5: {
                    object = BDouble.make((double)asnIn.readDouble());
                    this.setValueValue((BValue)object, bStatusValue, null);
                    break;
                }
                case 6: {
                    object = BBacnetOctetString.make(asnIn.readOctetString());
                    this.setValueValue((BValue)object, bStatusValue, null);
                    break;
                }
                case 7: {
                    object = BString.make((String)asnIn.readCharacterString());
                    this.setValueValue((BValue)object, bStatusValue, null);
                    break;
                }
                case 8: {
                    object = asnIn.readBitString();
                    this.setValueValue((BValue)object, bStatusValue, null);
                    break;
                }
                case 9: {
                    int n2 = asnIn.readEnumerated();
                    BEnumRange bEnumRange = (BEnumRange)bFacets.getFacet("range");
                    if (bValue instanceof BIEnum && bEnumRange == null) {
                        bEnumRange = (BEnumRange)((BIEnum)bValue).getEnumFacets().getFacet("range");
                    }
                    object = bEnumRange != null ? bEnumRange.get(n2) : BDynamicEnum.make((int)n2);
                    this.setValueValue((BValue)BInteger.make((int)n2), bStatusValue, bEnumRange);
                    break;
                }
                case 10: {
                    object = asnIn.readDate();
                    this.setValueValue((BValue)object, bStatusValue, null);
                    break;
                }
                case 11: {
                    object = asnIn.readTime();
                    this.setValueValue((BValue)object, bStatusValue, null);
                    break;
                }
                case 12: {
                    object = asnIn.readObjectIdentifier();
                    this.setValueValue((BValue)object, bStatusValue, null);
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                default: {
                    if (log.isTraceOn()) {
                        log.trace(this + ": unexpected tag:" + n);
                    }
                    BIBacnetDataType bIBacnetDataType = (BIBacnetDataType)bValue;
                    bIBacnetDataType.readAsn(asnIn);
                    if (!(bIBacnetDataType instanceof BValue)) break;
                    object = (BValue)bIBacnetDataType;
                    this.setValueValue((BValue)object, bStatusValue, null);
                }
            }
            return object;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void setValueValue(BValue bValue, BStatusValue bStatusValue, BEnumRange bEnumRange) {
        if (bStatusValue == null) {
            return;
        }
        if (bValue == null || bValue instanceof BBacnetNull) {
            bStatusValue.setStatusNull(true);
            return;
        }
        bStatusValue.setStatusNull(false);
        if (bStatusValue instanceof BStatusNumeric) {
            if (bValue instanceof BDouble) {
                bStatusValue.setValueValue(bValue);
                return;
            } else {
                if (!(bValue instanceof BNumber)) throw new IllegalArgumentException("Can't setValueValue: v=" + bValue + " [" + bValue.getType() + "] sv=" + bStatusValue + " [baja:StatusNumeric]");
                ((BStatusNumeric)bStatusValue).setValue(((BNumber)bValue).getDouble());
            }
            return;
        } else if (bStatusValue instanceof BStatusBoolean) {
            if (bValue instanceof BBoolean) {
                bStatusValue.setValueValue(bValue);
                return;
            } else {
                if (!(bValue instanceof BNumber)) throw new IllegalArgumentException("Can't setValueValue: v=" + bValue + " [" + bValue.getType() + "] sv=" + bStatusValue + " [baja:StatusBoolean]");
                BStatusBoolean bStatusBoolean = (BStatusBoolean)bStatusValue;
                boolean bl = false;
                if (((BNumber)bValue).getInt() != 0) {
                    bl = true;
                }
                bStatusBoolean.setValue(bl);
            }
            return;
        } else if (bStatusValue instanceof BStatusEnum) {
            if (bValue instanceof BDynamicEnum) {
                bStatusValue.setValueValue(bValue);
                return;
            } else {
                if (!(bValue instanceof BNumber)) throw new IllegalArgumentException("Can't setValueValue: v=" + bValue + " [" + bValue.getType() + "] sv=" + bStatusValue + " [baja:StatusEnum]");
                ((BStatusEnum)bStatusValue).setValue(BDynamicEnum.make((int)((BNumber)bValue).getInt(), (BEnumRange)bEnumRange));
            }
            return;
        } else if (bStatusValue instanceof BStatusString) {
            bStatusValue.setValueValue((BValue)BString.make((String)bValue.toString()));
            return;
        } else {
            bStatusValue.setValueValue(bValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final BStatus readAsnMetaData(byte[] byArray, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, String string) throws AsnException {
        int n2 = 0;
        BFacets bFacets = BFacets.NULL;
        AsnInputStream asnInputStream = asnIn;
        synchronized (asnInputStream) {
            int n3 = asnIn.peekApplicationTag();
            switch (n3) {
                case 0: {
                    n2 |= 0x40;
                    break;
                }
                case 1: {
                    bFacets = BFacets.make((String)string, (BIDataValue)BBoolean.make((boolean)asnIn.readBoolean()));
                    break;
                }
                case 2: {
                    bFacets = BFacets.make((String)string, (BIDataValue)BLong.make((long)asnIn.readUnsignedInteger()));
                    break;
                }
                case 3: {
                    bFacets = BFacets.make((String)string, (BIDataValue)asnIn.readSigned());
                    break;
                }
                case 4: {
                    bFacets = BFacets.make((String)string, (BIDataValue)asnIn.readFloat());
                    break;
                }
                case 5: {
                    bFacets = BFacets.make((String)string, (BIDataValue)BDouble.make((double)asnIn.readDouble()));
                    break;
                }
                case 6: {
                    bFacets = BFacets.make((String)string, (BIDataValue)BString.make((String)ByteArrayUtil.toHexString((byte[])asnIn.readOctetString())));
                    break;
                }
                case 7: {
                    bFacets = BFacets.make((String)string, (BIDataValue)BString.make((String)asnIn.readCharacterString()));
                    break;
                }
                case 8: {
                    if (n == 111) {
                        n2 |= asnIn.readStatusFlags().getBits();
                        break;
                    }
                    bFacets = BFacets.make((String)string, (String)asnIn.readBitString().toString(BacnetBitStringUtil.getBitStringTags(bBacnetObjectIdentifier.getObjectType(), n)));
                    break;
                }
                case 9: {
                    bFacets = BFacets.make((String)string, (BIDataValue)BString.make((String)this.device().getEnumRange(bBacnetObjectIdentifier.getObjectType(), n).getTag(asnIn.readEnumerated())));
                    break;
                }
                case 10: {
                    bFacets = BFacets.make((String)string, (BIDataValue)BString.make((String)asnIn.readDate().toString()));
                    break;
                }
                case 11: {
                    bFacets = BFacets.make((String)string, (BIDataValue)BString.make((String)asnIn.readTime().toString()));
                    break;
                }
                case 12: {
                    bFacets = BFacets.make((String)string, (BIDataValue)BString.make((String)asnIn.readObjectIdentifier().toString()));
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                default: {
                    bFacets = BFacets.make((String)string, (BIDataValue)BString.make((String)AsnUtil.fromAsn(byArray)[0].toString()));
                }
            }
            return BStatus.make((int)n2, (BFacets)bFacets);
        }
    }

    private final void updateStatus(Property property, PollListEntry pollListEntry, BStatus bStatus) {
        Hashtable<PollListEntry, BStatus> hashtable;
        if (this.propsStatusMap == null) {
            this.propsStatusMap = new Hashtable();
        }
        if ((hashtable = (Hashtable<PollListEntry, BStatus>)this.propsStatusMap.get(property)) == null) {
            hashtable = new Hashtable<PollListEntry, BStatus>();
            this.propsStatusMap.put(property, hashtable);
        }
        hashtable.put(pollListEntry, bStatus);
        this.updateStatus(property, 0);
    }

    private final void updateStatus(Property property, int n) {
        if (log.isTraceOn()) {
            BBacnetVirtualComponent.d("updateStatus(" + property.getName() + ", " + n + ')');
        }
        if (this.propsStatusMap == null) {
            BBacnetVirtualComponent.d("no propsStatusMap");
            return;
        }
        if (!(this.get(property) instanceof BStatusValue)) {
            BBacnetVirtualComponent.d("prop not a statusValue");
            return;
        }
        BStatusValue bStatusValue = (BStatusValue)this.get(property).newCopy();
        Hashtable hashtable = (Hashtable)this.propsStatusMap.get(property);
        if (hashtable == null) {
            BBacnetVirtualComponent.d("no propMap for " + property.getName());
            return;
        }
        Enumeration enumeration = hashtable.elements();
        BFacets bFacets = BFacets.NULL;
        while (enumeration.hasMoreElements()) {
            BStatus bStatus = (BStatus)enumeration.nextElement();
            n |= bStatus.getBits();
            bFacets = BFacets.make((BFacets)bFacets, (BFacets)bStatus.getFacets());
        }
        bStatusValue.setStatus(BStatus.make((int)n, (BFacets)bFacets));
        this.set(property, (BValue)bStatusValue, BacnetConst.noWrite);
    }

    private static final void d(String string) {
        System.out.println(string);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.objectId = BBacnetObjectIdentifier.DEFAULT;
        this.tpName = "defaultPolicy";
        this.cachedPolicy = null;
        this.writePriority = -1;
        this.ples = null;
        this.propsMap = new Hashtable();
        this.propsStatusMap = null;
        this.isPollSubscribed = false;
    }

    public BBacnetVirtualComponent() {
        this.this();
    }

    public BBacnetVirtualComponent(String string) {
        this.this();
        if (log.isTraceOn()) {
            BBacnetVirtualComponent.d("BVC ctor(): vpath=" + string);
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            this.objectId = (BBacnetObjectIdentifier)BBacnetObjectIdentifier.DEFAULT.decodeFromString(stringTokenizer.nextToken());
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.startsWith(POLICY_DEF)) {
                    this.tpName = string2.substring(7);
                    continue;
                }
                if (!string2.startsWith(PRIORITY_DEF)) continue;
                try {
                    this.writePriority = Integer.parseInt(string2.substring(9));
                }
                catch (Exception exception) {
                    BBacnetVirtualComponent.d("Invalid priority: " + string2 + " in virtualPathName");
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static {
        Class clazz = class$javax$baja$bacnet$virtual$BBacnetVirtualComponent;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$virtual$BBacnetVirtualComponent = BBacnetVirtualComponent.class("[Ljavax.baja.bacnet.virtual.BBacnetVirtualComponent;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        asnIn = new AsnInputStream();
        log = Log.getLog((String)"bacnet.virtual");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Write
    implements Runnable {
        int propertyId;
        int propertyArrayIndex;
        byte[] ev;
        int priority;

        public void run() {
            try {
                BBacnetVirtualComponent.this.network().getBacnetComm().writeProperty(BBacnetVirtualComponent.this.device().getAddress(), BBacnetVirtualComponent.this.objectId, this.propertyId, this.propertyArrayIndex, this.ev, this.priority);
            }
            catch (TransactionException transactionException) {
                BBacnetVirtualComponent.this.device().ping();
                log.warning("TransactionException writing " + BBacnetPropertyIdentifier.tag(this.propertyId) + " in " + this);
            }
            catch (BacnetException bacnetException) {
                bacnetException.printStackTrace();
                log.error("BacnetException writing " + BBacnetPropertyIdentifier.tag(this.propertyId) + " in " + this);
            }
        }

        private final /* synthetic */ void this() {
            this.propertyArrayIndex = -1;
            this.ev = null;
            this.priority = -1;
        }

        Write(int n, int n2, byte[] byArray, int n3) {
            this.this();
            if (n == 87) {
                this.propertyId = 85;
                this.priority = n2;
            } else {
                this.propertyId = n;
                this.propertyArrayIndex = n2;
                this.priority = n3;
            }
            this.ev = byArray;
        }
    }
}

