/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.util.worker;

import javax.baja.bacnet.util.worker.IWorkerPool;
import javax.baja.bacnet.util.worker.IWorkerPoolAware;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Queue;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetWorkerPool
extends BComponent
implements IWorkerPool {
    private static final int DEFAULT_WORKERS = 2;
    public static final Property maxThreads = BBacnetWorkerPool.newProperty((int)0, (int)2, (BFacets)BFacets.make((String)"min", (int)1));
    public static final Type TYPE;
    private static final BIcon icon;
    private ThreadPoolWorker worker;
    private Queue queue;
    static /* synthetic */ Class class$javax$baja$bacnet$util$worker$BBacnetWorkerPool;

    public int getMaxThreads() {
        return this.getInt(maxThreads);
    }

    public void setMaxThreads(int n) {
        this.setInt(maxThreads, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return BBacnetWorkerPool.isLegalParent(bComponent);
    }

    public static boolean isLegalParent(BComponent bComponent) {
        boolean bl = false;
        if (bComponent instanceof IWorkerPoolAware && !BBacnetWorkerPool.alreadyHasWorkerPool(bComponent)) {
            bl = true;
        }
        return bl;
    }

    private static final boolean alreadyHasWorkerPool(BComponent bComponent) {
        BComponent[] bComponentArray = bComponent.getChildComponents();
        int n = 0;
        while (n < bComponentArray.length) {
            if (bComponentArray[n] instanceof IWorkerPool) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void started() throws Exception {
        super.started();
        IWorkerPoolAware iWorkerPoolAware = (IWorkerPoolAware)this.getParent();
        this.queue = iWorkerPoolAware.getQueue();
        this.worker = new ThreadPoolWorker((Worker.ITodo)this.queue);
        this.worker.setMaxThreads(this.getMaxThreads());
        this.worker.start(iWorkerPoolAware.getWorkerThreadName());
        iWorkerPoolAware.stopWorker();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.worker.stop();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)maxThreads)) {
            this.updateMaxThreads();
        }
    }

    private final void updateMaxThreads() {
        this.worker.setMaxThreads(this.getMaxThreads());
    }

    public IFuture post(Runnable runnable) {
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        this.queue.enqueue((Object)runnable);
        return null;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.worker = null;
        this.queue = null;
    }

    public BBacnetWorkerPool() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$bacnet$util$worker$BBacnetWorkerPool;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$util$worker$BBacnetWorkerPool = BBacnetWorkerPool.class("[Ljavax.baja.bacnet.util.worker.BBacnetWorkerPool;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"gears.png");
    }
}

