/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.util;

import java.util.ListIterator;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Type;
import javax.baja.util.Array;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class LocalBacnetPoll
implements Runnable {
    private boolean alive;
    private Array subs;
    private Thread thread;

    public void run() {
        while (this.alive) {
            long l = Clock.ticks();
            long l2 = l + this.getPollRate().getMillis();
            long l3 = l2 - l;
            if (l3 > 0L) {
                try {
                    Thread.sleep(l3);
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                ListIterator listIterator = this.subs.iterator();
                while (listIterator.hasNext()) {
                    BObject bObject = (BObject)listIterator.next();
                    if (bObject == null || !bObject.getType().is(this.getPolledType()) || this.poll(bObject)) continue;
                    this.subs.remove((Object)bObject);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected abstract boolean poll(BObject var1) throws Exception;

    protected abstract BRelTime getPollRate();

    protected abstract String getThreadName();

    protected abstract Type getPolledType();

    public synchronized void subscribe(BObject bObject) {
        if (bObject == null) {
            return;
        }
        if (!bObject.getType().is(this.getPolledType())) {
            throw new IllegalArgumentException("wrong type " + bObject.getType() + " for local poll subscribe (" + this.getPolledType() + ')');
        }
        this.subs.add((Object)bObject);
        if (!this.alive) {
            this.startThread();
        }
    }

    public synchronized void unsubscribe(BObject bObject) {
        if (bObject == null) {
            return;
        }
        if (!bObject.getType().is(this.getPolledType())) {
            throw new IllegalArgumentException("wrong type " + bObject.getType() + " for local poll unsubscribe (" + this.getPolledType() + ')');
        }
        this.subs.remove((Object)bObject);
        if (this.subs.size() == 0) {
            this.stopThread();
        }
    }

    private final void startThread() {
        this.alive = true;
        this.thread = new Thread((Runnable)this, this.getThreadName());
        this.thread.start();
    }

    private final void stopThread() {
        this.alive = false;
        this.thread.interrupt();
        this.thread = null;
    }

    public void spy(SpyWriter spyWriter) {
        spyWriter.prop((Object)"alive", this.alive);
        spyWriter.trTitle((Object)this.getThreadName(), 2);
        spyWriter.prop((Object)"subs", this.subs.size());
        ListIterator listIterator = this.subs.iterator();
        int n = 0;
        while (listIterator.hasNext()) {
            spyWriter.prop((Object)("  subs[" + n++ + ']'), listIterator.next());
        }
    }

    private final /* synthetic */ void this() {
        this.alive = false;
        this.subs = new Array();
        this.thread = null;
    }

    protected LocalBacnetPoll() {
        this.this();
    }
}

