/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.util;

import javax.baja.bacnet.util.worker.IWorkerPool;
import javax.baja.bacnet.util.worker.IWorkerPoolAware;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BWorker;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.IFuture;
import javax.baja.util.Queue;
import javax.baja.util.Worker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetWorker
extends BWorker
implements IWorkerPoolAware {
    public static final Property maxQueueSize = BBacnetWorker.newProperty((int)0, (int)1000, null);
    public static final Property workerThreadName = BBacnetWorker.newProperty((int)3, (String)"", null);
    public static final Type TYPE;
    private Object lock;
    private IWorkerPool workerPool;
    protected CoalesceQueue queue;
    protected Worker worker;
    static /* synthetic */ Class class$javax$baja$bacnet$util$BBacnetWorker;

    public int getMaxQueueSize() {
        return this.getInt(maxQueueSize);
    }

    public void setMaxQueueSize(int n) {
        this.setInt(maxQueueSize, n, null);
    }

    public String getWorkerThreadName() {
        return this.getString(workerThreadName);
    }

    public void setWorkerThreadName(String string) {
        this.setString(workerThreadName, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        if (this.getWorkerThreadName().equals("")) {
            this.setWorkerThreadName(this.getParent().getName() + ':' + this.getName());
        }
        super.started();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property != maxQueueSize) return;
        if (!this.isRunning()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.workerPool != null) return;
            this.stopWorker();
            this.queue = null;
            this.worker = null;
            this.getWorker();
            this.startWorker();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void added(Property property, Context context) {
        super.added(property, context);
        BValue bValue = null;
        bValue = this.get(property);
        if (!(bValue instanceof IWorkerPool)) return;
        IWorkerPool iWorkerPool = (IWorkerPool)bValue;
        Object object = this.lock;
        synchronized (object) {
            this.workerPool = iWorkerPool;
            if (this.worker == null || !this.worker.isRunning()) return;
            this.worker.stop();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removed(Property property, BValue bValue, Context context) {
        super.removed(property, bValue, context);
        if (!(bValue instanceof IWorkerPool)) return;
        Object object = this.lock;
        synchronized (object) {
            this.workerPool = null;
            this.startWorker();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopWorker() {
        Object object = this.lock;
        synchronized (object) {
            if (this.worker != null && this.worker.isRunning()) {
                this.worker.stop();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IFuture post(Runnable runnable) {
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        if (this.queue == null) {
            throw new NotRunningException();
        }
        Object object = this.lock;
        synchronized (object) {
            block6: {
                block5: {
                    if (this.workerPool != null && this.workerPool.isRunning()) break block5;
                    this.queue.enqueue((Object)runnable);
                    break block6;
                }
                this.workerPool.post(runnable);
            }
            return null;
        }
    }

    public Worker getWorker() {
        if (this.worker == null) {
            this.queue = new CoalesceQueue(this.getMaxQueueSize());
            this.worker = new Worker((Worker.ITodo)this.queue);
        }
        return this.worker;
    }

    public void setWorker(Worker worker) {
        this.worker = worker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dump() {
        CoalesceQueue coalesceQueue = this.queue;
        synchronized (coalesceQueue) {
            Object[] objectArray = this.queue.toArray();
            System.out.println("BBacnetWorker dump (" + objectArray.length + " entries):");
            int n = 0;
            while (n < objectArray.length) {
                System.out.println(n + ": " + objectArray[n]);
                ++n;
            }
            return;
        }
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public Queue getQueue() {
        return this.queue;
    }

    public boolean hasWorkerPool() {
        boolean bl = false;
        if (this.workerPool != null) {
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lock = new Object();
        this.workerPool = null;
    }

    public BBacnetWorker() {
        this.this();
    }

    public BBacnetWorker(int n) {
        this.this();
        this.setMaxQueueSize(n);
    }

    public BBacnetWorker(String string) {
        this.this();
        this.setWorkerThreadName(string);
    }

    static {
        Class clazz = class$javax$baja$bacnet$util$BBacnetWorker;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$util$BBacnetWorker = BBacnetWorker.class("[Ljavax.baja.bacnet.util.BBacnetWorker;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

