/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.point;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.stack.BBacnetPoll;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.transport.TransactionException;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.io.ErrorException;
import javax.baja.bacnet.point.BBacnetProxyExt;
import javax.baja.bacnet.util.PollListEntry;
import javax.baja.log.Log;
import javax.baja.status.BStatusValue;
import javax.baja.util.ICoalesceable;

public class PointCmd
implements Runnable,
ICoalesceable {
    static Log log = Log.getLog((String)"bacnet.point");
    public static final int READ_POINT = Integer.MIN_VALUE;
    public static final int SUBSCRIBE_COV_POINT = 0x40000000;
    public static final int WRITE_POINT = 0x20000000;
    public static final int READ_META_DATA = 0x10000000;
    private static final String READ_POINT_STR = "read";
    private static final String SUBSCRIBE_COV_POINT_STR = "subscribe";
    private static final String WRITE_POINT_STR = "write";
    private static final String READ_META_DATA_STR = "readMetaData";
    private int cmd;
    private BBacnetProxyExt px;
    private Object arg;
    private int clr;
    private int lvl;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Bac PtCmd: px=");
        if (this.px != null) {
            stringBuffer.append(this.px.getParentPoint().getName()).append(" hc=").append(this.px.getHandle().hashCode());
        }
        stringBuffer.append(" cmd=").append(this.cmd()).append(" arg=").append(this.arg).append(" clr=").append(this.clr).append(" lvl=").append(this.lvl);
        return stringBuffer.toString();
    }

    private final String cmd() {
        switch (this.cmd) {
            case -2147483648: {
                return READ_POINT_STR;
            }
            case 0x40000000: {
                return SUBSCRIBE_COV_POINT_STR;
            }
            case 0x20000000: {
                return WRITE_POINT_STR;
            }
            case 0x10000000: {
                return READ_META_DATA_STR;
            }
        }
        return String.valueOf(this.cmd);
    }

    public Object getCoalesceKey() {
        return this;
    }

    public boolean equals(Object object) {
        if (object instanceof PointCmd) {
            PointCmd pointCmd = (PointCmd)object;
            if (this.px == pointCmd.px && this.cmd == pointCmd.cmd && this.clr == pointCmd.clr && this.lvl == pointCmd.lvl) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        Object object;
        if (this.px != null && (object = this.px.getHandle()) != null) {
            return object.hashCode();
        }
        return 31 * this.cmd + 37 * this.clr + 41 * this.lvl;
    }

    public ICoalesceable coalesce(ICoalesceable iCoalesceable) {
        this.arg = ((PointCmd)iCoalesceable).arg;
        this.clr = ((PointCmd)iCoalesceable).clr;
        this.lvl = ((PointCmd)iCoalesceable).lvl;
        return this;
    }

    public void run() {
        switch (this.cmd) {
            case -2147483648: {
                try {
                    byte[] byArray = ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient().readProperty(this.px.getDeviceAddress(), this.px.getObjectId(), this.px.getPropertyId().getOrdinal(), this.px.getPropertyArrayIndex());
                    this.px.device().pingOk();
                    this.px.fromEncodedValue(byArray, null, PollListEntry.forceCx);
                }
                catch (TransactionException transactionException) {
                    this.px.device().ping();
                    this.px.readFail(transactionException.toString());
                    log.warning("TransactionException reading point value for " + this.px + " in " + this.px.device() + ": " + transactionException, (Throwable)((Object)transactionException));
                }
                catch (ErrorException errorException) {
                    this.px.readFail(errorException.toString());
                    this.px.setLastReadError(errorException.getErrorType());
                    log.warning("ErrorException reading point value for " + this.px + " in " + this.px.device() + ": " + (Object)((Object)errorException), (Throwable)((Object)errorException));
                }
                catch (BacnetException bacnetException) {
                    this.px.readFail(bacnetException.toString());
                    this.px.setLastReadError(BBacnetProxyExt.ERROR_DEVICE_OTHER);
                    log.warning("BacnetException reading point value for " + this.px + " in " + this.px.device() + ": " + (Object)((Object)bacnetException), (Throwable)((Object)bacnetException));
                }
                break;
            }
            case 0x40000000: {
                this.px.device().subscribeCov(this.px);
                break;
            }
            case 0x20000000: {
                try {
                    if (this.lvl >= 1 && this.lvl <= 16) {
                        ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient().writeProperty(this.px.getDeviceAddress(), this.px.getObjectId(), this.px.getPropertyId().getOrdinal(), this.px.getPropertyArrayIndex(), this.px.toEncodedValue((BStatusValue)this.arg), this.lvl);
                    } else if (this.arg != null) {
                        ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient().writeProperty(this.px.getDeviceAddress(), this.px.getObjectId(), this.px.getPropertyId().getOrdinal(), this.px.getPropertyArrayIndex(), this.px.toEncodedValue((BStatusValue)this.arg));
                    } else if (this.clr == 0) {
                        ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient().writeProperty(this.px.getDeviceAddress(), this.px.getObjectId(), this.px.getPropertyId().getOrdinal(), this.px.getPropertyArrayIndex(), AsnUtil.toAsnNull());
                    }
                    if (this.clr > 0 && this.clr != this.lvl) {
                        if (this.clr == 17) {
                            ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient().writeProperty(this.px.getDeviceAddress(), this.px.getObjectId(), this.px.getPropertyId().getOrdinal(), this.px.getPropertyArrayIndex(), AsnUtil.toAsnNull());
                        } else {
                            ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient().writeProperty(this.px.getDeviceAddress(), this.px.getObjectId(), this.px.getPropertyId().getOrdinal(), this.px.getPropertyArrayIndex(), AsnUtil.toAsnNull(), this.clr);
                        }
                    }
                    this.px.device().pingOk();
                    this.px.writeOk((BStatusValue)this.arg);
                    this.px.setWriteStatus(BBacnetProxyExt.OK);
                    ((BBacnetPoll)this.px.network().getPollService(this.px)).pollNow(this.px);
                }
                catch (TransactionException transactionException) {
                    this.px.device().ping();
                    this.px.writeFail(transactionException.toString());
                    log.warning("TransactionException writing point value for " + this.px + " in " + this.px.device() + ": " + transactionException, (Throwable)((Object)transactionException));
                }
                catch (BacnetException bacnetException) {
                    this.px.writeFail(bacnetException.toString());
                    log.error("BacnetException writing point value for " + this.px + ": " + (Object)((Object)bacnetException), (Throwable)((Object)bacnetException));
                }
                break;
            }
            case 0x10000000: {
                try {
                    PollListEntry[] pollListEntryArray = this.px.getPollListEntries();
                    int n = 1;
                    while (n < pollListEntryArray.length) {
                        byte[] byArray = ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient().readProperty(pollListEntryArray[n].getDevice().getAddress(), pollListEntryArray[n].getObjectId(), pollListEntryArray[n].getPropertyId(), pollListEntryArray[n].getPropertyArrayIndex());
                        BStatusValue bStatusValue = (BStatusValue)this.px.getReadValue().newCopy();
                        this.px.readMetaData(byArray, pollListEntryArray[n], bStatusValue);
                        this.px.readOk(bStatusValue);
                        this.px.setLastReadError(null);
                        ++n;
                    }
                    this.px.device().pingOk();
                }
                catch (TransactionException transactionException) {
                    this.px.device().ping();
                    this.px.readFail(transactionException.toString());
                    log.warning("TransactionException reading metadata for " + this.px + " in " + this.px.device() + ": " + transactionException, (Throwable)((Object)transactionException));
                }
                catch (ErrorException errorException) {
                    this.px.readFail(errorException.toString());
                    this.px.setLastReadError(errorException.getErrorType());
                    log.warning("ErrorException reading metadata for " + this.px + " in " + this.px.device() + ": " + (Object)((Object)errorException), (Throwable)((Object)errorException));
                }
                catch (BacnetException bacnetException) {
                    this.px.readFail(bacnetException.toString());
                    this.px.setLastReadError(BBacnetProxyExt.ERROR_DEVICE_OTHER);
                    log.warning("BacnetException reading metadata for " + this.px + " in " + this.px.device() + ": " + (Object)((Object)bacnetException), (Throwable)((Object)bacnetException));
                }
                break;
            }
            default: {
                throw new RuntimeException("Invalid cmd {" + this.cmd + " } in PointCmd.");
            }
        }
    }

    public PointCmd(int n, BBacnetProxyExt bBacnetProxyExt) {
        this(n, bBacnetProxyExt, null, 0, 0);
    }

    public PointCmd(int n, BBacnetProxyExt bBacnetProxyExt, Object object) {
        this(n, bBacnetProxyExt, object, 0, 0);
    }

    public PointCmd(int n, BBacnetProxyExt bBacnetProxyExt, Object object, int n2, int n3) {
        this.cmd = n;
        this.px = bBacnetProxyExt;
        this.arg = object;
        this.clr = n2;
        this.lvl = n3;
    }
}

