/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.point;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.history.BIBacnetTrendLogExt;
import com.tridium.bacnet.stack.BBacnetPoll;
import com.tridium.bacnet.stack.BBacnetStack;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BIRemoteAlarmSource;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.point.BBacnetPointDeviceExt;
import javax.baja.bacnet.point.BBacnetTuningPolicy;
import javax.baja.bacnet.point.PointCmd;
import javax.baja.bacnet.util.BIBacnetPollable;
import javax.baja.bacnet.util.PollListEntry;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.log.Log;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BBacnetProxyExt
extends BProxyExt
implements BacnetConst,
BIBacnetPollable,
BIRemoteAlarmSource {
    static Lexicon lex = Lexicon.make((String)"bacnet");
    static String COV = lex.getText("point.cov");
    static String POLLED = lex.getText("point.polled");
    static String COV_PENDING = lex.getText("point.covPending");
    static String COV_FAILED = lex.getText("point.covFailed");
    static String UNSUBSCRIBED = lex.getText("point.unsubscribed");
    static String WRITABLE = lex.getText("point.writable");
    static String READONLY = lex.getText("point.readonly");
    static String OK = lex.getText("point.ok");
    public static final Property deviceFacets = BBacnetProxyExt.newProperty((int)1, (BValue)BFacets.NULL, null);
    public static final Property objectId = BBacnetProxyExt.newProperty((int)0, (BValue)BBacnetObjectIdentifier.DEFAULT, null);
    public static final Property propertyId = BBacnetProxyExt.newProperty((int)0, (BValue)BDynamicEnum.make((BEnum)BBacnetPropertyIdentifier.presentValue), null);
    public static final Property propertyArrayIndex = BBacnetProxyExt.newProperty((int)0, (int)-1, null);
    public static final Property dataType = BBacnetProxyExt.newProperty((int)1, (String)"", null);
    public static final Property readStatus = BBacnetProxyExt.newProperty((int)3, (String)UNSUBSCRIBED, null);
    public static final Property writeStatus = BBacnetProxyExt.newProperty((int)3, (String)READONLY, null);
    public static final Action forceRead = BBacnetProxyExt.newAction((int)0, null);
    public static final Action forceWrite = BBacnetProxyExt.newAction((int)0, null);
    public static final Action subscribeCov = BBacnetProxyExt.newAction((int)4, null);
    public static final Action ackAlarm = BBacnetProxyExt.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE;
    public static final int SUB_STATE_UNSUB = 0;
    public static final int SUB_STATE_POLLED = 1;
    public static final int SUB_STATE_COV = 2;
    public static final int SUB_STATE_PENDING = 3;
    public static final int SUB_STATE_POLLED_PENDING = 4;
    public static final int SUB_STATE_COV_PENDING = 5;
    public static final byte[] NO_VALUE;
    public static final String READ_STATUS_FLAGS = "statusFlags";
    public static final String READ_EVENT_STATE = "eventState";
    public static final String READ_PRIORITY_ARRAY = "priorityArray";
    public static final String READ_RELIABILITY = "reliability";
    public static final String STATUS_FLAGS_STATUS_FACET = "statusFlags";
    public static final String EVENT_STATE_STATUS_FACET = "state";
    public static final String PRIORITY_ARRAY_STATUS_FACET = "bac";
    public static final String RELIABILITY_STATUS_FACET = "reliability";
    public static final String PRIORITIZED_PRESENT_VALUE = "priPV";
    static final ErrorType ERROR_DEVICE_OTHER;
    public static final Context covContext;
    static Log log;
    private BBacnetDevice bacnetDevice;
    private boolean debug;
    private Clock.Ticket ticket;
    private ErrorType lastReadError;
    protected int dataSize;
    protected int asnType;
    private BBoolean priPV;
    private BBoolean useStatusFlags;
    private int lastWriteLevel;
    private BBacnetPoll pollService;
    private int subState;
    private PollListEntry[] ples;
    static /* synthetic */ Class class$javax$baja$bacnet$point$BBacnetProxyExt;
    static /* synthetic */ Class class$javax$baja$bacnet$util$PollListEntry;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetDeviceObjectPropertyReference;
    static /* synthetic */ Class class$com$tridium$bacnet$history$BIBacnetTrendLogExt;

    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    public void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.set(objectId, (BValue)bBacnetObjectIdentifier, null);
    }

    public BDynamicEnum getPropertyId() {
        return (BDynamicEnum)this.get(propertyId);
    }

    public void setPropertyId(BDynamicEnum bDynamicEnum) {
        this.set(propertyId, (BValue)bDynamicEnum, null);
    }

    public int getPropertyArrayIndex() {
        return this.getInt(propertyArrayIndex);
    }

    public void setPropertyArrayIndex(int n) {
        this.setInt(propertyArrayIndex, n, null);
    }

    public String getDataType() {
        return this.getString(dataType);
    }

    public void setDataType(String string) {
        this.setString(dataType, string, null);
    }

    public String getReadStatus() {
        return this.getString(readStatus);
    }

    public void setReadStatus(String string) {
        this.setString(readStatus, string, null);
    }

    public String getWriteStatus() {
        return this.getString(writeStatus);
    }

    public void setWriteStatus(String string) {
        this.setString(writeStatus, string, null);
    }

    public void forceRead() {
        this.invoke(forceRead, null, null);
    }

    public void forceWrite() {
        this.invoke(forceWrite, null, null);
    }

    public void subscribeCov() {
        this.invoke(subscribeCov, null, null);
    }

    public BBoolean ackAlarm(BAlarmRecord bAlarmRecord) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)bAlarmRecord, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doForceRead() {
        block3: {
            try {
                this.network().postAsync(new PointCmd(Integer.MIN_VALUE, this));
                if (this.isCOV()) {
                    this.network().postAsync(new PointCmd(0x40000000, this));
                }
            }
            catch (Exception exception) {
                if (!log.isTraceOn()) break block3;
                log.trace("Failed to read " + this + ':' + exception);
            }
        }
    }

    public void doForceWrite() {
        this.write(null);
    }

    public void doSubscribeCov() {
        if (!this.isSubscribedDesired()) {
            return;
        }
        switch (this.subState) {
            case 0: 
            case 1: {
                this.setSubState(3);
                break;
            }
            case 2: {
                this.setSubState(5);
                break;
            }
            case 3: {
                return;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        boolean bl = false;
        try {
            this.network().postAsync(new PointCmd(0x40000000, this));
        }
        catch (Exception exception) {
            bl = true;
            this.setSubState(4);
            this.pollService = (BBacnetPoll)this.network().getPollService(this);
            this.pollService.subscribe(this);
        }
        this.scheduleResubscribe(bl);
    }

    public BBoolean doAckAlarm(BAlarmRecord bAlarmRecord) {
        return ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getServer().getEventHandler().doAckAlarm(bAlarmRecord);
    }

    public void started() throws Exception {
        super.started();
        this.setDebug();
        this.setAsnType();
        this.setDataSize();
        this.discoverPrioritizedPresentValue();
        if (this.getParentPoint().isWritablePoint()) {
            this.setWriteStatus(WRITABLE);
        }
        this.points().registerPoint(this);
    }

    public void stopped() throws Exception {
        super.stopped();
        this.points().unregisterPoint(this);
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (this.get(property) instanceof BBacnetDeviceObjectPropertyReference) {
            this.readUnsubscribed(null);
            this.readSubscribed(null);
        } else if (property.getName().equals("debug")) {
            this.setDebug();
        }
    }

    public void removed(Property property, BValue bValue, Context context) {
        super.removed(property, bValue, context);
        if (bValue instanceof BBacnetDeviceObjectPropertyReference) {
            this.readUnsubscribed(null);
            this.readSubscribed(null);
        } else if (property.getName().equals("debug")) {
            this.debug = false;
        }
    }

    public final void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)objectId) || property.equals((Object)propertyId)) {
            PropertyInfo propertyInfo = this.device().getPropertyInfo(this.getObjectId().getObjectType(), this.getPropertyId().getOrdinal());
            if (propertyInfo != null) {
                this.setDataType(AsnUtil.getAsnTypeName(propertyInfo.getAsnType()));
            }
            if (this.isSubscribed()) {
                this.readUnsubscribed(null);
                this.readSubscribed(null);
            }
            this.setAsnType();
            this.setDataSize();
            BFacets bFacets = this.getDeviceFacets();
            bFacets = BFacets.makeRemove((BFacets)bFacets, (String)PRIORITIZED_PRESENT_VALUE);
            this.setDeviceFacets(bFacets);
            this.discoverPrioritizedPresentValue();
            this.points().reregisterPoint(this);
        } else if (property.equals((Object)propertyArrayIndex)) {
            if (this.isSubscribed()) {
                this.readUnsubscribed(null);
                this.readSubscribed(null);
            }
            this.points().reregisterPoint(this);
        } else if (property.equals((Object)dataType)) {
            this.setAsnType();
            this.setDataSize();
        } else if (property.equals((Object)tuningPolicyName)) {
            if (this.isSubscribed()) {
                this.readUnsubscribed(null);
                this.readSubscribed(null);
            }
        } else if (property.equals((Object)deviceFacets)) {
            this.priPV = (BBoolean)this.getDeviceFacets().get(PRIORITIZED_PRESENT_VALUE);
        } else if (property.getName().equals("debug")) {
            this.setDebug();
        } else {
            BValue bValue = this.get(property);
            if (bValue instanceof BBacnetDeviceObjectPropertyReference && this.isSubscribed()) {
                this.readUnsubscribed(null);
                this.readSubscribed(null);
            }
        }
    }

    public Type getDeviceExtType() {
        return BBacnetPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
    }

    public void readFail(String string) {
        this.setReadStatus(string);
        super.readFail(string);
    }

    public void writeFail(String string) {
        this.setWriteStatus(string);
        super.writeFail(string);
    }

    public void pointFacetsChanged() {
        super.pointFacetsChanged();
        if (this.getParentPoint().isSubscribed()) {
            this.readUnsubscribed(null);
            this.readSubscribed(null);
        }
        this.useStatusFlags = null;
    }

    protected boolean isSiblingLegal(BComponent bComponent) {
        if (bComponent instanceof BIBacnetTrendLogExt) {
            this.ples = null;
        }
        return super.isSiblingLegal(bComponent);
    }

    public final void readSubscribed(Context context) {
        if (!this.isRunning()) {
            return;
        }
        boolean bl = true;
        if (this.useCov() && this.device().canAddCov() && BBacnetObjectType.canSupportCov(this.getObjectId().getObjectType(), this.device()) && this.getPropertyId().getOrdinal() == 85) {
            this.subscribeCov();
            this.forceRead();
            bl = false;
        }
        if (bl) {
            this.pollService = (BBacnetPoll)this.network().getPollService(this);
            this.pollService.subscribe(this);
            this.setSubState(1);
        }
    }

    public final void readUnsubscribed(Context context) {
        if (this.isCOV()) {
            if (this.network().isRunning()) {
                this.device().unsubscribeCov(this);
            }
        } else {
            this.pollService = (BBacnetPoll)this.network().getPollService(this);
            this.pollService.unsubscribe(this);
        }
        this.ples = null;
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = null;
        this.setSubState(0);
    }

    /*
     * Unable to fully structure code
     */
    public boolean write(Context var1_1) {
        var2_2 = null;
        var3_4 = 0;
        if (this.getActiveLevel() != 17 || !this.getWriteValue().getStatus().isNull()) ** GOTO lbl14
        if (this.isPriorityArrayPoint()) {
            var2_2 = null;
        } else if (this.isPrioritizedPresentValue()) {
            var2_2 = null;
        } else {
            return false;
        }
        try {
            block9: {
                break block9;
lbl14:
                // 1 sources

                var2_2 = (BStatusValue)this.getWriteValue().newCopy();
                if (this.isPrioritizedPresentValue()) {
                    var3_4 = this.getActiveLevel();
                }
            }
            this.network().postWrite(new PointCmd(0x20000000, this, var2_2, this.lastWriteLevel, var3_4));
            if (this.isPrioritizedPresentValue()) {
                this.lastWriteLevel = var3_4;
            }
        }
        catch (Throwable var2_3) {
            var3_5 = BBacnetProxyExt.lex.getText("point.writeFail");
            this.writeFail(var3_5 + ':' + var2_3);
            BBacnetProxyExt.log.message("Error writing BACnet point " + this + " in " + this.device() + ": " + var2_3, var2_3);
        }
        return false;
    }

    public final BBacnetDevice device() {
        return (BBacnetDevice)this.getDevice();
    }

    public final int getPollableType() {
        return 1;
    }

    public boolean poll() {
        if (!this.device().getEnabled() || this.device().getStatus().isDown()) {
            return false;
        }
        if (!this.getObjectId().isValid()) {
            return false;
        }
        return this.device().poll(this);
    }

    public BPollFrequency getPollFrequency() {
        return ((BBacnetTuningPolicy)this.getTuningPolicy()).getPollFrequency();
    }

    /*
     * Unable to fully structure code
     */
    public final PollListEntry[] getPollListEntries() {
        block12: {
            if (this.ples != null) break block12;
            v0 = BBacnetProxyExt.class$javax$baja$bacnet$util$PollListEntry;
            if (v0 == null) {
                v0 = BBacnetProxyExt.class$javax$baja$bacnet$util$PollListEntry = BBacnetProxyExt.class("[Ljavax.baja.bacnet.util.PollListEntry;", false);
            }
            var1_1 = new Array(v0);
            var1_1.add((Object)new PollListEntry(this));
            var2_2 = false;
            var3_3 = this.getParentPoint().getFacets();
            if (this.useStatusFlags()) {
                var1_1.add((Object)new PollListEntry(this, 111));
                var2_2 = true;
            }
            if ((var4_4 = (BBoolean)var3_3.getFacet("eventState")) != null && var4_4.getBoolean()) {
                var1_1.add((Object)new PollListEntry(this, 36));
            }
            if ((var4_4 = (BBoolean)var3_3.getFacet("priorityArray")) != null && var4_4.getBoolean()) {
                var1_1.add((Object)new PollListEntry(this, 87));
            }
            if ((var4_4 = (BBoolean)var3_3.getFacet("reliability")) != null && var4_4.getBoolean()) {
                var1_1.add((Object)new PollListEntry(this, 103));
            }
            var5_5 = this.getProperties();
            if (true) ** GOTO lbl38
            do {
                var6_6 = (BIBacnetTrendLogExt[])var5_5.get();
                var7_7 = var6_6.getDeviceId();
                if (!var6_6.isDeviceIdUsed() || var7_7.hashCode() == this.device().getObjectId().hashCode()) {
                    var1_1.add((Object)new PollListEntry(var6_6.getObjectId(), var6_6.getPropertyId(), var6_6.getPropertyArrayIndex(), this.device(), this));
                } else {
                    var8_8 = this.network().doLookupDeviceById(var7_7);
                    if (var8_8 != null) {
                        var1_1.add((Object)new PollListEntry(var6_6.getObjectId(), var6_6.getPropertyId(), var6_6.getPropertyArrayIndex(), var8_8, this));
                    } else {
                        throw new IllegalStateException("Cannot find BACnet device for point metadata:" + this + "  ref=" + var6_6);
                    }
                }
lbl38:
                // 3 sources

                if ((v1 = BBacnetProxyExt.class$javax$baja$bacnet$datatypes$BBacnetDeviceObjectPropertyReference) != null) continue;
                v1 = BBacnetProxyExt.class("[Ljavax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;", false);
            } while (var5_5.next(v1));
            v2 = this.getParentPoint();
            v3 = BBacnetProxyExt.class$com$tridium$bacnet$history$BIBacnetTrendLogExt;
            if (v3 == null) {
                v3 = BBacnetProxyExt.class$com$tridium$bacnet$history$BIBacnetTrendLogExt = BBacnetProxyExt.class("[Lcom.tridium.bacnet.history.BIBacnetTrendLogExt;", false);
            }
            if ((var6_6 = (BIBacnetTrendLogExt[])v2.getChildren(v3)).length > 0 && !var2_2) {
                var1_1.add((Object)new PollListEntry(this, 111));
            }
            this.ples = (PollListEntry[])var1_1.trim();
        }
        return this.ples;
    }

    public final BBacnetPointDeviceExt points() {
        return (BBacnetPointDeviceExt)this.getDeviceExt();
    }

    public boolean useCov() {
        return ((BBacnetTuningPolicy)this.getTuningPolicy()).getUseCov();
    }

    public boolean useConfirmedCov() {
        return ((BBacnetTuningPolicy)this.getTuningPolicy()).getUseConfirmedCov();
    }

    public int getCovSubscriptionLifetime() {
        return ((BBacnetTuningPolicy)this.getTuningPolicy()).getCovSubscriptionLifetime();
    }

    public void tuningChanged(BBacnetTuningPolicy bBacnetTuningPolicy, Context context) {
        if ((bBacnetTuningPolicy == null || bBacnetTuningPolicy == this.getTuningPolicy()) && this.isSubscribed()) {
            this.readUnsubscribed(context);
            this.readSubscribed(context);
        }
    }

    public String toString(Context context) {
        char c = context == BacnetConst.nameContext ? (char)'_' : ':';
        return this.getObjectId().toString(context) + c + this.getPropertyId() + c + this.getPropertyArrayIndex() + c + this.getDataType();
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer(super.toDebugString());
        stringBuffer.append(" dev=").append(this.device().getObjectId().toString()).append(" oid=").append(this.getObjectId().toString()).append(" pid=").append(this.getPropertyId()).append(" ndx=").append(this.getPropertyArrayIndex()).append(" asn=").append(this.getDataType()).append(" run=").append(this.isRunning()).append(" sub=").append(this.isSubscribed());
        return stringBuffer.toString();
    }

    public BFacets getSlotFacets(Slot slot) {
        if (!this.isMounted()) {
            return super.getSlotFacets(slot);
        }
        BBacnetDevice bBacnetDevice = this.bacnetDevice();
        if (bBacnetDevice != null) {
            if (slot.equals((Object)objectId)) {
                return bBacnetDevice.getEnumerationList().getObjectTypeFacets();
            }
            if (slot.equals((Object)propertyId)) {
                return bBacnetDevice.getEnumerationList().getPropertyIdFacets();
            }
        }
        return super.getSlotFacets(slot);
    }

    private final BBacnetDevice bacnetDevice() {
        if (this.bacnetDevice == null) {
            BComplex bComplex = this.getParent();
            while (bComplex != null) {
                if (bComplex instanceof BBacnetDevice) {
                    this.bacnetDevice = (BBacnetDevice)bComplex;
                    break;
                }
                bComplex = bComplex.getParent();
            }
        }
        return this.bacnetDevice;
    }

    public final boolean isCOV() {
        boolean bl = false;
        if (this.subState == 2 || this.subState == 5) {
            bl = true;
        }
        return bl;
    }

    public final boolean isCOVPending() {
        boolean bl = false;
        if (this.subState == 3 || this.subState == 4 || this.subState == 5) {
            bl = true;
        }
        return bl;
    }

    public final boolean isPolled() {
        boolean bl = false;
        if (this.subState == 1 || this.subState == 4) {
            bl = true;
        }
        return bl;
    }

    public void setCOV(boolean bl) {
        if (bl) {
            this.subState = 2;
        }
    }

    public final void setSubState(int n) {
        this.subState = n;
        switch (n) {
            case 0: {
                this.setReadStatus(UNSUBSCRIBED);
                break;
            }
            case 1: {
                this.setReadStatus(POLLED);
                break;
            }
            case 2: {
                this.setReadStatus(COV);
                break;
            }
            case 3: {
                if (this.isCOV()) break;
                this.setReadStatus(COV_PENDING);
                break;
            }
            case 4: {
                this.setReadStatus(POLLED);
                break;
            }
            case 5: {
                break;
            }
        }
    }

    public ErrorType getLastReadError() {
        return this.lastReadError;
    }

    public void setLastReadError(ErrorType errorType) {
        this.lastReadError = errorType;
    }

    public boolean useStatusFlags() {
        boolean bl = false;
        if (this.getPropertyId().getOrdinal() == 85 && BBacnetObjectType.hasStatusFlags(this.getObjectId().getObjectType(), this.device()) && this.statusFlagsEnabled()) {
            bl = true;
        }
        return bl;
    }

    private final boolean statusFlagsEnabled() {
        BObject bObject;
        BFacets bFacets;
        if (this.useStatusFlags != null) {
            return this.useStatusFlags.getBoolean();
        }
        BControlPoint bControlPoint = this.getParentPoint();
        if (bControlPoint != null && (bFacets = bControlPoint.getFacets()) != null && (bObject = bFacets.getFacet("statusFlags")) != null && bObject instanceof BBoolean) {
            this.useStatusFlags = (BBoolean)bObject;
            return this.useStatusFlags.getBoolean();
        }
        return false;
    }

    public boolean isPriorityArrayPoint() {
        boolean bl = false;
        if (this.getPropertyId().getOrdinal() == 87) {
            bl = true;
        }
        return bl;
    }

    public boolean isPrioritizedPresentValue() {
        if (this.priPV != null) {
            return this.priPV.getBoolean();
        }
        log.error("\n***\n***\n***\n\npriPV is NULL in " + this + "!  How did we get here?? thd:" + Thread.currentThread().getName());
        new Throwable().printStackTrace();
        return true;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public void setPrioritizedPresentValue(boolean bl) {
        this.priPV = BBoolean.make((boolean)bl);
        if (!bl) {
            this.lastWriteLevel = 0;
        }
        BFacets bFacets = this.getDeviceFacets();
        bFacets = BFacets.make((BFacets)bFacets, (String)PRIORITIZED_PRESENT_VALUE, (BIDataValue)(bl ? BBoolean.TRUE : BBoolean.FALSE));
        this.setDeviceFacets(bFacets);
    }

    public abstract void fromEncodedValue(byte[] var1, BStatus var2, Context var3);

    public abstract byte[] toEncodedValue(BStatusValue var1);

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readMetaData(byte[] var1_1, Context var2_2, BStatusValue var3_3) throws AsnException {
        block16: {
            block15: {
                var4_4 = var3_3.getStatus();
                var5_5 = (PollListEntry)var2_2;
                var6_6 = var5_5.getObjectId();
                if (var6_6.hashCode() != this.getObjectId().hashCode()) break block15;
                var7_7 = var5_5.getPropertyId();
                switch (var7_7) {
                    case 111: {
                        var4_4 = AsnUtil.asnStatusFlagsToBStatus(var1_1);
                        break;
                    }
                    case 36: {
                        var8_10 = AsnUtil.fromAsnEnumerated(var1_1);
                        var9_13 = BBacnetEventState.tag(var8_10);
                        var4_4 = BStatus.make((BStatus)var4_4, (String)"state", (String)var9_13);
                        break;
                    }
                    case 87: {
                        var4_4 = BStatus.make((BStatus)var4_4, (String)"bac", (BIDataValue)BString.make((String)"def"));
                        var10_15 = AsnInputStream.make(var1_1);
                        try {
                            var13_17 = 0;
                            var14_19 = 0;
                            var14_19 = 1;
                            while (var14_19 <= 16) {
                                var13_17 = var10_15.skipTag();
                                if (var13_17 == 0) ** GOTO lbl27
                                var4_4 = BStatus.make((BStatus)var4_4, (String)"bac", (BIDataValue)BInteger.make((int)var14_19));
                                break;
lbl27:
                                // 1 sources

                                ++var14_19;
                            }
                        }
                        catch (Throwable var11_21) {
                            var12_23 = null;
                            var10_15.release();
                            throw var11_21;
                        }
                    }
                    {
                        var12_24 = null;
                        var10_15.release();
                        break;
                    }
                    case 103: {
                        var13_18 = AsnUtil.fromAsnEnumerated(var1_1);
                        var14_20 = BBacnetReliability.tag(var13_18);
                        var4_4 = BStatus.make((BStatus)var4_4, (String)"reliability", (String)var14_20);
                        break;
                    }
                    default: {
                        var15_25 = AsnUtil.asnToValue(this.device().getPropertyInfo(var5_5.getObjectId().getObjectType(), var7_7), var1_1);
                        var16_26 = BBacnetPropertyIdentifier.tag(var7_7);
                        var4_4 = BStatus.make((BStatus)var4_4, (String)var16_26, (String)var15_25.toString());
                        break;
                    }
                }
                break block16;
            }
            if (var6_6.getObjectType() == 9) {
                var7_8 = var5_5.getPropertyId();
                switch (var7_8) {
                    case 36: {
                        var8_11 = AsnUtil.fromAsnEnumerated(var1_1);
                        var9_14 = BBacnetEventState.tag(var8_11);
                        var4_4 = BStatus.make((BStatus)var4_4, (String)("EE" + var6_6.getInstanceNumber()), (String)var9_14);
                        break;
                    }
                    default: {
                        var10_16 = AsnUtil.asnToValue(this.device().getPropertyInfo(9, var7_8), var1_1);
                        var11_22 = BBacnetPropertyIdentifier.tag(var7_8);
                        var4_4 = BStatus.make((BStatus)var4_4, (String)("EE" + var6_6.getInstanceNumber() + '_' + var11_22), (String)var10_16.toString());
                        break;
                    }
                }
            } else {
                var7_9 = var5_5.getObjectId().toString(BacnetConst.facetsContext) + '_' + BBacnetPropertyIdentifier.tag(var5_5.getPropertyId());
                var8_12 = AsnUtil.asnToValue(this.device().getPropertyInfo(var5_5.getObjectId().getObjectType(), var5_5.getPropertyId()), var1_1);
                var4_4 = BStatus.make((BStatus)var4_4, (String)var7_9, (String)var8_12.toString());
            }
        }
        var3_3.setStatus(var4_4);
    }

    protected final BBacnetNetwork network() {
        return (BBacnetNetwork)this.getNetwork();
    }

    protected BBacnetAddress getDeviceAddress() {
        return ((BBacnetDevice)this.getDevice()).getAddress();
    }

    private final int getActiveLevel() {
        return this.getWriteValue().getStatus().geti("activeLevel", 17);
    }

    private final void scheduleResubscribe(boolean bl) {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        BRelTime bRelTime = null;
        if (bl) {
            bRelTime = BRelTime.makeSeconds((int)10);
        } else {
            int n = this.getCovSubscriptionLifetime();
            if (n <= 0) {
                n = 1440;
            }
            if (n <= 5) {
                n = 5;
            }
            bRelTime = BRelTime.make((long)((long)n * 30000L));
        }
        this.ticket = Clock.schedule((BComponent)this, (BRelTime)bRelTime, (Action)subscribeCov, null);
    }

    private final void setDataSize() {
        switch (this.asnType) {
            case 0: {
                this.dataSize = 1;
                break;
            }
            case 1: {
                this.dataSize = 2;
                break;
            }
            case 5: {
                this.dataSize = 9;
                break;
            }
            case 9: {
                this.dataSize = 3;
                break;
            }
            case 7: {
                this.dataSize = 20;
                break;
            }
            default: {
                this.dataSize = 5;
            }
        }
    }

    private final void setAsnType() {
        this.asnType = AsnUtil.getAsnType(this.getDataType());
    }

    private final void discoverPrioritizedPresentValue() {
        int n = this.getObjectId().getObjectType();
        switch (n) {
            case 1: 
            case 4: 
            case 14: {
                boolean bl = false;
                if (this.getPropertyId().getOrdinal() == 85) {
                    bl = true;
                }
                this.priPV = BBoolean.make((boolean)bl);
                break;
            }
            case 2: 
            case 5: 
            case 19: {
                if (this.getPropertyId().getOrdinal() == 85) {
                    BFacets bFacets = this.getDeviceFacets();
                    BBoolean bBoolean = (BBoolean)bFacets.getFacet(PRIORITIZED_PRESENT_VALUE);
                    if (bBoolean == null) {
                        this.network().postWrite(new Runnable(){

                            public final void run() {
                                BBacnetProxyExt.this.checkForPriorityArray();
                            }
                        });
                        break;
                    }
                    this.priPV = bBoolean;
                    break;
                }
                this.priPV = BBoolean.FALSE;
                break;
            }
            default: {
                this.priPV = BBoolean.FALSE;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void checkForPriorityArray() {
        BFacets bFacets = this.getDeviceFacets();
        bFacets = BFacets.make((BFacets)bFacets, (String)PRIORITIZED_PRESENT_VALUE, (BIDataValue)BBoolean.TRUE);
        try {
            try {
                ((BBacnetStack)this.network().getBacnetComm()).getClient().readProperty(this.getDeviceAddress(), this.getObjectId(), 87, 0);
            }
            catch (ErrorException errorException) {
                if (errorException.getErrorType().getErrorCode() == 32) {
                    bFacets = BFacets.make((BFacets)bFacets, (String)PRIORITIZED_PRESENT_VALUE, (BIDataValue)BBoolean.FALSE);
                }
            }
            catch (BacnetException bacnetException) {}
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.setDeviceFacets(bFacets);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.setDeviceFacets(bFacets);
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetProxyExt", 2);
        spyWriter.prop((Object)"asnType", this.asnType);
        spyWriter.prop((Object)"dataSize", this.dataSize);
        spyWriter.prop((Object)"lastReadError", (Object)this.lastReadError);
        spyWriter.prop((Object)"ticket", (Object)this.ticket);
        spyWriter.prop((Object)"prioritizedPV", (Object)this.priPV);
        spyWriter.prop((Object)"lastWriteLevel", this.lastWriteLevel);
        spyWriter.prop((Object)"subState", this.subState);
        spyWriter.prop((Object)"pollService", (Object)this.pollService);
        if (this.ples != null) {
            spyWriter.prop((Object)"ples", this.ples.length);
            int n = 0;
            while (n < this.ples.length) {
                spyWriter.prop((Object)("ples[" + n + "]:"), (Object)this.ples[n].debugString());
                ++n;
            }
        }
        spyWriter.endProps();
    }

    void dbg(String string) {
        if (this.debug) {
            System.out.println("BACPxExtDBG{" + this + "}:" + string);
        }
    }

    private final void setDebug() {
        BBoolean bBoolean = (BBoolean)this.get("debug");
        if (bBoolean != null) {
            this.debug = bBoolean.getBoolean();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.bacnetDevice = null;
        this.debug = false;
        this.ticket = null;
        this.dataSize = 0;
        this.asnType = 0;
        this.priPV = BBoolean.FALSE;
        this.useStatusFlags = null;
        this.lastWriteLevel = 0;
        this.subState = 0;
        this.ples = null;
    }

    public BBacnetProxyExt() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$bacnet$point$BBacnetProxyExt;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$point$BBacnetProxyExt = BBacnetProxyExt.class("[Ljavax.baja.bacnet.point.BBacnetProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        NO_VALUE = new byte[0];
        ERROR_DEVICE_OTHER = new NErrorType(0, 0);
        covContext = new BasicContext(){

            public final boolean equals(Object object) {
                boolean bl = false;
                if (this == object) {
                    bl = true;
                }
                return bl;
            }

            public final String toString() {
                return "Bacnet:covContext";
            }
        };
        log = Log.getLog((String)"bacnet.point");
    }
}

