/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.BacnetVendorUtil;
import com.tridium.bacnet.ObjectTypeList;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import com.tridium.bacnet.services.error.NChangeListError;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.DeviceRegistry;
import com.tridium.bacnet.stack.network.BBacnetNetworkLayer;
import com.tridium.bacnet.stack.server.BBacnetExportTable;
import com.tridium.bacnet.stack.server.LocalBacnetCovPropPoll;
import com.tridium.bacnet.stack.transport.BBacnetTransportLayer;
import com.tridium.sys.station.Station;
import com.tridium.util.ComponentTreeCursor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BIBacnetObjectContainer;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetAddressBinding;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetCovSubscription;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetRecipient;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetBackupState;
import javax.baja.bacnet.enums.BBacnetDeviceStatus;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetSegmentation;
import javax.baja.bacnet.enums.BCharacterSetEncoding;
import javax.baja.bacnet.enums.BExtensibleEnumList;
import javax.baja.bacnet.export.BBacnetEventSource;
import javax.baja.bacnet.export.BBacnetNotificationClassDescriptor;
import javax.baja.bacnet.export.BBacnetScheduleDescriptor;
import javax.baja.bacnet.export.BIBacnetCovSource;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BacnetCovSubscriber;
import javax.baja.bacnet.export.PointSubscriber;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RangeReference;
import javax.baja.bacnet.io.RejectException;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.bacnet.virtual.BLocalBacnetVirtualGateway;
import javax.baja.data.BIDataValue;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.security.PermissionException;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLocalBacnetDevice
extends BComponent
implements BIBacnetExportObject,
BIBacnetObjectContainer {
    private static final BBacnetBitString SERVER_OBJECT_TYPES_SUPPORTED;
    private static final BBacnetBitString SERVER_SERVICES_SUPPORTED;
    public static final Property status;
    public static final Property faultCause;
    public static final Property objectId;
    public static final Property systemStatus;
    public static final Property vendorName;
    public static final Property vendorId;
    public static final Property modelName;
    public static final Property firmwareRevision;
    public static final Property applicationSoftwareVersion;
    public static final Property location;
    public static final Property description;
    public static final Property protocolVersion;
    public static final Property protocolRevision;
    public static final Property protocolConformanceClass;
    public static final Property protocolServicesSupported;
    public static final Property protocolObjectTypesSupported;
    public static final Property maxAPDULengthAccepted;
    public static final Property segmentationSupported;
    public static final Property maxSegmentsAccepted;
    public static final Property apduSegmentTimeout;
    public static final Property apduTimeout;
    public static final Property numberOfApduRetries;
    public static final Property deviceAddressBinding;
    public static final Property databaseRevision;
    public static final Property configurationFiles;
    public static final Property lastRestoreTime;
    public static final Property backupFailureTimeout;
    public static final Property backupPreparationTime;
    public static final Property restorePreparationTime;
    public static final Property restoreCompletionTime;
    public static final Property backupAndRestoreState;
    public static final Property activeCovSubscriptions;
    public static final Property characterSet;
    public static final Property enumerationList;
    public static final Property exportTable;
    public static final Property virtual;
    public static final Property covPropertyPollRate;
    public static final Property timeSynchronizationRecipients;
    public static final Property timeSynchronizationInterval;
    public static final Property alignIntervals;
    public static final Property intervalOffset;
    public static final Property utcTimeSynchronizationRecipients;
    public static final Action sendIAm;
    public static final Action setBackupMode;
    public static final Action setRestoreMode;
    public static final Action println;
    public static final Action sendTimeSynch;
    public static final Type TYPE;
    private static final BIcon icon;
    private static Lexicon lex;
    private static final int[] REQUIRED_PROPS;
    public static final String LAST_RESTORE_TIME_FILENAME = "!backups/lastRestoreTime";
    private static Log log;
    private static AsnInputStream asnIn;
    private static AsnOutputStream asnOut;
    static BasicContext bacnetContext;
    private static boolean allowObjectIdWrite;
    private boolean fatalFault;
    private boolean brandPropertiesRead;
    private BacnetCovSubscriber covSubscriber;
    private BIBacnetExportObject.ObjectSubscriber objectSubscriber;
    private PointSubscriber pointSubscriber;
    private int maxWaitTime;
    private String objectName;
    private BBacnetDeviceStatus preBackupStatus;
    private BBacnetDeviceStatus preRestoreStatus;
    private LocalBacnetCovPropPoll covPropPoller;
    private Clock.Ticket tsTicket;
    private Object TIME_SYNC_LOCK;
    private BAbsTime lastTSTime;
    private Station.SaveListener saveListener;
    static /* synthetic */ Class class$javax$baja$bacnet$export$BLocalBacnetDevice;
    static /* synthetic */ Class class$javax$baja$nav$BINavNode;
    static /* synthetic */ Class class$javax$baja$bacnet$export$BIBacnetExportObject;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetRecipient;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetAddressBinding;
    static /* synthetic */ Class class$javax$baja$naming$BOrd;
    static /* synthetic */ Class class$com$tridium$bacnet$stack$network$BNetworkPort;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    public void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.set(objectId, (BValue)bBacnetObjectIdentifier, null);
    }

    public BBacnetDeviceStatus getSystemStatus() {
        return (BBacnetDeviceStatus)this.get(systemStatus);
    }

    public void setSystemStatus(BBacnetDeviceStatus bBacnetDeviceStatus) {
        this.set(systemStatus, (BValue)bBacnetDeviceStatus, null);
    }

    public String getVendorName() {
        return this.getString(vendorName);
    }

    public void setVendorName(String string) {
        this.setString(vendorName, string, null);
    }

    public int getVendorId() {
        return this.getInt(vendorId);
    }

    public void setVendorId(int n) {
        this.setInt(vendorId, n, null);
    }

    public String getModelName() {
        return this.getString(modelName);
    }

    public void setModelName(String string) {
        this.setString(modelName, string, null);
    }

    public String getFirmwareRevision() {
        return this.getString(firmwareRevision);
    }

    public void setFirmwareRevision(String string) {
        this.setString(firmwareRevision, string, null);
    }

    public String getApplicationSoftwareVersion() {
        return this.getString(applicationSoftwareVersion);
    }

    public void setApplicationSoftwareVersion(String string) {
        this.setString(applicationSoftwareVersion, string, null);
    }

    public String getLocation() {
        return this.getString(location);
    }

    public void setLocation(String string) {
        this.setString(location, string, null);
    }

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String string) {
        this.setString(description, string, null);
    }

    public int getProtocolVersion() {
        return this.getInt(protocolVersion);
    }

    public void setProtocolVersion(int n) {
        this.setInt(protocolVersion, n, null);
    }

    public int getProtocolRevision() {
        return this.getInt(protocolRevision);
    }

    public void setProtocolRevision(int n) {
        this.setInt(protocolRevision, n, null);
    }

    public int getProtocolConformanceClass() {
        return this.getInt(protocolConformanceClass);
    }

    public void setProtocolConformanceClass(int n) {
        this.setInt(protocolConformanceClass, n, null);
    }

    public BBacnetBitString getProtocolServicesSupported() {
        return (BBacnetBitString)this.get(protocolServicesSupported);
    }

    public void setProtocolServicesSupported(BBacnetBitString bBacnetBitString) {
        this.set(protocolServicesSupported, (BValue)bBacnetBitString, null);
    }

    public BBacnetBitString getProtocolObjectTypesSupported() {
        return (BBacnetBitString)this.get(protocolObjectTypesSupported);
    }

    public void setProtocolObjectTypesSupported(BBacnetBitString bBacnetBitString) {
        this.set(protocolObjectTypesSupported, (BValue)bBacnetBitString, null);
    }

    public int getMaxAPDULengthAccepted() {
        return this.getInt(maxAPDULengthAccepted);
    }

    public void setMaxAPDULengthAccepted(int n) {
        this.setInt(maxAPDULengthAccepted, n, null);
    }

    public BBacnetSegmentation getSegmentationSupported() {
        return (BBacnetSegmentation)this.get(segmentationSupported);
    }

    public void setSegmentationSupported(BBacnetSegmentation bBacnetSegmentation) {
        this.set(segmentationSupported, (BValue)bBacnetSegmentation, null);
    }

    public int getMaxSegmentsAccepted() {
        return this.getInt(maxSegmentsAccepted);
    }

    public void setMaxSegmentsAccepted(int n) {
        this.setInt(maxSegmentsAccepted, n, null);
    }

    public int getApduSegmentTimeout() {
        return this.getInt(apduSegmentTimeout);
    }

    public void setApduSegmentTimeout(int n) {
        this.setInt(apduSegmentTimeout, n, null);
    }

    public int getApduTimeout() {
        return this.getInt(apduTimeout);
    }

    public void setApduTimeout(int n) {
        this.setInt(apduTimeout, n, null);
    }

    public int getNumberOfApduRetries() {
        return this.getInt(numberOfApduRetries);
    }

    public void setNumberOfApduRetries(int n) {
        this.setInt(numberOfApduRetries, n, null);
    }

    public BBacnetListOf getDeviceAddressBinding() {
        return (BBacnetListOf)this.get(deviceAddressBinding);
    }

    public void setDeviceAddressBinding(BBacnetListOf bBacnetListOf) {
        this.set(deviceAddressBinding, (BValue)bBacnetListOf, null);
    }

    public int getDatabaseRevision() {
        return this.getInt(databaseRevision);
    }

    public void setDatabaseRevision(int n) {
        this.setInt(databaseRevision, n, null);
    }

    public BBacnetArray getConfigurationFiles() {
        return (BBacnetArray)this.get(configurationFiles);
    }

    public void setConfigurationFiles(BBacnetArray bBacnetArray) {
        this.set(configurationFiles, (BValue)bBacnetArray, null);
    }

    public BBacnetTimeStamp getLastRestoreTime() {
        return (BBacnetTimeStamp)this.get(lastRestoreTime);
    }

    public void setLastRestoreTime(BBacnetTimeStamp bBacnetTimeStamp) {
        this.set(lastRestoreTime, (BValue)bBacnetTimeStamp, null);
    }

    public BRelTime getBackupFailureTimeout() {
        return (BRelTime)this.get(backupFailureTimeout);
    }

    public void setBackupFailureTimeout(BRelTime bRelTime) {
        this.set(backupFailureTimeout, (BValue)bRelTime, null);
    }

    public BRelTime getBackupPreparationTime() {
        return (BRelTime)this.get(backupPreparationTime);
    }

    public void setBackupPreparationTime(BRelTime bRelTime) {
        this.set(backupPreparationTime, (BValue)bRelTime, null);
    }

    public BRelTime getRestorePreparationTime() {
        return (BRelTime)this.get(restorePreparationTime);
    }

    public void setRestorePreparationTime(BRelTime bRelTime) {
        this.set(restorePreparationTime, (BValue)bRelTime, null);
    }

    public BRelTime getRestoreCompletionTime() {
        return (BRelTime)this.get(restoreCompletionTime);
    }

    public void setRestoreCompletionTime(BRelTime bRelTime) {
        this.set(restoreCompletionTime, (BValue)bRelTime, null);
    }

    public BBacnetBackupState getBackupAndRestoreState() {
        return (BBacnetBackupState)this.get(backupAndRestoreState);
    }

    public void setBackupAndRestoreState(BBacnetBackupState bBacnetBackupState) {
        this.set(backupAndRestoreState, (BValue)bBacnetBackupState, null);
    }

    public BBacnetListOf getActiveCovSubscriptions() {
        return (BBacnetListOf)this.get(activeCovSubscriptions);
    }

    public void setActiveCovSubscriptions(BBacnetListOf bBacnetListOf) {
        this.set(activeCovSubscriptions, (BValue)bBacnetListOf, null);
    }

    public BCharacterSetEncoding getCharacterSet() {
        return (BCharacterSetEncoding)this.get(characterSet);
    }

    public void setCharacterSet(BCharacterSetEncoding bCharacterSetEncoding) {
        this.set(characterSet, (BValue)bCharacterSetEncoding, null);
    }

    public BExtensibleEnumList getEnumerationList() {
        return (BExtensibleEnumList)this.get(enumerationList);
    }

    public void setEnumerationList(BExtensibleEnumList bExtensibleEnumList) {
        this.set(enumerationList, (BValue)bExtensibleEnumList, null);
    }

    public BComponent getExportTable() {
        return (BComponent)this.get(exportTable);
    }

    public void setExportTable(BComponent bComponent) {
        this.set(exportTable, (BValue)bComponent, null);
    }

    public BLocalBacnetVirtualGateway getVirtual() {
        return (BLocalBacnetVirtualGateway)this.get(virtual);
    }

    public void setVirtual(BLocalBacnetVirtualGateway bLocalBacnetVirtualGateway) {
        this.set(virtual, (BValue)bLocalBacnetVirtualGateway, null);
    }

    public BRelTime getCovPropertyPollRate() {
        return (BRelTime)this.get(covPropertyPollRate);
    }

    public void setCovPropertyPollRate(BRelTime bRelTime) {
        this.set(covPropertyPollRate, (BValue)bRelTime, null);
    }

    public BBacnetListOf getTimeSynchronizationRecipients() {
        return (BBacnetListOf)this.get(timeSynchronizationRecipients);
    }

    public void setTimeSynchronizationRecipients(BBacnetListOf bBacnetListOf) {
        this.set(timeSynchronizationRecipients, (BValue)bBacnetListOf, null);
    }

    public BRelTime getTimeSynchronizationInterval() {
        return (BRelTime)this.get(timeSynchronizationInterval);
    }

    public void setTimeSynchronizationInterval(BRelTime bRelTime) {
        this.set(timeSynchronizationInterval, (BValue)bRelTime, null);
    }

    public boolean getAlignIntervals() {
        return this.getBoolean(alignIntervals);
    }

    public void setAlignIntervals(boolean bl) {
        this.setBoolean(alignIntervals, bl, null);
    }

    public int getIntervalOffset() {
        return this.getInt(intervalOffset);
    }

    public void setIntervalOffset(int n) {
        this.setInt(intervalOffset, n, null);
    }

    public BBacnetListOf getUtcTimeSynchronizationRecipients() {
        return (BBacnetListOf)this.get(utcTimeSynchronizationRecipients);
    }

    public void setUtcTimeSynchronizationRecipients(BBacnetListOf bBacnetListOf) {
        this.set(utcTimeSynchronizationRecipients, (BValue)bBacnetListOf, null);
    }

    public void sendIAm() {
        this.invoke(sendIAm, null, null);
    }

    public void setBackupMode(BBoolean bBoolean) {
        this.invoke(setBackupMode, (BValue)bBoolean, null);
    }

    public void setRestoreMode(BBoolean bBoolean) {
        this.invoke(setRestoreMode, (BValue)bBoolean, null);
    }

    public void println(BString bString) {
        this.invoke(println, (BValue)bString, null);
    }

    public void sendTimeSynch() {
        this.invoke(sendTimeSynch, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String toString(Context context) {
        return "Local Bacnet Device [" + (Object)((Object)this.getObjectId()) + ']';
    }

    public void started() throws Exception {
        super.started();
        this.checkFatalFault();
        BModule bModule = Sys.getBajaModule();
        this.setFirmwareRevision(bModule.getVendorVersion().toString());
        bModule = BBacnetNetwork.bacnet().getType().getModule();
        this.setApplicationSoftwareVersion(bModule.getVendor() + ' ' + bModule.getVendorVersion());
        this.objectName = Sys.getStation().getStationName();
        this.set(protocolRevision, protocolRevision.getDefaultValue());
        this.checkConfiguration();
        this.network().postAsync(new Runnable(){

            public final void run() {
                BLocalBacnetDevice.this.readBrandProperties();
            }
        });
        this.linkTo("sendIAmLink", this, (Slot)objectId, (Slot)sendIAm);
        this.setFlags(this.getSlot("sendIAmLink"), this.getFlags(this.getSlot("sendIAmLink")) | 4);
        Station.addSaveListener((Station.SaveListener)this.saveListener);
        try {
            BLocalBacnetDevice.getBacnetContext();
        }
        catch (Exception exception) {}
        this.maxWaitTime = this.getApduTimeout() * (this.getNumberOfApduRetries() + 1);
    }

    public void descendantsStarted() {
        BFileSystem bFileSystem = BFileSystem.INSTANCE;
        FilePath filePath = new FilePath(LAST_RESTORE_TIME_FILENAME);
        BIFile bIFile = bFileSystem.findFile(filePath);
        if (bIFile != null) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bIFile.getInputStream()));
                String string = bufferedReader.readLine();
                BAbsTime bAbsTime = BAbsTime.make((String)string);
                BBacnetTimeStamp bBacnetTimeStamp = new BBacnetTimeStamp(bAbsTime);
                this.setLastRestoreTime(bBacnetTimeStamp);
                string = bufferedReader.readLine();
                int n = Integer.parseInt(string);
                this.setDatabaseRevision(n + 1);
                bIFile.delete();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void stopped() {
        Station.removeSaveListener((Station.SaveListener)this.saveListener);
        this.covSubscriber.unsubscribeAll();
        this.covSubscriber = null;
        if (this.tsTicket != null) {
            this.tsTicket.cancel();
        }
        this.tsTicket = null;
        this.lastTSTime = null;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)objectId)) {
            this.checkConfiguration();
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (property.equals((Object)apduTimeout) || property.equals((Object)numberOfApduRetries)) {
            this.maxWaitTime = this.getApduTimeout() * (this.getNumberOfApduRetries() + 1);
            BBacnetTransportLayer bBacnetTransportLayer = ((BBacnetStack)((BBacnetNetwork)this.getParent()).getBacnetComm()).getTransport();
            long l = bBacnetTransportLayer.getLockupThreshold().getMillis();
            if ((long)this.maxWaitTime > l) {
                Log.getLog((String)"bacnet.transport").message("Reconfiguring Transport layer lockup threshold...");
                bBacnetTransportLayer.set(BBacnetTransportLayer.lockupThreshold, (BValue)BRelTime.make((long)this.maxWaitTime), BacnetConst.fallback);
            }
        }
        if (property.equals((Object)timeSynchronizationInterval) || property.equals((Object)alignIntervals) || property.equals((Object)intervalOffset)) {
            this.scheduleTimeSynch();
        }
        if (property.equals((Object)timeSynchronizationRecipients)) {
            this.checkRecipients(property);
        } else if (property.equals((Object)utcTimeSynchronizationRecipients)) {
            this.checkRecipients(property);
        }
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        this.checkRecipients(timeSynchronizationRecipients);
        this.checkRecipients(utcTimeSynchronizationRecipients);
        this.sendTimeSynch();
        this.scheduleTimeSynch();
    }

    public void clockChanged(BRelTime bRelTime) throws Exception {
        this.sendTimeSynch();
        this.scheduleTimeSynch();
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BBacnetNetwork;
    }

    public BINavNode[] getNavChildren() {
        BINavNode[] bINavNodeArray = super.getNavChildren();
        Class clazz = class$javax$baja$nav$BINavNode;
        if (clazz == null) {
            clazz = class$javax$baja$nav$BINavNode = BLocalBacnetDevice.class("[Ljavax.baja.nav.BINavNode;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < bINavNodeArray.length) {
            BComponent bComponent = (BComponent)bINavNodeArray[n];
            if (!bComponent.getType().is(BBacnetListOf.TYPE) && !bComponent.getType().is(BBacnetArray.TYPE)) {
                array.add((Object)bComponent);
            }
            ++n;
        }
        return (BINavNode[])array.trim();
    }

    public final BObject getObject() {
        return this;
    }

    public final BOrd getObjectOrd() {
        return this.getOrdInSession();
    }

    public final void setObjectOrd(BOrd bOrd, Context context) {
        throw new UnsupportedOperationException(lex.getText("UnsupportedOperationException.localDevice.setObjectOrd"));
    }

    public String getObjectName() {
        return this.objectName + '_' + this.getObjectId().getInstanceNumber();
    }

    public void setObjectName(String string) {
        throw new UnsupportedOperationException(lex.getText("UnsupportedOperationException.localDevice.setObjectName"));
    }

    public void checkConfiguration() {
        BIBacnetExportObject bIBacnetExportObject;
        if (this.isFatalFault()) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            return;
        }
        boolean bl = true;
        if (!this.getObjectId().isValid()) {
            this.setFaultCause("Invalid Object ID");
            bl = false;
        }
        if (Sys.getStation() != null && ((bIBacnetExportObject = BBacnetNetwork.localDevice().lookupBacnetObject(this.getObjectName())) == null || bIBacnetExportObject != this)) {
            this.setFaultCause("Duplicate Object_Name");
            bl = false;
        }
        if (bl) {
            this.setFaultCause("");
        }
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)(bl ^ true)));
    }

    public String export(BIBacnetExportObject bIBacnetExportObject) {
        return this.exports().export(bIBacnetExportObject);
    }

    public void unexport(BBacnetObjectIdentifier bBacnetObjectIdentifier, String string, BIBacnetExportObject bIBacnetExportObject) {
        this.exports().unexport(bBacnetObjectIdentifier, string, bIBacnetExportObject);
        if (this.isRunning()) {
            this.checkDuplicates(bIBacnetExportObject);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkDuplicates(BIBacnetExportObject var1_1) {
        var2_2 = new ComponentTreeCursor((BComponent)this.exports(), null);
        var3_3 = null;
        if (true) ** GOTO lbl7
        do {
            if ((var3_3 = (BIBacnetExportObject)var2_2.get()).getStatus().isFault() && var3_3 != var1_1) {
                var3_3.checkConfiguration();
            }
lbl7:
            // 4 sources

            if ((v0 = BLocalBacnetDevice.class$javax$baja$bacnet$export$BIBacnetExportObject) != null) continue;
            v0 = BLocalBacnetDevice.class("[Ljavax.baja.bacnet.export.BIBacnetExportObject;", false);
        } while (var2_2.next(v0));
    }

    private final BBacnetExportTable exports() {
        return (BBacnetExportTable)this.getExportTable();
    }

    public final BIBacnetExportObject lookupBacnetObject(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        if (this.getObjectId().equals((Object)bBacnetObjectIdentifier)) {
            return this;
        }
        return this.exports().byObjectId(bBacnetObjectIdentifier);
    }

    public final BIBacnetExportObject lookupBacnetObject(String string) {
        if (this.getObjectName().equals(string)) {
            return this;
        }
        return this.exports().byObjectName(string);
    }

    public final BBacnetObjectIdentifier lookupBacnetObjectId(BOrd bOrd) {
        if (this.getObjectOrd().equals((Object)bOrd)) {
            return this.getObjectId();
        }
        return this.exports().byObjectOrd(bOrd);
    }

    public final int getNextInstance(int n) {
        return this.exports().getNextInstance(n);
    }

    public final void incrementDatabaseRevision() {
        this.setDatabaseRevision(this.getDatabaseRevision() + 1);
    }

    public final BObject lookupBacnetObject(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, String string) {
        return (BObject)this.lookupBacnetObject(bBacnetObjectIdentifier);
    }

    public final void doSendIAm() {
        ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getServer().iAm();
    }

    public void doSetBackupMode(BBoolean bBoolean) {
        if (this.getSystemStatus().getOrdinal() == 3) {
            throw new IllegalStateException("Cannot modify backup mode while restore is in progress");
        }
        if (bBoolean.getBoolean()) {
            log.message("Entering Backup Mode...");
            this.preBackupStatus = this.getSystemStatus();
            this.setBackupAndRestoreState(BBacnetBackupState.preparingForBackup);
            this.setSystemStatus(BBacnetDeviceStatus.backupInProgress);
        } else {
            log.message("Exiting Backup Mode...");
            this.setBackupAndRestoreState(BBacnetBackupState.idle);
            this.setSystemStatus(this.preBackupStatus);
            ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getServer().cleanupBackupMode();
        }
    }

    public void doSetRestoreMode(BBoolean bBoolean) {
        if (this.getSystemStatus().getOrdinal() == 5) {
            throw new IllegalStateException("Cannot modify restore mode while backup is in progress");
        }
        if (bBoolean.getBoolean()) {
            log.message("Entering Restore Mode...");
            this.preRestoreStatus = this.getSystemStatus();
            this.setBackupAndRestoreState(BBacnetBackupState.preparingForRestore);
            this.setSystemStatus(BBacnetDeviceStatus.downloadInProgress);
        } else {
            log.message("Exiting Restore Mode...");
            this.setBackupAndRestoreState(BBacnetBackupState.idle);
            this.setSystemStatus(this.preRestoreStatus);
            ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getServer().cleanupBackupMode();
        }
    }

    public final void doPrintln(BString bString) {
        System.out.println("\n\n********\n" + bString + "\n********\n");
    }

    /*
     * Unable to fully structure code
     */
    public final void doSendTimeSynch() {
        this.lastTSTime = BAbsTime.make();
        if (BLocalBacnetDevice.log.isTraceOn()) {
            BLocalBacnetDevice.log.trace("Sending Automatic Time Synch...");
        }
        try {
            var1_1 = ((BBacnetStack)this.network().getBacnetComm()).getClient();
            var2_3 = this.getTimeSynchronizationRecipients().getProperties();
            var3_4 = null;
            if (true) ** GOTO lbl12
            do {
                if (!(var3_4 = (BBacnetRecipient)var2_3.get()).isDevice() || var3_4.getDevice().isValid() && DeviceRegistry.getDeviceAddress(var3_4.getDevice()) != null) {
                    var1_1.timeSynch(var3_4);
                }
lbl12:
                // 4 sources

                if ((v0 = BLocalBacnetDevice.class$javax$baja$bacnet$datatypes$BBacnetRecipient) != null) continue;
                v0 = BLocalBacnetDevice.class("[Ljavax.baja.bacnet.datatypes.BBacnetRecipient;", false);
            } while (var2_3.next(v0));
            var2_3 = this.getUtcTimeSynchronizationRecipients().getProperties();
            if (true) ** GOTO lbl20
            do {
                if (!(var3_4 = (BBacnetRecipient)var2_3.get()).isDevice() || var3_4.getDevice().isValid() && DeviceRegistry.getDeviceAddress(var3_4.getDevice()) != null) {
                    var1_1.utcTimeSynch(var3_4);
                }
lbl20:
                // 4 sources

                if ((v1 = BLocalBacnetDevice.class$javax$baja$bacnet$datatypes$BBacnetRecipient) != null) continue;
                v1 = BLocalBacnetDevice.class("[Ljavax.baja.bacnet.datatypes.BBacnetRecipient;", false);
            } while (var2_3.next(v1));
        }
        catch (BacnetException var1_2) {
            BLocalBacnetDevice.log.warning("BacnetException sending time synch! {" + (Object)var1_2 + '}', (Throwable)var1_2);
        }
    }

    public final void addAddressBinding(BBacnetDevice bBacnetDevice) {
        BBacnetAddressBinding bBacnetAddressBinding;
        BBacnetAddress bBacnetAddress = (BBacnetAddress)bBacnetDevice.getAddress().newCopy();
        BBacnetNetworkLayer bBacnetNetworkLayer = ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getNetwork();
        if (bBacnetNetworkLayer.isDirectlyConnectedNetwork(bBacnetAddress.getNetworkNumber())) {
            bBacnetAddress.setNetworkNumber(0);
        }
        if ((bBacnetAddressBinding = this.bindingById(bBacnetDevice.getObjectId())) == null) {
            bBacnetAddressBinding = new BBacnetAddressBinding(bBacnetDevice.getObjectId(), bBacnetAddress);
            this.getDeviceAddressBinding().addListElement((BValue)bBacnetAddressBinding, null);
        } else {
            bBacnetAddressBinding.getDeviceAddress().copyFrom((BComplex)bBacnetAddress);
        }
        Flags.setAllReadonly((BComponent)this.getDeviceAddressBinding(), (boolean)true, null);
    }

    public final void removeAddressBinding(BBacnetDevice bBacnetDevice) {
        BBacnetAddressBinding bBacnetAddressBinding = this.bindingById(bBacnetDevice.getObjectId());
        if (bBacnetAddressBinding != null) {
            this.getDeviceAddressBinding().removeListElement((BValue)bBacnetAddressBinding, null);
        }
    }

    public final void updateAddressBinding(BBacnetObjectIdentifier bBacnetObjectIdentifier, BBacnetObjectIdentifier bBacnetObjectIdentifier2) {
        BBacnetAddressBinding bBacnetAddressBinding = this.bindingById(bBacnetObjectIdentifier);
        if (bBacnetAddressBinding != null) {
            bBacnetAddressBinding.setDeviceObjectId(bBacnetObjectIdentifier2);
        }
    }

    public final void updateAddressBinding(BBacnetAddress bBacnetAddress, BBacnetAddress bBacnetAddress2) {
        BBacnetAddressBinding bBacnetAddressBinding;
        BBacnetAddress bBacnetAddress3 = (BBacnetAddress)bBacnetAddress.newCopy();
        BBacnetNetworkLayer bBacnetNetworkLayer = ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getNetwork();
        if (bBacnetNetworkLayer.isDirectlyConnectedNetwork(bBacnetAddress3.getNetworkNumber())) {
            bBacnetAddress3.setNetworkNumber(0);
        }
        if ((bBacnetAddressBinding = this.bindingByAddress(bBacnetAddress3)) != null) {
            bBacnetAddressBinding.getDeviceAddress().copyFrom((BComplex)bBacnetAddress2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final BBacnetAddressBinding bindingById(BBacnetObjectIdentifier var1_1) {
        var2_2 = this.getDeviceAddressBinding().getProperties();
        if (true) ** GOTO lbl6
        do {
            if ((var3_3 = (BBacnetAddressBinding)var2_2.get()).getDeviceObjectId().equals((Object)var1_1)) {
                return var3_3;
            }
lbl6:
            // 3 sources

            if ((v0 = BLocalBacnetDevice.class$javax$baja$bacnet$datatypes$BBacnetAddressBinding) != null) continue;
            v0 = BLocalBacnetDevice.class("[Ljavax.baja.bacnet.datatypes.BBacnetAddressBinding;", false);
        } while (var2_2.next(v0));
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private final BBacnetAddressBinding bindingByAddress(BBacnetAddress var1_1) {
        if (var1_1 == null) {
            return null;
        }
        var2_2 = var1_1.getMacAddress().getBytes();
        var3_3 = this.getDeviceAddressBinding().getProperties();
        if (true) ** GOTO lbl9
        do {
            if ((var4_4 = (BBacnetAddressBinding)var3_3.get()).getDeviceAddress().macEquals(var2_2)) {
                return var4_4;
            }
lbl9:
            // 3 sources

            if ((v0 = BLocalBacnetDevice.class$javax$baja$bacnet$datatypes$BBacnetAddressBinding) != null) continue;
            v0 = BLocalBacnetDevice.class("[Ljavax.baja.bacnet.datatypes.BBacnetAddressBinding;", false);
        } while (var3_3.next(v0));
        return null;
    }

    public final PropertyValue readProperty(PropertyReference propertyReference) throws RejectException {
        return this.readProperty(propertyReference.getPropertyId(), propertyReference.getPropertyArrayIndex());
    }

    public final PropertyValue[] readPropertyMultiple(PropertyReference[] propertyReferenceArray) throws RejectException {
        PropertyValue[] propertyValueArray = new PropertyValue[]{};
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>(propertyReferenceArray.length);
        int n = 0;
        while (n < propertyReferenceArray.length) {
            switch (propertyReferenceArray[n].getPropertyId()) {
                case 8: {
                    int[] nArray = REQUIRED_PROPS;
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2]));
                        ++n2;
                    }
                    nArray = this.getOptionalProps();
                    n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2]));
                        ++n2;
                    }
                    break;
                }
                case 80: {
                    int[] nArray = this.getOptionalProps();
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2]));
                        ++n2;
                    }
                    break;
                }
                case 105: {
                    int[] nArray = REQUIRED_PROPS;
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2]));
                        ++n2;
                    }
                    break;
                }
                default: {
                    arrayList.add(this.readProperty(propertyReferenceArray[n].getPropertyId(), propertyReferenceArray[n].getPropertyArrayIndex()));
                }
            }
            ++n;
        }
        return arrayList.toArray(propertyValueArray);
    }

    public final RangeData readRange(RangeReference rangeReference) throws RejectException {
        int n = rangeReference.getPropertyId();
        switch (n) {
            case 30: {
                BBacnetListOf bBacnetListOf = this.getDeviceAddressBinding();
                Class clazz = class$javax$baja$bacnet$datatypes$BBacnetAddressBinding;
                if (clazz == null) {
                    clazz = class$javax$baja$bacnet$datatypes$BBacnetAddressBinding = BLocalBacnetDevice.class("[Ljavax.baja.bacnet.datatypes.BBacnetAddressBinding;", false);
                }
                Object[] objectArray = (BBacnetAddressBinding[])bBacnetListOf.getChildren(clazz);
                return this.readRange(rangeReference, objectArray, 16);
            }
            case 152: {
                BBacnetListOf bBacnetListOf = this.getActiveCovSubscriptions();
                Class clazz = class$javax$baja$naming$BOrd;
                if (clazz == null) {
                    clazz = class$javax$baja$naming$BOrd = BLocalBacnetDevice.class("[Ljavax.baja.naming.BOrd;", false);
                }
                BOrd[] bOrdArray = (BOrd[])bBacnetListOf.getChildren(clazz);
                Object[] objectArray = new BBacnetCovSubscription[bOrdArray.length];
                int n2 = 0;
                try {
                    n2 = 0;
                    while (n2 < bOrdArray.length) {
                        objectArray[n2] = (BBacnetCovSubscription)bOrdArray[n2].get((BObject)this);
                        ++n2;
                    }
                    return this.readRange(rangeReference, objectArray, 44);
                }
                catch (Exception exception) {
                    log.message("Exception building Active_COV_Subscriptions[" + n2 + "] for ReadRange:" + exception);
                    return new ReadRangeAck(0, 25);
                }
            }
        }
        int n3 = 0;
        while (n3 < REQUIRED_PROPS.length) {
            if (n == REQUIRED_PROPS[n3]) {
                return new ReadRangeAck(5, 22);
            }
            ++n3;
        }
        int[] nArray = this.getOptionalProps();
        int n4 = 0;
        while (n4 < nArray.length) {
            if (n == nArray[n4]) {
                return new ReadRangeAck(5, 22);
            }
            ++n4;
        }
        return new ReadRangeAck(2, 32);
    }

    public final ErrorType writeProperty(PropertyValue propertyValue) throws BacnetException {
        return this.writeProperty(propertyValue.getPropertyId(), propertyValue.getPropertyArrayIndex(), propertyValue.getPropertyValue(), propertyValue.getPriority());
    }

    public final ChangeListError addListElements(PropertyValue propertyValue) throws BacnetException {
        return this.addListElements(propertyValue.getPropertyId(), propertyValue.getPropertyArrayIndex(), propertyValue.getPropertyValue());
    }

    public final ChangeListError removeListElements(PropertyValue propertyValue) throws BacnetException {
        return this.removeListElements(propertyValue.getPropertyId(), propertyValue.getPropertyArrayIndex(), propertyValue.getPropertyValue());
    }

    public int getDeviceTimeout() {
        return this.maxWaitTime;
    }

    boolean isArray(int n) {
        if (n == 76) {
            return true;
        }
        if (n == 154) {
            return true;
        }
        if (n == 172) {
            return true;
        }
        return n == 169;
    }

    private final PropertyValue readProperty(int n) {
        return this.readProperty(n, -1);
    }

    /*
     * Exception decompiling
     */
    protected PropertyValue readProperty(int var1_1, int var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [6 : 44->1601)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected RangeData readRange(RangeReference var1_1, Object[] var2_2, int var3_3) {
        block30: {
            block27: {
                block28: {
                    var4_4 = var1_1.getRangeType();
                    var5_5 = var2_2.length;
                    var6_6 = new boolean[3];
                    var7_7 = -1;
                    if (var1_1 instanceof BacnetConfirmedRequest) {
                        var7_7 = ((BacnetConfirmedRequest)var1_1).getMaxDataLength() - 23 + 3 + 5;
                    }
                    if (var4_4 != 3) break block27;
                    var8_8 = (int)var1_1.getReferenceIndex();
                    var9_10 = var1_1.getCount();
                    if (var8_8 > var5_5 || var8_8 < 1) {
                        return new ReadRangeAck(this.getObjectId(), var1_1.getPropertyId(), -1, BBacnetBitString.emptyBitString(3), 0L, new byte[0]);
                    }
                    var10_12 = new Array();
                    var11_13 = 0;
                    if (var9_10 <= 0) break block28;
                    var12_14 = var8_8 - 1;
                    if (true) ** GOTO lbl55
                }
                if (var9_10 >= 0) {
                    return new ReadRangeAck(5, 7);
                }
                var9_10 = -var9_10;
                var12_14 = var8_8 - 1;
                if (true) ** GOTO lbl66
            }
            if (var4_4 != -1) {
                return new ReadRangeAck(5, 7);
            }
            var6_6[0] = true;
            var8_9 = 0;
            var9_11 = BLocalBacnetDevice.asnOut;
            synchronized (var9_11) {
                block24: {
                    BLocalBacnetDevice.asnOut.reset();
                    if (var7_7 <= 0) break block24;
                    var12_16 = 0;
                    while (var12_16 < var5_5) {
                        ((BIBacnetDataType)var2_2[var12_16]).writeAsn(BLocalBacnetDevice.asnOut);
                        ++var8_9;
                        if (var7_7 - BLocalBacnetDevice.asnOut.size() < var3_3) break;
                        ++var12_16;
                    }
                    if (var8_9 == var5_5) {
                        var6_6[1] = true;
                    }
                    break block29;
                }
                var8_9 = var5_5;
                var12_17 = 0;
                if (true) ** GOTO lbl103
            }
            do {
                var10_12.add(var2_2[var12_14]);
                ++var11_13;
                ++var12_14;
lbl55:
                // 2 sources

            } while (var12_14 < var5_5 && var11_13 < var9_10);
            if (var8_8 == 1) {
                var6_6[0] = true;
            }
            if (var8_8 + var9_10 - 1 >= var5_5) {
                var6_6[1] = true;
            }
            break block30;
            do {
                var10_12.add(var2_2[var12_14]);
                ++var11_13;
                --var12_14;
lbl66:
                // 2 sources

            } while (var12_14 >= 0 && var11_13 < var9_10);
            var10_12 = var10_12.reverse();
            if (var8_8 - var9_10 <= 0) {
                var6_6[0] = true;
            }
            if (var8_8 == var5_5) {
                var6_6[1] = true;
            }
        }
        var12_15 = var10_12.iterator();
        var13_18 = 0;
        var14_19 = BLocalBacnetDevice.asnOut;
        synchronized (var14_19) {
            block26: {
                block25: {
                    BLocalBacnetDevice.asnOut.reset();
                    if (var7_7 <= 0) break block25;
                    while (var12_15.hasNext()) {
                        if (var7_7 - BLocalBacnetDevice.asnOut.size() < var3_3) {
                            var6_6[1] = false;
                            break block26;
                        }
                        ((BIBacnetDataType)var12_15.next()).writeAsn(BLocalBacnetDevice.asnOut);
                        ++var13_18;
                    }
                    break block26;
                }
                var13_18 = var11_13;
                while (var12_15.hasNext()) {
                    ((BIBacnetDataType)var12_15.next()).writeAsn(BLocalBacnetDevice.asnOut);
                }
            }
            if (var13_18 < var11_13) {
                var6_6[2] = true;
            }
            return new ReadRangeAck(this.getObjectId(), var1_1.getPropertyId(), -1, BBacnetBitString.make(var6_6), (long)var13_18, BLocalBacnetDevice.asnOut.toByteArray());
        }
        {
            block29: {
                do {
                    ((BIBacnetDataType)var2_2[var12_17]).writeAsn(BLocalBacnetDevice.asnOut);
                    ++var12_17;
lbl103:
                    // 2 sources

                } while (var12_17 < var5_5);
                var6_6[1] = true;
            }
            if (var8_9 < var5_5) {
                var6_6[2] = true;
            }
            return new ReadRangeAck(this.getObjectId(), var1_1.getPropertyId(), -1, BBacnetBitString.make(var6_6), (long)var8_9, BLocalBacnetDevice.asnOut.toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ErrorType writeProperty(int var1_1, int var2_2, byte[] var3_3, int var4_4) throws BacnetException {
        if (var2_2 >= 0 && !this.isArray(var1_1)) {
            return new NErrorType(2, 50);
        }
        try {
            var5_5 = BLocalBacnetDevice.asnIn;
            synchronized (var5_5) {
                var8_8 = 0L;
                switch (var1_1) {
                    case 75: {
                        if (BLocalBacnetDevice.allowObjectIdWrite) {
                            this.set(BLocalBacnetDevice.objectId, (BValue)AsnUtil.fromAsnObjectId(var3_3), BLocalBacnetDevice.getBacnetContext());
                            return null;
                        }
                        return new NErrorType(2, 40);
                    }
                    case 58: {
                        this.setString(BLocalBacnetDevice.location, AsnUtil.fromAsnCharacterString(var3_3), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 28: {
                        this.setString(BLocalBacnetDevice.description, AsnUtil.fromAsnCharacterString(var3_3), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 116: {
                        BLocalBacnetDevice.asnIn.setBuffer(var3_3);
                        var10_9 = (BBacnetListOf)this.getTimeSynchronizationRecipients().newCopy();
                        var10_9.readAsn(BLocalBacnetDevice.asnIn);
                        this.set(BLocalBacnetDevice.timeSynchronizationRecipients, (BValue)var10_9, BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 153: {
                        var8_8 = AsnUtil.fromAsnUnsignedInteger(var3_3);
                        if (var8_8 > 65535L) {
                            return new NErrorType(2, 37);
                        }
                        this.set(BLocalBacnetDevice.backupFailureTimeout, (BValue)BRelTime.make((long)(1000L * var8_8)), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 206: {
                        BLocalBacnetDevice.asnIn.setBuffer(var3_3);
                        var11_10 = (BBacnetListOf)this.getUtcTimeSynchronizationRecipients().newCopy();
                        var11_10.readAsn(BLocalBacnetDevice.asnIn);
                        this.set(BLocalBacnetDevice.utcTimeSynchronizationRecipients, (BValue)var11_10, BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 204: {
                        var12_11 = AsnUtil.fromAsnUnsigned(var3_3);
                        var13_12 = var12_11.getUnsigned();
                        this.set(BLocalBacnetDevice.timeSynchronizationInterval, (BValue)BRelTime.make((long)(var13_12 * 60000L)), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 193: {
                        var15_13 = AsnUtil.fromAsnBoolean(var3_3);
                        this.setBoolean(BLocalBacnetDevice.alignIntervals, var15_13, BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 195: {
                        var16_14 = AsnUtil.fromAsnUnsignedInteger(var3_3);
                        var18_15 = this.getSlotFacets((Slot)BLocalBacnetDevice.intervalOffset);
                        if (var16_14 <= (long)var18_15.geti("max", 1440) && var16_14 >= (long)var18_15.geti("min", 0)) {
                            this.setInt(BLocalBacnetDevice.intervalOffset, (int)var16_14, BLocalBacnetDevice.getBacnetContext());
                            return null;
                        }
                        return new NErrorType(2, 37);
                    }
                }
                var19_16 = 0;
                if (true) ** GOTO lbl62
                do {
                    if (var1_1 == BLocalBacnetDevice.REQUIRED_PROPS[var19_16]) {
                        return new NErrorType(2, 40);
                    }
                    ++var19_16;
lbl62:
                    // 2 sources

                } while (var19_16 < BLocalBacnetDevice.REQUIRED_PROPS.length);
                var19_17 = this.getOptionalProps();
                var20_18 = 0;
                while (var20_18 < var19_17.length) {
                    if (var1_1 == var19_17[var20_18]) {
                        return new NErrorType(2, 40);
                    }
                    ++var20_18;
                }
                return new NErrorType(2, 32);
            }
        }
        catch (AsnException var5_6) {
            BLocalBacnetDevice.log.message("AsnException writing property " + var1_1 + " in object " + (Object)this.getObjectId() + ':' + (Object)var5_6);
            return new NErrorType(2, 9);
        }
        catch (PermissionException var5_7) {
            BLocalBacnetDevice.log.message("PermissionException writing property " + var1_1 + " in object " + (Object)this.getObjectId() + ':' + (Object)var5_7);
            return new NErrorType(2, 40);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ChangeListError addListElements(int var1_1, int var2_2, byte[] var3_3) throws BacnetException {
        var4_4 = BLocalBacnetDevice.asnIn;
        synchronized (var4_4) {
            switch (var1_1) {
                case 30: {
                    return new NChangeListError(8, new NErrorType(2, 40), 0L);
                }
                case 116: {
                    if (var2_2 >= 0) {
                        return new NChangeListError(8, new NErrorType(2, 50), 0L);
                    }
                    return this.getTimeSynchronizationRecipients().addElements(var3_3, BLocalBacnetDevice.getBacnetContext());
                }
                case 206: {
                    if (var2_2 >= 0) {
                        return new NChangeListError(8, new NErrorType(2, 50), 0L);
                    }
                    return this.getUtcTimeSynchronizationRecipients().addElements(var3_3, BLocalBacnetDevice.getBacnetContext());
                }
                case 152: {
                    return new NChangeListError(8, new NErrorType(2, 40), 0L);
                }
            }
            var7_5 = 0;
            if (true) ** GOTO lbl25
            do {
                if (var1_1 == BLocalBacnetDevice.REQUIRED_PROPS[var7_5]) {
                    return new NChangeListError(8, new NErrorType(5, 22), 0L);
                }
                ++var7_5;
lbl25:
                // 2 sources

            } while (var7_5 < BLocalBacnetDevice.REQUIRED_PROPS.length);
            var7_6 = this.getOptionalProps();
            var8_7 = 0;
            while (var8_7 < var7_6.length) {
                if (var1_1 == var7_6[var8_7]) {
                    return new NChangeListError(8, new NErrorType(5, 22), 0L);
                }
                ++var8_7;
            }
            return new NChangeListError(8, new NErrorType(2, 32), 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ChangeListError removeListElements(int var1_1, int var2_2, byte[] var3_3) throws BacnetException {
        var4_4 = BLocalBacnetDevice.asnIn;
        synchronized (var4_4) {
            switch (var1_1) {
                case 30: {
                    return new NChangeListError(9, new NErrorType(2, 40), 0L);
                }
                case 116: {
                    if (var2_2 >= 0) {
                        return new NChangeListError(9, new NErrorType(2, 50), 0L);
                    }
                    return this.getTimeSynchronizationRecipients().removeElements(var3_3, BLocalBacnetDevice.getBacnetContext());
                }
                case 206: {
                    if (var2_2 >= 0) {
                        return new NChangeListError(9, new NErrorType(2, 50), 0L);
                    }
                    return this.getUtcTimeSynchronizationRecipients().removeElements(var3_3, BLocalBacnetDevice.getBacnetContext());
                }
                case 152: {
                    return new NChangeListError(9, new NErrorType(2, 40), 0L);
                }
            }
            var7_5 = 0;
            if (true) ** GOTO lbl25
            do {
                if (var1_1 == BLocalBacnetDevice.REQUIRED_PROPS[var7_5]) {
                    return new NChangeListError(9, new NErrorType(5, 22), 0L);
                }
                ++var7_5;
lbl25:
                // 2 sources

            } while (var7_5 < BLocalBacnetDevice.REQUIRED_PROPS.length);
            var7_6 = this.getOptionalProps();
            var8_7 = 0;
            while (var8_7 < var7_6.length) {
                if (var1_1 == var7_6[var8_7]) {
                    return new NChangeListError(9, new NErrorType(5, 22), 0L);
                }
                ++var8_7;
            }
            return new NChangeListError(9, new NErrorType(2, 32), 0L);
        }
    }

    private final int[] getOptionalProps() {
        Vector<BBacnetPropertyIdentifier> vector = new Vector<BBacnetPropertyIdentifier>();
        vector.add(BBacnetPropertyIdentifier.location);
        vector.add(BBacnetPropertyIdentifier.description);
        vector.add(BBacnetPropertyIdentifier.maxSegmentsAccepted);
        vector.add(BBacnetPropertyIdentifier.localTime);
        vector.add(BBacnetPropertyIdentifier.localDate);
        vector.add(BBacnetPropertyIdentifier.utcOffset);
        vector.add(BBacnetPropertyIdentifier.daylightSavingsStatus);
        vector.add(BBacnetPropertyIdentifier.apduSegmentTimeout);
        vector.add(BBacnetPropertyIdentifier.timeSynchronizationRecipients);
        vector.add(BBacnetPropertyIdentifier.activeCovSubscriptions);
        vector.add(BBacnetPropertyIdentifier.maxMaster);
        vector.add(BBacnetPropertyIdentifier.maxInfoFrames);
        vector.add(BBacnetPropertyIdentifier.configurationFiles);
        vector.add(BBacnetPropertyIdentifier.lastRestoreTime);
        vector.add(BBacnetPropertyIdentifier.backupFailureTimeout);
        vector.add(BBacnetPropertyIdentifier.activeCovSubscriptions);
        vector.add(BBacnetPropertyIdentifier.utcTimeSynchronizationRecipients);
        vector.add(BBacnetPropertyIdentifier.timeSynchronizationInterval);
        vector.add(BBacnetPropertyIdentifier.alignIntervals);
        vector.add(BBacnetPropertyIdentifier.intervalOffset);
        vector.add((BBacnetPropertyIdentifier)BDynamicEnum.make((int)1338));
        vector.add((BBacnetPropertyIdentifier)BDynamicEnum.make((int)1339));
        vector.add((BBacnetPropertyIdentifier)BDynamicEnum.make((int)1340));
        vector.add((BBacnetPropertyIdentifier)BDynamicEnum.make((int)1341));
        this.addOptionalProps(vector);
        int[] nArray = new int[vector.size()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = ((BEnum)vector.elementAt(n)).getOrdinal();
            ++n;
        }
        return nArray;
    }

    protected void addOptionalProps(Vector vector) {
    }

    private final BBacnetNetwork network() {
        return (BBacnetNetwork)this.getParent();
    }

    public void subscribeCov(BIBacnetCovSource bIBacnetCovSource, BComponent bComponent, Property property) {
        BBacnetCovSubscription bBacnetCovSubscription = (BBacnetCovSubscription)((BComplex)bIBacnetCovSource).get(property);
        if (bBacnetCovSubscription.isCovProperty()) {
            this.covPropPoller.subscribe((BObject)bBacnetCovSubscription);
        } else {
            this.covSubscriber.subscribe(bIBacnetCovSource, bComponent);
        }
        BOrd bOrd = BOrd.make((String)(((BComponent)bIBacnetCovSource).getSlotPathOrd().toString() + '/' + property.getName()));
        Property property2 = this.getActiveCovSubscriptions().addListElement((BValue)bOrd, null);
        this.getActiveCovSubscriptions().setFlags((Slot)property2, 1);
    }

    public void unsubscribeCov(BIBacnetCovSource bIBacnetCovSource, BComponent bComponent, Property property) {
        BBacnetCovSubscription bBacnetCovSubscription = (BBacnetCovSubscription)((BComplex)bIBacnetCovSource).get(property);
        if (bBacnetCovSubscription.isCovProperty()) {
            this.covPropPoller.unsubscribe((BObject)bBacnetCovSubscription);
        } else {
            this.covSubscriber.unsubscribe(bIBacnetCovSource, bComponent);
        }
        BOrd bOrd = BOrd.make((String)(((BComponent)bIBacnetCovSource).getSlotPathOrd().toString() + '/' + property.getName()));
        this.getActiveCovSubscriptions().removeListElement((BValue)bOrd, null);
    }

    public void subscribe(BIBacnetExportObject bIBacnetExportObject, Object object) {
        if (object instanceof BComponent) {
            this.objectSubscriber.subscribe(bIBacnetExportObject, ((BComponent)object).getParent().asComponent());
            if (bIBacnetExportObject instanceof BBacnetEventSource) {
                this.pointSubscriber.subscribe((BBacnetEventSource)bIBacnetExportObject, (BComponent)object);
            }
            if (bIBacnetExportObject instanceof BBacnetScheduleDescriptor || bIBacnetExportObject instanceof BBacnetNotificationClassDescriptor) {
                this.objectSubscriber.subscribe(bIBacnetExportObject, (BComponent)object);
            }
        }
    }

    public void unsubscribe(BIBacnetExportObject bIBacnetExportObject, Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof BComponent) {
            BComponent bComponent = (BComponent)object;
            if (bComponent.getParent() != null) {
                this.objectSubscriber.unsubscribe(bComponent.getParent().asComponent());
            }
            if (bIBacnetExportObject instanceof BBacnetEventSource) {
                this.pointSubscriber.unsubscribe(bComponent);
            }
            if (bIBacnetExportObject instanceof BBacnetScheduleDescriptor || bIBacnetExportObject instanceof BBacnetNotificationClassDescriptor) {
                this.objectSubscriber.unsubscribe(bIBacnetExportObject, bComponent);
            }
        }
    }

    public static Context getBacnetContext() {
        if (bacnetContext == null) {
            try {
                BUserService bUserService = (BUserService)Sys.getService((Type)BUserService.TYPE);
                BUser bUser = bUserService.getUser("BACnet");
                if (bUser == null) {
                    bUser = (BUser)bUserService.get(bUserService.add("BACnet", (BValue)new BUser()));
                }
                if (!bUser.getEnabled()) {
                    throw new PermissionException("BACnet User not enabled");
                }
                bacnetContext = new BasicContext(bUser);
            }
            catch (Exception exception) {
                log.error("Unable to retrieve BACnet user context!!", (Throwable)exception);
                throw new PermissionException("Error retrieving BACnet User context");
            }
        }
        return bacnetContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void scheduleTimeSynch() {
        Object object = this.TIME_SYNC_LOCK;
        synchronized (object) {
            block15: {
                block11: {
                    Object object2;
                    BAbsTime bAbsTime;
                    BRelTime bRelTime;
                    block14: {
                        BAbsTime bAbsTime2;
                        block12: {
                            long l;
                            long l2;
                            block13: {
                                if (this.tsTicket != null) {
                                    this.tsTicket.cancel();
                                }
                                if ((l2 = (bRelTime = this.getTimeSynchronizationInterval()).getMillis()) == 0L) {
                                    this.tsTicket = null;
                                    return;
                                }
                                bAbsTime2 = BAbsTime.now();
                                bAbsTime = null;
                                l = bAbsTime2.getMillis();
                                if (l2 <= 0L) break block11;
                                if (!this.getAlignIntervals()) break block12;
                                if (3600000L % l2 != 0L) break block13;
                                object2 = BAbsTime.make((int)bAbsTime2.getYear(), (BMonth)bAbsTime2.getMonth(), (int)bAbsTime2.getDay(), (int)bAbsTime2.getHour(), (int)0);
                                long l3 = object2.getMillis();
                                bAbsTime = this.getNextInterval(l3, l2, this.getIntervalOffset(), l);
                                break block14;
                            }
                            if (86400000L % l2 == 0L) {
                                object2 = BAbsTime.make((int)bAbsTime2.getYear(), (BMonth)bAbsTime2.getMonth(), (int)bAbsTime2.getDay(), (int)0, (int)0);
                                long l4 = object2.getMillis();
                                bAbsTime = this.getNextInterval(l4, l2, this.getIntervalOffset(), l);
                                break block14;
                            } else {
                                bAbsTime = this.lastTSTime.add(bRelTime);
                                if (bAbsTime.isBefore(bAbsTime2)) {
                                    bAbsTime2.add(bRelTime);
                                }
                            }
                            break block14;
                        }
                        bAbsTime = this.lastTSTime.add(bRelTime);
                        if (bAbsTime.isBefore(bAbsTime2)) {
                            bAbsTime2.add(bRelTime);
                        }
                    }
                    if (log.isTraceOn()) {
                        object2 = new StringBuffer("BACnet Time Synchronization: every ");
                        ((StringBuffer)object2).append(bRelTime.toString((Context)BFacets.make((String)"showSeconds", (boolean)false))).append(", beginning at ").append(bAbsTime.toString((Context)BFacets.make((String)"showSeconds", (boolean)false))).append(this.getAlignIntervals() ? ": aligned" : ": unaligned");
                        if (this.getAlignIntervals()) {
                            ((StringBuffer)object2).append(", offset:").append(this.getIntervalOffset()).append(" min");
                        }
                        log.trace(((StringBuffer)object2).toString());
                    }
                    this.tsTicket = Clock.schedulePeriodically((BComponent)this, (BAbsTime)bAbsTime, (BRelTime)bRelTime, (Action)sendTimeSynch, null);
                    break block15;
                }
                log.trace("BACnet Time Synchronization disabled");
            }
            return;
        }
    }

    private final BAbsTime getNextInterval(long l, long l2, int n, long l3) {
        long l4 = (long)n * 60000L % l2;
        long l5 = l + l4;
        while ((l5 += l2) < l3) {
        }
        return BAbsTime.make((long)l5);
    }

    /*
     * Unable to fully structure code
     */
    private final void checkRecipients(Property var1_1) {
        var2_2 = ((BComplex)this.get(var1_1)).getProperties();
        var3_3 = null;
        if (true) ** GOTO lbl11
        do {
            if ((var3_3 = (BBacnetRecipient)var2_2.get()).isDevice() && (var4_4 = var3_3.getDevice()).isValid() && DeviceRegistry.getDeviceAddress(var4_4) == null) {
                try {
                    ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient().whoIs(BBacnetAddress.GLOBAL_BROADCAST_ADDRESS, var4_4.getInstanceNumber(), var4_4.getInstanceNumber());
                }
                catch (BacnetException var5_5) {
                    BLocalBacnetDevice.log.error("Unable to determine address for Bacnet Time Synch Recipient " + (Object)var4_4, (Throwable)var5_5);
                }
            }
lbl11:
            // 5 sources

            if ((v0 = BLocalBacnetDevice.class$javax$baja$bacnet$datatypes$BBacnetRecipient) != null) continue;
            v0 = BLocalBacnetDevice.class("[Ljavax.baja.bacnet.datatypes.BBacnetRecipient;", false);
        } while (var2_2.next(v0));
    }

    public PropertyInfo getPropertyInfo(int n, int n2) {
        PropertyInfo propertyInfo = ObjectTypeList.getInstance().getPropertyInfo(n, n2);
        if (propertyInfo == null) {
            propertyInfo = new PropertyInfo(BBacnetPropertyIdentifier.tag(n2), n2, -6);
        }
        return propertyInfo;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"LocalBacnetDevice", 2);
        spyWriter.prop((Object)"fatalFault", this.fatalFault);
        spyWriter.prop((Object)"objectName", (Object)this.getObjectName());
        spyWriter.prop((Object)"preBackupStatus", (Object)this.preBackupStatus);
        spyWriter.prop((Object)"preRestoreStatus", (Object)this.preRestoreStatus);
        spyWriter.prop((Object)"tsTicket", (Object)this.tsTicket);
        spyWriter.prop((Object)"lastTSTime", (Object)this.lastTSTime);
        spyWriter.trTitle((Object)"DeviceRegistry", 2);
        Iterator iterator = DeviceRegistry.addressIterator();
        int n = 0;
        while (iterator.hasNext()) {
            spyWriter.prop((Object)("  " + n++), iterator.next());
        }
        spyWriter.prop((Object)"bacnetContext", (Object)bacnetContext);
        spyWriter.prop((Object)"COV subscription count", this.covSubscriber.getSubscriptionCount());
        this.covPropPoller.spy(spyWriter);
        spyWriter.endProps();
    }

    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    private final void checkFatalFault() {
        if (this.fatalFault) {
            return;
        }
        if (this.network().isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("Network fault: " + this.network().getFaultCause());
            return;
        }
        this.setFaultCause("");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readBrandProperties() {
        if (this.brandPropertiesRead) {
            return;
        }
        InputStream inputStream = null;
        try {
            try {
                BOrd bOrd = BOrd.make((String)"file:!lib/brand.properties");
                BIFile bIFile = (BIFile)bOrd.resolve().get();
                inputStream = bIFile.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = bufferedReader.readLine();
                while (string != null) {
                    block20: {
                        try {
                            string = string.trim();
                            if (string.startsWith("bacnetVendorId=")) {
                                int n = 36;
                                try {
                                    n = Integer.parseInt(string.substring(15));
                                }
                                catch (Exception exception) {}
                                this.setVendorId(n);
                                this.setVendorName(BacnetVendorUtil.getVendorName(n));
                                break block20;
                            }
                            if (string.startsWith("modelName=")) {
                                String string2 = string.substring(10);
                                this.objectName = new String(string2);
                                this.setModelName(string2);
                                break block20;
                            }
                            if (string.startsWith("applicationSoftwareVersion=")) {
                                BModule bModule = this.getType().getModule();
                                String string3 = bModule.getVendor() + ' ' + bModule.getVendorVersion();
                                this.setApplicationSoftwareVersion(string.substring(27) + " - BACnet: " + string3);
                            }
                        }
                        catch (Exception exception) {
                            log.message("Error parsing BACnet device branding information:" + string + "\n  " + exception);
                        }
                    }
                    string = bufferedReader.readLine();
                }
            }
            catch (UnresolvedException unresolvedException) {
            }
            catch (Exception exception) {
                log.message("Error reading BACnet device branding information:" + exception);
                exception.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var3_13 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
            this.brandPropertiesRead = true;
            throw throwable;
        }
        {
            Object var3_14 = null;
        }
        try {}
        catch (Exception exception) {}
        if (inputStream != null) {
            inputStream.close();
        }
        this.brandPropertiesRead = true;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.fatalFault = false;
        this.brandPropertiesRead = false;
        this.covSubscriber = new BacnetCovSubscriber();
        this.objectSubscriber = new BIBacnetExportObject.ObjectSubscriber();
        this.pointSubscriber = new PointSubscriber();
        this.maxWaitTime = 0;
        this.objectName = "";
        this.preBackupStatus = BBacnetDeviceStatus.operational;
        this.preRestoreStatus = BBacnetDeviceStatus.operational;
        this.covPropPoller = new LocalBacnetCovPropPoll(this);
        this.tsTicket = null;
        this.TIME_SYNC_LOCK = new Object();
        this.lastTSTime = null;
        this.saveListener = new Station.SaveListener(){

            public final void stationSave() {
                BLocalBacnetDevice.this.setDatabaseRevision(BLocalBacnetDevice.this.getDatabaseRevision() + 1);
            }

            public final void stationSaveOk() {
            }

            public final void stationSaveFail(String string) {
            }

            public final String toString() {
                return "Local BACnet Device " + BLocalBacnetDevice.this.getNavOrd();
            }
        };
    }

    public BLocalBacnetDevice() {
        this.this();
    }

    static {
        boolean[] blArray = new boolean[31];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[8] = true;
        blArray[10] = true;
        blArray[12] = true;
        blArray[13] = true;
        blArray[14] = true;
        blArray[15] = true;
        blArray[17] = true;
        blArray[19] = true;
        blArray[20] = true;
        blArray[29] = true;
        SERVER_OBJECT_TYPES_SUPPORTED = BBacnetBitString.make(blArray);
        boolean[] blArray2 = new boolean[40];
        blArray2[0] = true;
        blArray2[1] = true;
        blArray2[2] = true;
        blArray2[3] = true;
        blArray2[4] = true;
        blArray2[5] = true;
        blArray2[6] = true;
        blArray2[7] = true;
        blArray2[8] = true;
        blArray2[9] = true;
        blArray2[12] = true;
        blArray2[14] = true;
        blArray2[15] = true;
        blArray2[16] = true;
        blArray2[17] = true;
        blArray2[18] = true;
        blArray2[20] = true;
        blArray2[26] = true;
        blArray2[27] = true;
        blArray2[28] = true;
        blArray2[29] = true;
        blArray2[30] = true;
        blArray2[32] = true;
        blArray2[33] = true;
        blArray2[34] = true;
        blArray2[35] = true;
        blArray2[36] = true;
        blArray2[38] = true;
        blArray2[39] = true;
        SERVER_SERVICES_SUPPORTED = BBacnetBitString.make(blArray2);
        status = BLocalBacnetDevice.newProperty((int)67, (BValue)BStatus.ok, null);
        faultCause = BLocalBacnetDevice.newProperty((int)3, (String)"", null);
        objectId = BLocalBacnetDevice.newProperty((int)0, (BValue)BBacnetObjectIdentifier.make(8), (BFacets)BBacnetObjectType.getObjectIdFacets(8));
        systemStatus = BLocalBacnetDevice.newProperty((int)3, (BValue)BBacnetDeviceStatus.operational, null);
        vendorName = BLocalBacnetDevice.newProperty((int)1, (String)"Tridium", null);
        vendorId = BLocalBacnetDevice.newProperty((int)1, (int)36, null);
        modelName = BLocalBacnetDevice.newProperty((int)1, (String)"NiagaraAX Station", null);
        firmwareRevision = BLocalBacnetDevice.newProperty((int)1, (String)"unknown", null);
        applicationSoftwareVersion = BLocalBacnetDevice.newProperty((int)1, (String)"unknown", null);
        location = BLocalBacnetDevice.newProperty((int)0, (String)"unknown", null);
        description = BLocalBacnetDevice.newProperty((int)0, (String)"Local BACnet Device object", null);
        protocolVersion = BLocalBacnetDevice.newProperty((int)1, (int)1, null);
        protocolRevision = BLocalBacnetDevice.newProperty((int)1, (int)7, null);
        protocolConformanceClass = BLocalBacnetDevice.newProperty((int)5, (int)3, null);
        protocolServicesSupported = BLocalBacnetDevice.newProperty((int)1, (BValue)SERVER_SERVICES_SUPPORTED, (BFacets)BacnetBitStringUtil.BACNET_SERVICES_SUPPORTED_FACETS);
        protocolObjectTypesSupported = BLocalBacnetDevice.newProperty((int)1, (BValue)SERVER_OBJECT_TYPES_SUPPORTED, (BFacets)BacnetBitStringUtil.BACNET_OBJECT_TYPES_SUPPORTED_FACETS);
        maxAPDULengthAccepted = BLocalBacnetDevice.newProperty((int)1, (int)1476, null);
        segmentationSupported = BLocalBacnetDevice.newProperty((int)1, (BValue)BBacnetSegmentation.segmentedBoth, null);
        maxSegmentsAccepted = BLocalBacnetDevice.newProperty((int)1, (int)255, null);
        apduSegmentTimeout = BLocalBacnetDevice.newProperty((int)0, (int)2000, (BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")), (BFacets)BFacets.make((String)"min", (int)0)));
        apduTimeout = BLocalBacnetDevice.newProperty((int)0, (int)3000, (BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")), (BFacets)BFacets.make((String)"min", (int)0)));
        numberOfApduRetries = BLocalBacnetDevice.newProperty((int)0, (int)3, null);
        deviceAddressBinding = BLocalBacnetDevice.newProperty((int)7, (BValue)new BBacnetListOf(BBacnetAddressBinding.TYPE), null);
        databaseRevision = BLocalBacnetDevice.newProperty((int)1, (int)1, null);
        configurationFiles = BLocalBacnetDevice.newProperty((int)5, (BValue)new BBacnetArray(BBacnetObjectIdentifier.TYPE), null);
        lastRestoreTime = BLocalBacnetDevice.newProperty((int)1, (BValue)new BBacnetTimeStamp(new BBacnetDateTime()), null);
        backupFailureTimeout = BLocalBacnetDevice.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)180), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (boolean)false), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.DEFAULT)));
        backupPreparationTime = BLocalBacnetDevice.newProperty((int)1, (BValue)BRelTime.make((long)60000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (boolean)true), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.DEFAULT)));
        restorePreparationTime = BLocalBacnetDevice.newProperty((int)1, (BValue)BRelTime.make((long)60000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (boolean)true), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.DEFAULT)));
        restoreCompletionTime = BLocalBacnetDevice.newProperty((int)1, (BValue)BRelTime.make((long)180000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (boolean)true), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.DEFAULT)));
        backupAndRestoreState = BLocalBacnetDevice.newProperty((int)3, (BValue)BBacnetBackupState.DEFAULT, null);
        activeCovSubscriptions = BLocalBacnetDevice.newProperty((int)7, (BValue)new BBacnetListOf(BBacnetCovSubscription.TYPE), null);
        characterSet = BLocalBacnetDevice.newProperty((int)0, (BValue)BCharacterSetEncoding.ansiX3_4, null);
        enumerationList = BLocalBacnetDevice.newProperty((int)0, (BValue)new BExtensibleEnumList(), null);
        exportTable = BLocalBacnetDevice.newProperty((int)0, (BValue)new BBacnetExportTable(), null);
        virtual = BLocalBacnetDevice.newProperty((int)4, (BValue)new BLocalBacnetVirtualGateway(), null);
        covPropertyPollRate = BLocalBacnetDevice.newProperty((int)4, (BValue)BRelTime.makeSeconds((int)5), null);
        timeSynchronizationRecipients = BLocalBacnetDevice.newProperty((int)0, (BValue)new BBacnetListOf(BBacnetRecipient.TYPE), null);
        timeSynchronizationInterval = BLocalBacnetDevice.newProperty((int)0, (BValue)BRelTime.make((long)86400000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showSeconds", (boolean)false), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.DEFAULT)));
        alignIntervals = BLocalBacnetDevice.newProperty((int)0, (boolean)true, null);
        intervalOffset = BLocalBacnetDevice.newProperty((int)0, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"minute")), (BFacets)BFacets.make((String)"min", (int)0)), (BFacets)BFacets.make((String)"max", (int)1440)));
        utcTimeSynchronizationRecipients = BLocalBacnetDevice.newProperty((int)0, (BValue)new BBacnetListOf(BBacnetRecipient.TYPE), null);
        sendIAm = BLocalBacnetDevice.newAction((int)0, null);
        setBackupMode = BLocalBacnetDevice.newAction((int)4, (BValue)BBoolean.FALSE, null);
        setRestoreMode = BLocalBacnetDevice.newAction((int)4, (BValue)BBoolean.FALSE, null);
        println = BLocalBacnetDevice.newAction((int)0, (BValue)BString.make((String)""), null);
        sendTimeSynch = BLocalBacnetDevice.newAction((int)4, null);
        Class clazz = class$javax$baja$bacnet$export$BLocalBacnetDevice;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$export$BLocalBacnetDevice = BLocalBacnetDevice.class("[Ljavax.baja.bacnet.export.BLocalBacnetDevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"deviceLocal.png");
        lex = Lexicon.make((String)"bacnet");
        REQUIRED_PROPS = new int[]{75, 77, 79, 112, 121, 120, 70, 44, 12, 98, 139, 97, 96, 76, 62, 107, 11, 73, 30, 155};
        log = Log.getLog((String)"bacnet.server");
        asnIn = new AsnInputStream();
        asnOut = new AsnOutputStream();
        allowObjectIdWrite = false;
    }
}

