/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import java.util.StringTokenizer;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.export.BBacnetMultiStatePointDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.enums.BPriorityLevel;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatusEnum;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BBacnetMultiStateWritableDescriptor
extends BBacnetMultiStatePointDescriptor {
    public static final Property bacnetWritable = BBacnetMultiStateWritableDescriptor.newProperty((int)5, (String)lexNotWritable, null);
    public static final Type TYPE;
    static /* synthetic */ Class class$javax$baja$bacnet$export$BBacnetMultiStateWritableDescriptor;
    static /* synthetic */ Class class$javax$baja$status$BStatusEnum;

    public String getBacnetWritable() {
        return this.getString(bacnetWritable);
    }

    public void setBacnetWritable(String string) {
        this.setString(bacnetWritable, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected final boolean isPointTypeLegal(BControlPoint bControlPoint) {
        return bControlPoint instanceof BEnumWritable;
    }

    protected boolean isCommandable() {
        return true;
    }

    protected PropertyValue readProperty(int n, int n2) {
        BEnumWritable bEnumWritable = (BEnumWritable)this.getPoint();
        if (bEnumWritable == null) {
            return new NReadPropertyResult(n, n2, new NErrorType(1, 1000));
        }
        if (n2 >= 0 && !this.isArray(n)) {
            return new NReadPropertyResult(n, n2, new NErrorType(2, 50));
        }
        switch (n) {
            case 87: {
                return this.readPriorityArray(n2);
            }
            case 104: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(bEnumWritable.getFallback().getValue().getOrdinal()));
            }
        }
        return super.readProperty(n, n2);
    }

    protected ErrorType writeProperty(int n, int n2, byte[] byArray, int n3) throws BacnetException {
        BEnumWritable bEnumWritable = (BEnumWritable)this.getPoint();
        if (bEnumWritable == null) {
            return new NErrorType(1, 1000);
        }
        if (n2 >= 0 && !this.isArray(n)) {
            return new NErrorType(2, 50);
        }
        try {
            switch (n) {
                case 85: {
                    return this.writePriorityArray(n3, byArray);
                }
                case 87: {
                    return new NErrorType(2, 40);
                }
                case 104: {
                    int n4 = AsnUtil.fromAsnUnsignedInt(byArray);
                    BDynamicEnum bDynamicEnum = bEnumWritable.getFallback().getValue();
                    BEnumRange bEnumRange = (BEnumRange)bEnumWritable.getFacets().getFacet("range");
                    if (bEnumRange != null && !bEnumRange.isOrdinal(n4)) {
                        return new NErrorType(2, 37);
                    }
                    BStatusEnum bStatusEnum = bEnumWritable.getFallback();
                    bStatusEnum.set(BStatusEnum.value, (BValue)BDynamicEnum.make((int)n4, (BEnumRange)bDynamicEnum.getRange()), BLocalBacnetDevice.getBacnetContext());
                    bStatusEnum.setStatusNull(false);
                    return null;
                }
            }
            return super.writeProperty(n, n2, byArray, n3);
        }
        catch (AsnException asnException) {
            log.message("AsnException writing property " + n + " in object " + (Object)((Object)this.getObjectId()));
            return new NErrorType(2, 9);
        }
        catch (PermissionException permissionException) {
            log.message("PermissionException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)permissionException));
            return new NErrorType(2, 40);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new NErrorType(2, 37);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final PropertyValue readPriorityArray(int n) {
        BEnumWritable bEnumWritable = (BEnumWritable)this.getPoint();
        if (bEnumWritable == null) {
            return new NReadPropertyResult(87, n, new NErrorType(1, 1000));
        }
        if (n == -1) {
            AsnOutputStream asnOutputStream = asnOut;
            synchronized (asnOutputStream) {
                asnOut.reset();
                int n2 = 1;
                while (true) {
                    if (n2 > 16) {
                        return new NReadPropertyResult(87, n, asnOut.toByteArray());
                    }
                    BStatusEnum bStatusEnum = bEnumWritable.getLevel(BPriorityLevel.make((int)n2));
                    if (bStatusEnum.getStatus().isNull()) {
                        asnOut.writeNull();
                    } else {
                        asnOut.writeUnsignedInteger(bStatusEnum.getValue().getOrdinal());
                    }
                    ++n2;
                }
            }
        }
        if (n == 0) {
            return new NReadPropertyResult(87, n, AsnUtil.toAsnUnsigned(16L));
        }
        try {
            BStatusEnum bStatusEnum = bEnumWritable.getLevel(BPriorityLevel.make((int)n));
            if (bStatusEnum.getStatus().isNull()) {
                return new NReadPropertyResult(87, n, AsnUtil.toAsnNull());
            }
            return new NReadPropertyResult(87, n, AsnUtil.toAsnUnsigned(bStatusEnum.getValue().getOrdinal()));
        }
        catch (Exception exception) {
            return new NReadPropertyResult(87, n, new NErrorType(2, 42));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ErrorType writePriorityArray(int n, byte[] byArray) throws BacnetException {
        BEnumWritable bEnumWritable = (BEnumWritable)this.getPoint();
        if (bEnumWritable == null) {
            return new NErrorType(1, 1000);
        }
        try {
            BStatusEnum bStatusEnum;
            Property property;
            block13: {
                if (n == -1) {
                    n = 16;
                }
                if (n < 1 || n > 16) {
                    return new NErrorType(2, 42);
                }
                String string = "bacnetValueIn" + n;
                property = this.loadSlots().getProperty(string);
                BDynamicEnum bDynamicEnum = bEnumWritable.getOut().getValue();
                if (property == null) {
                    return new NErrorType(2, 40);
                }
                bStatusEnum = (BStatusEnum)this.get(string).newCopy();
                AsnInputStream asnInputStream = asnIn;
                synchronized (asnInputStream) {
                    int n2;
                    block12: {
                        asnIn.setBuffer(byArray);
                        n2 = asnIn.peekTag();
                        if (n2 != 0) break block12;
                        bStatusEnum.setStatusNull(true);
                        break block13;
                    }
                    if (n2 != 2) {
                        throw new AsnException("Invalid tag: " + n2);
                    }
                    bStatusEnum.setStatusNull(false);
                    int n3 = asnIn.readUnsignedInt();
                    BEnumRange bEnumRange = (BEnumRange)bEnumWritable.getFacets().getFacet("range");
                    if (bEnumRange != null && !bEnumRange.isOrdinal(n3)) {
                        return new NErrorType(2, 37);
                    }
                    bStatusEnum.setValue(bDynamicEnum.getRange().get(n3));
                }
            }
            this.set(property, (BValue)bStatusEnum, BLocalBacnetDevice.getBacnetContext());
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.message("IllegalArgumentException writing priorityArray in object " + (Object)((Object)this.getObjectId()) + ':' + illegalArgumentException);
            return new NErrorType(2, 37);
        }
        catch (PermissionException permissionException) {
            log.message("PermissionException writing priorityArray in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)permissionException));
            return new NErrorType(2, 40);
        }
    }

    private final void resetBacnetWritable() {
        StringBuffer stringBuffer = new StringBuffer();
        Knob[] knobArray = this.getKnobs();
        int n = 0;
        while (n < knobArray.length) {
            BObject bObject = knobArray[n].getTargetOrd().get((BObject)this);
            BControlPoint bControlPoint = this.getPoint();
            if (knobArray[n].getTargetSlotName().startsWith("in") && bObject == bControlPoint) {
                stringBuffer.append(knobArray[n].getTargetSlotName()).append(',');
            }
            ++n;
        }
        this.setBacnetWritable(stringBuffer.length() > 0 ? stringBuffer.toString().substring(0, stringBuffer.length() - 1) : lexNotWritable);
    }

    public void knobAdded(Knob knob, Context context) {
        this.resetBacnetWritable();
    }

    public void knobRemoved(Knob knob, Context context) {
        this.resetBacnetWritable();
    }

    public final void doMakeWritable(BValue bValue) {
        if (!this.isRunning()) {
            return;
        }
        BEnumWritable bEnumWritable = (BEnumWritable)this.getPoint();
        if (bEnumWritable == null) {
            return;
        }
        BLink[] bLinkArray = bEnumWritable.getLinks();
        int n = 0;
        while (n < bLinkArray.length) {
            if (bLinkArray[n].isActive()) {
                if (bLinkArray[n].getSourceComponent() == this && bLinkArray[n].getTargetSlot().getName().startsWith("in")) {
                    bEnumWritable.remove((BComplex)bLinkArray[n]);
                }
            } else {
                bEnumWritable.remove((BComplex)bLinkArray[n]);
            }
            ++n;
        }
        Class clazz = class$javax$baja$status$BStatusEnum;
        if (clazz == null) {
            clazz = class$javax$baja$status$BStatusEnum = BBacnetMultiStateWritableDescriptor.class("[Ljavax.baja.status.BStatusEnum;", false);
        }
        BStatusEnum[] bStatusEnumArray = (BStatusEnum[])this.getChildren(clazz);
        int n2 = 0;
        while (n2 < bStatusEnumArray.length) {
            if (bStatusEnumArray[n2].getName().startsWith("bacnetValueIn")) {
                this.remove((BComplex)bStatusEnumArray[n2]);
            }
            ++n2;
        }
        String string = ((BString)bValue).getString();
        if (string.equals(lexNotWritable)) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            Slot slot = bEnumWritable.getSlot(string2);
            String string3 = "bacnetValue" + TextUtil.capitalize((String)string2);
            BStatusEnum bStatusEnum = new BStatusEnum();
            bStatusEnum.setStatusNull(true);
            this.add(string3, (BValue)bStatusEnum, 257);
            bEnumWritable.setFlags(slot, bEnumWritable.getFlags(slot) | 0x400);
            BLink bLink = new BLink(this.getHandleOrd(), string3, string2, true);
            bEnumWritable.add("bacnet" + string2, (BValue)bLink, 1);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$bacnet$export$BBacnetMultiStateWritableDescriptor;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$export$BBacnetMultiStateWritableDescriptor = BBacnetMultiStateWritableDescriptor.class("[Ljavax.baja.bacnet.export.BBacnetMultiStateWritableDescriptor;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

