/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import com.tridium.bacnet.services.error.NChangeListError;
import com.tridium.bacnet.stack.server.BBacnetExportFolder;
import java.util.ArrayList;
import java.util.Vector;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BAlarmState;
import javax.baja.alarm.ext.BOffnormalAlgorithm;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetCovSubscription;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetSetpointReference;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.enums.BBacnetEngineeringUnits;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetNotifyType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.export.BBacnetEventSource;
import javax.baja.bacnet.export.BBacnetNotificationClassDescriptor;
import javax.baja.bacnet.export.BIBacnetCovSource;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.Cov;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RangeReference;
import javax.baja.bacnet.io.RejectException;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.security.PermissionException;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetLoopDescriptor
extends BBacnetEventSource
implements BIBacnetCovSource {
    public static final Property pointOrd = BBacnetLoopDescriptor.newProperty((int)64, (BValue)BOrd.DEFAULT, (BFacets)BFacets.make((String)"targetType", (String)"baja:Component"));
    public static final Property objectId = BBacnetLoopDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(12), null);
    public static final Property objectName = BBacnetLoopDescriptor.newProperty((int)64, (String)"", null);
    public static final Property reliability = BBacnetLoopDescriptor.newProperty((int)3, (BValue)BBacnetReliability.noFaultDetected, null);
    public static final Property description = BBacnetLoopDescriptor.newProperty((int)0, (String)"", null);
    public static final Property notifyType = BBacnetLoopDescriptor.newProperty((int)0, (BValue)BBacnetNotifyType.alarm, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"bacnet:BacnetNotifyTypeFE")));
    public static final Property covIncrement = BBacnetLoopDescriptor.newProperty((int)0, (float)0.0f, null);
    public static final Action addCovSubscription = BBacnetLoopDescriptor.newAction((int)4, (BValue)new BBacnetCovSubscription(), null);
    public static final Action removeCovSubscription = BBacnetLoopDescriptor.newAction((int)4, (BValue)new BBacnetCovSubscription(), null);
    public static final Action sendCovNotification = BBacnetLoopDescriptor.newAction((int)4, (BValue)new BBacnetCovSubscription(), null);
    public static final Action checkCov = BBacnetLoopDescriptor.newAction((int)20, null);
    public static final Type TYPE;
    private static final BIcon icon;
    static final AsnInputStream asnIn;
    static final AsnOutputStream asnOut;
    static Log log;
    static Lexicon lex;
    private static final BBacnetObjectPropertyReference NULL_OPR;
    private static final int[] REQUIRED_PROPS;
    private BNumericPoint point;
    private int[] optionalProps;
    private int oldNotifyType;
    private BBacnetObjectIdentifier oldId;
    private String oldName;
    private boolean duplicate;
    private boolean configOk;
    static /* synthetic */ Class class$javax$baja$bacnet$export$BBacnetLoopDescriptor;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetCovSubscription;
    static /* synthetic */ Class class$javax$baja$alarm$ext$BAlarmSourceExt;

    public BOrd getPointOrd() {
        return (BOrd)this.get(pointOrd);
    }

    public void setPointOrd(BOrd bOrd) {
        this.set(pointOrd, (BValue)bOrd, null);
    }

    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    public void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.set(objectId, (BValue)bBacnetObjectIdentifier, null);
    }

    public String getObjectName() {
        return this.getString(objectName);
    }

    public void setObjectName(String string) {
        this.setString(objectName, string, null);
    }

    public BEnum getReliability() {
        return (BEnum)this.get(reliability);
    }

    public void setReliability(BEnum bEnum) {
        this.set(reliability, (BValue)bEnum, null);
    }

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String string) {
        this.setString(description, string, null);
    }

    public BBacnetNotifyType getNotifyType() {
        return (BBacnetNotifyType)this.get(notifyType);
    }

    public void setNotifyType(BBacnetNotifyType bBacnetNotifyType) {
        this.set(notifyType, (BValue)bBacnetNotifyType, null);
    }

    public float getCovIncrement() {
        return this.getFloat(covIncrement);
    }

    public void setCovIncrement(float f) {
        this.setFloat(covIncrement, f, null);
    }

    public void addCovSubscription(BBacnetCovSubscription bBacnetCovSubscription) {
        this.invoke(addCovSubscription, (BValue)bBacnetCovSubscription, null);
    }

    public void removeCovSubscription(BBacnetCovSubscription bBacnetCovSubscription) {
        this.invoke(removeCovSubscription, (BValue)bBacnetCovSubscription, null);
    }

    public void sendCovNotification(BBacnetCovSubscription bBacnetCovSubscription) {
        this.invoke(sendCovNotification, (BValue)bBacnetCovSubscription, null);
    }

    public void checkCov() {
        this.invoke(checkCov, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void started() throws Exception {
        super.started();
        this.oldId = this.getObjectId();
        this.oldName = this.getObjectName();
        this.checkConfiguration();
        if (Sys.isStationStarted() && this.configOk()) {
            BBacnetNetwork.localDevice().incrementDatabaseRevision();
        }
    }

    public final void stopped() throws Exception {
        super.stopped();
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        bLocalBacnetDevice.unexport(this.oldId, this.oldName, this);
        bLocalBacnetDevice.unsubscribe(this, this.point);
        this.point = null;
        this.oldId = null;
        this.oldName = null;
        if (this.getStatus().isOk() && bLocalBacnetDevice.isRunning()) {
            bLocalBacnetDevice.incrementDatabaseRevision();
        }
    }

    public final void added(Property property, Context context) {
        super.added(property, context);
        if (!this.isRunning()) {
            return;
        }
    }

    public final void removed(Property property, BValue bValue, Context context) {
        super.removed(property, bValue, context);
    }

    public void changed(Property property, Context context) {
        BBacnetExportFolder bBacnetExportFolder;
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)objectId)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldId = this.getObjectId();
            try {
                ((BComponent)this.getParent()).rename(this.getPropertyInParent(), this.getObjectId().toString(BacnetConst.nameContext));
            }
            catch (DuplicateSlotException duplicateSlotException) {}
            if (this.configOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (property.equals((Object)objectName)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldName = this.getObjectName();
            if (this.configOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (property.equals((Object)pointOrd)) {
            this.checkConfiguration();
            if (this.configOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (property.equals((Object)notifyType)) {
            if (this.getNotifyType() == BBacnetNotifyType.ackNotification) {
                log.message("Invalid Notify Type for " + this);
                this.setNotifyType(BBacnetNotifyType.make(this.oldNotifyType));
            } else {
                this.oldNotifyType = this.getNotifyType().getOrdinal();
            }
        } else if (property.equals((Object)description) && (bBacnetExportFolder = this.getSvo()) != null) {
            bBacnetExportFolder.fireSubordinateAnnotationChanged(null);
        }
    }

    public final void doAddCovSubscription(BBacnetCovSubscription bBacnetCovSubscription) {
        if (log.isTraceOn()) {
            log.trace("Adding Cov subscription: " + bBacnetCovSubscription + " on " + this);
        }
        Property property = this.add("covSubscription?", (BValue)bBacnetCovSubscription, 3);
        BBacnetNetwork.localDevice().subscribeCov(this, (BComponent)this.getPoint(), property);
    }

    public final void doRemoveCovSubscription(BBacnetCovSubscription bBacnetCovSubscription) {
        Clock.Ticket ticket;
        if (log.isTraceOn()) {
            log.trace("Removing Cov subscription: " + bBacnetCovSubscription + " on " + this);
        }
        if ((ticket = bBacnetCovSubscription.getTicket()) != null) {
            ticket.cancel();
        }
        bBacnetCovSubscription.setTicket(null);
        Property property = this.getProperty(bBacnetCovSubscription.getName());
        if (property != null) {
            this.remove(property);
        }
        BBacnetNetwork.localDevice().unsubscribeCov(this, (BComponent)this.getPoint(), property);
    }

    public void doSendCovNotification(BBacnetCovSubscription bBacnetCovSubscription) {
        BNumericPoint bNumericPoint = this.getPoint();
        if (bBacnetCovSubscription.getTimeRemaining() < 0) {
            this.removeCovSubscription(bBacnetCovSubscription);
            return;
        }
        if (log.isTraceOn()) {
            log.trace("Sending Cov Notification: pt=" + bNumericPoint + ", covSub=" + bBacnetCovSubscription);
        }
        Cov cov = new Cov(bBacnetCovSubscription, this, (BControlPoint)bNumericPoint);
        BBacnetNetwork.bacnet().postAsync(cov);
        if (bBacnetCovSubscription.isCovProperty()) {
            bBacnetCovSubscription.setLastPropValue(this.getCurrentCovValue(bBacnetCovSubscription));
            bBacnetCovSubscription.setLastStatusBits(this.getStatusFlags().getBits() & 0x2B);
        } else {
            bBacnetCovSubscription.setLastValue(this.getCurrentStatusValue());
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void doCheckCov() {
        var1_1 = this.getProperties();
        if (true) ** GOTO lbl30
        do {
            if ((var2_2 = (BBacnetCovSubscription)var1_1.get()).isCovProperty()) {
                try {
                    var3_3 = this.readProperty(var2_2.getMonitoredPropertyReference().getPropertyId(), var2_2.getMonitoredPropertyReference().getPropertyArrayIndex());
                    var4_5 = BBacnetNetwork.localDevice().getPropertyInfo(this.getObjectId().getObjectType(), var2_2.getMonitoredPropertyReference().getPropertyId());
                    var5_6 = AsnUtil.asnToValue(var4_5, var3_3.getPropertyValue());
                    var6_7 = this.getStatusFlags().getBits() & 43;
                    if (var6_7 != var2_2.getLastStatusBits()) {
                        this.sendCovNotification(var2_2);
                        return;
                    }
                    if (var4_5.getAsnType() == 4) {
                        var7_8 = Math.abs(((BINumeric)var5_6).getNumeric() - ((BINumeric)var2_2.getLastPropValue()).getNumeric());
                        var9_9 = var2_2.getCovIncrement();
                        if (Double.isNaN(var9_9)) {
                            var9_9 = var2_2.getMonitoredPropertyReference().getPropertyId() == 85 ? ((var11_10 = (BDouble)this.get("covIncrement")) != null ? var11_10.getDouble() : 0.0) : 0.0;
                        }
                        if (var7_8 >= var9_9) {
                            this.sendCovNotification(var2_2);
                        }
                    } else if (!var5_6.equals((Object)var2_2.getLastPropValue())) {
                        this.sendCovNotification(var2_2);
                    }
                }
                catch (AsnException var3_4) {
                    var3_4.printStackTrace();
                }
            } else if (this.checkCov(this.getCurrentStatusValue(), var2_2.getLastValue())) {
                this.sendCovNotification(var2_2);
            }
            if ((v0 = BBacnetLoopDescriptor.class$javax$baja$bacnet$datatypes$BBacnetCovSubscription) != null) continue;
            v0 = BBacnetLoopDescriptor.class("[Ljavax.baja.bacnet.datatypes.BBacnetCovSubscription;", false);
        } while (var1_1.next(v0));
    }

    public final BObject getObject() {
        return this.getPoint();
    }

    public final BOrd getObjectOrd() {
        return this.getPointOrd();
    }

    public final void setObjectOrd(BOrd bOrd, Context context) {
        this.set(pointOrd, (BValue)bOrd, context);
    }

    public void checkConfiguration() {
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        if (this.isFatalFault()) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            return;
        }
        this.findPoint();
        bLocalBacnetDevice.unsubscribe(this, this.point);
        boolean bl = true;
        if (this.point == null) {
            this.setFaultCause("Cannot find exported loop");
            bl = false;
        } else {
            bLocalBacnetDevice.subscribe(this, this.point);
        }
        if (!this.getObjectId().isValid()) {
            this.setFaultCause("Invalid Object ID");
            bl = false;
        }
        if (bl) {
            String string = bLocalBacnetDevice.export(this);
            if (string != null) {
                this.duplicate = true;
                this.setFaultCause(string);
                bl = false;
            } else {
                this.duplicate = false;
            }
        }
        this.configOk = bl;
        if (bl) {
            this.setReliability((BEnum)BBacnetReliability.noFaultDetected);
            this.setFaultCause("");
            this.validate();
        } else {
            this.setReliability((BEnum)BBacnetReliability.unreliableOther);
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        }
    }

    public boolean isValidAlarmExt(BIAlarmSource bIAlarmSource) {
        if (bIAlarmSource instanceof BAlarmSourceExt) {
            return ((BAlarmSourceExt)bIAlarmSource).getOffnormalAlgorithm().getType().toString().equals("kitControl:LoopAlarmAlgorithm");
        }
        return false;
    }

    public final boolean isEventInitiationEnabled() {
        boolean bl = false;
        if (this.getNotificationClass() != null) {
            bl = true;
        }
        return bl;
    }

    public final BEnum getEventState() {
        BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
        if (bAlarmSourceExt == null) {
            return null;
        }
        return BBacnetEventState.make(bAlarmSourceExt.getAlarmState());
    }

    public final BBacnetBitString getAckedTransitions() {
        BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
        if (bAlarmSourceExt == null) {
            return null;
        }
        return BacnetBitStringUtil.getBacnetEventTransitionBits(bAlarmSourceExt.getAckedTransitions());
    }

    public final BBacnetTimeStamp[] getEventTimeStamps() {
        BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
        if (bAlarmSourceExt == null) {
            return null;
        }
        BBacnetTimeStamp[] bBacnetTimeStampArray = new BBacnetTimeStamp[3];
        BAbsTime bAbsTime = bAlarmSourceExt.getLastOffnormalTime();
        bBacnetTimeStampArray[0] = BAbsTime.DEFAULT.equals((Object)bAbsTime) ? new BBacnetTimeStamp(new BBacnetDateTime()) : new BBacnetTimeStamp(bAbsTime);
        bAbsTime = bAlarmSourceExt.getLastFaultTime();
        bBacnetTimeStampArray[1] = BAbsTime.DEFAULT.equals((Object)bAbsTime) ? new BBacnetTimeStamp(new BBacnetDateTime()) : new BBacnetTimeStamp(bAbsTime);
        bAbsTime = bAlarmSourceExt.getLastToNormalTime();
        bBacnetTimeStampArray[2] = BAbsTime.DEFAULT.equals((Object)bAbsTime) ? new BBacnetTimeStamp(new BBacnetDateTime()) : new BBacnetTimeStamp(bAbsTime);
        return bBacnetTimeStampArray;
    }

    public final BBacnetBitString getEventEnable() {
        BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
        if (bAlarmSourceExt == null) {
            return null;
        }
        return BacnetBitStringUtil.getBacnetEventTransitionBits(bAlarmSourceExt.getAlarmEnable());
    }

    public final int[] getEventPriorities() {
        BBacnetNotificationClassDescriptor bBacnetNotificationClassDescriptor = this.getNotificationClass();
        if (bBacnetNotificationClassDescriptor == null) {
            return null;
        }
        return bBacnetNotificationClassDescriptor.getEventPriorities();
    }

    public final BBacnetNotificationClassDescriptor getNotificationClass() {
        BBacnetNotificationClassDescriptor bBacnetNotificationClassDescriptor = null;
        BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
        if (bAlarmSourceExt == null) {
            return null;
        }
        try {
            BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            BAlarmClass bAlarmClass = bAlarmService.lookupAlarmClass(bAlarmSourceExt.getAlarmClass());
            BBacnetObjectIdentifier bBacnetObjectIdentifier = BBacnetNetwork.localDevice().lookupBacnetObjectId(bAlarmClass.getHandleOrd());
            if (bBacnetObjectIdentifier != null) {
                bBacnetNotificationClassDescriptor = (BBacnetNotificationClassDescriptor)BBacnetNetwork.localDevice().lookupBacnetObject(bBacnetObjectIdentifier);
                if (bBacnetNotificationClassDescriptor == null) {
                    log.warning("Can't find Notification Class Descriptor for ID " + (Object)((Object)bBacnetObjectIdentifier));
                }
            } else {
                log.message("Alarm Class '" + bAlarmClass + "' is used for BACnet-exposed object " + this + ", but is not exposed as a BACnet Notification Class!");
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            log.message("getNotificationClass on " + this + ": Unable to find alarm service!", (Throwable)serviceNotFoundException);
        }
        return bBacnetNotificationClassDescriptor;
    }

    public BEnum getEventType() {
        return BBacnetEventType.floatingLimit;
    }

    public BIBacnetExportObject getExport() {
        return this;
    }

    public final BBacnetCovSubscription findCovSubscription(BBacnetAddress bBacnetAddress, long l, BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        return this.findSubscription(false, bBacnetAddress, l, bBacnetObjectIdentifier, 85, -1);
    }

    public final BBacnetCovSubscription findCovPropertySubscription(BBacnetAddress bBacnetAddress, long l, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2) {
        return this.findSubscription(true, bBacnetAddress, l, bBacnetObjectIdentifier, n, -1);
    }

    public final void startCovTimer(BBacnetCovSubscription bBacnetCovSubscription, long l) {
        Clock.Ticket ticket = bBacnetCovSubscription.getTicket();
        if (ticket != null) {
            ticket.cancel();
        }
        if (l > 0L) {
            BRelTime bRelTime = BRelTime.make((long)((long)((int)l) * 1000L));
            bBacnetCovSubscription.setSubscriptionEndTime(BAbsTime.make().add(bRelTime));
            bBacnetCovSubscription.setTicket(Clock.schedule((BComponent)this, (BRelTime)bRelTime, (Action)removeCovSubscription, (BValue)bBacnetCovSubscription));
        }
        this.sendCovNotification(bBacnetCovSubscription);
    }

    public Property getOutProperty() {
        return this.getPoint().getOutProperty();
    }

    public boolean supportsSubscribeCov() {
        return true;
    }

    public BValue getCurrentCovValue(BBacnetCovSubscription bBacnetCovSubscription) {
        PropertyValue propertyValue = this.readProperty(bBacnetCovSubscription.getMonitoredPropertyReference().getPropertyId(), bBacnetCovSubscription.getMonitoredPropertyReference().getPropertyArrayIndex());
        try {
            return AsnUtil.asnToValue(BBacnetNetwork.localDevice().getPropertyInfo(this.getObjectId().getObjectType(), bBacnetCovSubscription.getMonitoredPropertyReference().getPropertyId()), propertyValue.getPropertyValue());
        }
        catch (AsnException asnException) {
            asnException.printStackTrace();
            return null;
        }
    }

    final BStatusValue getCurrentStatusValue() {
        BStatusValue bStatusValue = (BStatusValue)this.getPoint().getOutStatusValue().newCopy(true);
        bStatusValue.setStatus(this.getStatusFlags());
        return bStatusValue;
    }

    boolean checkCov(BStatusValue bStatusValue, BStatusValue bStatusValue2) {
        if (bStatusValue.getStatus().getBits() != bStatusValue2.getStatus().getBits()) {
            return true;
        }
        boolean bl = false;
        if (Math.abs(((BINumeric)bStatusValue).getNumeric() - ((BINumeric)bStatusValue2).getNumeric()) >= (double)this.getCovIncrement()) {
            bl = true;
        }
        return bl;
    }

    public final PropertyValue readProperty(PropertyReference propertyReference) throws RejectException {
        this.getPoint();
        return this.readProperty(propertyReference.getPropertyId(), propertyReference.getPropertyArrayIndex());
    }

    public final PropertyValue[] readPropertyMultiple(PropertyReference[] propertyReferenceArray) throws RejectException {
        this.getPoint();
        PropertyValue[] propertyValueArray = new PropertyValue[]{};
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>(propertyReferenceArray.length);
        int n = 0;
        while (n < propertyReferenceArray.length) {
            switch (propertyReferenceArray[n].getPropertyId()) {
                case 8: {
                    int[] nArray = REQUIRED_PROPS;
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    nArray = this.getOptionalProps();
                    n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    break;
                }
                case 80: {
                    int[] nArray = this.getOptionalProps();
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    break;
                }
                case 105: {
                    int[] nArray = REQUIRED_PROPS;
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    break;
                }
                default: {
                    arrayList.add(this.readProperty(propertyReferenceArray[n].getPropertyId(), propertyReferenceArray[n].getPropertyArrayIndex()));
                }
            }
            ++n;
        }
        return arrayList.toArray(propertyValueArray);
    }

    public final RangeData readRange(RangeReference rangeReference) throws RejectException {
        this.getPoint();
        return new ReadRangeAck(2, 0);
    }

    public final ErrorType writeProperty(PropertyValue propertyValue) throws BacnetException {
        this.getPoint();
        return this.writeProperty(propertyValue.getPropertyId(), propertyValue.getPropertyArrayIndex(), propertyValue.getPropertyValue(), propertyValue.getPriority());
    }

    public final ChangeListError addListElements(PropertyValue propertyValue) throws BacnetException {
        this.getPoint();
        int[] nArray = REQUIRED_PROPS;
        int n = propertyValue.getPropertyId();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return new NChangeListError(8, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        nArray = this.getOptionalProps();
        n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return new NChangeListError(8, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        return new NChangeListError(8, new NErrorType(2, 32), 0L);
    }

    public final ChangeListError removeListElements(PropertyValue propertyValue) throws BacnetException {
        this.getPoint();
        int[] nArray = REQUIRED_PROPS;
        int n = propertyValue.getPropertyId();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return new NChangeListError(9, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        nArray = this.getOptionalProps();
        n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return new NChangeListError(9, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        return new NChangeListError(9, new NErrorType(2, 32), 0L);
    }

    boolean isArray(int n) {
        return n == 130;
    }

    BStatus getStatusFlags() {
        int n;
        this.getPoint();
        BStatus bStatus = this.point.getStatus();
        int n2 = n = this.point == null ? 2 : bStatus.getBits();
        if (bStatus.isDown()) {
            n |= 2;
        }
        n = ((BStatusBoolean)this.point.get("loopEnable")).getValue() ? (n &= 0xFFFFFFFE) : (n |= 1);
        if (this.getReliability() != BBacnetReliability.noFaultDetected) {
            n |= 2;
        }
        return BStatus.make((int)n);
    }

    protected PropertyValue readProperty(int n, int n2) {
        if (this.point == null) {
            return new NReadPropertyResult(n, n2, new NErrorType(1, 1000));
        }
        if (n2 >= 0 && !this.isArray(n)) {
            return new NReadPropertyResult(n, n2, new NErrorType(2, 50));
        }
        try {
            switch (n) {
                case 75: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnObjectId(this.getObjectId()));
                }
                case 77: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnCharacterString(this.getObjectName()));
                }
                case 79: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(this.getObjectId().getObjectType()));
                }
                case 85: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnReal(this.point.getOut().getValue()));
                }
                case 28: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnCharacterString(this.getDescription()));
                }
                case 111: {
                    return new NReadPropertyResult(n, n2, AsnUtil.statusToAsnStatusFlags(this.getStatusFlags()));
                }
                case 36: {
                    BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
                    if (bAlarmSourceExt == null) {
                        return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(0));
                    }
                    BAlarmState bAlarmState = bAlarmSourceExt.getAlarmState();
                    if (bAlarmState.isOffnormal()) {
                        double d;
                        double d2 = ((BStatusNumeric)this.point.get("controlledVariable")).getValue();
                        bAlarmState = d2 > (d = ((BStatusNumeric)this.point.get("setpoint")).getValue()) ? BAlarmState.highLimit : BAlarmState.lowLimit;
                    }
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(BBacnetEventState.fromBAlarmState(bAlarmState)));
                }
                case 103: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(this.getReliability()));
                }
                case 81: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnBoolean(false));
                }
                case 82: {
                    BUnit bUnit = (BUnit)this.point.getFacets().getFacet("units");
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated((BEnum)BBacnetEngineeringUnits.make(bUnit)));
                }
                case 60: {
                    return new NReadPropertyResult(n, n2, this.getManipulatedVariableReference());
                }
                case 19: {
                    return new NReadPropertyResult(n, n2, this.getControlledVariableReference());
                }
                case 21: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnReal(((BStatusNumeric)this.point.get("controlledVariable")).getValue()));
                }
                case 20: {
                    BUnit bUnit = (BUnit)((BFacets)this.point.get("inputFacets")).getFacet("units");
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated((BEnum)BBacnetEngineeringUnits.make(bUnit)));
                }
                case 109: {
                    return new NReadPropertyResult(n, n2, this.getSetpointReference());
                }
                case 108: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnReal(((BStatusNumeric)this.point.get("setpoint")).getValue()));
                }
                case 2: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(((BEnum)this.point.get("loopAction")).getOrdinal()));
                }
                case 93: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnReal(((BDouble)this.point.get("proportionalConstant")).getDouble()));
                }
                case 94: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(95));
                }
                case 49: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnReal(((BDouble)this.point.get("integralConstant")).getDouble()));
                }
                case 50: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(100));
                }
                case 26: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnReal(((BDouble)this.point.get("derivativeConstant")).getDouble()));
                }
                case 27: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(73));
                }
                case 14: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnReal(((BDouble)this.point.get("bias")).getDouble()));
                }
                case 61: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnReal(((BDouble)this.point.get("maximumOutput")).getDouble()));
                }
                case 68: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnReal(((BDouble)this.point.get("minimumOutput")).getDouble()));
                }
                case 88: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(this.getPriorityForWriting()));
                }
                case 22: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnReal(this.getCovIncrement()));
                }
            }
            return this.readOptionalProperty(n, n2);
        }
        catch (NullPointerException nullPointerException) {
            return new NReadPropertyResult(n, n2, new NErrorType(2, 32));
        }
    }

    protected PropertyValue readOptionalProperty(int n, int n2) {
        BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
        if (bAlarmSourceExt != null) {
            BOffnormalAlgorithm bOffnormalAlgorithm = bAlarmSourceExt.getOffnormalAlgorithm();
            try {
                switch (n) {
                    case 113: {
                        return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(bAlarmSourceExt.getTimeDelay().getMillis() / 1000L));
                    }
                    case 17: {
                        BBacnetNotificationClassDescriptor bBacnetNotificationClassDescriptor = this.getNotificationClass();
                        if (bBacnetNotificationClassDescriptor == null) {
                            return new NReadPropertyResult(n, n2, new NErrorType(2, 32));
                        }
                        return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(bBacnetNotificationClassDescriptor.getNotificationClass()));
                    }
                    case 25: {
                        return new NReadPropertyResult(n, n2, AsnUtil.toAsnReal(((BDouble)bOffnormalAlgorithm.get("deadband")).getDouble()));
                    }
                    case 34: {
                        return new NReadPropertyResult(n, n2, AsnUtil.toAsnReal(((BDouble)bOffnormalAlgorithm.get("errorLimit")).getDouble()));
                    }
                    case 35: {
                        return new NReadPropertyResult(n, n2, AsnUtil.toAsnBitString(BacnetBitStringUtil.getBacnetEventTransitionBits(bAlarmSourceExt.getAlarmEnable())));
                    }
                    case 0: {
                        return new NReadPropertyResult(n, n2, AsnUtil.toAsnBitString(BacnetBitStringUtil.getBacnetEventTransitionBits(bAlarmSourceExt.getAckedTransitions())));
                    }
                    case 72: {
                        return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated((BEnum)this.getNotifyType()));
                    }
                    case 130: {
                        return this.readEventTimeStamps(bAlarmSourceExt, n2);
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                return new NReadPropertyResult(n, n2, new NErrorType(2, 32));
            }
        }
        return new NReadPropertyResult(n, n2, new NErrorType(2, 32));
    }

    protected ErrorType writeProperty(int n, int n2, byte[] byArray, int n3) throws BacnetException {
        if (this.point == null) {
            return new NErrorType(1, 1000);
        }
        if (n2 >= 0 && !this.isArray(n)) {
            return new NErrorType(2, 50);
        }
        try {
            switch (n) {
                case 77: {
                    return BacUtil.setObjectName(this, objectName, byArray);
                }
                case 75: 
                case 79: 
                case 85: {
                    return new NErrorType(2, 40);
                }
                case 28: {
                    this.setString(description, AsnUtil.fromAsnCharacterString(byArray), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
                case 36: 
                case 103: 
                case 111: {
                    return new NErrorType(2, 40);
                }
                case 81: {
                    return new NErrorType(2, 40);
                }
                case 19: 
                case 20: 
                case 21: 
                case 60: 
                case 82: 
                case 109: {
                    return new NErrorType(2, 40);
                }
                case 108: {
                    BLink[] bLinkArray = this.point.getLinks((Slot)this.point.getProperty("setpoint"));
                    if (bLinkArray.length > 0) {
                        return new NErrorType(2, 40);
                    }
                    this.point.set(this.point.getProperty("setpoint"), (BValue)new BStatusNumeric((double)AsnUtil.fromAsnReal(byArray)), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
                case 2: {
                    return new NErrorType(2, 40);
                }
                case 93: {
                    this.point.set(this.point.getProperty("proportionalConstant"), (BValue)BDouble.make((double)AsnUtil.fromAsnReal(byArray)), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
                case 94: {
                    return new NErrorType(2, 40);
                }
                case 49: {
                    this.point.set(this.point.getProperty("integralConstant"), (BValue)BDouble.make((double)AsnUtil.fromAsnReal(byArray)), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
                case 50: {
                    return new NErrorType(2, 40);
                }
                case 26: {
                    this.point.set(this.point.getProperty("derivativeConstant"), (BValue)BDouble.make((double)AsnUtil.fromAsnReal(byArray)), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
                case 27: {
                    return new NErrorType(2, 40);
                }
                case 14: {
                    this.point.set(this.point.getProperty("bias"), (BValue)BDouble.make((double)AsnUtil.fromAsnReal(byArray)), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
                case 61: {
                    this.point.set(this.point.getProperty("maximumOutput"), (BValue)BDouble.make((double)AsnUtil.fromAsnReal(byArray)), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
                case 68: {
                    this.point.set(this.point.getProperty("minimumOutput"), (BValue)BDouble.make((double)AsnUtil.fromAsnReal(byArray)), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
                case 88: {
                    return new NErrorType(2, 40);
                }
                case 22: {
                    this.setFloat(covIncrement, AsnUtil.fromAsnReal(byArray), BLocalBacnetDevice.getBacnetContext());
                    this.checkCov();
                    return null;
                }
            }
            return this.writeOptionalProperty(n, n2, byArray, n3);
        }
        catch (AsnException asnException) {
            asnException.printStackTrace();
            log.message("AsnException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)asnException));
            return new NErrorType(2, 9);
        }
        catch (PermissionException permissionException) {
            log.message("PermissionException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)permissionException));
            return new NErrorType(2, 40);
        }
        catch (NullPointerException nullPointerException) {
            return new NErrorType(2, 32);
        }
    }

    protected ErrorType writeOptionalProperty(int n, int n2, byte[] byArray, int n3) throws BacnetException {
        try {
            BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
            if (bAlarmSourceExt != null) {
                BOffnormalAlgorithm bOffnormalAlgorithm = bAlarmSourceExt.getOffnormalAlgorithm();
                switch (n) {
                    case 113: {
                        bAlarmSourceExt.set(BAlarmSourceExt.timeDelay, (BValue)BRelTime.make((long)(AsnUtil.fromAsnUnsignedInteger(byArray) * 1000L)), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 17: {
                        return new NErrorType(2, 40);
                    }
                    case 25: {
                        bOffnormalAlgorithm.set(bOffnormalAlgorithm.getProperty("deadband"), (BValue)BDouble.make((double)AsnUtil.fromAsnReal(byArray)), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 34: {
                        bOffnormalAlgorithm.set(bOffnormalAlgorithm.getProperty("errorLimit"), (BValue)BDouble.make((double)AsnUtil.fromAsnReal(byArray)), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 35: {
                        return new NErrorType(2, 40);
                    }
                    case 0: {
                        return new NErrorType(2, 40);
                    }
                    case 72: {
                        return new NErrorType(2, 40);
                    }
                    case 130: {
                        return new NErrorType(2, 40);
                    }
                }
            }
        }
        catch (AsnException asnException) {
            log.message("AsnException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)asnException));
            return new NErrorType(2, 9);
        }
        catch (PermissionException permissionException) {
            log.message("PermissionException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)permissionException));
            return new NErrorType(2, 40);
        }
        catch (NullPointerException nullPointerException) {
            return new NErrorType(2, 32);
        }
        return new NErrorType(2, 32);
    }

    private final int[] getOptionalProps() {
        BOffnormalAlgorithm bOffnormalAlgorithm;
        Vector<BBacnetPropertyIdentifier> vector = new Vector<BBacnetPropertyIdentifier>();
        vector.add(BBacnetPropertyIdentifier.description);
        vector.add(BBacnetPropertyIdentifier.reliability);
        vector.add(BBacnetPropertyIdentifier.proportionalConstant);
        vector.add(BBacnetPropertyIdentifier.proportionalConstantUnits);
        vector.add(BBacnetPropertyIdentifier.integralConstant);
        vector.add(BBacnetPropertyIdentifier.integralConstantUnits);
        vector.add(BBacnetPropertyIdentifier.derivativeConstant);
        vector.add(BBacnetPropertyIdentifier.derivativeConstantUnits);
        vector.add(BBacnetPropertyIdentifier.bias);
        vector.add(BBacnetPropertyIdentifier.maximumOutput);
        vector.add(BBacnetPropertyIdentifier.minimumOutput);
        vector.add(BBacnetPropertyIdentifier.covIncrement);
        BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
        if (bAlarmSourceExt != null && (bOffnormalAlgorithm = bAlarmSourceExt.getOffnormalAlgorithm()).getType().getTypeName().equals("LoopAlarmAlgorithm")) {
            vector.add(BBacnetPropertyIdentifier.timeDelay);
            vector.add(BBacnetPropertyIdentifier.notificationClass);
            vector.add(BBacnetPropertyIdentifier.eventEnable);
            vector.add(BBacnetPropertyIdentifier.ackedTransitions);
            vector.add(BBacnetPropertyIdentifier.notifyType);
            vector.add(BBacnetPropertyIdentifier.eventTimeStamps);
            vector.add(BBacnetPropertyIdentifier.deadband);
            vector.add(BBacnetPropertyIdentifier.errorLimit);
        }
        this.optionalProps = new int[vector.size()];
        int n = 0;
        while (n < this.optionalProps.length) {
            this.optionalProps[n] = ((BEnum)vector.elementAt(n)).getOrdinal();
            ++n;
        }
        return this.optionalProps;
    }

    void checkValid() {
        if (this.configOk()) {
            this.validate();
        }
    }

    private final synchronized boolean configOk() {
        return this.configOk;
    }

    private final void validate() {
        BStatusNumeric bStatusNumeric = this.getPoint().getOut();
        BStatus bStatus = bStatusNumeric.getStatus();
        if (bStatus.isNull()) {
            this.setReliability((BEnum)BBacnetReliability.unreliableOther);
            this.setFaultCause("Invalid value for BACnet Object:" + bStatusNumeric);
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        } else if (bStatus.isFault() || bStatus.isDown()) {
            this.setReliability((BEnum)BBacnetReliability.unreliableOther);
        } else {
            this.setReliability((BEnum)BBacnetReliability.noFaultDetected);
            if (this.configOk()) {
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
                this.setFaultCause("");
            } else {
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
                this.setFaultCause(lex.getText("export.configurationFault"));
            }
        }
    }

    public String toString(Context context) {
        return this.getObjectName() + " [" + (Object)((Object)this.getObjectId()) + ']';
    }

    final BNumericPoint getPoint() {
        if (this.point == null) {
            return this.findPoint();
        }
        return this.point;
    }

    /*
     * Unable to fully structure code
     */
    private final BAlarmSourceExt getAlarmExt() {
        var1_1 = this.getPoint();
        if (var1_1 == null) {
            return null;
        }
        var2_2 = var1_1.getProperties();
        if (true) ** GOTO lbl9
        do {
            if (this.isValidAlarmExt((BIAlarmSource)(var3_3 = (BAlarmSourceExt)var2_2.get()))) {
                return var3_3;
            }
lbl9:
            // 3 sources

            if ((v0 = BBacnetLoopDescriptor.class$javax$baja$alarm$ext$BAlarmSourceExt) != null) continue;
            v0 = BBacnetLoopDescriptor.class("[Ljavax.baja.alarm.ext.BAlarmSourceExt;", false);
        } while (var2_2.next(v0));
        return null;
    }

    private final BNumericPoint findPoint() {
        try {
            if (!pointOrd.isEquivalentToDefaultValue((BValue)this.getPointOrd())) {
                BObject bObject = this.getPointOrd().get((BObject)this);
                this.point = bObject instanceof BNumericPoint && bObject.getType().toString().equals("kitControl:LoopPoint") ? (BNumericPoint)bObject : null;
            }
        }
        catch (Exception exception) {
            log.warning("Unable to resolve point ord for " + this + ": " + this.getPointOrd());
            this.point = null;
        }
        if (this.point == null && this.isRunning()) {
            this.setReliability((BEnum)BBacnetReliability.unreliableOther);
            this.setFaultCause("Cannot find exported loop");
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        }
        return this.point;
    }

    private final byte[] getManipulatedVariableReference() {
        BBacnetObjectPropertyReference bBacnetObjectPropertyReference = NULL_OPR;
        Knob[] knobArray = this.point.getKnobs((Slot)this.point.getProperty("out"));
        if (knobArray.length > 0) {
            BOrd bOrd = knobArray[0].getTargetOrd();
            BBacnetObjectIdentifier bBacnetObjectIdentifier = BBacnetNetwork.localDevice().lookupBacnetObjectId(bOrd);
            if (bBacnetObjectIdentifier != null) {
                bBacnetObjectPropertyReference = new BBacnetObjectPropertyReference(bBacnetObjectIdentifier);
            }
        }
        return AsnUtil.toAsn((BValue)bBacnetObjectPropertyReference);
    }

    private final byte[] getControlledVariableReference() {
        BBacnetObjectPropertyReference bBacnetObjectPropertyReference = NULL_OPR;
        BLink[] bLinkArray = this.point.getLinks(this.point.getSlot("controlledVariable"));
        if (bLinkArray.length > 0) {
            BOrd bOrd = bLinkArray[0].getSourceComponent().getAbsoluteOrd();
            BBacnetObjectIdentifier bBacnetObjectIdentifier = BBacnetNetwork.localDevice().lookupBacnetObjectId(bOrd);
            if (bBacnetObjectIdentifier != null) {
                bBacnetObjectPropertyReference = new BBacnetObjectPropertyReference(bBacnetObjectIdentifier);
            }
        }
        return AsnUtil.toAsn((BValue)bBacnetObjectPropertyReference);
    }

    private final byte[] getSetpointReference() {
        BLink[] bLinkArray = this.point.getLinks((Slot)this.point.getProperty("setpoint"));
        if (bLinkArray.length > 0) {
            BOrd bOrd = bLinkArray[0].getSourceComponent().getAbsoluteOrd();
            BBacnetObjectIdentifier bBacnetObjectIdentifier = BBacnetNetwork.localDevice().lookupBacnetObjectId(bOrd);
            if (bBacnetObjectIdentifier != null) {
                BBacnetSetpointReference bBacnetSetpointReference = new BBacnetSetpointReference(new BBacnetObjectPropertyReference(bBacnetObjectIdentifier));
                return AsnUtil.toAsn((BValue)bBacnetSetpointReference);
            }
        }
        return new byte[0];
    }

    private final int getPriorityForWriting() {
        Knob[] knobArray = this.point.getKnobs((Slot)this.point.getProperty("out"));
        if (knobArray.length == 0) {
            return 16;
        }
        String string = knobArray[0].getTargetSlotName();
        try {
            return Integer.parseInt(string.substring(2));
        }
        catch (Exception exception) {
            return 16;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final PropertyValue readEventTimeStamps(BAlarmSourceExt bAlarmSourceExt, int n) {
        AsnOutputStream asnOutputStream = asnOut;
        synchronized (asnOutputStream) {
            asnOut.reset();
            BAbsTime bAbsTime = bAlarmSourceExt.getToOffnormalTimes().getNormalTime();
            if (bAbsTime.isBefore(bAlarmSourceExt.getToFaultTimes().getNormalTime())) {
                bAbsTime = bAlarmSourceExt.getToFaultTimes().getNormalTime();
            }
            switch (n) {
                case 0: {
                    asnOut.writeUnsignedInteger(3);
                    break;
                }
                case 1: {
                    BBacnetTimeStamp.encodeTimeStamp(bAlarmSourceExt.getToOffnormalTimes().getAlarmTime(), asnOut);
                    break;
                }
                case 2: {
                    BBacnetTimeStamp.encodeTimeStamp(bAlarmSourceExt.getToFaultTimes().getAlarmTime(), asnOut);
                    break;
                }
                case 3: {
                    BBacnetTimeStamp.encodeTimeStamp(bAbsTime, asnOut);
                    break;
                }
                case -1: {
                    BBacnetTimeStamp.encodeTimeStamp(bAlarmSourceExt.getToOffnormalTimes().getAlarmTime(), asnOut);
                    BBacnetTimeStamp.encodeTimeStamp(bAlarmSourceExt.getToFaultTimes().getAlarmTime(), asnOut);
                    BBacnetTimeStamp.encodeTimeStamp(bAbsTime, asnOut);
                    break;
                }
                default: {
                    return new NReadPropertyResult(130, n, new NErrorType(2, 42));
                }
            }
            return new NReadPropertyResult(130, n, asnOut.toByteArray());
        }
    }

    /*
     * Unable to fully structure code
     */
    private final BBacnetCovSubscription findSubscription(boolean var1_1, BBacnetAddress var2_2, long var3_3, BBacnetObjectIdentifier var5_4, int var6_5, int var7_6) {
        var8_7 = this.getProperties();
        if (true) ** GOTO lbl6
        do {
            if ((var9_8 = (BBacnetCovSubscription)var8_7.get()).isCovProperty() == var1_1 && var9_8.getRecipient().getRecipient().getAddress().equals(var2_2.getNetworkNumber(), var2_2.getMacAddress().getBytes()) && var9_8.getRecipient().getProcessIdentifier().getUnsigned() == var3_3 && this.getObjectId().equals((Object)var5_4) && var9_8.getMonitoredPropertyReference().getPropertyId() == var6_5 && var9_8.getMonitoredPropertyReference().getPropertyArrayIndex() == var7_6) {
                return var9_8;
            }
lbl6:
            // 3 sources

            if ((v0 = BBacnetLoopDescriptor.class$javax$baja$bacnet$datatypes$BBacnetCovSubscription) != null) continue;
            v0 = BBacnetLoopDescriptor.class("[Ljavax.baja.bacnet.datatypes.BBacnetCovSubscription;", false);
        } while (var8_7.next(v0));
        return null;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetLoopDescriptor", 2);
        spyWriter.prop((Object)"point", (Object)this.point);
        spyWriter.prop((Object)"oldId", (Object)this.oldId);
        spyWriter.prop((Object)"oldName", (Object)this.oldName);
        spyWriter.prop((Object)"duplicate", this.duplicate);
        spyWriter.prop((Object)"oldNotifyType", this.oldNotifyType);
        spyWriter.prop((Object)"almExt", (Object)this.getAlarmExt());
        spyWriter.prop((Object)"notificationClass", (Object)this.getNotificationClass());
        spyWriter.prop((Object)"configOk", this.configOk());
        spyWriter.endProps();
    }

    public BIcon getIcon() {
        return icon;
    }

    final void d(String string) {
        System.out.println("BacSLoop{" + (Object)((Object)this.getObjectId()) + "}:" + string);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.oldId = null;
        this.oldName = null;
        this.duplicate = false;
    }

    public BBacnetLoopDescriptor() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$bacnet$export$BBacnetLoopDescriptor;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$export$BBacnetLoopDescriptor = BBacnetLoopDescriptor.class("[Ljavax.baja.bacnet.export.BBacnetLoopDescriptor;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((BIcon)BIcon.std((String)"control/numericPoint.png"), (BIcon)BIcon.std((String)"badges/export.png"));
        asnIn = new AsnInputStream();
        asnOut = new AsnOutputStream();
        log = Log.getLog((String)"bacnet.server");
        lex = Lexicon.make((String)"bacnet");
        NULL_OPR = new BBacnetObjectPropertyReference();
        REQUIRED_PROPS = new int[]{75, 77, 79, 85, 111, 36, 81, 82, 60, 19, 21, 20, 109, 108, 2, 88};
    }
}

