/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import com.tridium.bacnet.services.error.NChangeListError;
import com.tridium.bacnet.stack.server.BBacnetExportTable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetFileAccessMethod;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RangeReference;
import javax.baja.bacnet.io.RejectException;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.security.PermissionException;
import javax.baja.space.BISpaceNode;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetFileDescriptor
extends BComponent
implements BIBacnetExportObject {
    public static final Property status = BBacnetFileDescriptor.newProperty((int)67, (BValue)BStatus.ok, null);
    public static final Property faultCause = BBacnetFileDescriptor.newProperty((int)3, (String)"", null);
    public static final Property fileOrd = BBacnetFileDescriptor.newProperty((int)64, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (String)"baja:IFile"));
    public static final Property objectId = BBacnetFileDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(10), null);
    public static final Property objectName = BBacnetFileDescriptor.newProperty((int)64, (String)"", null);
    public static final Property description = BBacnetFileDescriptor.newProperty((int)0, (String)"", null);
    public static final Property fileType = BBacnetFileDescriptor.newProperty((int)0, (String)"", null);
    public static final Property archiveTime = BBacnetFileDescriptor.newProperty((int)0, (BValue)BAbsTime.DEFAULT, null);
    public static final Property fileAccessMethod = BBacnetFileDescriptor.newProperty((int)1, (BValue)BBacnetFileAccessMethod.streamAccess, null);
    public static final Type TYPE;
    private static final BIcon icon;
    public static final int FILE_WRITE_OK = -1;
    public static final int APPEND_START_POSITION = -1;
    static Log log;
    private static final int[] REQUIRED_PROPS;
    private static final int[] OPTIONAL_PROPS;
    private boolean fatalFault;
    private BIFile file;
    private boolean eof;
    private Subscriber subscriber;
    private BBacnetObjectIdentifier oldId;
    private String oldName;
    private boolean duplicate;
    static /* synthetic */ Class class$javax$baja$bacnet$export$BBacnetFileDescriptor;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public BOrd getFileOrd() {
        return (BOrd)this.get(fileOrd);
    }

    public void setFileOrd(BOrd bOrd) {
        this.set(fileOrd, (BValue)bOrd, null);
    }

    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    public void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.set(objectId, (BValue)bBacnetObjectIdentifier, null);
    }

    public String getObjectName() {
        return this.getString(objectName);
    }

    public void setObjectName(String string) {
        this.setString(objectName, string, null);
    }

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String string) {
        this.setString(description, string, null);
    }

    public String getFileType() {
        return this.getString(fileType);
    }

    public void setFileType(String string) {
        this.setString(fileType, string, null);
    }

    public BAbsTime getArchiveTime() {
        return (BAbsTime)this.get(archiveTime);
    }

    public void setArchiveTime(BAbsTime bAbsTime) {
        this.set(archiveTime, (BValue)bAbsTime, null);
    }

    public BBacnetFileAccessMethod getFileAccessMethod() {
        return (BBacnetFileAccessMethod)this.get(fileAccessMethod);
    }

    public void setFileAccessMethod(BBacnetFileAccessMethod bBacnetFileAccessMethod) {
        this.set(fileAccessMethod, (BValue)bBacnetFileAccessMethod, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void started() throws Exception {
        super.started();
        this.checkFatalFault();
        this.oldId = this.getObjectId();
        this.oldName = this.getObjectName();
        this.subscriber = new FileSubscriber(this);
        this.checkConfiguration();
        if (Sys.isStationStarted() && this.getStatus().isOk()) {
            BBacnetNetwork.localDevice().incrementDatabaseRevision();
        }
    }

    public final void stopped() throws Exception {
        super.stopped();
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        bLocalBacnetDevice.unexport(this.oldId, this.oldName, this);
        this.subscriber.unsubscribeAll();
        this.file = null;
        this.subscriber = null;
        this.oldId = null;
        this.oldName = null;
        if (this.getStatus().isOk() && bLocalBacnetDevice.isRunning()) {
            bLocalBacnetDevice.incrementDatabaseRevision();
        }
    }

    public final void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)objectId)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldId = this.getObjectId();
            try {
                ((BComponent)this.getParent()).rename(this.getPropertyInParent(), this.getObjectId().toString(BacnetConst.nameContext));
            }
            catch (DuplicateSlotException duplicateSlotException) {}
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (property.equals((Object)objectName)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldName = this.getObjectName();
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (property.equals((Object)fileOrd)) {
            this.checkConfiguration();
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        }
    }

    public final BFacets getSlotFacets(Slot slot) {
        if (slot == objectId) {
            return BBacnetObjectType.getObjectIdFacets(10);
        }
        return super.getSlotFacets(slot);
    }

    public final BObject getObject() {
        return (BObject)this.getFile();
    }

    public final BOrd getObjectOrd() {
        return this.getFileOrd();
    }

    public final void setObjectOrd(BOrd bOrd, Context context) {
        this.set(fileOrd, (BValue)bOrd, context);
    }

    public void checkConfiguration() {
        if (this.isFatalFault()) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            return;
        }
        this.subscriber.unsubscribeAll();
        this.getFile();
        boolean bl = true;
        if (this.file == null) {
            this.setFaultCause("Cannot find exported file");
            bl = false;
        } else {
            this.subscriber.subscribe((BComponent)this.getParent());
        }
        if (!this.getObjectId().isValid()) {
            this.setFaultCause("Invalid Object ID");
            bl = false;
        }
        if (bl) {
            String string = BBacnetNetwork.localDevice().export(this);
            if (string != null) {
                this.duplicate = true;
                this.setFaultCause(string);
                bl = false;
            } else {
                this.duplicate = false;
            }
        }
        if (bl) {
            this.setFaultCause("");
        }
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)(bl ^ true)));
    }

    public final PropertyValue readProperty(PropertyReference propertyReference) throws RejectException {
        this.getFile();
        return this.readProperty(propertyReference.getPropertyId(), propertyReference.getPropertyArrayIndex());
    }

    public final PropertyValue[] readPropertyMultiple(PropertyReference[] propertyReferenceArray) throws RejectException {
        this.getFile();
        PropertyValue[] propertyValueArray = new PropertyValue[]{};
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>(propertyReferenceArray.length);
        int n = 0;
        while (n < propertyReferenceArray.length) {
            switch (propertyReferenceArray[n].getPropertyId()) {
                case 8: {
                    int[] nArray = REQUIRED_PROPS;
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    nArray = OPTIONAL_PROPS;
                    n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    break;
                }
                case 80: {
                    int[] nArray = OPTIONAL_PROPS;
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    break;
                }
                case 105: {
                    int[] nArray = REQUIRED_PROPS;
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    break;
                }
                default: {
                    arrayList.add(this.readProperty(propertyReferenceArray[n].getPropertyId(), propertyReferenceArray[n].getPropertyArrayIndex()));
                }
            }
            ++n;
        }
        return arrayList.toArray(propertyValueArray);
    }

    public RangeData readRange(RangeReference rangeReference) throws RejectException {
        int n = rangeReference.getPropertyId();
        int n2 = 0;
        while (n2 < REQUIRED_PROPS.length) {
            if (n == REQUIRED_PROPS[n2]) {
                return new ReadRangeAck(5, 22);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < OPTIONAL_PROPS.length) {
            if (n == OPTIONAL_PROPS[n2]) {
                return new ReadRangeAck(5, 22);
            }
            ++n2;
        }
        return new ReadRangeAck(2, 32);
    }

    public final ErrorType writeProperty(PropertyValue propertyValue) throws BacnetException {
        this.getFile();
        return this.writeProperty(propertyValue.getPropertyId(), propertyValue.getPropertyArrayIndex(), propertyValue.getPropertyValue(), propertyValue.getPriority());
    }

    public final ChangeListError addListElements(PropertyValue propertyValue) throws BacnetException {
        this.getFile();
        int n = propertyValue.getPropertyId();
        int n2 = 0;
        while (n2 < REQUIRED_PROPS.length) {
            if (n == REQUIRED_PROPS[n2]) {
                return new NChangeListError(8, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < OPTIONAL_PROPS.length) {
            if (n == OPTIONAL_PROPS[n2]) {
                return new NChangeListError(8, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        return new NChangeListError(8, new NErrorType(2, 32), 0L);
    }

    public final ChangeListError removeListElements(PropertyValue propertyValue) throws BacnetException {
        this.getFile();
        int n = propertyValue.getPropertyId();
        int n2 = 0;
        while (n2 < REQUIRED_PROPS.length) {
            if (n == REQUIRED_PROPS[n2]) {
                return new NChangeListError(9, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < OPTIONAL_PROPS.length) {
            if (n == OPTIONAL_PROPS[n2]) {
                return new NChangeListError(9, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        return new NChangeListError(9, new NErrorType(2, 32), 0L);
    }

    protected PropertyValue readProperty(int n, int n2) {
        if (this.file == null) {
            return new NReadPropertyResult(n, n2, new NErrorType(1, 1000));
        }
        if (n2 >= 0) {
            return new NReadPropertyResult(n, n2, new NErrorType(2, 50));
        }
        switch (n) {
            case 75: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnObjectId(this.getObjectId()));
            }
            case 79: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(this.getObjectId().getObjectType()));
            }
            case 77: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnCharacterString(this.getObjectName()));
            }
            case 43: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnCharacterString(this.file.getMimeType()));
            }
            case 42: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(this.file.getSize()));
            }
            case 71: {
                return new NReadPropertyResult(n, n2, AsnUtil.toBacnetDateTime(this.file.getLastModified()));
            }
            case 13: {
                boolean bl = this.getArchiveTime().isAfter(this.file.getLastModified());
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnBoolean(bl));
            }
            case 99: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnBoolean(this.file.isReadonly()));
            }
            case 41: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated((BEnum)this.getFileAccessMethod()));
            }
            case 28: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnCharacterString(this.getDescription()));
            }
        }
        return new NReadPropertyResult(n, n2, new NErrorType(2, 32));
    }

    protected ErrorType writeProperty(int n, int n2, byte[] byArray, int n3) throws BacnetException {
        if (this.file == null) {
            return new NErrorType(1, 1000);
        }
        if (n2 >= 0) {
            return new NErrorType(5, 7);
        }
        try {
            switch (n) {
                case 75: {
                    return new NErrorType(2, 40);
                }
                case 79: {
                    return new NErrorType(2, 40);
                }
                case 77: {
                    return BacUtil.setObjectName(this, objectName, byArray);
                }
                case 43: {
                    return new NErrorType(2, 40);
                }
                case 42: {
                    if (this.file.isReadonly()) {
                        return new NErrorType(2, 40);
                    }
                    try {
                        if (AsnUtil.fromAsnUnsignedInt(byArray) != 0) {
                            return new NErrorType(2, 37);
                        }
                        this.file.write(new byte[0]);
                        return null;
                    }
                    catch (IOException iOException) {
                        return new NErrorType(0, 25);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return new NErrorType(2, 37);
                    }
                }
                case 71: {
                    return new NErrorType(2, 40);
                }
                case 13: {
                    boolean bl = AsnUtil.fromAsnBoolean(byArray);
                    if (bl) {
                        this.set(archiveTime, (BValue)BAbsTime.make(), BLocalBacnetDevice.getBacnetContext());
                    } else {
                        this.set(archiveTime, (BValue)BAbsTime.DEFAULT, BLocalBacnetDevice.getBacnetContext());
                    }
                    return null;
                }
                case 99: {
                    return new NErrorType(2, 40);
                }
                case 41: {
                    return new NErrorType(2, 40);
                }
                case 28: {
                    this.setString(description, AsnUtil.fromAsnCharacterString(byArray), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
            }
            return new NErrorType(2, 32);
        }
        catch (AsnException asnException) {
            log.message("AsnException writing property " + n + " in object " + (Object)((Object)this.getObjectId()));
            return new NErrorType(2, 9);
        }
        catch (PermissionException permissionException) {
            log.message("PermissionException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)permissionException));
            return new NErrorType(2, 40);
        }
    }

    public String toString(Context context) {
        return this.getObjectName() + " [" + (Object)((Object)this.getObjectId()) + ']';
    }

    protected final BIFile getFile() {
        if (this.file == null) {
            return this.findFile();
        }
        return this.file;
    }

    private final BIFile findFile() {
        try {
            if (!fileOrd.isEquivalentToDefaultValue((BValue)this.getFileOrd())) {
                BObject bObject = this.getFileOrd().get((BObject)this);
                this.file = bObject instanceof BIFile ? (BIFile)bObject : null;
            }
        }
        catch (Exception exception) {
            log.warning("Unable to resolve file ord for " + this + ": " + this.getFileOrd());
            this.file = null;
        }
        if (this.file == null) {
            this.setFaultCause("Cannot find exported file");
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        }
        return this.file;
    }

    public final byte[] read(int n, int n2) throws IOException {
        return this.readFile(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readFile(int n, int n2) throws IOException {
        byte[] byArray;
        if (this.file == null) {
            return null;
        }
        this.eof = false;
        InputStream inputStream = this.file.getInputStream();
        try {
            inputStream.skip(n);
            int n3 = inputStream.available();
            byte[] byArray2 = null;
            if (n3 <= n2) {
                this.eof = true;
                byArray2 = new byte[n3];
            } else {
                this.eof = false;
                byArray2 = new byte[n2];
            }
            int n4 = inputStream.read(byArray2);
            if (log.isTraceOn()) {
                log.trace("BacnetFile " + this.file.getFileName() + " {" + (Object)((Object)this.getObjectId()) + "}.read():" + n2 + " bytes requested, " + n4 + " bytes read from file.");
            }
            if (n4 < 0) {
                this.eof = true;
            }
            byArray = byArray2;
            Object var5_8 = null;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return byArray;
    }

    public final int write(int n, byte[] byArray) throws IOException {
        return this.writeFile(n, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int writeFile(int n, byte[] byArray) throws IOException {
        RandomAccessFile randomAccessFile;
        block10: {
            int n2;
            if (this.file == null) {
                return 5;
            }
            if (this.file.isReadonly()) {
                return 5;
            }
            if (log.isTraceOn()) {
                log.trace("BacnetFile " + this.file.getFileName() + " {" + (Object)((Object)this.getObjectId()) + "}.write():" + byArray.length + " bytes starting at " + n);
            }
            long l = this.file.getSize();
            File file = ((BLocalFileStore)this.file.getStore()).getLocalFile();
            randomAccessFile = new RandomAccessFile(file, "rw");
            try {
                if ((long)n >= l) {
                    int n3 = (int)((long)n - l);
                    randomAccessFile.seek(l);
                    byte[] byArray2 = new byte[n3];
                    int n4 = 0;
                    while (n4 < n3) {
                        byArray2[n4] = 0;
                        ++n4;
                    }
                    randomAccessFile.write(byArray2);
                    break block10;
                }
                if (n == -1) {
                    randomAccessFile.seek(l);
                    break block10;
                }
                if (n >= 0) {
                    randomAccessFile.seek(n);
                    break block10;
                }
                n2 = 11;
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                randomAccessFile.close();
                throw throwable;
            }
            randomAccessFile.close();
            return n2;
        }
        randomAccessFile.write(byArray);
        log.trace("File write OK");
        int n5 = -1;
        Object var8_12 = null;
        randomAccessFile.close();
        return n5;
    }

    public long getFileSize() {
        return this.getFile().getSize();
    }

    public final boolean isEOF() {
        return this.eof;
    }

    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    private final void checkFatalFault() {
        BBacnetExportTable bBacnetExportTable = null;
        BLocalBacnetDevice bLocalBacnetDevice = null;
        BBacnetNetwork bBacnetNetwork = null;
        if (this.fatalFault) {
            return;
        }
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BBacnetExportTable) {
                bBacnetExportTable = (BBacnetExportTable)bComplex;
            } else if (bComplex instanceof BLocalBacnetDevice) {
                bLocalBacnetDevice = (BLocalBacnetDevice)bComplex;
                break;
            }
            bComplex = bComplex.getParent();
        }
        if (bBacnetExportTable == null || bLocalBacnetDevice == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under LocalBacnetDevice Export Table");
            return;
        }
        if (bLocalBacnetDevice.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("LocalDevice fault: " + bLocalBacnetDevice.getFaultCause());
            return;
        }
        bBacnetNetwork = (BBacnetNetwork)bLocalBacnetDevice.getParent();
        if (bBacnetNetwork == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under BacnetNetwork");
            return;
        }
        if (bBacnetNetwork.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("Network fault: " + bBacnetNetwork.getFaultCause());
            return;
        }
        Feature feature = bBacnetNetwork.getLicenseFeature();
        boolean bl = feature.getb("export", false);
        if (!bl) {
            this.fatalFault = true;
            this.setFaultCause("Server capability not licensed");
            return;
        }
        this.setFaultCause("");
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetFileDescriptor", 2);
        spyWriter.prop((Object)"fatalFault", this.fatalFault);
        spyWriter.prop((Object)"file", (Object)this.file);
        spyWriter.prop((Object)"eof", this.eof);
        spyWriter.prop((Object)"subscriber", (Object)this.subscriber);
        spyWriter.prop((Object)"oldId", (Object)this.oldId);
        spyWriter.prop((Object)"oldName", (Object)this.oldName);
        spyWriter.prop((Object)"duplicate", this.duplicate);
        spyWriter.endProps();
    }

    public BIcon getIcon() {
        return icon;
    }

    void d(String string) {
        System.out.println(string);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.fatalFault = false;
        this.eof = true;
        this.oldId = null;
        this.oldName = null;
        this.duplicate = false;
    }

    public BBacnetFileDescriptor() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$bacnet$export$BBacnetFileDescriptor;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$export$BBacnetFileDescriptor = BBacnetFileDescriptor.class("[Ljavax.baja.bacnet.export.BBacnetFileDescriptor;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((BIcon)BIcon.std((String)"file.png"), (BIcon)BIcon.std((String)"badges/export.png"));
        log = Log.getLog((String)"bacnet.server");
        REQUIRED_PROPS = new int[]{75, 77, 79, 43, 42, 71, 13, 99, 41};
        OPTIONAL_PROPS = new int[]{28};
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class FileSubscriber
    extends Subscriber {
        private BBacnetFileDescriptor obj;

        public void event(BComponentEvent bComponentEvent) {
            try {
                if (bComponentEvent.getId() == 3 && bComponentEvent.getSlotName().equals(this.obj.getObjectName())) {
                    this.obj.setObjectOrd(((BISpaceNode)this.obj.getObject()).getOrdInSpace(), null);
                    this.obj.checkConfiguration();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("obj=" + (Object)((Object)this.obj.getObjectId()));
            }
        }

        public FileSubscriber(BBacnetFileDescriptor bBacnetFileDescriptor2) {
            this.obj = bBacnetFileDescriptor2;
        }
    }
}

