/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.stack.server.BBacnetExportFolder;
import com.tridium.bacnet.stack.server.BBacnetExportTable;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.enums.BBacnetNotifyType;
import javax.baja.bacnet.export.BBacnetNotificationClassDescriptor;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.license.Feature;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BBacnetEventSource
extends BComponent
implements BIBacnetExportObject {
    public static final Property status = BBacnetEventSource.newProperty((int)67, (BValue)BStatus.ok, null);
    public static final Property faultCause = BBacnetEventSource.newProperty((int)3, (String)"", null);
    public static final Type TYPE;
    private boolean fatalFault;
    static /* synthetic */ Class class$javax$baja$bacnet$export$BBacnetEventSource;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.checkFatalFault();
    }

    void checkValid() {
    }

    protected BBacnetExportFolder getSvo() {
        BBacnetEventSource bBacnetEventSource = this;
        while (bBacnetEventSource != null) {
            if (bBacnetEventSource instanceof BBacnetExportFolder) {
                return (BBacnetExportFolder)((Object)bBacnetEventSource);
            }
            bBacnetEventSource = bBacnetEventSource.getParent();
        }
        return null;
    }

    public abstract boolean isValidAlarmExt(BIAlarmSource var1);

    public abstract boolean isEventInitiationEnabled();

    public abstract BBacnetObjectIdentifier getObjectId();

    public abstract BEnum getEventState();

    public abstract BBacnetBitString getAckedTransitions();

    public abstract BBacnetTimeStamp[] getEventTimeStamps();

    public abstract BBacnetNotifyType getNotifyType();

    public abstract BBacnetBitString getEventEnable();

    public abstract int[] getEventPriorities();

    public abstract BBacnetNotificationClassDescriptor getNotificationClass();

    public abstract BEnum getEventType();

    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    private final void checkFatalFault() {
        BBacnetExportTable bBacnetExportTable = null;
        BLocalBacnetDevice bLocalBacnetDevice = null;
        BBacnetNetwork bBacnetNetwork = null;
        if (this.fatalFault) {
            return;
        }
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BBacnetExportTable) {
                bBacnetExportTable = (BBacnetExportTable)bComplex;
            } else if (bComplex instanceof BLocalBacnetDevice) {
                bLocalBacnetDevice = (BLocalBacnetDevice)bComplex;
                break;
            }
            bComplex = bComplex.getParent();
        }
        if (bBacnetExportTable == null || bLocalBacnetDevice == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under LocalBacnetDevice Export Table");
            return;
        }
        if (bLocalBacnetDevice.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("LocalDevice fault: " + bLocalBacnetDevice.getFaultCause());
            return;
        }
        bBacnetNetwork = (BBacnetNetwork)bLocalBacnetDevice.getParent();
        if (bBacnetNetwork == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under BacnetNetwork");
            return;
        }
        if (bBacnetNetwork.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("Network fault: " + bBacnetNetwork.getFaultCause());
            return;
        }
        Feature feature = bBacnetNetwork.getLicenseFeature();
        boolean bl = feature.getb("export", false);
        if (!bl) {
            this.fatalFault = true;
            this.setFaultCause("Server capability not licensed");
            return;
        }
        this.setFaultCause("");
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetEventSource", 2);
        spyWriter.prop((Object)"fatalFault", this.fatalFault);
        spyWriter.endProps();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.fatalFault = false;
    }

    public BBacnetEventSource() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$bacnet$export$BBacnetEventSource;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$export$BBacnetEventSource = BBacnetEventSource.class("[Ljavax.baja.bacnet.export.BBacnetEventSource;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

