/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BBacnetBinaryPointDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.enums.BPriorityLevel;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BBacnetBinaryWritableDescriptor
extends BBacnetBinaryPointDescriptor {
    public static final Property bacnetWritable = BBacnetBinaryWritableDescriptor.newProperty((int)5, (String)lexNotWritable, null);
    public static final Type TYPE;
    static /* synthetic */ Class class$javax$baja$bacnet$export$BBacnetBinaryWritableDescriptor;
    static /* synthetic */ Class class$javax$baja$status$BStatusBoolean;

    public String getBacnetWritable() {
        return this.getString(bacnetWritable);
    }

    public void setBacnetWritable(String string) {
        this.setString(bacnetWritable, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected final boolean isPointTypeLegal(BControlPoint bControlPoint) {
        return bControlPoint instanceof BBooleanWritable;
    }

    protected boolean isCommandable() {
        return true;
    }

    protected boolean commandabilityRequired() {
        return true;
    }

    protected PropertyValue readProperty(int n, int n2) {
        BBooleanWritable bBooleanWritable = (BBooleanWritable)this.getPoint();
        if (bBooleanWritable == null) {
            return new NReadPropertyResult(n, n2, new NErrorType(1, 1000));
        }
        switch (n) {
            case 87: {
                return this.readPriorityArray(n2);
            }
            case 104: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(bBooleanWritable.getFallback().getValue()));
            }
        }
        return super.readProperty(n, n2);
    }

    protected ErrorType writeProperty(int n, int n2, byte[] byArray, int n3) throws BacnetException {
        BBooleanWritable bBooleanWritable = (BBooleanWritable)this.getPoint();
        if (bBooleanWritable == null) {
            return new NErrorType(1, 1000);
        }
        if (n2 >= 0 && !this.isArray(n)) {
            return new NErrorType(2, 50);
        }
        try {
            switch (n) {
                case 85: {
                    return this.writePriorityArray(n3, byArray);
                }
                case 87: {
                    return new NErrorType(2, 40);
                }
                case 104: {
                    BStatusBoolean bStatusBoolean = bBooleanWritable.getFallback();
                    bStatusBoolean.setBoolean(BStatusBoolean.value, AsnUtil.fromOnlyBinaryPv(byArray), BLocalBacnetDevice.getBacnetContext());
                    bStatusBoolean.setStatusNull(false);
                    return null;
                }
            }
        }
        catch (OutOfRangeException outOfRangeException) {
            log.message("OutOfRangeException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)outOfRangeException));
            return new NErrorType(2, 37);
        }
        catch (AsnException asnException) {
            log.message("AsnException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)asnException));
            return new NErrorType(2, 9);
        }
        catch (PermissionException permissionException) {
            log.message("PermissionException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)permissionException));
            return new NErrorType(2, 40);
        }
        return super.writeProperty(n, n2, byArray, n3);
    }

    protected void addRequiredProps(Vector vector) {
        super.addRequiredProps(vector);
        if (this.commandabilityRequired()) {
            vector.add(BBacnetPropertyIdentifier.priorityArray);
            vector.add(BBacnetPropertyIdentifier.relinquishDefault);
        }
    }

    protected void addOptionalProps(Vector vector) {
        super.addOptionalProps(vector);
        vector.add(BBacnetPropertyIdentifier.minimumOffTime);
        vector.add(BBacnetPropertyIdentifier.minimumOnTime);
        if (!this.commandabilityRequired()) {
            vector.add(BBacnetPropertyIdentifier.priorityArray);
            vector.add(BBacnetPropertyIdentifier.relinquishDefault);
        }
    }

    protected PropertyValue readOptionalProperty(int n, int n2) {
        BBooleanWritable bBooleanWritable = (BBooleanWritable)this.getPoint();
        switch (n) {
            case 66: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(bBooleanWritable.getMinInactiveTime().getMillis() / 1000L));
            }
            case 67: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(bBooleanWritable.getMinActiveTime().getMillis() / 1000L));
            }
        }
        return super.readOptionalProperty(n, n2);
    }

    protected ErrorType writeOptionalProperty(int n, int n2, byte[] byArray, int n3) throws BacnetException {
        try {
            BBooleanWritable bBooleanWritable = (BBooleanWritable)this.getPoint();
            switch (n) {
                case 66: {
                    bBooleanWritable.set(BBooleanWritable.minInactiveTime, (BValue)BRelTime.make((long)(1000L * AsnUtil.fromAsnUnsignedInteger(byArray))), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
                case 67: {
                    bBooleanWritable.set(BBooleanWritable.minActiveTime, (BValue)BRelTime.make((long)(1000L * AsnUtil.fromAsnUnsignedInteger(byArray))), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
            }
            return super.writeOptionalProperty(n, n2, byArray, n3);
        }
        catch (AsnException asnException) {
            log.message("AsnException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)asnException));
            return new NErrorType(2, 9);
        }
        catch (PermissionException permissionException) {
            log.message("PermissionException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)permissionException));
            return new NErrorType(2, 40);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final PropertyValue readPriorityArray(int n) {
        BBooleanWritable bBooleanWritable = (BBooleanWritable)this.getPoint();
        if (bBooleanWritable == null) {
            return new NReadPropertyResult(87, n, new NErrorType(1, 1000));
        }
        if (n == -1) {
            AsnOutputStream asnOutputStream = asnOut;
            synchronized (asnOutputStream) {
                asnOut.reset();
                int n2 = 1;
                while (true) {
                    if (n2 > 16) {
                        return new NReadPropertyResult(87, n, asnOut.toByteArray());
                    }
                    BStatusBoolean bStatusBoolean = bBooleanWritable.getLevel(BPriorityLevel.make((int)n2));
                    if (bStatusBoolean.getStatus().isNull()) {
                        asnOut.writeNull();
                    } else {
                        asnOut.writeEnumerated(bStatusBoolean.getValue() ? 1 : 0);
                    }
                    ++n2;
                }
            }
        }
        if (n == 0) {
            return new NReadPropertyResult(87, n, AsnUtil.toAsnUnsigned(16L));
        }
        try {
            BStatusBoolean bStatusBoolean = bBooleanWritable.getLevel(BPriorityLevel.make((int)n));
            if (bStatusBoolean.getStatus().isNull()) {
                return new NReadPropertyResult(87, n, AsnUtil.toAsnNull());
            }
            return new NReadPropertyResult(87, n, AsnUtil.toAsnEnumerated(bStatusBoolean.getValue() ? 1 : 0));
        }
        catch (Exception exception) {
            return new NReadPropertyResult(87, n, new NErrorType(2, 42));
        }
    }

    /*
     * Exception decompiling
     */
    private final ErrorType writePriorityArray(int var1_1, byte[] var2_2) throws BacnetException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 128->227)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void resetBacnetWritable() {
        StringBuffer stringBuffer = new StringBuffer();
        Knob[] knobArray = this.getKnobs();
        int n = 0;
        while (n < knobArray.length) {
            BObject bObject = knobArray[n].getTargetOrd().get((BObject)this);
            BControlPoint bControlPoint = this.getPoint();
            if (knobArray[n].getTargetSlotName().startsWith("in") && bObject == bControlPoint) {
                stringBuffer.append(knobArray[n].getTargetSlotName()).append(',');
            }
            ++n;
        }
        this.setBacnetWritable(stringBuffer.length() > 0 ? stringBuffer.toString().substring(0, stringBuffer.length() - 1) : lexNotWritable);
    }

    public void knobAdded(Knob knob, Context context) {
        this.resetBacnetWritable();
    }

    public void knobRemoved(Knob knob, Context context) {
        this.resetBacnetWritable();
    }

    public final void doMakeWritable(BValue bValue) {
        if (!this.isRunning()) {
            return;
        }
        BBooleanWritable bBooleanWritable = (BBooleanWritable)this.getPoint();
        if (bBooleanWritable == null) {
            return;
        }
        BLink[] bLinkArray = bBooleanWritable.getLinks();
        int n = 0;
        while (n < bLinkArray.length) {
            if (bLinkArray[n].isActive()) {
                if (bLinkArray[n].getSourceComponent() == this && bLinkArray[n].getTargetSlot().getName().startsWith("in")) {
                    bBooleanWritable.remove((BComplex)bLinkArray[n]);
                }
            } else {
                bBooleanWritable.remove((BComplex)bLinkArray[n]);
            }
            ++n;
        }
        Class clazz = class$javax$baja$status$BStatusBoolean;
        if (clazz == null) {
            clazz = class$javax$baja$status$BStatusBoolean = BBacnetBinaryWritableDescriptor.class("[Ljavax.baja.status.BStatusBoolean;", false);
        }
        BStatusBoolean[] bStatusBooleanArray = (BStatusBoolean[])this.getChildren(clazz);
        int n2 = 0;
        while (n2 < bStatusBooleanArray.length) {
            if (bStatusBooleanArray[n2].getName().startsWith("bacnetValueIn")) {
                this.remove((BComplex)bStatusBooleanArray[n2]);
            }
            ++n2;
        }
        String string = ((BString)bValue).getString();
        if (string.equals(lexNotWritable)) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            Slot slot = bBooleanWritable.getSlot(string2);
            String string3 = "bacnetValue" + TextUtil.capitalize((String)string2);
            BStatusBoolean bStatusBoolean = new BStatusBoolean();
            bStatusBoolean.setStatusNull(true);
            this.add(string3, (BValue)bStatusBoolean, 257);
            bBooleanWritable.setFlags(slot, bBooleanWritable.getFlags(slot) | 0x400);
            BLink bLink = new BLink(this.getHandleOrd(), string3, string2, true);
            bBooleanWritable.add("bacnet" + string2, (BValue)bLink, 1);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$bacnet$export$BBacnetBinaryWritableDescriptor;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$export$BBacnetBinaryWritableDescriptor = BBacnetBinaryWritableDescriptor.class("[Ljavax.baja.bacnet.export.BBacnetBinaryWritableDescriptor;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

