/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import java.util.Vector;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetCovSubscription;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.export.BBacnetPointDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BDiscreteTotalizerExt;
import javax.baja.data.BIDataValue;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BBacnetBinaryPointDescriptor
extends BBacnetPointDescriptor {
    public static final Type TYPE;
    private static final BIcon icon;
    static /* synthetic */ Class class$javax$baja$bacnet$export$BBacnetBinaryPointDescriptor;
    static /* synthetic */ Class class$javax$baja$control$ext$BDiscreteTotalizerExt;

    public Type getType() {
        return TYPE;
    }

    protected boolean isPointTypeLegal(BControlPoint bControlPoint) {
        return bControlPoint instanceof BBooleanPoint;
    }

    protected PropertyValue readOptionalProperty(int n, int n2) {
        BDiscreteTotalizerExt bDiscreteTotalizerExt = this.getTotalizerExt();
        if (bDiscreteTotalizerExt != null) {
            switch (n) {
                case 16: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toBacnetDateTime(bDiscreteTotalizerExt.getChangeOfStateTime()));
                }
                case 15: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(bDiscreteTotalizerExt.getChangeOfStateCount()));
                }
                case 115: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toBacnetDateTime(bDiscreteTotalizerExt.getTimeOfStateCountReset()));
                }
                case 33: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(bDiscreteTotalizerExt.getElapsedActiveTime().getSeconds()));
                }
                case 114: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toBacnetDateTime(bDiscreteTotalizerExt.getTimeOfActiveTimeReset()));
                }
            }
        }
        BBooleanPoint bBooleanPoint = (BBooleanPoint)this.getPoint();
        switch (n) {
            case 4: {
                BString bString = (BString)bBooleanPoint.getFacets().getFacet("trueText");
                if (bString != null) {
                    String string = BFormat.format((String)bString.toString(), null, null);
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnCharacterString(string));
                }
            }
            case 46: {
                BString bString = (BString)bBooleanPoint.getFacets().getFacet("falseText");
                if (bString == null) break;
                String string = BFormat.format((String)bString.toString(), null, null);
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnCharacterString(string));
            }
        }
        return super.readOptionalProperty(n, n2);
    }

    protected ErrorType writeOptionalProperty(int n, int n2, byte[] byArray, int n3) throws BacnetException {
        BDiscreteTotalizerExt bDiscreteTotalizerExt = this.getTotalizerExt();
        try {
            if (bDiscreteTotalizerExt != null) {
                switch (n) {
                    case 16: {
                        return new NErrorType(2, 40);
                    }
                    case 15: {
                        if (AsnUtil.fromAsnUnsignedInteger(byArray) != 0L) {
                            return new NErrorType(2, 37);
                        }
                        bDiscreteTotalizerExt.invoke(BDiscreteTotalizerExt.resetChangeOfStateCount, null, BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 115: {
                        return new NErrorType(2, 40);
                    }
                    case 33: {
                        if (AsnUtil.fromAsnUnsignedInteger(byArray) != 0L) {
                            return new NErrorType(2, 37);
                        }
                        bDiscreteTotalizerExt.invoke(BDiscreteTotalizerExt.resetElapsedActiveTime, null, BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 114: {
                        return new NErrorType(2, 40);
                    }
                }
            }
            BBooleanPoint bBooleanPoint = (BBooleanPoint)this.getPoint();
            switch (n) {
                case 4: {
                    BString bString = (BString)bBooleanPoint.getFacets().getFacet("trueText");
                    if (bString != null) {
                        bBooleanPoint.set(BControlPoint.facets, (BValue)BFacets.make((BFacets)bBooleanPoint.getFacets(), (String)"trueText", (BIDataValue)BString.make((String)AsnUtil.fromAsnCharacterString(byArray))), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                }
                case 46: {
                    BString bString = (BString)bBooleanPoint.getFacets().getFacet("falseText");
                    if (bString == null) break;
                    bBooleanPoint.set(BControlPoint.facets, (BValue)BFacets.make((BFacets)bBooleanPoint.getFacets(), (String)"falseText", (BIDataValue)BString.make((String)AsnUtil.fromAsnCharacterString(byArray))), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
            }
            return super.writeOptionalProperty(n, n2, byArray, n3);
        }
        catch (AsnException asnException) {
            log.message("AsnException writing property " + n + " in object " + (Object)((Object)this.getObjectId()));
            return new NErrorType(2, 9);
        }
        catch (PermissionException permissionException) {
            log.message("PermissionException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)permissionException));
            return new NErrorType(2, 40);
        }
    }

    protected void addRequiredProps(Vector vector) {
        super.addRequiredProps(vector);
        vector.add(BBacnetPropertyIdentifier.presentValue);
        vector.add(BBacnetPropertyIdentifier.statusFlags);
        vector.add(BBacnetPropertyIdentifier.eventState);
        vector.add(BBacnetPropertyIdentifier.outOfService);
    }

    protected void addOptionalProps(Vector vector) {
        BDiscreteTotalizerExt bDiscreteTotalizerExt;
        BString bString;
        super.addOptionalProps(vector);
        BControlPoint bControlPoint = this.getPoint();
        BString bString2 = (BString)bControlPoint.getFacets().getFacet("trueText");
        if (bString2 != null) {
            vector.add(BBacnetPropertyIdentifier.activeText);
        }
        if ((bString = (BString)bControlPoint.getFacets().getFacet("falseText")) != null) {
            vector.add(BBacnetPropertyIdentifier.inactiveText);
        }
        if ((bDiscreteTotalizerExt = this.getTotalizerExt()) != null) {
            vector.add(BBacnetPropertyIdentifier.changeOfStateTime);
            vector.add(BBacnetPropertyIdentifier.changeOfStateCount);
            vector.add(BBacnetPropertyIdentifier.timeOfStateCountReset);
            vector.add(BBacnetPropertyIdentifier.elapsedActiveTime);
            vector.add(BBacnetPropertyIdentifier.timeOfActiveTimeReset);
        }
    }

    protected void validate() {
        BStatusBoolean bStatusBoolean = ((BBooleanPoint)this.getPoint()).getOut();
        BStatus bStatus = bStatusBoolean.getStatus();
        if (bStatus.isNull()) {
            this.setReliability((BEnum)BBacnetReliability.unreliableOther);
            this.setFaultCause("Invalid value for BACnet Object:" + bStatusBoolean);
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        } else if (bStatus.isFault()) {
            this.setReliability((BEnum)BBacnetReliability.unreliableOther);
        } else if (bStatus.isDown()) {
            this.setReliability((BEnum)BBacnetReliability.communicationFailure);
        } else {
            this.setReliability((BEnum)BBacnetReliability.noFaultDetected);
            if (this.configOk()) {
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
                this.setFaultCause("");
            } else {
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
                this.setFaultCause(lex.getText("export.configurationFault"));
            }
        }
    }

    BStatusValue getCurrentStatusValue() {
        BStatusBoolean bStatusBoolean = new BStatusBoolean(((BBooleanPoint)this.getPoint()).getOut().getValue());
        bStatusBoolean.setStatus(this.getStatusFlags());
        return bStatusBoolean;
    }

    boolean checkCov(BStatusValue bStatusValue, BStatusValue bStatusValue2) {
        if (bStatusValue.getStatus().getBits() != bStatusValue2.getStatus().getBits()) {
            return true;
        }
        return ((BStatusBoolean)bStatusValue).getBoolean() ^ ((BStatusBoolean)bStatusValue2).getBoolean();
    }

    boolean checkCov(BControlPoint bControlPoint, BBacnetCovSubscription bBacnetCovSubscription) {
        if (bControlPoint.getStatus().getBits() != bBacnetCovSubscription.getLastValue().getStatus().getBits()) {
            return true;
        }
        boolean bl = ((BBooleanPoint)bControlPoint).getBoolean();
        boolean bl2 = ((BIBoolean)bBacnetCovSubscription.getLastValue()).getBoolean();
        return bl ^ bl2;
    }

    private final BDiscreteTotalizerExt getTotalizerExt() {
        BControlPoint bControlPoint = this.getPoint();
        if (bControlPoint == null) {
            return null;
        }
        SlotCursor slotCursor = bControlPoint.getProperties();
        Class clazz = class$javax$baja$control$ext$BDiscreteTotalizerExt;
        if (clazz == null) {
            clazz = class$javax$baja$control$ext$BDiscreteTotalizerExt = BBacnetBinaryPointDescriptor.class("[Ljavax.baja.control.ext.BDiscreteTotalizerExt;", false);
        }
        if (slotCursor.next(clazz)) {
            return (BDiscreteTotalizerExt)slotCursor.get();
        }
        return null;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$bacnet$export$BBacnetBinaryPointDescriptor;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$export$BBacnetBinaryPointDescriptor = BBacnetBinaryPointDescriptor.class("[Ljavax.baja.bacnet.export.BBacnetBinaryPointDescriptor;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((BIcon)BIcon.std((String)"control/booleanPoint.png"), (BIcon)BIcon.std((String)"badges/export.png"));
    }
}

