/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import java.util.Vector;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.offnormal.BOutOfRangeAlgorithm;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetCovSubscription;
import javax.baja.bacnet.enums.BBacnetEngineeringUnits;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.export.BBacnetPointDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIcon;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BBacnetAnalogPointDescriptor
extends BBacnetPointDescriptor {
    public static final Property covIncrement = BBacnetAnalogPointDescriptor.newProperty((int)0, (float)1.0f, null);
    public static final Type TYPE;
    private static final BIcon icon;
    static /* synthetic */ Class class$javax$baja$bacnet$export$BBacnetAnalogPointDescriptor;

    public float getCovIncrement() {
        return this.getFloat(covIncrement);
    }

    public void setCovIncrement(float f) {
        this.setFloat(covIncrement, f, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected boolean isPointTypeLegal(BControlPoint bControlPoint) {
        return bControlPoint instanceof BNumericPoint;
    }

    public BEnum getEventType() {
        return BBacnetEventType.outOfRange;
    }

    public boolean isValidAlarmExt(BIAlarmSource bIAlarmSource) {
        if (bIAlarmSource instanceof BAlarmSourceExt) {
            return ((BAlarmSourceExt)bIAlarmSource).getOffnormalAlgorithm() instanceof BOutOfRangeAlgorithm;
        }
        return false;
    }

    protected PropertyValue readProperty(int n, int n2) {
        BNumericPoint bNumericPoint = (BNumericPoint)this.getPoint();
        if (bNumericPoint == null) {
            return new NReadPropertyResult(n, n2, new NErrorType(1, 1000));
        }
        if (n2 >= 0 && !this.isArray(n)) {
            return new NReadPropertyResult(n, n2, new NErrorType(2, 50));
        }
        switch (n) {
            case 85: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnReal(bNumericPoint.getOut().getValue()));
            }
            case 117: {
                BUnit bUnit = (BUnit)bNumericPoint.getFacets().getFacet("units");
                if (bUnit != null) {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated((BEnum)BBacnetEngineeringUnits.make(bUnit)));
                }
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(95));
            }
            case 22: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnReal(this.getCovIncrement()));
            }
        }
        return super.readProperty(n, n2);
    }

    protected ErrorType writeProperty(int n, int n2, byte[] byArray, int n3) throws BacnetException {
        BNumericPoint bNumericPoint = (BNumericPoint)this.getPoint();
        if (bNumericPoint == null) {
            return new NErrorType(1, 1000);
        }
        if (n2 >= 0 && !this.isArray(n)) {
            return new NErrorType(2, 50);
        }
        try {
            switch (n) {
                case 117: {
                    return new NErrorType(2, 40);
                }
                case 22: {
                    BNumber bNumber = (BNumber)this.getPoint().getFacets().getFacet("min");
                    BNumber bNumber2 = (BNumber)this.getPoint().getFacets().getFacet("max");
                    double d = bNumber != null ? bNumber.getDouble() : Double.NEGATIVE_INFINITY;
                    double d2 = bNumber2 != null ? bNumber2.getDouble() : Double.POSITIVE_INFINITY;
                    float f = AsnUtil.fromAsnReal(byArray);
                    if ((double)f < 0.0 || (double)f > d2 - d) {
                        return new NErrorType(2, 37);
                    }
                    this.setFloat(covIncrement, f, BLocalBacnetDevice.getBacnetContext());
                    this.checkCov();
                    return null;
                }
            }
            return super.writeProperty(n, n2, byArray, n3);
        }
        catch (AsnException asnException) {
            log.message("AsnException writing property " + n + " in object " + (Object)((Object)this.getObjectId()));
            return new NErrorType(2, 9);
        }
        catch (PermissionException permissionException) {
            log.message("PermissionException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)permissionException));
            return new NErrorType(2, 40);
        }
    }

    protected void addRequiredProps(Vector vector) {
        super.addRequiredProps(vector);
        vector.add(BBacnetPropertyIdentifier.presentValue);
        vector.add(BBacnetPropertyIdentifier.statusFlags);
        vector.add(BBacnetPropertyIdentifier.eventState);
        vector.add(BBacnetPropertyIdentifier.outOfService);
        vector.add(BBacnetPropertyIdentifier.units);
    }

    protected void addOptionalProps(Vector vector) {
        super.addOptionalProps(vector);
        BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
        if (bAlarmSourceExt != null) {
            vector.add(BBacnetPropertyIdentifier.highLimit);
            vector.add(BBacnetPropertyIdentifier.lowLimit);
            vector.add(BBacnetPropertyIdentifier.deadband);
            vector.add(BBacnetPropertyIdentifier.limitEnable);
        }
        vector.add(BBacnetPropertyIdentifier.covIncrement);
    }

    protected PropertyValue readOptionalProperty(int n, int n2) {
        BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
        if (bAlarmSourceExt != null) {
            BOutOfRangeAlgorithm bOutOfRangeAlgorithm = (BOutOfRangeAlgorithm)bAlarmSourceExt.getOffnormalAlgorithm();
            switch (n) {
                case 45: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnReal(bOutOfRangeAlgorithm.getHighLimit()));
                }
                case 59: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnReal(bOutOfRangeAlgorithm.getLowLimit()));
                }
                case 25: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnReal(bOutOfRangeAlgorithm.getDeadband()));
                }
                case 52: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnBitString(BacnetBitStringUtil.getBacnetLimitEnable(bOutOfRangeAlgorithm.getLimitEnable())));
                }
            }
        }
        return super.readOptionalProperty(n, n2);
    }

    protected ErrorType writeOptionalProperty(int n, int n2, byte[] byArray, int n3) throws BacnetException {
        BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
        try {
            if (bAlarmSourceExt != null) {
                BOutOfRangeAlgorithm bOutOfRangeAlgorithm = (BOutOfRangeAlgorithm)bAlarmSourceExt.getOffnormalAlgorithm();
                BNumber bNumber = (BNumber)this.getPoint().getFacets().getFacet("min");
                BNumber bNumber2 = (BNumber)this.getPoint().getFacets().getFacet("max");
                double d = bNumber != null ? bNumber.getDouble() : Double.NEGATIVE_INFINITY;
                double d2 = bNumber2 != null ? bNumber2.getDouble() : Double.POSITIVE_INFINITY;
                switch (n) {
                    case 45: {
                        double d3 = AsnUtil.fromAsnReal(byArray);
                        if (d3 < d || d3 > d2) {
                            return new NErrorType(2, 37);
                        }
                        bOutOfRangeAlgorithm.setDouble(BOutOfRangeAlgorithm.highLimit, (double)AsnUtil.fromAsnReal(byArray), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 59: {
                        double d4 = AsnUtil.fromAsnReal(byArray);
                        if (d4 < d || d4 > d2) {
                            return new NErrorType(2, 37);
                        }
                        bOutOfRangeAlgorithm.setDouble(BOutOfRangeAlgorithm.lowLimit, (double)AsnUtil.fromAsnReal(byArray), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 25: {
                        double d5 = AsnUtil.fromAsnReal(byArray);
                        double d6 = bOutOfRangeAlgorithm.getHighLimit();
                        double d7 = bOutOfRangeAlgorithm.getLowLimit();
                        if (d5 < 0.0 || d5 > d6 - d7) {
                            return new NErrorType(2, 37);
                        }
                        bOutOfRangeAlgorithm.setDouble(BOutOfRangeAlgorithm.deadband, (double)AsnUtil.fromAsnReal(byArray), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 52: {
                        BBacnetBitString bBacnetBitString = AsnUtil.fromAsnBitString(byArray);
                        bOutOfRangeAlgorithm.set(BOutOfRangeAlgorithm.limitEnable, (BValue)BacnetBitStringUtil.getBLimitEnable(bBacnetBitString), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                }
            }
            return super.writeOptionalProperty(n, n2, byArray, n3);
        }
        catch (AsnException asnException) {
            log.message("AsnException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)asnException));
            return new NErrorType(2, 9);
        }
        catch (PermissionException permissionException) {
            log.message("PermissionException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)permissionException));
            return new NErrorType(2, 40);
        }
    }

    protected void validate() {
        BStatusNumeric bStatusNumeric = ((BNumericPoint)this.getPoint()).getOut();
        BStatus bStatus = bStatusNumeric.getStatus();
        if (bStatus.isNull()) {
            this.setReliability((BEnum)BBacnetReliability.unreliableOther);
            this.setFaultCause("Invalid value for BACnet Object:" + bStatusNumeric);
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        } else if (bStatus.isFault()) {
            this.setReliability((BEnum)BBacnetReliability.unreliableOther);
        } else if (bStatus.isDown()) {
            this.setReliability((BEnum)BBacnetReliability.communicationFailure);
        } else {
            this.setReliability((BEnum)BBacnetReliability.noFaultDetected);
            if (this.configOk()) {
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
                this.setFaultCause("");
            } else {
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
                this.setFaultCause(lex.getText("export.configurationFault"));
            }
        }
    }

    BStatusValue getCurrentStatusValue() {
        BStatusNumeric bStatusNumeric = new BStatusNumeric(((BNumericPoint)this.getPoint()).getOut().getValue());
        bStatusNumeric.setStatus(this.getStatusFlags());
        return bStatusNumeric;
    }

    boolean checkCov(BStatusValue bStatusValue, BStatusValue bStatusValue2) {
        if (bStatusValue.getStatus().getBits() != bStatusValue2.getStatus().getBits()) {
            return true;
        }
        double d = ((BStatusNumeric)bStatusValue).getNumeric();
        double d2 = ((BStatusNumeric)bStatusValue2).getNumeric();
        if (Double.isNaN(d)) {
            return Double.isNaN(d2) ^ true;
        }
        if (Double.isNaN(d2)) {
            return true;
        }
        boolean bl = false;
        if (Math.abs(((BStatusNumeric)bStatusValue).getNumeric() - ((BStatusNumeric)bStatusValue2).getNumeric()) >= (double)this.getCovIncrement()) {
            bl = true;
        }
        return bl;
    }

    boolean checkCov(BControlPoint bControlPoint, BBacnetCovSubscription bBacnetCovSubscription) {
        if (bControlPoint.getStatus().getBits() != bBacnetCovSubscription.getLastValue().getStatus().getBits()) {
            return true;
        }
        double d = ((BNumericPoint)bControlPoint).getNumeric();
        double d2 = ((BINumeric)bBacnetCovSubscription.getLastValue()).getNumeric();
        boolean bl = false;
        if (Math.abs(d - d2) >= (double)this.getCovIncrement()) {
            bl = true;
        }
        return bl;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$bacnet$export$BBacnetAnalogPointDescriptor;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$export$BBacnetAnalogPointDescriptor = BBacnetAnalogPointDescriptor.class("[Ljavax.baja.bacnet.export.BBacnetAnalogPointDescriptor;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((BIcon)BIcon.std((String)"control/numericPoint.png"), (BIcon)BIcon.std((String)"badges/export.png"));
    }
}

