/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.enums;

import javax.baja.bacnet.BacnetConst;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBacnetProgramError
extends BFrozenEnum
implements BacnetConst {
    public static final int NORMAL = 0;
    public static final int LOAD_FAILED = 1;
    public static final int INTERNAL = 2;
    public static final int PROGRAM = 3;
    public static final int OTHER = 4;
    public static final BBacnetProgramError normal = new BBacnetProgramError(0);
    public static final BBacnetProgramError loadFailed = new BBacnetProgramError(1);
    public static final BBacnetProgramError internal = new BBacnetProgramError(2);
    public static final BBacnetProgramError program = new BBacnetProgramError(3);
    public static final BBacnetProgramError other = new BBacnetProgramError(4);
    public static final Type TYPE;
    public static final int MAX_ASHRAE_ID = 4;
    public static final int MAX_RESERVED_ID = 63;
    public static final int MAX_ID = 65535;
    public static final BBacnetProgramError DEFAULT;
    static /* synthetic */ Class class$javax$baja$bacnet$enums$BBacnetProgramError;

    public final Type getType() {
        return TYPE;
    }

    public static final BBacnetProgramError make(int n) {
        return (BBacnetProgramError)normal.getRange().get(n);
    }

    public static final BBacnetProgramError make(String string) {
        return (BBacnetProgramError)normal.getRange().get(string);
    }

    public static final String tag(int n) {
        if (DEFAULT.getRange().isOrdinal(n)) {
            return DEFAULT.getRange().getTag(n);
        }
        if (BBacnetProgramError.isAshrae(n)) {
            return BacnetConst.ASHRAE_PREFIX + n;
        }
        if (BBacnetProgramError.isProprietary(n)) {
            return BacnetConst.PROPRIETARY_PREFIX + n;
        }
        throw new InvalidEnumException(n);
    }

    public static final int ordinal(String string) {
        try {
            return DEFAULT.getRange().tagToOrdinal(string);
        }
        catch (InvalidEnumException invalidEnumException) {
            if (string.startsWith(BacnetConst.ASHRAE_PREFIX)) {
                return Integer.parseInt(string.substring(BacnetConst.ASHRAE_PREFIX_LENGTH));
            }
            if (string.startsWith(BacnetConst.PROPRIETARY_PREFIX)) {
                return Integer.parseInt(string.substring(BacnetConst.PROPRIETARY_PREFIX_LENGTH));
            }
            throw invalidEnumException;
        }
    }

    public static final boolean isProprietary(int n) {
        boolean bl = false;
        if (n > 63 && n <= (char)-1) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isAshrae(int n) {
        boolean bl = false;
        if (n > 4 && n <= 63) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isValid(int n) {
        boolean bl = false;
        if (n <= (char)-1) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isFixed(int n) {
        boolean bl = false;
        if (n <= 4) {
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BBacnetProgramError(int n) {
        super(n);
    }

    static {
        Class clazz = class$javax$baja$bacnet$enums$BBacnetProgramError;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$enums$BBacnetProgramError = BBacnetProgramError.class("[Ljavax.baja.bacnet.enums.BBacnetProgramError;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        DEFAULT = normal;
    }
}

