/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.enums;

import javax.baja.bacnet.BacnetConst;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBacnetErrorClass
extends BFrozenEnum
implements BacnetConst {
    public static final int DEVICE = 0;
    public static final int OBJECT = 1;
    public static final int PROPERTY = 2;
    public static final int RESOURCES = 3;
    public static final int SECURITY = 4;
    public static final int SERVICES = 5;
    public static final int VT = 6;
    public static final int COMMUNICATION = 7;
    public static final BBacnetErrorClass device = new BBacnetErrorClass(0);
    public static final BBacnetErrorClass object = new BBacnetErrorClass(1);
    public static final BBacnetErrorClass property = new BBacnetErrorClass(2);
    public static final BBacnetErrorClass resources = new BBacnetErrorClass(3);
    public static final BBacnetErrorClass security = new BBacnetErrorClass(4);
    public static final BBacnetErrorClass services = new BBacnetErrorClass(5);
    public static final BBacnetErrorClass vt = new BBacnetErrorClass(6);
    public static final BBacnetErrorClass communication = new BBacnetErrorClass(7);
    public static final Type TYPE;
    public static final int MAX_ASHRAE_ID = 7;
    public static final int MAX_RESERVED_ID = 63;
    public static final int MAX_ID = 65535;
    public static final BBacnetErrorClass DEFAULT;
    static /* synthetic */ Class class$javax$baja$bacnet$enums$BBacnetErrorClass;

    public final Type getType() {
        return TYPE;
    }

    public static final BBacnetErrorClass make(int n) {
        return (BBacnetErrorClass)device.getRange().get(n, false);
    }

    public static final BBacnetErrorClass make(String string) {
        return (BBacnetErrorClass)device.getRange().get(string);
    }

    public static final String tag(int n) {
        if (DEFAULT.getRange().isOrdinal(n)) {
            return DEFAULT.getRange().getTag(n);
        }
        if (BBacnetErrorClass.isAshrae(n)) {
            return BacnetConst.ASHRAE_PREFIX + n;
        }
        if (BBacnetErrorClass.isProprietary(n)) {
            return BacnetConst.PROPRIETARY_PREFIX + n;
        }
        throw new InvalidEnumException(n);
    }

    public static final int ordinal(String string) {
        try {
            return DEFAULT.getRange().tagToOrdinal(string);
        }
        catch (InvalidEnumException invalidEnumException) {
            if (string.startsWith(BacnetConst.ASHRAE_PREFIX)) {
                return Integer.parseInt(string.substring(BacnetConst.ASHRAE_PREFIX_LENGTH));
            }
            if (string.startsWith(BacnetConst.PROPRIETARY_PREFIX)) {
                return Integer.parseInt(string.substring(BacnetConst.PROPRIETARY_PREFIX_LENGTH));
            }
            throw invalidEnumException;
        }
    }

    public static final boolean isProprietary(int n) {
        boolean bl = false;
        if (n > 63 && n <= (char)-1) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isAshrae(int n) {
        boolean bl = false;
        if (n > 7 && n <= 63) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isValid(int n) {
        boolean bl = false;
        if (n <= (char)-1) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isFixed(int n) {
        boolean bl = false;
        if (n <= 7) {
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BBacnetErrorClass(int n) {
        super(n);
    }

    static {
        Class clazz = class$javax$baja$bacnet$enums$BBacnetErrorClass;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$enums$BBacnetErrorClass = BBacnetErrorClass.class("[Ljavax.baja.bacnet.enums.BBacnetErrorClass;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        DEFAULT = device;
    }
}

