/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetDate;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.log.Log;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BStruct;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBacnetTimeStamp
extends BStruct
implements BIBacnetDataType {
    public static final Property choice = BBacnetTimeStamp.newProperty((int)4, (int)1, (BFacets)BFacets.makeInt((int)0, (int)2));
    public static final Property time = BBacnetTimeStamp.newProperty((int)0, (BValue)BBacnetTime.DEFAULT, null);
    public static final Property sequenceNumber = BBacnetTimeStamp.newProperty((int)0, (BValue)BBacnetUnsigned.DEFAULT, null);
    public static final Property dateTime = BBacnetTimeStamp.newProperty((int)0, (BValue)new BBacnetDateTime(), null);
    public static final Type TYPE;
    public static final int TIME_TAG = 0;
    public static final int SEQUENCE_NUMBER_TAG = 1;
    public static final int DATE_TIME_TAG = 2;
    public static final int MAX_SEQUENCE_NUMBER = 65535;
    private static final String[] FACET_TAGS;
    private static final String[] DEBUG_TAGS;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetTimeStamp;

    public final int getChoice() {
        return this.getInt(choice);
    }

    public final void setChoice(int n) {
        this.setInt(choice, n, null);
    }

    public final BBacnetTime getTime() {
        return (BBacnetTime)this.get(time);
    }

    public final void setTime(BBacnetTime bBacnetTime) {
        this.set(time, (BValue)bBacnetTime, null);
    }

    public final BBacnetUnsigned getSequenceNumber() {
        return (BBacnetUnsigned)this.get(sequenceNumber);
    }

    public final void setSequenceNumber(BBacnetUnsigned bBacnetUnsigned) {
        this.set(sequenceNumber, (BValue)bBacnetUnsigned, null);
    }

    public final BBacnetDateTime getDateTime() {
        return (BBacnetDateTime)this.get(dateTime);
    }

    public final void setDateTime(BBacnetDateTime bBacnetDateTime) {
        this.set(dateTime, (BValue)bBacnetDateTime, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final BValue getTimeStamp() {
        switch (this.getChoice()) {
            case 0: {
                return this.getTime();
            }
            case 1: {
                return this.getSequenceNumber();
            }
            case 2: {
                return this.getDateTime();
            }
        }
        throw new IllegalStateException();
    }

    public final void setTimeStamp(BValue bValue) {
        this.setTimeStamp(bValue, null);
    }

    public final void setTimeStamp(BValue bValue, Context context) {
        if (bValue.getType() == BBacnetTime.TYPE) {
            this.setInt(choice, 0, context);
            this.set(time, bValue, context);
        } else if (bValue.getType() == BBacnetUnsigned.TYPE) {
            this.setInt(choice, 1, context);
            this.set(sequenceNumber, bValue, context);
        } else if (bValue.getType() == BBacnetDateTime.TYPE) {
            this.setInt(choice, 2, context);
            this.set(dateTime, bValue, context);
        }
    }

    public final void writeAsn(AsnOutput asnOutput) {
        switch (this.getChoice()) {
            case 0: {
                asnOutput.writeTime(0, this.getTime());
                break;
            }
            case 1: {
                asnOutput.writeUnsigned(1, this.getSequenceNumber());
                break;
            }
            case 2: {
                asnOutput.writeOpeningTag(2);
                this.getDateTime().writeAsn(asnOutput);
                asnOutput.writeClosingTag(2);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid timestamp type:" + this.getChoice());
            }
        }
    }

    public final void readAsn(AsnInput asnInput) throws AsnException {
        int n = asnInput.peekTag();
        if (asnInput.isValueTag(0)) {
            this.setTimeStamp((BValue)asnInput.readTime(0), BacnetConst.noWrite);
        } else if (asnInput.isValueTag(1)) {
            this.setTimeStamp((BValue)asnInput.readUnsigned(1), BacnetConst.noWrite);
        } else if (asnInput.isOpeningTag(2)) {
            asnInput.skipTag();
            this.getDateTime().readAsn(asnInput);
            this.setInt(choice, 2, BacnetConst.noWrite);
            asnInput.skipTag();
        } else {
            throw new AsnException("Invalid tag: " + n);
        }
    }

    public final String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(BBacnetTimeStamp.tag(this.getChoice(), context));
        stringBuffer.append(this.getTimeStamp().toString(context));
        return stringBuffer.toString();
    }

    public final String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(BBacnetTimeStamp.tag(this.getChoice(), BacnetConst.debugContext));
        stringBuffer.append(this.getTime().toString()).append(";").append(this.getSequenceNumber().toString()).append(";").append(this.getDateTime().toString());
        return stringBuffer.toString();
    }

    public static final BBacnetTimeStamp fromText(String string) {
        if (string.startsWith(FACET_TAGS[0])) {
            return new BBacnetTimeStamp(BBacnetTime.fromString(string.substring(FACET_TAGS[0].length())));
        }
        if (string.startsWith(FACET_TAGS[1])) {
            return new BBacnetTimeStamp(BBacnetUnsigned.make(Long.parseLong(string.substring(FACET_TAGS[1].length()))));
        }
        if (string.startsWith(FACET_TAGS[2])) {
            return new BBacnetTimeStamp(BBacnetDateTime.fromString(string.substring(FACET_TAGS[2].length())));
        }
        throw new IllegalArgumentException(string);
    }

    private static final String tag(int n, Context context) {
        if (context == null) {
            return "";
        }
        if (context.equals(BacnetConst.facetsContext)) {
            return FACET_TAGS[n];
        }
        return DEBUG_TAGS[n];
    }

    public final BAbsTime toBAbsTime() {
        switch (this.getChoice()) {
            case 0: {
                Log.getLog((String)"bacnet").trace("converting BBacnetTime > BAbsTime using Niagara date");
                return BAbsTime.make((BAbsTime)BAbsTime.now(), (BTime)this.getTime().toBTime());
            }
            case 1: {
                Log.getLog((String)"bacnet").trace("using Niagara time to replace Sequence Number Timestamp!");
                return BAbsTime.now();
            }
            case 2: {
                BBacnetDate bBacnetDate = this.getDateTime().getDate();
                BBacnetTime bBacnetTime = this.getDateTime().getTime();
                return BAbsTime.make((int)bBacnetDate.getYear(), (BMonth)bBacnetDate.getBMonth(), (int)bBacnetDate.getDayOfMonth(), (int)bBacnetTime.getHour(), (int)bBacnetTime.getMinute(), (int)bBacnetTime.getSecond(), (int)(bBacnetTime.getHundredth() * 10));
            }
        }
        return BAbsTime.make();
    }

    public final void fromBAbsTime(BAbsTime bAbsTime) {
        this.fromBAbsTime(bAbsTime, 2);
    }

    public final void fromBAbsTime(BAbsTime bAbsTime, int n) {
        this.setChoice(n);
        switch (n) {
            case 0: {
                this.setChoice(0);
                this.setTime(BBacnetTime.make(bAbsTime));
                break;
            }
            case 1: {
                throw new IllegalArgumentException("Cannot convert BAbsTime to Bacnet Sequence Number!");
            }
            case 2: {
                this.setChoice(2);
                this.setDateTime(new BBacnetDateTime(bAbsTime));
                break;
            }
        }
    }

    public static final void encodeTimeStamp(BAbsTime bAbsTime, AsnOutput asnOutput) {
        asnOutput.writeOpeningTag(2);
        asnOutput.writeDate(bAbsTime);
        asnOutput.writeTime(bAbsTime);
        asnOutput.writeClosingTag(2);
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        int n = this.getChoice();
        dataOutput.writeInt(n);
        switch (n) {
            case 0: {
                this.getTime().encode(dataOutput);
                break;
            }
            case 1: {
                this.getSequenceNumber().encode(dataOutput);
                break;
            }
            case 2: {
                this.getDateTime().getDate().encode(dataOutput);
                this.getDateTime().getTime().encode(dataOutput);
                break;
            }
        }
    }

    public final void decode(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        this.setChoice(n);
        switch (n) {
            case 0: {
                this.setTime((BBacnetTime)this.getTime().decode(dataInput));
                break;
            }
            case 1: {
                this.setSequenceNumber((BBacnetUnsigned)this.getSequenceNumber().decode(dataInput));
                break;
            }
            case 2: {
                BBacnetDateTime bBacnetDateTime = this.getDateTime();
                bBacnetDateTime.setDate((BBacnetDate)bBacnetDateTime.getDate().decode(dataInput));
                bBacnetDateTime.setTime((BBacnetTime)bBacnetDateTime.getTime().decode(dataInput));
                break;
            }
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BBacnetTimeStamp() {
    }

    public BBacnetTimeStamp(BBacnetTime bBacnetTime) {
        this.setChoice(0);
        this.setTime(bBacnetTime);
    }

    public BBacnetTimeStamp(BBacnetUnsigned bBacnetUnsigned) {
        this.setChoice(1);
        this.setSequenceNumber(bBacnetUnsigned);
    }

    public BBacnetTimeStamp(BBacnetDateTime bBacnetDateTime) {
        this.setChoice(2);
        this.setDateTime(bBacnetDateTime);
    }

    public BBacnetTimeStamp(BAbsTime bAbsTime) {
        this.fromBAbsTime(bAbsTime);
    }

    static {
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetTimeStamp;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetTimeStamp = BBacnetTimeStamp.class("[Ljavax.baja.bacnet.datatypes.BBacnetTimeStamp;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        FACET_TAGS = new String[]{"ts_t.", "ts_sn.", "ts_dt."};
        DEBUG_TAGS = new String[]{"timeStamp{time}:", "timeStamp{sequenceNumber}:", "timeStamp{dateTime}:"};
    }
}

