/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.util.worker.IBacnetAddress;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBacnetRecipient
extends BStruct
implements BIBacnetDataType,
IBacnetAddress {
    public static final Property choice = BBacnetRecipient.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)1));
    public static final Property device = BBacnetRecipient.newProperty((int)0, (BValue)BBacnetObjectIdentifier.make(8), null);
    public static final Property address = BBacnetRecipient.newProperty((int)0, (BValue)new BBacnetAddress(), null);
    public static final Type TYPE;
    public static final int DEVICE_TAG = 0;
    public static final int ADDRESS_TAG = 1;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetRecipient;

    public final int getChoice() {
        return this.getInt(choice);
    }

    public final void setChoice(int n) {
        this.setInt(choice, n, null);
    }

    public final BBacnetObjectIdentifier getDevice() {
        return (BBacnetObjectIdentifier)this.get(device);
    }

    public final void setDevice(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.set(device, (BValue)bBacnetObjectIdentifier, null);
    }

    public final BBacnetAddress getAddress() {
        return (BBacnetAddress)this.get(address);
    }

    public final void setAddress(BBacnetAddress bBacnetAddress) {
        this.set(address, (BValue)bBacnetAddress, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final boolean isDevice() {
        boolean bl = false;
        if (this.getChoice() == 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isAddress() {
        boolean bl = false;
        if (this.getChoice() == 1) {
            bl = true;
        }
        return bl;
    }

    public final BValue getRecipient() {
        if (this.getChoice() == 0) {
            return this.getDevice();
        }
        return this.getAddress();
    }

    public final void setRecipient(BValue bValue) {
        this.setRecipient(bValue, null);
    }

    public final void setRecipient(BValue bValue, Context context) {
        Type type = bValue.getType();
        if (type == BBacnetObjectIdentifier.TYPE) {
            this.setInt(choice, 0, context);
            this.set(device, bValue, context);
        } else if (type == BBacnetAddress.TYPE) {
            this.setInt(choice, 1, context);
            this.getAddress().copyFrom((BComplex)((BBacnetAddress)bValue), context);
        }
    }

    public final void writeAsn(AsnOutput asnOutput) {
        switch (this.getChoice()) {
            case 0: {
                asnOutput.writeObjectIdentifier(0, this.getDevice());
                break;
            }
            case 1: {
                asnOutput.writeOpeningTag(1);
                this.getAddress().writeAsn(asnOutput);
                asnOutput.writeClosingTag(1);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid recipient type:" + this.getChoice());
            }
        }
    }

    public final void readAsn(AsnInput asnInput) throws AsnException {
        int n = asnInput.peekTag();
        if (asnInput.isValueTag(0)) {
            BBacnetObjectIdentifier bBacnetObjectIdentifier = asnInput.readObjectIdentifier(0);
            this.setRecipient((BValue)bBacnetObjectIdentifier, BacnetConst.noWrite);
        } else if (asnInput.isOpeningTag(1)) {
            asnInput.skipTag();
            this.getAddress().readAsn(asnInput);
            this.setInt(choice, 1, BacnetConst.noWrite);
            asnInput.skipTag();
        } else {
            throw new AsnException("Invalid tag: " + n);
        }
    }

    public final boolean equivalent(Object object) {
        if (object instanceof BBacnetRecipient) {
            BBacnetRecipient bBacnetRecipient = (BBacnetRecipient)object;
            int n = this.getChoice();
            if (n != bBacnetRecipient.getChoice()) {
                return false;
            }
            switch (n) {
                case 0: {
                    return this.getDevice().equals((Object)bBacnetRecipient.getDevice());
                }
                case 1: {
                    int n2 = this.getAddress().getNetworkNumber();
                    if (n2 != bBacnetRecipient.getAddress().getNetworkNumber()) {
                        return false;
                    }
                    return this.getAddress().macEquals(bBacnetRecipient.getAddress().getMacAddress().getAddr());
                }
            }
        }
        return false;
    }

    public final String toString(Context context) {
        return this.getRecipient().toString(context);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BBacnetRecipient() {
    }

    public BBacnetRecipient(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.setChoice(0);
        this.setDevice(bBacnetObjectIdentifier);
    }

    public BBacnetRecipient(BBacnetAddress bBacnetAddress) {
        this.setChoice(1);
        this.getAddress().copyFrom((BComplex)bBacnetAddress);
    }

    static {
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetRecipient;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetRecipient = BBacnetRecipient.class("[Ljavax.baja.bacnet.datatypes.BBacnetRecipient;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

