/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import com.tridium.bacnet.asn.AsnUtil;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetBinaryPv;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.log.Log;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFloat;
import javax.baja.sys.BNumber;
import javax.baja.sys.BSimple;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBacnetPriorityValue
extends BStruct
implements BIBacnetDataType {
    public static final Property value = BBacnetPriorityValue.newProperty((int)4, (BValue)BBacnetNull.DEFAULT, null);
    public static final Type TYPE;
    public static final String INVALID_CHOICE = "invalid choice";
    public static final String NULL_CHOICE = "NULL";
    public static final String REAL_CHOICE = "Real";
    public static final String BINARY_CHOICE = "Binary";
    public static final String INTEGER_CHOICE = "Integer";
    public static final String CONSTRUCTED_VALUE_CHOICE = "ConstructedValue";
    public static final int CONSTRUCTED_VALUE_TAG = 0;
    private static final int NULL_TAG = -1;
    private static final int REAL_TAG = -2;
    private static final int BINARY_TAG = -3;
    private static final int INTEGER_TAG = -4;
    private int choice;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetPriorityValue;

    public final BSimple getValue() {
        return (BSimple)this.get(value);
    }

    public final void setValue(BSimple bSimple) {
        this.set(value, (BValue)bSimple, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final int choice() {
        Type type = this.getValue().getType();
        this.choice = type == BBacnetNull.TYPE ? -1 : (type == BFloat.TYPE ? -2 : (type == BBacnetBinaryPv.TYPE ? -3 : (type == BBacnetUnsigned.TYPE ? -4 : 0)));
        return this.choice;
    }

    public final boolean isNull() {
        boolean bl = false;
        if (this.choice() == -1) {
            bl = true;
        }
        return bl;
    }

    public final BValue getPriorityValue() {
        return this.getValue();
    }

    public final void setPriorityValue(BValue bValue) {
        this.setPriorityValue(bValue, null);
    }

    public final void setPriorityValue(BValue bValue, Context context) {
        Type type;
        Context context2 = context;
        BComponent bComponent = this.getParentComponent();
        if ((bComponent == null || !bComponent.isMounted()) && context != null && context instanceof Transaction) {
            context2 = null;
        }
        if ((type = bValue.getType()) == BBacnetNull.TYPE) {
            this.choice = -1;
            this.set(value, bValue, context2);
        } else if (type == BFloat.TYPE) {
            this.choice = -2;
            this.set(value, bValue, context2);
        } else if (type == BBacnetBinaryPv.TYPE) {
            this.choice = -3;
            this.set(value, bValue, context2);
        } else if (type == BBacnetUnsigned.TYPE) {
            this.choice = -4;
            this.set(value, bValue, context2);
        } else if (bValue instanceof BSimple) {
            this.choice = 0;
            this.set(value, bValue, context2);
        } else {
            throw new IllegalArgumentException("BacnetPriorityValue:Cannot handle constructed types! v=" + bValue + " [" + bValue.getType() + ']');
        }
    }

    public final void writeAsn(AsnOutput asnOutput) {
        switch (this.choice()) {
            case -1: {
                asnOutput.writeNull();
                break;
            }
            case -2: {
                asnOutput.writeReal((BNumber)((BFloat)this.getValue()));
                break;
            }
            case -3: {
                asnOutput.writeEnumerated((BEnum)((BBacnetBinaryPv)this.getValue()));
                break;
            }
            case -4: {
                asnOutput.writeUnsigned((BBacnetUnsigned)this.getValue());
                break;
            }
            case 0: {
                Log.getLog((String)"bacnet.debug").trace("write constructed value in BacnetPriorityValue!");
                asnOutput.writeEncodedValue(0, AsnUtil.toAsn((BValue)this.getValue()));
                break;
            }
            default: {
                throw new IllegalStateException("Invalid priority value type:" + this.choice);
            }
        }
    }

    public final void readAsn(AsnInput asnInput) throws AsnException {
        int n = asnInput.peekTag();
        switch (n) {
            case 0: {
                this.setPriorityValue((BValue)asnInput.readNull(), BacnetConst.noWrite);
                break;
            }
            case 4: {
                this.setPriorityValue((BValue)BFloat.make((float)asnInput.readReal()), BacnetConst.noWrite);
                break;
            }
            case 9: {
                this.setPriorityValue((BValue)BBacnetBinaryPv.make(asnInput.readEnumerated()), BacnetConst.noWrite);
                break;
            }
            case 2: {
                this.setPriorityValue((BValue)asnInput.readUnsigned(), BacnetConst.noWrite);
                break;
            }
            default: {
                if (asnInput.isOpeningTag(0)) {
                    BValue bValue = AsnUtil.asnToValue(null, asnInput.readEncodedValue(0));
                    if (bValue instanceof BSimple) {
                        System.out.println("read constructed value in BacnetPriorityValue!");
                        this.setPriorityValue(bValue, BacnetConst.noWrite);
                        break;
                    }
                    System.out.println("non-BSimple constructed value not supported in BacnetPriorityValue!");
                    break;
                }
                throw new AsnException("Invalid tag: " + n);
            }
        }
    }

    public final String toString(Context context) {
        return this.getValue().toString(context);
    }

    public final String choiceName() {
        return BBacnetPriorityValue.choiceName(this.choice());
    }

    public static final String choiceName(int n) {
        switch (n) {
            case -1: {
                return NULL_CHOICE;
            }
            case -2: {
                return REAL_CHOICE;
            }
            case -3: {
                return BINARY_CHOICE;
            }
            case -4: {
                return INTEGER_CHOICE;
            }
            case 0: {
                return CONSTRUCTED_VALUE_CHOICE;
            }
        }
        return INVALID_CHOICE;
    }

    public static final int choice(String string) {
        if (NULL_CHOICE.equals(string)) {
            return -1;
        }
        if (REAL_CHOICE.equals(string)) {
            return -2;
        }
        if (BINARY_CHOICE.equals(string)) {
            return -3;
        }
        if (INTEGER_CHOICE.equals(string)) {
            return -4;
        }
        return 0;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BBacnetPriorityValue() {
    }

    public BBacnetPriorityValue(BBacnetNull bBacnetNull) {
        this.choice = -1;
        this.setValue(BBacnetNull.DEFAULT);
    }

    public BBacnetPriorityValue(BFloat bFloat) {
        this.choice = -2;
        this.setValue((BSimple)bFloat);
    }

    public BBacnetPriorityValue(BBacnetBinaryPv bBacnetBinaryPv) {
        this.choice = -3;
        this.setValue((BSimple)bBacnetBinaryPv);
    }

    public BBacnetPriorityValue(BBacnetUnsigned bBacnetUnsigned) {
        this.choice = -4;
        this.setValue(bBacnetUnsigned);
    }

    public BBacnetPriorityValue(BSimple bSimple) {
        this.choice = 0;
        this.setValue(bSimple);
    }

    static {
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetPriorityValue;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetPriorityValue = BBacnetPriorityValue.class("[Ljavax.baja.bacnet.datatypes.BBacnetPriorityValue;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

