/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.baja.bacnet.BacnetConst;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBacnetOctetString
extends BSimple {
    private static Lexicon lex;
    public static final String BACNET_OCTET_STRING = "bacOctetStr";
    public static final BBacnetOctetString DEFAULT;
    public static final BBacnetOctetString BACNET_WEEK_N_DAY;
    public static final Type TYPE;
    private byte[] arr;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetOctetString;

    public static final synchronized BBacnetOctetString make(byte[] byArray) {
        BBacnetOctetString bBacnetOctetString = new BBacnetOctetString(byArray);
        return bBacnetOctetString;
    }

    public final boolean isNull() {
        boolean bl = false;
        if (this.arr == null) {
            bl = true;
        }
        return bl;
    }

    public final boolean equals(Object object) {
        if (object instanceof BBacnetOctetString) {
            BBacnetOctetString bBacnetOctetString = (BBacnetOctetString)((Object)object);
            Arrays.equals(bBacnetOctetString.arr, this.arr);
        }
        return false;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        if (this.arr == null) {
            dataOutput.writeInt(0);
        } else {
            dataOutput.writeInt(this.arr.length);
            dataOutput.write(this.arr, 0, this.arr.length);
        }
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        byte[] byArray = null;
        int n = -1;
        try {
            n = dataInput.readInt();
            if (n != 0) {
                byArray = new byte[n];
                dataInput.readFully(byArray, 0, n);
            }
            return BBacnetOctetString.make(byArray);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new IOException("Invalid octet string length: " + n);
        }
    }

    public final String encodeToString() throws IOException {
        if (this.arr == null || this.arr.length == 0) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(BBacnetOctetString.hexByte(this.arr[0]));
        int n = 1;
        while (n < this.arr.length) {
            stringBuffer.append(" ");
            stringBuffer.append(BBacnetOctetString.hexByte(this.arr[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    private static final String hexByte(byte by) {
        String string = TextUtil.byteToHexString((int)by);
        return string.length() == 1 ? "0" + string : string;
    }

    public final BObject decodeFromString(String string) throws IOException {
        byte[] byArray;
        if (string.equals("null")) {
            byArray = null;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            byArray = new byte[stringTokenizer.countTokens()];
            try {
                int n = 0;
                while (n < byArray.length) {
                    byArray[n] = (byte)Integer.parseInt(stringTokenizer.nextToken(), 16);
                    ++n;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                byArray = null;
            }
        }
        return BBacnetOctetString.make(byArray);
    }

    public final int length() {
        return this.arr.length;
    }

    public final byte byteAt(int n) {
        return this.arr[n];
    }

    public final byte[] getBytes() {
        if (this.arr == null) {
            return null;
        }
        byte[] byArray = new byte[this.arr.length];
        System.arraycopy(this.arr, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public final byte[] getAddr() {
        if (this.arr == null) {
            return null;
        }
        return this.arr;
    }

    public final String toString(Context context) {
        if (context != null) {
            if (context.equals(BacnetConst.nameContext)) {
                return this.toNameString();
            }
            if (context.equals(BacnetConst.deviceRegistryContext)) {
                return TextUtil.bytesToHexString((byte[])this.arr);
            }
            BString bString = (BString)context.getFacet(BACNET_OCTET_STRING);
            if (bString != null) {
                StringBuffer stringBuffer = new StringBuffer();
                String string = bString.getString() + ".b";
                int n = 0;
                while (n < this.arr.length) {
                    String string2 = string + String.valueOf(n) + '.' + String.valueOf(this.arr[n]);
                    String string3 = lex.get(string2);
                    if (string3 == null) {
                        string3 = BBacnetOctetString.hexByte(this.arr[n]);
                    }
                    stringBuffer.append(string3).append(':');
                    ++n;
                }
                return stringBuffer.substring(0, stringBuffer.length() - 1);
            }
        }
        try {
            return this.encodeToString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return exception.toString();
        }
    }

    public final int hashCode() {
        if (this.arr == null) {
            return 0;
        }
        int n = 1;
        int n2 = 0;
        while (n2 < this.arr.length) {
            n = 31 * n + this.arr[n2];
            ++n2;
        }
        return n;
    }

    private final String toNameString() {
        if (this.arr == null || this.arr.length == 0) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("_").append(TextUtil.byteToHexString((int)this.arr[0]));
        int n = 1;
        while (n < this.arr.length) {
            stringBuffer.append("_").append(TextUtil.byteToHexString((int)this.arr[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static final String bytesToString(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = TextUtil.byteToHexString((int)byArray[0]);
        if (string.length() == 1) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
        int n = 1;
        while (n < byArray.length) {
            stringBuffer.append(" ");
            string = TextUtil.byteToHexString((int)byArray[n]);
            if (string.length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static final byte[] stringToBytes(String string) {
        byte[] byArray;
        if (string.equals("null")) {
            byArray = null;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            byArray = new byte[stringTokenizer.countTokens()];
            try {
                int n = 0;
                while (n < byArray.length) {
                    byArray[n] = (byte)Integer.parseInt(stringTokenizer.nextToken(), 16);
                    ++n;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                byArray = null;
            }
        }
        return byArray;
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.arr = null;
    }

    private BBacnetOctetString(byte[] byArray) {
        this.this();
        if (byArray == null) {
            this.arr = null;
        } else {
            this.arr = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.arr, 0, byArray.length);
        }
    }

    static {
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetOctetString;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetOctetString = BBacnetOctetString.class("[Ljavax.baja.bacnet.datatypes.BBacnetOctetString;", false);
        }
        lex = Lexicon.make((Class)clazz);
        DEFAULT = BBacnetOctetString.make(null);
        BACNET_WEEK_N_DAY = BBacnetOctetString.make(new byte[]{-1, -1, -1});
        Class clazz2 = class$javax$baja$bacnet$datatypes$BBacnetOctetString;
        if (clazz2 == null) {
            clazz2 = class$javax$baja$bacnet$datatypes$BBacnetOctetString = BBacnetOctetString.class("[Ljavax.baja.bacnet.datatypes.BBacnetOctetString;", false);
        }
        TYPE = Sys.loadType((Class)clazz2);
    }
}

