/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.datatypes.BTrendEvent;
import com.tridium.bacnet.history.BBacnetBooleanTrendRecord;
import com.tridium.bacnet.history.BBacnetEnumTrendRecord;
import com.tridium.bacnet.history.BBacnetNumericTrendRecord;
import com.tridium.bacnet.history.BBacnetStringTrendRecord;
import com.tridium.bacnet.history.BBacnetTrendRecord;
import java.io.IOException;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.history.BHistoryRecord;
import javax.baja.log.Log;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBacnetLogRecord
extends BStruct
implements BIBacnetDataType {
    public static final Property timestamp = BBacnetLogRecord.newProperty((int)0, (BValue)new BBacnetDateTime(), null);
    public static final Property logDatum = BBacnetLogRecord.newProperty((int)0, (BValue)BBacnetNull.DEFAULT, null);
    public static final Property statusFlags = BBacnetLogRecord.newProperty((int)0, (BValue)BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetStatusFlags")), (BFacets)BacnetBitStringUtil.BACNET_STATUS_FLAGS_FACETS);
    public static final Type TYPE;
    public static final int TIMESTAMP_TAG = 0;
    public static final int LOG_DATUM_TAG = 1;
    public static final int STATUS_FLAGS_TAG = 2;
    public static final int LOG_STATUS_TAG = 0;
    public static final int BOOLEAN_VALUE_TAG = 1;
    public static final int REAL_VALUE_TAG = 2;
    public static final int ENUM_VALUE_TAG = 3;
    public static final int UNSIGNED_VALUE_TAG = 4;
    public static final int SIGNED_VALUE_TAG = 5;
    public static final int BITSTRING_VALUE_TAG = 6;
    public static final int NULL_VALUE_TAG = 7;
    public static final int FAILURE_TAG = 8;
    public static final int TIME_CHANGE_TAG = 9;
    public static final int ANY_VALUE_TAG = 10;
    private static Lexicon lex;
    public static final String LOG_STATUS_STRING;
    public static final String FAILURE_STRING;
    public static final String TIME_CHANGE_STRING;
    public static final String EVENT_STRING;
    public static final String INVALID_STRING;
    public static final String UNKNOWN_STRING;
    public static final String LOG_ENABLED_STRING;
    public static final String LOG_DISABLED_STRING;
    public static final String LOG_BUFFER_PURGED_STRING;
    public static final String LOG_INTERRUPTED_STRING;
    public static final String SECONDS_STRING;
    private BTypeSpec recType;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetLogRecord;

    public final BBacnetDateTime getTimestamp() {
        return (BBacnetDateTime)this.get(timestamp);
    }

    public final void setTimestamp(BBacnetDateTime bBacnetDateTime) {
        this.set(timestamp, (BValue)bBacnetDateTime, null);
    }

    public final BSimple getLogDatum() {
        return (BSimple)this.get(logDatum);
    }

    public final void setLogDatum(BSimple bSimple) {
        this.set(logDatum, (BValue)bSimple, null);
    }

    public final BBacnetBitString getStatusFlags() {
        return (BBacnetBitString)this.get(statusFlags);
    }

    public final void setStatusFlags(BBacnetBitString bBacnetBitString) {
        this.set(statusFlags, (BValue)bBacnetBitString, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final void writeAsn(AsnOutput asnOutput) {
        asnOutput.writeOpeningTag(0);
        this.getTimestamp().writeAsn(asnOutput);
        asnOutput.writeClosingTag(0);
        asnOutput.writeOpeningTag(1);
        BBacnetLogRecord.writeLogDatum(asnOutput, this.getLogDatum(), this.getLogDatumType(), this.getLogDatumEvent().getLong(), BacnetBitStringUtil.getBStatus(this.getStatusFlags()));
        asnOutput.writeClosingTag(1);
        asnOutput.writeBitString(2, this.getStatusFlags());
    }

    public final void readAsn(AsnInput asnInput) throws AsnException {
        int n;
        this.recType = null;
        int n2 = asnInput.peekTag();
        if (!asnInput.isOpeningTag(0)) {
            throw new AsnException("Invalid tag: " + n2);
        }
        asnInput.skipTag();
        this.getTimestamp().readAsn(asnInput);
        asnInput.skipTag();
        n2 = asnInput.peekTag();
        if (asnInput.isOpeningTag(1)) {
            asnInput.skipTag();
            n = asnInput.peekTag();
            switch (n) {
                case 1: {
                    this.set(logDatum, (BValue)BBoolean.make((boolean)asnInput.readBoolean(1)), BacnetConst.noWrite);
                    this.recType = BTypeSpec.make((String)"bacnet", (String)"BacnetBooleanTrendRecord");
                    break;
                }
                case 2: {
                    this.set(logDatum, (BValue)BFloat.make((float)asnInput.readReal(2)), BacnetConst.noWrite);
                    this.recType = BTypeSpec.make((String)"bacnet", (String)"BacnetNumericTrendRecord");
                    break;
                }
                case 0: {
                    this.set(logDatum, (BValue)BTrendEvent.makeLogStatus(asnInput.readBitString(0)), BacnetConst.noWrite);
                    break;
                }
                case 3: {
                    this.set(logDatum, (BValue)BDynamicEnum.make((int)asnInput.readEnumerated(3)), BacnetConst.noWrite);
                    this.recType = BTypeSpec.make((String)"bacnet", (String)"BacnetEnumTrendRecord");
                    break;
                }
                case 4: {
                    this.set(logDatum, (BValue)asnInput.readUnsigned(4), BacnetConst.noWrite);
                    this.recType = BTypeSpec.make((String)"bacnet", (String)"BacnetNumericTrendRecord");
                    break;
                }
                case 5: {
                    this.set(logDatum, (BValue)asnInput.readSigned(5), BacnetConst.noWrite);
                    this.recType = BTypeSpec.make((String)"bacnet", (String)"BacnetNumericTrendRecord");
                    break;
                }
                case 6: {
                    this.set(logDatum, (BValue)asnInput.readBitString(6), BacnetConst.noWrite);
                    this.recType = BTypeSpec.make((String)"bacnet", (String)"BacnetStringTrendRecord");
                    break;
                }
                case 8: {
                    asnInput.skipTag();
                    NErrorType nErrorType = new NErrorType();
                    nErrorType.readEncoded(asnInput);
                    asnInput.skipTag();
                    this.set(logDatum, (BValue)BTrendEvent.makeFailure(nErrorType), BacnetConst.noWrite);
                    break;
                }
                case 9: {
                    this.set(logDatum, (BValue)BTrendEvent.makeTimeChange((long)asnInput.readReal(9)), BacnetConst.noWrite);
                    break;
                }
                case 7: {
                    this.set(logDatum, (BValue)asnInput.readNull(7), BacnetConst.noWrite);
                    break;
                }
                case 10: {
                    Log.getLog((String)"bacnet.debug").message(this + ".readAsn:logDatumChoice " + n + " not yet supported");
                    this.set(logDatum, (BValue)BBacnetNull.DEFAULT, BacnetConst.noWrite);
                    this.recType = BTypeSpec.make((String)"bacnet", (String)"BacnetStringTrendRecord");
                    break;
                }
                default: {
                    Log.getLog((String)"bacnet").message("Invalid logDatumChoice!");
                }
            }
        } else {
            throw new AsnException("Invalid tag: " + n2);
        }
        asnInput.skipTag();
        n = asnInput.peekTag();
        if (n == 2) {
            this.set(statusFlags, (BValue)asnInput.readBitString(2), BacnetConst.noWrite);
        }
    }

    public final String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTimestamp().toString(context)).append('_').append(this.getLogDatum().toString(context)).append('_').append(this.getStatusFlags().toString((Context)this.getSlotFacets((Slot)statusFlags)));
        return stringBuffer.toString();
    }

    private final int getLogDatumType() {
        Type type = this.getLogDatum().getType();
        if (type.is(BBoolean.TYPE)) {
            return 1;
        }
        if (type.is(BDouble.TYPE) || type.is(BFloat.TYPE)) {
            return 2;
        }
        if (this.getLogDatum() instanceof BEnum) {
            return 3;
        }
        if (type.is(BBacnetUnsigned.TYPE)) {
            return 4;
        }
        if (type.is(BInteger.TYPE)) {
            return 5;
        }
        if (type.is(BBacnetBitString.TYPE)) {
            return 6;
        }
        if (type.is(BBacnetNull.TYPE)) {
            return 7;
        }
        if (type.is(BTrendEvent.TYPE)) {
            BTrendEvent bTrendEvent = (BTrendEvent)this.getLogDatum();
            if (bTrendEvent.isLogStatus()) {
                return 0;
            }
            if (bTrendEvent.isFailure()) {
                return 8;
            }
            if (bTrendEvent.isTimeChange()) {
                return 9;
            }
        }
        return 10;
    }

    private final BTrendEvent getLogDatumEvent() {
        Type type = this.getLogDatum().getType();
        if (type.is(BTrendEvent.TYPE)) {
            return (BTrendEvent)this.getLogDatum();
        }
        return BTrendEvent.DEFAULT;
    }

    public static final void writeLogRecord(BBacnetDateTime bBacnetDateTime, BSimple bSimple, int n, BBacnetBitString bBacnetBitString, long l, AsnOutput asnOutput) {
        asnOutput.writeOpeningTag(0);
        bBacnetDateTime.writeAsn(asnOutput);
        asnOutput.writeClosingTag(0);
        asnOutput.writeOpeningTag(1);
        BBacnetLogRecord.writeLogDatum(asnOutput, bSimple, n, l, BacnetBitStringUtil.getBStatus(bBacnetBitString));
        asnOutput.writeClosingTag(1);
        asnOutput.writeBitString(2, bBacnetBitString);
    }

    public static final void writeLogRecord(BAbsTime bAbsTime, BSimple bSimple, int n, BStatus bStatus, long l, AsnOutput asnOutput) {
        asnOutput.writeOpeningTag(0);
        asnOutput.writeDate(bAbsTime);
        asnOutput.writeTime(bAbsTime);
        asnOutput.writeClosingTag(0);
        asnOutput.writeOpeningTag(1);
        BBacnetLogRecord.writeLogDatum(asnOutput, bSimple, n, l, bStatus);
        asnOutput.writeClosingTag(1);
        asnOutput.writeBitString(2, BacnetBitStringUtil.getBacnetStatusFlags(bStatus));
    }

    private static final void writeLogDatum(AsnOutput asnOutput, BSimple bSimple, int n, long l, BStatus bStatus) {
        try {
            if (bStatus.isNull()) {
                asnOutput.writeNull(7);
                return;
            }
            switch (n) {
                case 1: {
                    if (bSimple instanceof BBoolean) {
                        asnOutput.writeBoolean(1, (BBoolean)bSimple);
                        break;
                    }
                    if (bSimple instanceof BEnum) {
                        asnOutput.writeBoolean(1, ((BEnum)bSimple).isActive());
                    }
                    break;
                }
                case 2: {
                    asnOutput.writeReal(2, (BNumber)bSimple);
                    break;
                }
                case 0: {
                    asnOutput.writeBitString(0, BTrendEvent.getLogStatus(l));
                    break;
                }
                case 3: {
                    asnOutput.writeEnumerated(3, (BEnum)bSimple);
                    break;
                }
                case 8: {
                    NErrorType nErrorType = BTrendEvent.getFailure(l);
                    asnOutput.writeOpeningTag(8);
                    asnOutput.writeEnumerated(nErrorType.getErrorClass());
                    asnOutput.writeEnumerated(nErrorType.getErrorCode());
                    asnOutput.writeClosingTag(8);
                    break;
                }
                case 9: {
                    asnOutput.writeReal(9, BTrendEvent.getTimeChange(l));
                    break;
                }
                case 4: {
                    if (bSimple instanceof BNumber) {
                        asnOutput.writeUnsignedInteger(4, ((BNumber)bSimple).getLong());
                        break;
                    }
                    if (bSimple instanceof BEnum) {
                        asnOutput.writeUnsignedInteger(4, ((BEnum)bSimple).getOrdinal());
                    }
                    break;
                }
                case 5: {
                    if (bSimple instanceof BNumber) {
                        asnOutput.writeSignedInteger(5, ((BNumber)bSimple).getInt());
                        break;
                    }
                    if (bSimple instanceof BEnum) {
                        asnOutput.writeSignedInteger(5, ((BEnum)bSimple).getOrdinal());
                    }
                    break;
                }
                case 6: {
                    if (bSimple instanceof BBacnetBitString) {
                        asnOutput.writeBitString(6, (BBacnetBitString)bSimple);
                        break;
                    }
                    if (bSimple instanceof BString) {
                        try {
                            BBacnetBitString bBacnetBitString = (BBacnetBitString)BBacnetBitString.DEFAULT.decodeFromString(bSimple.toString());
                            asnOutput.writeBitString(6, bBacnetBitString);
                        }
                        catch (IOException iOException) {
                            asnOutput.writeOpeningTag(8);
                            asnOutput.writeEnumerated(1);
                            asnOutput.writeEnumerated(0);
                            asnOutput.writeClosingTag(8);
                        }
                    }
                    break;
                }
                case 7: {
                    asnOutput.writeNull(7);
                    break;
                }
                case 10: {
                    Log.getLog((String)"bacnet.debug").message("BacnetLogRecord.writeLogDatum:logDatumChoice " + n + " not yet supported: logDatum=" + bSimple + " [" + bSimple.getType() + ']');
                    break;
                }
                default: {
                    Log.getLog((String)"bacnet").message("Invalid logDatumChoice!");
                }
            }
        }
        catch (ClassCastException classCastException) {
            Log.getLog((String)"bacnet").message("Incompatible logDatum/logDatumChoice!", (Throwable)classCastException);
        }
    }

    public final BTypeSpec getNiagaraRecordType() {
        return this.recType;
    }

    public final BHistoryRecord initializeNiagaraRecord(BHistoryRecord bHistoryRecord, long l) {
        BBacnetTrendRecord bBacnetTrendRecord = (BBacnetTrendRecord)bHistoryRecord;
        bBacnetTrendRecord.setTimestamp(this.getTimestamp().toBAbsTime());
        bBacnetTrendRecord.setStatus(BacnetBitStringUtil.getBStatus(this.getStatusFlags()));
        bBacnetTrendRecord.setSequenceNumber(l);
        if (this.getLogDatum() instanceof BBacnetNull) {
            bBacnetTrendRecord.setLogEvent(BTrendEvent.DEFAULT);
            bBacnetTrendRecord.setStatus(BStatus.makeNull((BStatus)bBacnetTrendRecord.getStatus(), (boolean)true));
            return bBacnetTrendRecord;
        }
        if (this.recType == null) {
            bBacnetTrendRecord.setLogEvent((BTrendEvent)this.getLogDatum());
            bBacnetTrendRecord.setTrendFlags(bBacnetTrendRecord.getTrendFlags().set(4, true));
            return bBacnetTrendRecord;
        }
        Type type = bBacnetTrendRecord.getType();
        if (type == BBacnetBooleanTrendRecord.TYPE) {
            BSimple bSimple = this.getLogDatum();
            if (bSimple.getType().is(BDynamicEnum.TYPE)) {
                int n;
                boolean bl = false;
                boolean bl2 = false;
                BDynamicEnum bDynamicEnum = (BDynamicEnum)bSimple;
                if (bDynamicEnum != null && ((n = bDynamicEnum.getOrdinal()) == 0 || n == 1)) {
                    boolean bl3 = false;
                    if (n != 0) {
                        bl3 = true;
                    }
                    bl = bl3;
                    bl2 = true;
                }
                if (bl2) {
                    ((BBacnetBooleanTrendRecord)bBacnetTrendRecord).setValue(bl);
                } else {
                    Log.getLog((String)"bacnet").message("Error, could not encode non-zero/one enumerated logDatum to a BBooleanHistoryRecord (" + this.getLogDatum().toString() + ')');
                }
            } else if (bSimple.getType().is(BBoolean.TYPE)) {
                ((BBacnetBooleanTrendRecord)bBacnetTrendRecord).setValue(((BBoolean)this.getLogDatum()).getBoolean());
            } else {
                Log.getLog((String)"bacnet").message("Error, could not encode logDatum to a BBooleanHistoryRecord (" + this.getLogDatum().toString() + ')');
            }
        } else if (type == BBacnetNumericTrendRecord.TYPE) {
            BSimple bSimple = this.getLogDatum();
            if (bSimple.getType().is(BBacnetUnsigned.TYPE)) {
                ((BBacnetNumericTrendRecord)bBacnetTrendRecord).setValue(((BBacnetUnsigned)this.getLogDatum()).getLong());
            } else {
                ((BBacnetNumericTrendRecord)bBacnetTrendRecord).setValue(((BNumber)this.getLogDatum()).getDouble());
            }
        } else if (type == BBacnetEnumTrendRecord.TYPE) {
            BSimple bSimple = this.getLogDatum();
            if (bSimple.getType().is(BBacnetUnsigned.TYPE)) {
                ((BBacnetEnumTrendRecord)bBacnetTrendRecord).setValue(BDynamicEnum.make((int)((BBacnetUnsigned)this.getLogDatum()).getInt()));
            } else if (bSimple.getType().is(BDynamicEnum.TYPE)) {
                ((BBacnetEnumTrendRecord)bBacnetTrendRecord).setValue((BDynamicEnum)this.getLogDatum());
            } else {
                Log.getLog((String)"bacnet").message("Error, could not encode logDatum to a BEnumTrendRecord (" + this.getLogDatum().toString() + ')');
            }
        } else if (type == BBacnetStringTrendRecord.TYPE) {
            try {
                ((BBacnetStringTrendRecord)bBacnetTrendRecord).setValue(this.getLogDatum().encodeToString());
            }
            catch (Exception exception) {
                Log.getLog((String)"bacnet").message("Error, could not encode logDatum to a string (" + this.getLogDatum().toString() + ')', (Throwable)exception);
                ((BBacnetStringTrendRecord)bBacnetTrendRecord).setValue("Error, could not encode " + this.getLogDatum().toString());
            }
        }
        return bBacnetTrendRecord;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.recType = null;
    }

    public BBacnetLogRecord() {
        this.this();
    }

    public BBacnetLogRecord(BBacnetDateTime bBacnetDateTime, BSimple bSimple) {
        this.this();
        this.setTimestamp(bBacnetDateTime);
        this.setLogDatum(bSimple);
    }

    public BBacnetLogRecord(BAbsTime bAbsTime, BSimple bSimple) {
        this.this();
        this.getTimestamp().fromBAbsTime(bAbsTime);
        this.setLogDatum(bSimple);
    }

    static {
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetLogRecord;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetLogRecord = BBacnetLogRecord.class("[Ljavax.baja.bacnet.datatypes.BBacnetLogRecord;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"bacnet");
        LOG_STATUS_STRING = lex.getText("BacnetLogRecord.status");
        FAILURE_STRING = lex.getText("BacnetLogRecord.failure");
        TIME_CHANGE_STRING = lex.getText("BacnetLogRecord.timeChange");
        EVENT_STRING = lex.getText("BacnetLogRecord.event");
        INVALID_STRING = lex.getText("BacnetLogRecord.invalid");
        UNKNOWN_STRING = lex.getText("BacnetLogRecord.unknown");
        LOG_ENABLED_STRING = lex.getText("BacnetLogRecord.enabled");
        LOG_DISABLED_STRING = lex.getText("BacnetLogRecord.disabled");
        LOG_BUFFER_PURGED_STRING = lex.getText("BacnetLogRecord.purged");
        LOG_INTERRUPTED_STRING = lex.getText("BacnetLogRecord.interrupted");
        SECONDS_STRING = lex.getText("BacnetLogRecord.seconds");
    }
}

