/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.datatypes.BTrendEvent;
import com.tridium.bacnet.history.BBacnetBooleanTrendRecord;
import com.tridium.bacnet.history.BBacnetEnumTrendRecord;
import com.tridium.bacnet.history.BBacnetNumericTrendRecord;
import com.tridium.bacnet.history.BBacnetStringTrendRecord;
import com.tridium.bacnet.history.BBacnetTrendRecord;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.history.BHistoryRecord;
import javax.baja.log.Log;
import javax.baja.status.BStatus;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BFloat;
import javax.baja.sys.BNumber;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.BTypeSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetLogMultipleRecord
extends BComponent
implements BIBacnetDataType {
    public static final Property timestamp = BBacnetLogMultipleRecord.newProperty((int)0, (BValue)new BBacnetDateTime(), null);
    public static final Property statusFlags = BBacnetLogMultipleRecord.newProperty((int)0, (BValue)BBacnetNull.DEFAULT, null);
    public static final Property timeChange = BBacnetLogMultipleRecord.newProperty((int)0, (BValue)BBacnetNull.DEFAULT, null);
    public static final Type TYPE;
    public static final int TIMESTAMP_TAG = 0;
    public static final int LOG_DATA_TAG = 1;
    public static final int LOG_STATUS_TAG = 0;
    public static final int LOG_DATA_SEQ_TAG = 1;
    public static final int TIME_CHANGE_TAG = 2;
    public static final int BOOLEAN_VALUE_TAG = 0;
    public static final int REAL_VALUE_TAG = 1;
    public static final int ENUM_VALUE_TAG = 2;
    public static final int UNSIGNED_VALUE_TAG = 3;
    public static final int SIGNED_VALUE_TAG = 4;
    public static final int BITSTRING_VALUE_TAG = 5;
    public static final int NULL_VALUE_TAG = 6;
    public static final int FAILURE_TAG = 7;
    public static final int ANY_VALUE_TAG = 8;
    private BTypeSpec[] recType;
    private int logDataChoice;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetLogMultipleRecord;
    static /* synthetic */ Class class$javax$baja$util$BTypeSpec;

    public BBacnetDateTime getTimestamp() {
        return (BBacnetDateTime)this.get(timestamp);
    }

    public void setTimestamp(BBacnetDateTime bBacnetDateTime) {
        this.set(timestamp, (BValue)bBacnetDateTime, null);
    }

    public BSimple getStatusFlags() {
        return (BSimple)this.get(statusFlags);
    }

    public void setStatusFlags(BSimple bSimple) {
        this.set(statusFlags, (BValue)bSimple, null);
    }

    public BSimple getTimeChange() {
        return (BSimple)this.get(timeChange);
    }

    public void setTimeChange(BSimple bSimple) {
        this.set(timeChange, (BValue)bSimple, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void writeAsn(AsnOutput asnOutput) {
    }

    public void readAsn(AsnInput asnInput) throws AsnException {
        this.recType = null;
        int n = asnInput.peekTag();
        if (!asnInput.isOpeningTag(0)) {
            throw new AsnException("Invalid tag: " + n);
        }
        asnInput.skipTag();
        this.getTimestamp().readAsn(asnInput);
        asnInput.skipTag();
        n = asnInput.peekTag();
        if (asnInput.isOpeningTag(1)) {
            asnInput.skipTag();
            this.logDataChoice = asnInput.peekTag();
            switch (this.logDataChoice) {
                case 0: {
                    this.set(statusFlags, (BValue)BTrendEvent.makeLogStatus(asnInput.readBitString(0)), BacnetConst.noWrite);
                    break;
                }
                case 1: {
                    asnInput.skipTag();
                    this.processDataSeq(asnInput);
                    asnInput.skipTag();
                    break;
                }
                case 2: {
                    this.set(timeChange, (BValue)BTrendEvent.makeTimeChange((long)asnInput.readReal(2)), BacnetConst.noWrite);
                    break;
                }
            }
        } else {
            throw new AsnException("Invalid tag: " + n);
        }
        asnInput.skipTag();
    }

    private final void processDataSeq(AsnInput asnInput) throws AsnException {
        Class clazz = class$javax$baja$util$BTypeSpec;
        if (clazz == null) {
            clazz = class$javax$baja$util$BTypeSpec = BBacnetLogMultipleRecord.class("[Ljavax.baja.util.BTypeSpec;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        int n2 = asnInput.peekTag();
        while (!asnInput.isClosingTag(1)) {
            BTypeSpec bTypeSpec = null;
            switch (n2) {
                case 0: {
                    this.addData((BSimple)BBoolean.make((boolean)asnInput.readBoolean(0)), n);
                    bTypeSpec = BTypeSpec.make((String)"bacnet", (String)"BacnetBooleanTrendRecord");
                    break;
                }
                case 1: {
                    this.addData((BSimple)BFloat.make((float)asnInput.readReal(1)), n);
                    bTypeSpec = BTypeSpec.make((String)"bacnet", (String)"BacnetNumericTrendRecord");
                    break;
                }
                case 2: {
                    this.addData((BSimple)BDynamicEnum.make((int)asnInput.readEnumerated(2)), n);
                    bTypeSpec = BTypeSpec.make((String)"bacnet", (String)"BacnetEnumTrendRecord");
                    break;
                }
                case 3: {
                    this.addData(asnInput.readUnsigned(3), n);
                    bTypeSpec = BTypeSpec.make((String)"bacnet", (String)"BacnetNumericTrendRecord");
                    break;
                }
                case 4: {
                    this.addData((BSimple)asnInput.readSigned(4), n);
                    bTypeSpec = BTypeSpec.make((String)"bacnet", (String)"BacnetNumericTrendRecord");
                    break;
                }
                case 5: {
                    this.addData(asnInput.readBitString(5), n);
                    bTypeSpec = BTypeSpec.make((String)"bacnet", (String)"BacnetStringTrendRecord");
                    break;
                }
                case 7: {
                    asnInput.skipTag();
                    NErrorType nErrorType = new NErrorType();
                    nErrorType.readEncoded(asnInput);
                    asnInput.skipTag();
                    this.addData(BTrendEvent.makeFailure(nErrorType), n);
                    break;
                }
                case 6: {
                    this.addData(asnInput.readNull(6), n);
                    bTypeSpec = BTypeSpec.make((String)"bacnet", (String)"BacnetNull");
                    break;
                }
                case 8: {
                    Log.getLog((String)"bacnet.debug").message(this + ".readAsn:logDataChoice " + n2 + " not yet supported");
                    this.addData(BBacnetNull.DEFAULT, n);
                    bTypeSpec = BTypeSpec.make((String)"bacnet", (String)"BacnetStringTrendRecord");
                    break;
                }
                default: {
                    Log.getLog((String)"bacnet").message("Invalid logDatumChoice!");
                }
            }
            array.add(bTypeSpec);
            ++n;
            n2 = asnInput.peekTag();
        }
        this.recType = (BTypeSpec[])array.trim();
    }

    private final void addData(BSimple bSimple, int n) {
        this.add(this.getSeqName(n), (BValue)bSimple, BacnetConst.noWrite);
    }

    private final String getSeqName(int n) {
        return "data" + n;
    }

    public BTypeSpec getNiagaraRecordType(int n) {
        return this.recType[n];
    }

    public BHistoryRecord initializeNiagaraRecord(BHistoryRecord bHistoryRecord, long l, int n) {
        BBacnetTrendRecord bBacnetTrendRecord = (BBacnetTrendRecord)bHistoryRecord;
        bBacnetTrendRecord.setTimestamp(this.getTimestamp().toBAbsTime());
        bBacnetTrendRecord.setSequenceNumber(l);
        if (!this.isLogData()) {
            if (this.isLogStatus()) {
                bBacnetTrendRecord.setLogEvent((BTrendEvent)this.getStatusFlags());
            } else {
                bBacnetTrendRecord.setLogEvent((BTrendEvent)this.getTimeChange());
            }
            bBacnetTrendRecord.setTrendFlags(bBacnetTrendRecord.getTrendFlags().set(4, true));
            return bBacnetTrendRecord;
        }
        BSimple bSimple = (BSimple)this.get(this.getSeqName(n));
        bBacnetTrendRecord.setLogEvent(BTrendEvent.DEFAULT);
        Type type = bBacnetTrendRecord.getType();
        if (type == BBacnetBooleanTrendRecord.TYPE) {
            if (bSimple instanceof BBacnetNull) {
                ((BBacnetBooleanTrendRecord)bBacnetTrendRecord).setValue(false);
                bBacnetTrendRecord.setLogEvent(BTrendEvent.DEFAULT);
                bBacnetTrendRecord.setStatus(BStatus.makeNull((BStatus)bBacnetTrendRecord.getStatus(), (boolean)true));
            } else {
                ((BBacnetBooleanTrendRecord)bBacnetTrendRecord).setValue(((BBoolean)bSimple).getBoolean());
            }
        } else if (type == BBacnetNumericTrendRecord.TYPE) {
            if (bSimple instanceof BBacnetNull) {
                ((BBacnetNumericTrendRecord)bBacnetTrendRecord).setValue(0.0);
                bBacnetTrendRecord.setLogEvent(BTrendEvent.DEFAULT);
                bBacnetTrendRecord.setStatus(BStatus.makeNull((BStatus)bBacnetTrendRecord.getStatus(), (boolean)true));
            } else {
                BSimple bSimple2 = bSimple;
                if (bSimple2.getType().is(BBacnetUnsigned.TYPE)) {
                    ((BBacnetNumericTrendRecord)bBacnetTrendRecord).setValue(((BBacnetUnsigned)bSimple).getLong());
                } else {
                    ((BBacnetNumericTrendRecord)bBacnetTrendRecord).setValue(((BNumber)bSimple).getDouble());
                }
            }
        } else if (type == BBacnetEnumTrendRecord.TYPE) {
            if (bSimple instanceof BBacnetNull) {
                ((BBacnetEnumTrendRecord)bBacnetTrendRecord).setValue(BDynamicEnum.make((int)0));
                bBacnetTrendRecord.setLogEvent(BTrendEvent.DEFAULT);
                bBacnetTrendRecord.setStatus(BStatus.makeNull((BStatus)bBacnetTrendRecord.getStatus(), (boolean)true));
            } else {
                ((BBacnetEnumTrendRecord)bBacnetTrendRecord).setValue((BDynamicEnum)bSimple);
            }
        } else if (type == BBacnetStringTrendRecord.TYPE) {
            try {
                if (bSimple instanceof BBacnetNull) {
                    ((BBacnetStringTrendRecord)bBacnetTrendRecord).setValue("");
                    bBacnetTrendRecord.setLogEvent(BTrendEvent.DEFAULT);
                    bBacnetTrendRecord.setStatus(BStatus.makeNull((BStatus)bBacnetTrendRecord.getStatus(), (boolean)true));
                } else {
                    ((BBacnetStringTrendRecord)bBacnetTrendRecord).setValue(bSimple.encodeToString());
                }
            }
            catch (Exception exception) {
                Log.getLog((String)"bacnet").message("Error, could not encode logDatum to a string (" + bSimple.toString() + ')', (Throwable)exception);
                ((BBacnetStringTrendRecord)bBacnetTrendRecord).setValue("Error, could not encode " + bSimple.toString());
            }
        }
        return bBacnetTrendRecord;
    }

    public boolean isLogStatus() {
        boolean bl = false;
        if (this.logDataChoice == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isLogData() {
        boolean bl = false;
        if (this.logDataChoice == 1) {
            bl = true;
        }
        return bl;
    }

    public int getLogDataChoice() {
        return this.logDataChoice;
    }

    public BTypeSpec[] getTypeSpecs() {
        return this.recType;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.recType = null;
    }

    public BBacnetLogMultipleRecord() {
        this.this();
    }

    public BBacnetLogMultipleRecord(AsnInput asnInput) throws AsnException {
        this.this();
        this.readAsn(asnInput);
    }

    static {
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetLogMultipleRecord;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetLogMultipleRecord = BBacnetLogMultipleRecord.class("[Ljavax.baja.bacnet.datatypes.BBacnetLogMultipleRecord;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

