/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.datatypes.BAddListElementAction;
import com.tridium.bacnet.datatypes.BRemoveListElementAction;
import com.tridium.bacnet.datatypes.ListManipulation;
import com.tridium.bacnet.services.error.NChangeListError;
import java.util.Vector;
import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDate;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.virtual.BBacnetVirtualProperty;
import javax.baja.bacnet.virtual.BacnetVirtualUtil;
import javax.baja.category.BCategoryMask;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAction;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetListOf
extends BComponent
implements BIBacnetDataType {
    public static final Property listTypeSpec = BBacnetListOf.newProperty((int)4, (BValue)BTypeSpec.DEFAULT, null);
    public static final Topic listPropertyChanged = BBacnetListOf.newTopic((int)0, null);
    public static final Type TYPE;
    protected boolean addActions;
    private int asnType;
    private boolean config;
    private boolean export;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetListOf;
    static /* synthetic */ Class class$javax$baja$sys$BEnum;

    public BTypeSpec getListTypeSpec() {
        return (BTypeSpec)this.get(listTypeSpec);
    }

    public void setListTypeSpec(BTypeSpec bTypeSpec) {
        this.set(listTypeSpec, (BValue)bTypeSpec, null);
    }

    public void fireListPropertyChanged(BValue bValue) {
        this.fire(listPropertyChanged, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (this.getParent() instanceof BBacnetObject) {
            this.config = true;
        }
        if (this.getParent() instanceof BIBacnetExportObject) {
            this.export = true;
        }
        if (this.addActions) {
            BAction bAction;
            if (this.get("addElement") == null) {
                bAction = new BAddListElementAction();
                bAction.setParameterTypeSpec(this.getListTypeSpec());
                this.add("addElement", (BValue)bAction, 2);
            }
            if (this.get("removeElement") == null) {
                bAction = new BRemoveListElementAction();
                bAction.setParameterTypeSpec(this.getListTypeSpec());
                this.add("removeElement", (BValue)bAction, 2);
            }
        }
    }

    public final void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (this.config || this.export || BacnetVirtualUtil.isVirtual(this)) {
            this.getParent().asComponent().changed(this.getPropertyInParent(), context);
        }
    }

    public final void added(Property property, Context context) {
        super.added(property, context);
        if (context == BacnetConst.noWrite) {
            return;
        }
        if (this.export) {
            this.getParent().asComponent().changed(this.getPropertyInParent(), context);
        }
    }

    public final void removed(Property property, BValue bValue, Context context) {
        super.removed(property, bValue, context);
        if (context == BacnetConst.noWrite) {
            return;
        }
        if (this.export) {
            this.getParent().asComponent().changed(this.getPropertyInParent(), context);
        }
    }

    public final void subscribed() {
        BBacnetVirtualProperty bBacnetVirtualProperty;
        if (this.config && !this.getParent().asComponent().isSubscribed()) {
            this.getParent().asComponent().subscribed();
        }
        if ((bBacnetVirtualProperty = BacnetVirtualUtil.getVirtualProperty(this)) != null) {
            bBacnetVirtualProperty.childSubscribed(this);
        }
    }

    public final void unsubscribed() {
        BBacnetVirtualProperty bBacnetVirtualProperty;
        if (this.config && !this.getParent().asComponent().isSubscribed()) {
            this.getParent().asComponent().unsubscribed();
        }
        if ((bBacnetVirtualProperty = BacnetVirtualUtil.getVirtualProperty(this)) != null) {
            bBacnetVirtualProperty.childUnsubscribed(this);
        }
    }

    public BCategoryMask getAppliedCategoryMask() {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getAppliedCategoryMask();
        }
        return super.getAppliedCategoryMask();
    }

    public BCategoryMask getCategoryMask() {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getCategoryMask();
        }
        return super.getCategoryMask();
    }

    public BPermissions getPermissions(Context context) {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getPermissions(context);
        }
        return super.getPermissions(context);
    }

    /*
     * Unable to fully structure code
     */
    public final ChangeListError addElements(byte[] var1_1, Context var2_2) {
        block8: {
            var3_3 = new Vector<BObject>();
            var4_4 = 1;
            try {
                var5_5 = new AsnInputStream(var1_1);
                var6_8 = var5_5.peekTag();
                var7_9 = this.getListType();
                if (!var7_9.is(BIBacnetDataType.TYPE)) ** GOTO lbl22
                while (var6_8 != -1) {
                    var8_10 = var7_9.getInstance();
                    ((BIBacnetDataType)var8_10).readAsn(var5_5);
                    var3_3.addElement(var8_10);
                    ++var4_4;
                    var6_8 = var5_5.peekTag();
                }
                break block8;
lbl-1000:
                // 1 sources

                {
                    var8_10 = var5_5.readAsn();
                    if (var7_9.is(BEnum.TYPE)) {
                        var8_10 = ((BEnum)var7_9.getInstance()).getRange().get(((BInteger)var8_10).getInt());
                    }
                    var3_3.addElement(var8_10);
                    ++var4_4;
                    var6_8 = var5_5.peekTag();
lbl22:
                    // 2 sources

                    ** while (var6_8 != -1)
                }
lbl23:
                // 1 sources

            }
            catch (AsnException var5_6) {
                return new NChangeListError(8, new NErrorType(2, 9), var4_4);
            }
        }
        try {
            var4_4 = 0;
            while (var4_4 < var3_3.size()) {
                this.addListElement((BValue)var3_3.get(var4_4), var2_2);
                ++var4_4;
            }
            return null;
        }
        catch (PermissionException var5_7) {
            return new NChangeListError(8, new NErrorType(2, 40), 0L);
        }
    }

    /*
     * Unable to fully structure code
     */
    public final ChangeListError removeElements(byte[] var1_1, Context var2_2) {
        block10: {
            var3_3 = new Vector<BObject>();
            var4_4 = 1;
            try {
                var5_5 = new AsnInputStream(var1_1);
                var6_8 = var5_5.peekTag();
                var7_9 = this.getListType();
                if (!var7_9.is(BIBacnetDataType.TYPE)) ** GOTO lbl22
                while (var6_8 != -1) {
                    var8_10 = var7_9.getInstance();
                    ((BIBacnetDataType)var8_10).readAsn(var5_5);
                    var3_3.addElement(var8_10);
                    ++var4_4;
                    var6_8 = var5_5.peekTag();
                }
                break block10;
lbl-1000:
                // 1 sources

                {
                    var8_10 = var5_5.readAsn();
                    if (var7_9.is(BEnum.TYPE)) {
                        var8_10 = ((BEnum)var7_9.getInstance()).getRange().get(((BInteger)var8_10).getInt());
                    }
                    var3_3.addElement(var8_10);
                    ++var4_4;
                    var6_8 = var5_5.peekTag();
lbl22:
                    // 2 sources

                    ** while (var6_8 != -1)
                }
lbl23:
                // 1 sources

            }
            catch (AsnException var5_6) {
                return new NChangeListError(9, new NErrorType(2, 9), var4_4);
            }
        }
        try {
            var4_4 = 1;
            while (var4_4 <= var3_3.size()) {
                if (!this.contains((BValue)var3_3.get(var4_4 - 1))) {
                    return new NChangeListError(9, new NErrorType(5, 81), var4_4);
                }
                ++var4_4;
            }
            var4_4 = 0;
            while (var4_4 < var3_3.size()) {
                this.removeListElement((BValue)var3_3.get(var4_4), var2_2);
                ++var4_4;
            }
            return null;
        }
        catch (PermissionException var5_7) {
            return new NChangeListError(9, new NErrorType(2, 40), 0L);
        }
    }

    public final boolean contains(BValue bValue) {
        SlotCursor slotCursor = this.getProperties();
        while (slotCursor.next()) {
            if (!slotCursor.get().equivalent((Object)bValue)) continue;
            return true;
        }
        return false;
    }

    public final Type getListType() {
        try {
            return this.getListTypeSpec().getResolvedType();
        }
        catch (Exception exception) {
            Log.getLog((String)"bacnet.debug").message("Exception resolving list type for " + this.getName() + ':' + exception, (Throwable)exception);
            return BBacnetNull.TYPE;
        }
    }

    public String toString(Context context) {
        if (context != null && context instanceof BasicContext) {
            return "List of " + this.getListTypeSpec();
        }
        this.loadSlots();
        StringBuffer stringBuffer = new StringBuffer("{");
        SlotCursor slotCursor = this.getProperties();
        while (slotCursor.next()) {
            if (!slotCursor.slot().isProperty() || !slotCursor.property().getType().getTypeSpec().equals((Object)this.getListTypeSpec()) && !slotCursor.property().getType().is(BOrd.TYPE)) continue;
            stringBuffer.append(slotCursor.get()).append(',');
        }
        if (stringBuffer.length() == 1) {
            return "{}";
        }
        stringBuffer.setCharAt(stringBuffer.length() - 1, '}');
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void writeAsn(AsnOutput asnOutput) {
        AsnOutput asnOutput2 = asnOutput;
        synchronized (asnOutput2) {
            SlotCursor slotCursor = this.getProperties();
            slotCursor.next();
            block20: while (slotCursor.next()) {
                try {
                    BObject bObject = slotCursor.get();
                    if (bObject instanceof BAction) continue;
                    if (bObject instanceof BOrd) {
                        bObject = ((BOrd)bObject).get((BObject)this);
                    }
                    if (bObject != null && bObject.getType() == this.getListType()) {
                        switch (this.asnType()) {
                            case 0: {
                                asnOutput.writeNull();
                                continue block20;
                            }
                            case 1: {
                                asnOutput.writeBoolean((BBoolean)bObject);
                                continue block20;
                            }
                            case 2: {
                                asnOutput.writeUnsigned((BBacnetUnsigned)bObject);
                                continue block20;
                            }
                            case 3: {
                                asnOutput.writeSignedInteger((BInteger)bObject);
                                continue block20;
                            }
                            case 4: {
                                asnOutput.writeReal((BNumber)((BFloat)bObject));
                                continue block20;
                            }
                            case 5: {
                                asnOutput.writeDouble((BNumber)((BDouble)bObject));
                                continue block20;
                            }
                            case 6: {
                                asnOutput.writeOctetString((BBacnetOctetString)bObject);
                                continue block20;
                            }
                            case 7: {
                                asnOutput.writeCharacterString((BString)bObject);
                                continue block20;
                            }
                            case 8: {
                                asnOutput.writeBitString((BBacnetBitString)bObject);
                                continue block20;
                            }
                            case 9: {
                                asnOutput.writeEnumerated((BEnum)bObject);
                                continue block20;
                            }
                            case 10: {
                                asnOutput.writeDate((BBacnetDate)bObject);
                                continue block20;
                            }
                            case 11: {
                                asnOutput.writeTime((BBacnetTime)bObject);
                                continue block20;
                            }
                            case 12: {
                                asnOutput.writeObjectIdentifier((BBacnetObjectIdentifier)bObject);
                                continue block20;
                            }
                        }
                        ((BIBacnetDataType)bObject).writeAsn(asnOutput);
                        Log.getLog((String)"bacnet").trace(this.getName() + ':' + this + ": writeAsn: constructed data type: listElem=" + bObject + " t=" + bObject.getType() + ", list type=" + this.getListType());
                        continue;
                    }
                    Log.getLog((String)"bacnet").warning(this.getName() + ':' + this + ": writeAsn: listElem is null or type mismatch!");
                    System.out.println("listElem=" + bObject + " t=" + bObject.getType() + ", list type=" + this.getListType());
                    continue;
                }
                catch (Exception exception) {
                    Log.getLog((String)"bacnet").warning(this.getName() + ':' + this + ": writeAsn: Exception!", (Throwable)exception);
                    continue;
                }
                break;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void readAsn(AsnInput var1_1) throws AsnException {
        var2_2 = new Vector<BSimple>();
        var3_3 = var1_1;
        synchronized (var3_3) {
            while (true) {
                block22: {
                    if (var1_1.peekTag() != -1) break block22;
                    // MONITOREXIT @DISABLED, blocks:[1, 18] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                    var5_5 = 0;
                    var6_6 = var2_2.iterator();
                    if (true) ** GOTO lbl71
                }
                var5_4 = null;
                switch (this.asnType()) {
                    case 0: {
                        var5_4 = var1_1.readNull();
                        break;
                    }
                    case 1: {
                        var5_4 = BBoolean.make((boolean)var1_1.readBoolean());
                        break;
                    }
                    case 2: {
                        var5_4 = var1_1.readUnsigned();
                        break;
                    }
                    case 3: {
                        var5_4 = BInteger.make((int)var1_1.readSignedInteger());
                        break;
                    }
                    case 4: {
                        var5_4 = BFloat.make((float)var1_1.readReal());
                        break;
                    }
                    case 5: {
                        var5_4 = BDouble.make((double)var1_1.readDouble());
                        break;
                    }
                    case 6: {
                        var5_4 = BBacnetOctetString.make(var1_1.readOctetString());
                        break;
                    }
                    case 7: {
                        var5_4 = BString.make((String)var1_1.readCharacterString());
                        break;
                    }
                    case 8: {
                        var5_4 = var1_1.readBitString();
                        break;
                    }
                    case 9: {
                        var6_6 = (BEnum)this.getListType().getInstance();
                        var5_4 = var6_6.getRange().get(var1_1.readEnumerated());
                        break;
                    }
                    case 10: {
                        var5_4 = var1_1.readDate();
                        break;
                    }
                    case 11: {
                        var5_4 = var1_1.readTime();
                        break;
                    }
                    case 12: {
                        var5_4 = var1_1.readObjectIdentifier();
                        break;
                    }
                    default: {
                        var5_4 = (BValue)this.getListType().getInstance();
                        ((BIBacnetDataType)var5_4).readAsn(var1_1);
                    }
                }
                if (var5_4 == null) continue;
                if (!var5_4.getType().getTypeName().equals(this.getListTypeSpec().getTypeName())) {
                    throw new AsnException("Invalid data type for list element: expected=" + this.getListTypeSpec().getTypeName() + " actual=" + var5_4.getType().getTypeName());
                }
                var2_2.add(var5_4);
            }
        }
        do {
            var7_7 = (BValue)var6_6.next();
            var8_8 = this.name(var5_5++);
            BacUtil.setOrAdd(this, var8_8, var7_7, BacnetConst.noWrite);
lbl71:
            // 2 sources

        } while (var6_6.hasNext());
        var7_7 = this.getProperty(this.name(var5_5++));
        while (var7_7 != null) {
            this.remove((Property)var7_7, BacnetConst.noWrite);
            var7_7 = this.getProperty(this.name(var5_5++));
        }
    }

    public Property addListElement(BValue bValue, Context context) {
        if (this.config) {
            BBacnetObject bBacnetObject = (BBacnetObject)this.getParent();
            bBacnetObject.postAsync(new ListManipulation(bBacnetObject, this.getPropertyInParent(), bValue, true));
            bBacnetObject.upload(new BUploadParameters());
            return null;
        }
        if (bValue.getType().is(this.getListType())) {
            if (!this.contains(bValue)) {
                return this.add(null, bValue, context);
            }
            return null;
        }
        if (bValue instanceof BOrd) {
            return this.add(null, bValue, 2, context);
        }
        Log.getLog((String)"bacnet").error(this + ".addListElement:Wrong element type: this is a list of " + this.getListType().getTypeName());
        return null;
    }

    public void removeListElement(BValue bValue, Context context) {
        if (this.config) {
            BBacnetObject bBacnetObject = (BBacnetObject)this.getParent();
            bBacnetObject.postAsync(new ListManipulation(bBacnetObject, this.getPropertyInParent(), bValue, false));
            bBacnetObject.upload(new BUploadParameters());
            return;
        }
        SlotCursor slotCursor = this.getProperties();
        while (slotCursor.next()) {
            if (!slotCursor.get().equivalent((Object)bValue)) continue;
            this.remove(slotCursor.property(), context);
            return;
        }
    }

    private final int asnType() {
        Type type = this.getListType();
        if (type == BBacnetNull.TYPE) {
            this.asnType = 0;
        } else if (type == BBoolean.TYPE) {
            this.asnType = 1;
        } else if (type == BBacnetUnsigned.TYPE) {
            this.asnType = 2;
        } else if (type == BInteger.TYPE) {
            this.asnType = 3;
        } else if (type == BFloat.TYPE) {
            this.asnType = 4;
        } else if (type == BDouble.TYPE) {
            this.asnType = 5;
        } else if (type == BBacnetOctetString.TYPE) {
            this.asnType = 6;
        } else if (type == BString.TYPE) {
            this.asnType = 7;
        } else if (type == BBacnetBitString.TYPE) {
            this.asnType = 8;
        } else {
            Class clazz = class$javax$baja$sys$BEnum;
            if (clazz == null) {
                clazz = class$javax$baja$sys$BEnum = BBacnetListOf.class("[Ljavax.baja.sys.BEnum;", false);
            }
            this.asnType = clazz.isAssignableFrom(type.getTypeClass()) ? 9 : (type == BBacnetDate.TYPE ? 10 : (type == BBacnetTime.TYPE ? 11 : (type == BBacnetObjectIdentifier.TYPE ? 12 : -1)));
        }
        return this.asnType;
    }

    private final String name(int n) {
        String string = this.getListTypeSpec().getTypeName();
        if (n == 0) {
            return string;
        }
        return string + n;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetListOf", 2);
        spyWriter.prop((Object)"asnType", this.asnType);
        spyWriter.prop((Object)"config", this.config);
        spyWriter.prop((Object)"export", this.export);
        spyWriter.prop((Object)"virtual", BacnetVirtualUtil.isVirtual(this));
        spyWriter.endProps();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.addActions = true;
    }

    public BBacnetListOf() {
        this.this();
    }

    public BBacnetListOf(Type type) {
        this.this();
        this.setListTypeSpec(BTypeSpec.make((Type)type));
    }

    static {
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetListOf;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetListOf = BBacnetListOf.class("[Ljavax.baja.bacnet.datatypes.BBacnetListOf;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

