/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetRecipientProcess;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.naming.SlotPath;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BNumber;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBacnetCovSubscription
extends BStruct
implements BIBacnetDataType {
    public static final Property recipient = BBacnetCovSubscription.newProperty((int)0, (BValue)new BBacnetRecipientProcess(), null);
    public static final Property monitoredPropertyReference = BBacnetCovSubscription.newProperty((int)0, (BValue)new BBacnetObjectPropertyReference(), null);
    public static final Property issueConfirmedNotifications = BBacnetCovSubscription.newProperty((int)0, (boolean)false, null);
    public static final Property subscriptionEndTime = BBacnetCovSubscription.newProperty((int)0, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((BFacets)BFacets.make((String)"showSeconds", (boolean)true), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)true)));
    public static final Property covIncrement = BBacnetCovSubscription.newProperty((int)0, (BValue)BFloat.NaN, null);
    public static final Type TYPE;
    public static final int RECIPIENT_TAG = 0;
    public static final int MONITORED_PROPERTY_REFERENCE_TAG = 1;
    public static final int ISSUE_CONFIRMED_NOTIFICATIONS_TAG = 2;
    public static final int TIME_REMAINING_TAG = 3;
    public static final int COV_INCREMENT_TAG = 4;
    public static final int MAX_ENCODED_SIZE = 44;
    private Clock.Ticket ticket;
    private boolean covProperty;
    private BValue lastPropValue;
    private PropertyValue lastPropertyValue;
    private BStatus lastStatusFlags;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetCovSubscription;

    public final BBacnetRecipientProcess getRecipient() {
        return (BBacnetRecipientProcess)this.get(recipient);
    }

    public final void setRecipient(BBacnetRecipientProcess bBacnetRecipientProcess) {
        this.set(recipient, (BValue)bBacnetRecipientProcess, null);
    }

    public final BBacnetObjectPropertyReference getMonitoredPropertyReference() {
        return (BBacnetObjectPropertyReference)this.get(monitoredPropertyReference);
    }

    public final void setMonitoredPropertyReference(BBacnetObjectPropertyReference bBacnetObjectPropertyReference) {
        this.set(monitoredPropertyReference, (BValue)bBacnetObjectPropertyReference, null);
    }

    public final boolean getIssueConfirmedNotifications() {
        return this.getBoolean(issueConfirmedNotifications);
    }

    public final void setIssueConfirmedNotifications(boolean bl) {
        this.setBoolean(issueConfirmedNotifications, bl, null);
    }

    public final BAbsTime getSubscriptionEndTime() {
        return (BAbsTime)this.get(subscriptionEndTime);
    }

    public final void setSubscriptionEndTime(BAbsTime bAbsTime) {
        this.set(subscriptionEndTime, (BValue)bAbsTime, null);
    }

    public final float getCovIncrement() {
        return this.getFloat(covIncrement);
    }

    public final void setCovIncrement(float f) {
        this.setFloat(covIncrement, f, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final BStatusValue getLastValue() {
        return this.covProperty ? null : (BStatusValue)this.lastPropValue;
    }

    public final void setLastValue(BStatusValue bStatusValue) {
        this.lastPropValue = bStatusValue.newCopy();
    }

    public final BValue getLastPropValue() {
        return this.lastPropValue;
    }

    public final void setLastPropValue(BValue bValue) {
        this.lastPropValue = bValue.newCopy();
    }

    public final PropertyValue getLastPropertyValue() {
        return this.lastPropertyValue;
    }

    public final void setLastPropertyValue(PropertyValue propertyValue) {
        this.lastPropertyValue = propertyValue;
    }

    public final Clock.Ticket getTicket() {
        return this.ticket;
    }

    public final void setTicket(Clock.Ticket ticket) {
        this.ticket = ticket;
    }

    public final int getTimeRemaining() {
        if (this.getSubscriptionEndTime().equals((Object)BAbsTime.NULL)) {
            return 0;
        }
        long l = BAbsTime.make().getMillis();
        int n = (int)((this.getSubscriptionEndTime().getMillis() - l) / 1000L);
        return n > 0 ? n : -1;
    }

    public final String toString(Context context) {
        if (context != null && context.equals(BacnetConst.nameContext)) {
            return this.getNameString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.covProperty ? "CovPSub " : "CovSub ").append(this.getRecipient().toString(context)).append('{').append(this.getMonitoredPropertyReference().toString(context));
        if (this.covProperty) {
            stringBuffer.append(':').append(this.getCovIncrement());
        }
        stringBuffer.append(this.getIssueConfirmedNotifications() ? "} C until " : "} U until ").append(this.getSubscriptionEndTime());
        return stringBuffer.toString();
    }

    public final boolean isCovIncrementUsed() {
        return Float.isNaN(this.getCovIncrement()) ^ true;
    }

    public final boolean isCovProperty() {
        return this.covProperty;
    }

    public final void setCovProperty(boolean bl) {
        this.covProperty = bl;
    }

    public final int getLastStatusBits() {
        BStatus bStatus = this.getLastStatusFlags();
        if (bStatus != null) {
            return bStatus.getBits();
        }
        return 0;
    }

    public final void setLastStatusBits(int n) {
        this.lastStatusFlags = BStatus.make((int)(n & 0x2B));
    }

    public final void setLastStatusFlags(BStatus bStatus) {
        this.lastStatusFlags = BStatus.make((int)(bStatus.getBits() & 0x2B));
    }

    public final BStatus getLastStatusFlags() {
        return this.lastStatusFlags;
    }

    private final void setTimeRemaining(long l) {
        this.set(subscriptionEndTime, (BValue)BAbsTime.make().add(BRelTime.make((long)(l * 1000L))), BacnetConst.noWrite);
    }

    private final String getNameString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.covProperty ? "covP_" : "cov_").append(SlotPath.unescape((String)this.getRecipient().toString(BacnetConst.nameContext))).append("_").append(this.getMonitoredPropertyReference().toString(BacnetConst.nameContext));
        if (this.covProperty) {
            stringBuffer.append('_').append(this.getCovIncrement());
        }
        return SlotPath.escape((String)stringBuffer.toString());
    }

    public final void writeAsn(AsnOutput asnOutput) {
        asnOutput.writeOpeningTag(0);
        this.getRecipient().writeAsn(asnOutput);
        asnOutput.writeClosingTag(0);
        asnOutput.writeOpeningTag(1);
        this.getMonitoredPropertyReference().writeAsn(asnOutput);
        asnOutput.writeClosingTag(1);
        asnOutput.writeBoolean(2, this.getIssueConfirmedNotifications());
        asnOutput.writeUnsignedInteger(3, this.getTimeRemaining());
        if (this.isCovIncrementUsed()) {
            asnOutput.writeReal(4, this.getCovIncrement());
        }
    }

    public final void readAsn(AsnInput asnInput) throws AsnException {
        int n = asnInput.peekTag();
        if (!asnInput.isOpeningTag(0)) {
            throw new AsnException("Invalid tag: " + n);
        }
        asnInput.skipTag();
        this.getRecipient().readAsn(asnInput);
        asnInput.skipTag();
        n = asnInput.peekTag();
        if (!asnInput.isOpeningTag(1)) {
            throw new AsnException("Invalid tag: " + n);
        }
        asnInput.skipTag();
        this.getMonitoredPropertyReference().readAsn(asnInput);
        asnInput.skipTag();
        this.setBoolean(issueConfirmedNotifications, asnInput.readBoolean(2), BacnetConst.noWrite);
        this.setTimeRemaining(asnInput.readUnsignedInteger(3));
        asnInput.peekTag();
        if (asnInput.isValueTag(4)) {
            this.setFloat(covIncrement, asnInput.readReal(4), BacnetConst.noWrite);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.covProperty = false;
        this.lastPropValue = null;
        this.lastPropertyValue = null;
        this.lastStatusFlags = null;
    }

    public BBacnetCovSubscription() {
        this.this();
    }

    public BBacnetCovSubscription(BBacnetAddress bBacnetAddress, long l, BBacnetObjectIdentifier bBacnetObjectIdentifier, boolean bl) {
        this.this();
        this.getRecipient().getRecipient().setRecipient((BValue)bBacnetAddress);
        this.getRecipient().setProcessIdentifier(BBacnetUnsigned.make(l));
        this.getMonitoredPropertyReference().setObjectId(bBacnetObjectIdentifier);
        this.setIssueConfirmedNotifications(bl);
    }

    public BBacnetCovSubscription(BBacnetAddress bBacnetAddress, long l, BBacnetObjectIdentifier bBacnetObjectIdentifier, PropertyReference propertyReference, boolean bl, BNumber bNumber) {
        this.this();
        this.getRecipient().getRecipient().setRecipient((BValue)bBacnetAddress);
        this.getRecipient().setProcessIdentifier(BBacnetUnsigned.make(l));
        this.getMonitoredPropertyReference().setObjectId(bBacnetObjectIdentifier);
        this.getMonitoredPropertyReference().setPropertyId(propertyReference.getPropertyId());
        this.getMonitoredPropertyReference().setPropertyArrayIndex(propertyReference.getPropertyArrayIndex());
        this.setIssueConfirmedNotifications(bl);
        this.setCovIncrement(bNumber != null ? bNumber.getFloat() : Float.NaN);
    }

    static {
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetCovSubscription;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetCovSubscription = BBacnetCovSubscription.class("[Ljavax.baja.bacnet.datatypes.BBacnetCovSubscription;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

