/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBacnetBitString
extends BSimple {
    public static final BBacnetBitString DEFAULT = new BBacnetBitString(new boolean[0], BFacets.NULL);
    public static final Type TYPE;
    private boolean[] bits;
    private BFacets tags;
    private int hashCode;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetBitString;

    public static final BBacnetBitString make(boolean[] blArray, BFacets bFacets) {
        boolean[] blArray2 = new boolean[blArray.length];
        System.arraycopy(blArray, 0, blArray2, 0, blArray2.length);
        return new BBacnetBitString(blArray2, bFacets);
    }

    public static final BBacnetBitString make(boolean[] blArray) {
        boolean[] blArray2 = new boolean[blArray.length];
        System.arraycopy(blArray, 0, blArray2, 0, blArray2.length);
        return new BBacnetBitString(blArray2, BFacets.NULL);
    }

    public static final BBacnetBitString make(BBacnetBitString bBacnetBitString, int n, boolean bl) {
        boolean[] blArray = new boolean[bBacnetBitString.bits.length];
        System.arraycopy(bBacnetBitString.bits, 0, blArray, 0, bBacnetBitString.bits.length);
        blArray[n] = bl;
        return new BBacnetBitString(blArray, bBacnetBitString.tags);
    }

    public final boolean equals(Object object) {
        if (object instanceof BBacnetBitString) {
            boolean[] blArray = ((BBacnetBitString)((Object)object)).bits;
            if (this.bits.length != blArray.length) {
                return false;
            }
            int n = 0;
            while (n < this.bits.length) {
                if (blArray[n] != this.bits[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public final String toString(Context context) {
        return this.getActiveTags(context);
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.bits.length);
        int n = 0;
        while (n < this.bits.length) {
            dataOutput.writeBoolean(this.bits[n]);
            ++n;
        }
        this.tags.encode(dataOutput);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            blArray[n2] = dataInput.readBoolean();
            ++n2;
        }
        BFacets bFacets = (BFacets)BFacets.DEFAULT.decode(dataInput);
        return new BBacnetBitString(blArray, bFacets);
    }

    public final String encodeToString() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getCompleteString());
        stringBuffer.append(':');
        stringBuffer.append(this.tags.encodeToString());
        return stringBuffer.toString();
    }

    public final BObject decodeFromString(String string) throws IOException {
        BFacets bFacets = BFacets.NULL;
        int n = string.indexOf(":");
        int n2 = -1;
        if (n < 0) {
            n = string.length();
        } else {
            n2 = n + 1;
        }
        boolean[] blArray = new boolean[n];
        int n3 = 0;
        while (n3 < n) {
            boolean bl = false;
            if (string.charAt(n3) == '1') {
                bl = true;
            }
            blArray[n3] = bl;
            ++n3;
        }
        if (n2 > 0) {
            String string2 = string.substring(n + 1);
            bFacets = (BFacets)BFacets.DEFAULT.decodeFromString(string2);
        }
        return new BBacnetBitString(blArray, bFacets);
    }

    public final int length() {
        return this.bits.length;
    }

    public final boolean getBit(int n) {
        try {
            return this.bits[n];
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid index (" + n + ") in getBit()!!");
        }
    }

    public final boolean[] getBits() {
        boolean[] blArray = new boolean[this.bits.length];
        System.arraycopy(this.bits, 0, blArray, 0, this.bits.length);
        return blArray;
    }

    public final String getActiveTags(Context context) {
        Context context2 = context;
        if (context2 == null) {
            context2 = this.tags;
        }
        if (context2 != null && !context2.equals(BFacets.NULL)) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.bits.length) {
                if (this.bits[n]) {
                    BObject bObject = context2.getFacet("bit" + String.valueOf(n));
                    if (bObject == null) {
                        return this.getCompleteString();
                    }
                    stringBuffer.append(bObject);
                    stringBuffer.append(";");
                }
                ++n;
            }
            if (stringBuffer.length() > 0) {
                return stringBuffer.substring(0, stringBuffer.length() - 1);
            }
            return "none";
        }
        return this.getCompleteString();
    }

    public final String getCompleteTagList(Context context) {
        Context context2 = context;
        if (context2 == null) {
            context2 = this.tags;
        }
        if (context2 != null && !context2.equals(BFacets.NULL)) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.bits.length) {
                stringBuffer.append(context2.getFacet("bit" + String.valueOf(n)));
                stringBuffer.append("=" + this.bits[n] + ';');
                ++n;
            }
            if (stringBuffer.length() > 0) {
                return stringBuffer.substring(0, stringBuffer.length() - 1);
            }
            return "none";
        }
        return this.getCompleteString();
    }

    public final String getCompleteString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.bits.length) {
            stringBuffer.append(this.bits[n] + 48);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static final BBacnetBitString emptyBitString(int n) {
        return BBacnetBitString.make(new boolean[n]);
    }

    private final void getHashCode() {
        int n = this.bits.length;
        int n2 = n / 32;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            int n5 = 0;
            while (n5 < 32) {
                int n6 = n3 * 32 + n5;
                if (n6 >= n) break;
                if (this.bits[n6]) {
                    n4 |= 1 << n5;
                }
                ++n5;
            }
            this.hashCode ^= n4;
            ++n3;
        }
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BBacnetBitString(boolean[] blArray, BFacets bFacets) {
        this.bits = blArray;
        this.tags = bFacets;
        this.getHashCode();
    }

    static {
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetBitString;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetBitString = BBacnetBitString.class("[Ljavax.baja.bacnet.datatypes.BBacnetBitString;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

