/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.datatypes.BAddArrayElementAction;
import com.tridium.bacnet.datatypes.BRemoveArrayElementAction;
import java.util.Vector;
import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDate;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.util.GrandchildChangedContext;
import javax.baja.bacnet.virtual.BBacnetVirtualProperty;
import javax.baja.bacnet.virtual.BacnetVirtualUtil;
import javax.baja.category.BCategoryMask;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.security.BPermissions;
import javax.baja.spy.SpyWriter;
import javax.baja.sync.Transaction;
import javax.baja.sys.Action;
import javax.baja.sys.BAction;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetArray
extends BComponent
implements BIBacnetDataType {
    public static final Property arrayTypeSpec = BBacnetArray.newProperty((int)4, (BValue)BTypeSpec.DEFAULT, null);
    public static final Property size = BBacnetArray.newProperty((int)4, (int)0, null);
    public static final Property fixedSize = BBacnetArray.newProperty((int)4, (boolean)false, null);
    public static final Action addElement = BBacnetArray.newAction((int)4, (BValue)BBacnetUnsigned.DEFAULT, null);
    public static final Action removeElement = BBacnetArray.newAction((int)4, (BValue)BInteger.make((int)0), null);
    public static final Topic arrayPropertyChanged = BBacnetArray.newTopic((int)0, null);
    public static final Type TYPE;
    public static final String ELEMENT_0 = "element0";
    private int asnType;
    private boolean config;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetArray;
    static /* synthetic */ Class class$javax$baja$sys$BEnum;

    public BTypeSpec getArrayTypeSpec() {
        return (BTypeSpec)this.get(arrayTypeSpec);
    }

    public void setArrayTypeSpec(BTypeSpec bTypeSpec) {
        this.set(arrayTypeSpec, (BValue)bTypeSpec, null);
    }

    public int getSize() {
        return this.getInt(size);
    }

    public void setSize(int n) {
        this.setInt(size, n, null);
    }

    public boolean getFixedSize() {
        return this.getBoolean(fixedSize);
    }

    public void setFixedSize(boolean bl) {
        this.setBoolean(fixedSize, bl, null);
    }

    public void addElement(BValue bValue) {
        this.invoke(addElement, bValue, null);
    }

    public void removeElement(BInteger bInteger) {
        this.invoke(removeElement, (BValue)bInteger, null);
    }

    public void fireArrayPropertyChanged(BValue bValue) {
        this.fire(arrayPropertyChanged, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void started() {
        if (this.getParent() instanceof BBacnetObject) {
            this.config = true;
        }
        this.checkSize(true, null);
        if (!this.getFixedSize()) {
            BAction bAction;
            if (this.get("addArrayElement") == null) {
                bAction = new BAddArrayElementAction();
                bAction.setParameterTypeSpec(this.getArrayTypeSpec());
                this.add("addArrayElement", (BValue)bAction, 2);
            }
            if (this.get("removeArrayElement") == null) {
                bAction = new BRemoveArrayElementAction();
                bAction.setParameterTypeSpec(BDynamicEnum.TYPE.getTypeSpec());
                this.add("removeArrayElement", (BValue)bAction, 2);
            }
        }
    }

    public final void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)size)) {
            Property property2 = this.getProperty(ELEMENT_0);
            if (property2 != null) {
                this.setInt(property2, this.getSize(), context);
            }
            if (context != BacnetConst.noWrite) {
                this.checkSize(true, context);
            }
        } else if (!property.equals((Object)fixedSize) && !property.equals((Object)arrayTypeSpec) && !property.getName().equals(ELEMENT_0) && property.getName().startsWith("element") && context != BacnetConst.noWrite) {
            if (this.config) {
                try {
                    ((BBacnetObject)this.getParent()).writeProperty(this.getPropertyInParent(), this.index(property), AsnUtil.toAsn(this.asnType(), this.get(property)));
                }
                catch (BacnetException bacnetException) {
                    Log.getLog((String)"bacnet.client").warning("Unable to write array element " + this.index(property) + " in property " + this.getPropertyInParent() + " of " + this.getParent() + ':' + (Object)((Object)bacnetException));
                }
            } else if (BacnetVirtualUtil.isVirtual(this)) {
                this.getParent().asComponent().changed(this.getPropertyInParent(), (Context)new GrandchildChangedContext(this.index(property), AsnUtil.toAsn(this.asnType(), this.get(property))));
            }
        }
    }

    public final void subscribed() {
        BBacnetVirtualProperty bBacnetVirtualProperty;
        if (this.config && !this.getParent().asComponent().isSubscribed()) {
            this.getParent().asComponent().subscribed();
        }
        if ((bBacnetVirtualProperty = BacnetVirtualUtil.getVirtualProperty(this)) != null) {
            bBacnetVirtualProperty.childSubscribed(this);
        }
    }

    public void unsubscribed() {
        BBacnetVirtualProperty bBacnetVirtualProperty;
        if (this.config && !this.getParent().asComponent().isSubscribed()) {
            this.getParent().asComponent().unsubscribed();
        }
        if ((bBacnetVirtualProperty = BacnetVirtualUtil.getVirtualProperty(this)) != null) {
            bBacnetVirtualProperty.childUnsubscribed(this);
        }
    }

    public boolean isChildLegal(BComponent bComponent) {
        if (!this.isRunning()) {
            return true;
        }
        return bComponent.getType().is(this.getArrayTypeSpec().getTypeInfo());
    }

    public BCategoryMask getAppliedCategoryMask() {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getAppliedCategoryMask();
        }
        return super.getAppliedCategoryMask();
    }

    public BCategoryMask getCategoryMask() {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getCategoryMask();
        }
        return super.getCategoryMask();
    }

    public BPermissions getPermissions(Context context) {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getPermissions(context);
        }
        return super.getPermissions(context);
    }

    public final void doAddElement(BValue bValue) {
        if (this.getFixedSize()) {
            Log.getLog((String)"bacnet.debug").error(this + ".doAddElement:Fixed size array; can't add element!");
            return;
        }
        int n = this.getSize();
        if (bValue.getType() == this.getArrayType()) {
            this.add(this.name(n), bValue);
            this.setSize(++n);
            this.getParent().asComponent().changed(this.getPropertyInParent(), null);
        } else if (bValue instanceof BOrd) {
            this.add(this.name(n), bValue);
            this.setSize(++n);
        } else {
            Log.getLog((String)"bacnet.debug").error(this + ".doAddElement:Wrong element type: this is an array of " + this.getArrayType().getTypeName());
        }
    }

    public final void doRemoveElement(BInteger bInteger) {
        if (this.getFixedSize()) {
            Log.getLog((String)"bacnet.debug").error(this + ".doRemoveElement:Fixed size array; can't remove element!");
            return;
        }
        this.remove(this.name(bInteger.getInt()));
        this.reIndex();
        this.setSize(this.getSize() - 1);
        this.getParent().asComponent().changed(this.getPropertyInParent(), null);
    }

    public String toString(Context context) {
        this.loadSlots();
        if (context != null && context instanceof BasicContext) {
            return "BacnetARRAY[" + this.getSize() + "] of " + this.getArrayTypeSpec();
        }
        StringBuffer stringBuffer = new StringBuffer("{");
        int n = this.getSize();
        int n2 = 1;
        while (n2 <= n) {
            stringBuffer.append(this.getElement(n2)).append(',');
            ++n2;
        }
        if (stringBuffer.length() == 1) {
            return "{}";
        }
        stringBuffer.setCharAt(stringBuffer.length() - 1, '}');
        return stringBuffer.toString();
    }

    public final BValue getElement(int n) {
        if (n == 0) {
            return this.get(size);
        }
        return this.get(this.name(n - 1));
    }

    public final void setElement(int n, BValue bValue) {
        if (bValue.getType() == this.getArrayType() && n > 0 && n <= this.getSize()) {
            this.set(this.name(n - 1), bValue);
        }
    }

    public static int index(String string) {
        int n = (string = SlotPath.unescape((String)string)).indexOf(";");
        if (n < 0) {
            return Integer.parseInt(string.substring(7));
        }
        return Integer.parseInt(string.substring(7, n));
    }

    private final Type getArrayType() {
        try {
            return this.getArrayTypeSpec().getResolvedType();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private final int asnType() {
        Type type = this.getArrayType();
        if (type == BBacnetNull.TYPE) {
            this.asnType = 0;
        } else if (type == BBoolean.TYPE) {
            this.asnType = 1;
        } else if (type == BBacnetUnsigned.TYPE) {
            this.asnType = 2;
        } else if (type == BInteger.TYPE) {
            this.asnType = 3;
        } else if (type == BFloat.TYPE) {
            this.asnType = 4;
        } else if (type == BDouble.TYPE) {
            this.asnType = 5;
        } else if (type == BBacnetOctetString.TYPE) {
            this.asnType = 6;
        } else if (type == BString.TYPE) {
            this.asnType = 7;
        } else if (type == BBacnetBitString.TYPE) {
            this.asnType = 8;
        } else {
            Class clazz = class$javax$baja$sys$BEnum;
            if (clazz == null) {
                clazz = class$javax$baja$sys$BEnum = BBacnetArray.class("[Ljavax.baja.sys.BEnum;", false);
            }
            this.asnType = clazz.isAssignableFrom(type.getTypeClass()) ? 9 : (type == BBacnetDate.TYPE ? 10 : (type == BBacnetTime.TYPE ? 11 : (type == BBacnetObjectIdentifier.TYPE ? 12 : -1)));
        }
        return this.asnType;
    }

    private final synchronized void checkSize(boolean bl, Context context) {
        SlotCursor slotCursor = this.getProperties();
        int n = 0;
        while (slotCursor.next(this.getArrayType().getTypeClass())) {
            if (!slotCursor.property().isDynamic()) continue;
            ++n;
        }
        if (bl) {
            this.trimToSize(n, context);
        } else {
            this.setInt(size, n, context);
            Property property = this.getProperty(ELEMENT_0);
            if (property != null) {
                this.setInt(property, n, context);
            }
        }
    }

    private final void trimToSize(int n, Context context) {
        block3: {
            int n2;
            block2: {
                n2 = this.getSize();
                if (n2 >= n) break block2;
                int n3 = n2;
                while (n3 < n) {
                    this.remove(this.name(n3), context);
                    ++n3;
                }
                break block3;
            }
            if (n2 <= n) break block3;
            int n4 = n;
            while (n4 < n2) {
                this.add(this.name(n4), (BValue)this.getArrayType().getInstance(), context);
                ++n4;
            }
        }
    }

    private final String name(int n) {
        return "element" + (n + 1);
    }

    private final int index(Property property) {
        return Integer.parseInt(property.getName().substring(7));
    }

    private static final void copyFrom(BComponent bComponent, BComponent bComponent2, Context context) {
        Context context2 = Transaction.start((BComponent)bComponent2, (Context)context);
        Property[] propertyArray = bComponent2.getPropertiesArray();
        int n = propertyArray.length;
        while (--n >= 0) {
            if (!propertyArray[n].isDynamic()) continue;
            bComponent2.remove(propertyArray[n], context);
        }
        SlotCursor slotCursor = bComponent.getProperties();
        while (slotCursor.next()) {
            Property property = slotCursor.property();
            BValue bValue = (BValue)slotCursor.get();
            if (bValue instanceof BComplex) {
                bValue = bValue.newCopy(true);
            }
            if (bComponent2.get(property.getName()) != null) {
                bComponent2.set(property, bValue, context);
                continue;
            }
            bComponent2.asComponent().add(property.getName(), bValue, context);
        }
        try {
            Transaction.end((BComponent)bComponent2, (Context)context2);
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    private final void reIndex() {
        if (this.getFixedSize()) {
            return;
        }
        int n = this.getSize();
        int n2 = 1;
        while (n2 < n) {
            BValue bValue = this.getElement(n2);
            if (bValue == null) {
                int n3 = n2;
                while (bValue == null) {
                    if (n3 >= n) break;
                    bValue = this.getElement(++n3);
                }
                this.add(this.name(n2 - 1), bValue);
                this.remove(this.name(n3 - 1));
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void writeAsn(AsnOutput asnOutput) {
        AsnOutput asnOutput2 = asnOutput;
        synchronized (asnOutput2) {
            SlotCursor slotCursor = this.getProperties();
            block20: while (slotCursor.next()) {
                try {
                    BValue bValue = (BValue)slotCursor.get();
                    if (bValue instanceof BOrd) {
                        bValue = ((BOrd)bValue).get((BObject)this);
                    }
                    if (bValue == null || bValue.getType() != this.getArrayType()) continue;
                    switch (this.asnType()) {
                        case 0: {
                            asnOutput.writeNull();
                            continue block20;
                        }
                        case 1: {
                            asnOutput.writeBoolean((BBoolean)slotCursor.get());
                            continue block20;
                        }
                        case 2: {
                            asnOutput.writeUnsigned((BBacnetUnsigned)slotCursor.get());
                            continue block20;
                        }
                        case 3: {
                            asnOutput.writeSignedInteger((BInteger)slotCursor.get());
                            continue block20;
                        }
                        case 4: {
                            asnOutput.writeReal((BNumber)((BFloat)slotCursor.get()));
                            continue block20;
                        }
                        case 5: {
                            asnOutput.writeDouble((BNumber)((BDouble)slotCursor.get()));
                            continue block20;
                        }
                        case 6: {
                            asnOutput.writeOctetString((BBacnetOctetString)slotCursor.get());
                            continue block20;
                        }
                        case 7: {
                            asnOutput.writeCharacterString((BString)slotCursor.get());
                            continue block20;
                        }
                        case 8: {
                            asnOutput.writeBitString((BBacnetBitString)slotCursor.get());
                            continue block20;
                        }
                        case 9: {
                            asnOutput.writeEnumerated((BEnum)slotCursor.get());
                            continue block20;
                        }
                        case 10: {
                            asnOutput.writeDate((BBacnetDate)slotCursor.get());
                            continue block20;
                        }
                        case 11: {
                            asnOutput.writeTime((BBacnetTime)slotCursor.get());
                            continue block20;
                        }
                        case 12: {
                            asnOutput.writeObjectIdentifier((BBacnetObjectIdentifier)slotCursor.get());
                            continue block20;
                        }
                    }
                    ((BIBacnetDataType)slotCursor.get()).writeAsn(asnOutput);
                    continue;
                }
                catch (Exception exception) {
                    Log.getLog((String)"bacnet").warning(this.getName() + ':' + this + ": writeAsn: Exception!", (Throwable)exception);
                    continue;
                }
                break;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void readAsn(AsnInput var1_1) throws AsnException {
        var2_2 = this.getSubscribers();
        if (var2_2 == null || var2_2.length == 0) {
            var3_3 = this.getChildComponents();
            var4_4 = false;
            var5_6 = 0;
            while (var5_6 < ((BComponent[])var3_3).length) {
                if (var3_3[var5_6].isSubscribed()) {
                    var4_4 = true;
                    break;
                }
                ++var5_6;
            }
            if (!var4_4 && (var5_7 = this.getProperty("element0")) != null) {
                this.remove(var5_7);
            }
        }
        var3_3 = new Vector<E>();
        var4_5 = var1_1;
        synchronized (var4_5) {
            while (true) {
                block28: {
                    if (var1_1.peekTag() != -1) break block28;
                    // MONITOREXIT @DISABLED, blocks:[1, 19] lbl24 : MonitorExitStatement: MONITOREXIT : var4_5
                    var6_9 = 0;
                    var7_10 = var3_3.iterator();
                    if (true) ** GOTO lbl90
                }
                var6_8 = null;
                switch (this.asnType()) {
                    case 0: {
                        var6_8 = var1_1.readNull();
                        break;
                    }
                    case 1: {
                        var6_8 = BBoolean.make((boolean)var1_1.readBoolean());
                        break;
                    }
                    case 2: {
                        var6_8 = var1_1.readUnsigned();
                        break;
                    }
                    case 3: {
                        var6_8 = BInteger.make((int)var1_1.readSignedInteger());
                        break;
                    }
                    case 4: {
                        var6_8 = BFloat.make((float)var1_1.readReal());
                        break;
                    }
                    case 5: {
                        var6_8 = BDouble.make((double)var1_1.readDouble());
                        break;
                    }
                    case 6: {
                        var6_8 = BBacnetOctetString.make(var1_1.readOctetString());
                        break;
                    }
                    case 7: {
                        var6_8 = BString.make((String)var1_1.readCharacterString());
                        break;
                    }
                    case 8: {
                        var6_8 = var1_1.readBitString();
                        break;
                    }
                    case 9: {
                        var7_10 = (BEnum)this.getArrayType().getInstance();
                        var6_8 = var7_10.getRange().get(var1_1.readEnumerated());
                        break;
                    }
                    case 10: {
                        var6_8 = var1_1.readDate();
                        break;
                    }
                    case 11: {
                        var6_8 = var1_1.readTime();
                        break;
                    }
                    case 12: {
                        var6_8 = var1_1.readObjectIdentifier();
                        break;
                    }
                    default: {
                        var6_8 = (BValue)this.getArrayType().getInstance();
                        ((BIBacnetDataType)var6_8).readAsn(var1_1);
                    }
                }
                if (var6_8 == null) continue;
                var3_3.add(var6_8);
            }
        }
        do {
            var8_11 = (BValue)var7_10.next();
            if ((var10_13 = this.getProperty(var9_12 = this.name(var6_9++))) != null) {
                if (var10_13.getType().is(BSimple.TYPE)) {
                    this.set(var10_13, var8_11, BacnetConst.noWrite);
                    continue;
                }
                if (var10_13.getType().is(BComponent.TYPE)) {
                    BBacnetArray.copyFrom(var8_11.asComponent(), this.get(var10_13).asComponent(), BacnetConst.noWrite);
                    continue;
                }
                ((BComplex)this.get(var10_13)).copyFrom(var8_11.asComplex(), BacnetConst.noWrite);
                continue;
            }
            this.add(var9_12, var8_11, BacnetConst.noWrite);
lbl90:
            // 5 sources

        } while (var7_10.hasNext());
        var8_11 = this.getProperty(this.name(var6_9++));
        while (var8_11 != null) {
            this.remove((Property)var8_11, BacnetConst.noWrite);
            var8_11 = this.getProperty(this.name(var6_9++));
        }
        this.checkSize(false, BacnetConst.noWrite);
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetArray", 2);
        spyWriter.prop((Object)"asnType", this.asnType);
        spyWriter.prop((Object)"config", this.config);
        spyWriter.prop((Object)"virtual", BacnetVirtualUtil.isVirtual(this));
        spyWriter.endProps();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BBacnetArray() {
    }

    public BBacnetArray(Type type) {
        this.setArrayTypeSpec(BTypeSpec.make((Type)type));
    }

    public BBacnetArray(Type type, int n) {
        this.setArrayTypeSpec(BTypeSpec.make((Type)type));
        this.setFixedSize(true);
        this.setSize(n);
        this.checkSize(true, null);
    }

    static {
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetArray;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetArray = BBacnetArray.class("[Ljavax.baja.bacnet.datatypes.BBacnetArray;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

