/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import com.tridium.bacnet.asn.AsnInputStream;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDate;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.log.Log;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBacnetAny
extends BComponent
implements BIBacnetDataType {
    public static final Property choice = BBacnetAny.newProperty((int)4, (int)0, (BFacets)BFacets.makeInt((int)0, (int)12));
    public static final Property value = BBacnetAny.newProperty((int)0, (BValue)BBacnetNull.DEFAULT, null);
    public static final Type TYPE;
    private static final AsnInputStream asnIn;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetAny;

    public final int getChoice() {
        return this.getInt(choice);
    }

    public final void setChoice(int n) {
        this.setInt(choice, n, null);
    }

    public final BSimple getValue() {
        return (BSimple)this.get(value);
    }

    public final void setValue(BSimple bSimple) {
        this.set(value, (BValue)bSimple, null);
    }

    public final Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final BBacnetAny make(byte[] byArray) throws AsnException {
        BBacnetAny bBacnetAny = new BBacnetAny();
        AsnInputStream asnInputStream = asnIn;
        synchronized (asnInputStream) {
            asnIn.setBuffer(byArray);
            bBacnetAny.readAsn(asnIn);
            return bBacnetAny;
        }
    }

    public final void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isMounted() || !this.isRunning()) {
            return;
        }
        if (property == choice) {
            return;
        }
        this.getParent().asComponent().changed(this.getPropertyInParent(), context);
    }

    public final BSimple getAny() {
        return this.getValue();
    }

    public final void setAny(BSimple bSimple) {
        this.setAny((BValue)bSimple, null);
    }

    public final void setAny(BValue object, Context context) {
        Type type;
        if (object == null) {
            object = BBacnetNull.DEFAULT;
        }
        if ((type = object.getType()) == BBacnetNull.TYPE) {
            this.setInt(choice, 0, context);
        } else if (type == BBoolean.TYPE) {
            this.setInt(choice, 1, context);
        } else if (type == BBacnetUnsigned.TYPE) {
            this.setInt(choice, 2, context);
        } else if (type == BInteger.TYPE) {
            this.setInt(choice, 3, context);
        } else if (type == BFloat.TYPE) {
            this.setInt(choice, 4, context);
        } else if (type == BDouble.TYPE) {
            this.setInt(choice, 5, context);
        } else if (type == BBacnetOctetString.TYPE) {
            this.setInt(choice, 6, context);
        } else if (type == BString.TYPE) {
            this.setInt(choice, 7, context);
        } else if (type == BBacnetBitString.TYPE) {
            this.setInt(choice, 8, context);
        } else if (type.is(BEnum.TYPE)) {
            this.setInt(choice, 9, context);
        } else if (type == BBacnetDate.TYPE) {
            this.setInt(choice, 10, context);
        } else if (type == BBacnetTime.TYPE) {
            this.setInt(choice, 11, context);
        } else if (type == BBacnetObjectIdentifier.TYPE) {
            this.setInt(choice, 12, context);
        } else {
            throw new IllegalArgumentException("Invalid type for BBacnetAny:" + type);
        }
        this.set(value, (BValue)object, context);
    }

    public final void writeAsn(AsnOutput asnOutput) {
        switch (this.getChoice()) {
            case 0: {
                asnOutput.writeNull();
                break;
            }
            case 1: {
                asnOutput.writeBoolean((BBoolean)this.getValue());
                break;
            }
            case 2: {
                asnOutput.writeUnsigned((BBacnetUnsigned)this.getValue());
                break;
            }
            case 3: {
                asnOutput.writeSignedInteger((BInteger)this.getValue());
                break;
            }
            case 4: {
                asnOutput.writeReal((BNumber)((BFloat)this.getValue()));
                break;
            }
            case 5: {
                asnOutput.writeDouble((BNumber)((BDouble)this.getValue()));
                break;
            }
            case 6: {
                asnOutput.writeOctetString((BBacnetOctetString)this.getValue());
                break;
            }
            case 7: {
                asnOutput.writeCharacterString((BString)this.getValue());
                break;
            }
            case 8: {
                asnOutput.writeBitString((BBacnetBitString)this.getValue());
                break;
            }
            case 9: {
                asnOutput.writeEnumerated((BEnum)this.getValue());
                break;
            }
            case 10: {
                asnOutput.writeDate((BBacnetDate)this.getValue());
                break;
            }
            case 11: {
                asnOutput.writeTime((BBacnetTime)this.getValue());
                break;
            }
            case 12: {
                asnOutput.writeObjectIdentifier((BBacnetObjectIdentifier)this.getValue());
                break;
            }
            default: {
                throw new IllegalStateException("Invalid any type:" + this.getChoice());
            }
        }
    }

    public final void readAsn(AsnInput asnInput) throws AsnException {
        int n = asnInput.peekTag();
        switch (n) {
            case 0: {
                this.setAny((BValue)asnInput.readNull(), BacnetConst.noWrite);
                break;
            }
            case 1: {
                this.setAny((BValue)BBoolean.make((boolean)asnInput.readBoolean()), BacnetConst.noWrite);
                break;
            }
            case 2: {
                this.setAny((BValue)asnInput.readUnsigned(), BacnetConst.noWrite);
                break;
            }
            case 3: {
                this.setAny((BValue)asnInput.readSigned(), BacnetConst.noWrite);
                break;
            }
            case 4: {
                this.setAny((BValue)asnInput.readFloat(), BacnetConst.noWrite);
                break;
            }
            case 5: {
                this.setAny((BValue)BDouble.make((double)asnInput.readDouble()), BacnetConst.noWrite);
                break;
            }
            case 6: {
                this.setAny((BValue)asnInput.readBacnetOctetString(), BacnetConst.noWrite);
                break;
            }
            case 7: {
                this.setAny((BValue)BString.make((String)asnInput.readCharacterString()), BacnetConst.noWrite);
                break;
            }
            case 8: {
                this.setAny((BValue)asnInput.readBitString(), BacnetConst.noWrite);
                break;
            }
            case 9: {
                this.setAny((BValue)BDynamicEnum.make((int)asnInput.readEnumerated()), BacnetConst.noWrite);
                break;
            }
            case 10: {
                this.setAny((BValue)asnInput.readDate(), BacnetConst.noWrite);
                break;
            }
            case 11: {
                this.setAny((BValue)asnInput.readTime(), BacnetConst.noWrite);
                break;
            }
            case 12: {
                this.setAny((BValue)asnInput.readObjectIdentifier(), BacnetConst.noWrite);
                break;
            }
            default: {
                Log.getLog((String)"bacnet").error("Unknown any type: " + n);
            }
        }
    }

    public final String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(BBacnetAny.tag(this.getChoice(), context)).append(':').append(this.getAny().toString(context));
        return stringBuffer.toString();
    }

    public final String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(BBacnetAny.tag(this.getChoice(), null));
        stringBuffer.append(this.getAny().toString());
        return stringBuffer.toString();
    }

    private static final String tag(int n, Context context) {
        if (n < 0) {
            return "INVALID";
        }
        return BacnetConst.ASN_PRIMITIVE_TAGS[n];
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BBacnetAny() {
    }

    public BBacnetAny(BSimple bSimple) {
        this.setAny(bSimple);
    }

    static {
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetAny;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetAny = BBacnetAny.class("[Ljavax.baja.bacnet.datatypes.BBacnetAny;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        asnIn = new AsnInputStream();
    }
}

