/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import java.util.StringTokenizer;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BFacets;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBacnetAddress
extends BStruct
implements BIBacnetDataType {
    public static final Property addressType = BBacnetAddress.newProperty((int)4, (int)0, null);
    public static final Property networkNumber = BBacnetAddress.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)((char)-1)));
    public static final Property macAddress = BBacnetAddress.newProperty((int)0, (BValue)BBacnetOctetString.DEFAULT, null);
    public static final Type TYPE;
    public static final int LOCAL_NETWORK = 0;
    public static final int BROADCAST_NETWORK = 65535;
    public static final int NETWORK_NUMBER_MASK = 65535;
    public static final int MAC_TYPE_UNKNOWN = 0;
    public static final int MAC_TYPE_ETHERNET = 1;
    public static final int MAC_TYPE_IP = 2;
    public static final int MAC_TYPE_MSTP = 3;
    public static final BBacnetAddress GLOBAL_BROADCAST_ADDRESS;
    public static final BBacnetAddress LOCAL_BROADCAST_ADDRESS;
    public static final BBacnetAddress DEFAULT;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetAddress;

    public final int getAddressType() {
        return this.getInt(addressType);
    }

    public final void setAddressType(int n) {
        this.setInt(addressType, n, null);
    }

    public final int getNetworkNumber() {
        return this.getInt(networkNumber);
    }

    public final void setNetworkNumber(int n) {
        this.setInt(networkNumber, n, null);
    }

    public final BBacnetOctetString getMacAddress() {
        return (BBacnetOctetString)this.get(macAddress);
    }

    public final void setMacAddress(BBacnetOctetString bBacnetOctetString) {
        this.set(macAddress, (BValue)bBacnetOctetString, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final void setMac(byte[] byArray, Context context) {
        this.set(macAddress, (BValue)BBacnetOctetString.make(byArray), context);
    }

    public final int hash() {
        return 31 * this.getNetworkNumber() + this.getMacAddress().hashCode();
    }

    public final String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (context != null && ((bl = context.equals(BacnetConst.nameContext)) || context.equals(BacnetConst.deviceRegistryContext))) {
            stringBuffer.append('_').append(this.getNetworkNumber()).append('_');
            stringBuffer.append(this.getMacAddress().toString(context));
            String string = stringBuffer.toString();
            return bl ? SlotPath.escape((String)string) : string;
        }
        stringBuffer.append(this.getNetworkNumber()).append(':');
        byte[] byArray = this.getMacAddress().getBytes();
        if (byArray == null) {
            stringBuffer.append("null");
        } else {
            switch (this.getAddressType()) {
                case 1: {
                    int n = 0;
                    while (n < byArray.length) {
                        stringBuffer.append(TextUtil.byteToHexString((int)byArray[n])).append(' ');
                        ++n;
                    }
                    stringBuffer.setLength(stringBuffer.length() - 1);
                    break;
                }
                case 2: {
                    stringBuffer.append(byArray[0] & 0xFF).append('.');
                    stringBuffer.append(byArray[1] & 0xFF).append('.');
                    stringBuffer.append(byArray[2] & 0xFF).append('.');
                    stringBuffer.append(byArray[3] & 0xFF).append(':');
                    stringBuffer.append((byArray[4] & 0xFF) << 8 | byArray[5] & 0xFF);
                    break;
                }
                case 0: 
                case 3: {
                    int n = 0;
                    while (n < byArray.length) {
                        stringBuffer.append(TextUtil.byteToHexString((int)byArray[n])).append(' ');
                        ++n;
                    }
                    stringBuffer.setLength(stringBuffer.length() - 1);
                    break;
                }
                default: {
                    stringBuffer.append(this.getMacAddress().toString(context));
                }
            }
        }
        return stringBuffer.toString();
    }

    public final void writeAsn(AsnOutput asnOutput) {
        asnOutput.writeUnsignedInteger(this.getNetworkNumber());
        byte[] byArray = this.getMacAddress().getBytes();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        asnOutput.writeOctetString(byArray);
    }

    public final void readAsn(AsnInput asnInput) throws AsnException {
        this.setInt(networkNumber, asnInput.readUnsignedInt(), BacnetConst.noWrite);
        this.set(macAddress, (BValue)BBacnetOctetString.make(asnInput.readOctetString()), BacnetConst.noWrite);
    }

    public final boolean equals(int n, byte[] byArray) {
        if (n != this.getNetworkNumber()) {
            return false;
        }
        byte[] byArray2 = this.getMacAddress().getBytes();
        if (byArray == null && byArray2 != null) {
            return false;
        }
        if (byArray != null && byArray2 == null) {
            return false;
        }
        if (byArray == null && byArray2 == null) {
            return true;
        }
        int n2 = byArray2.length;
        if (byArray.length != n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (byArray[n3] != byArray2[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public final boolean macEquals(byte[] byArray) {
        byte[] byArray2 = this.getMacAddress().getBytes();
        if (byArray == null && byArray2 != null) {
            return false;
        }
        if (byArray != null && byArray2 == null) {
            return false;
        }
        if (byArray == null && byArray2 == null) {
            return true;
        }
        int n = byArray2.length;
        if (byArray.length != n) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static final String bytesToString(int n, byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        switch (n) {
            case 1: {
                if (byArray.length != 6) {
                    throw new IllegalArgumentException("Invalid Ethernet MAC address!");
                }
                int n2 = 0;
                while (n2 < 6) {
                    stringBuffer.append(TextUtil.byteToHexString((int)byArray[n2]).toUpperCase()).append(':');
                    ++n2;
                }
                stringBuffer.setLength(stringBuffer.length() - 1);
                break;
            }
            case 2: {
                stringBuffer.append(0xFF & byArray[0]).append('.').append(0xFF & byArray[1]).append('.').append(0xFF & byArray[2]).append('.').append(0xFF & byArray[3]);
                if (byArray.length <= 5) break;
                stringBuffer.append(':');
                int n3 = (0xFF & byArray[4]) << 8;
                stringBuffer.append("0x").append(Integer.toHexString(n3 |= 0xFF & byArray[5]).toUpperCase());
                break;
            }
            default: {
                if (byArray.length == 1) {
                    int n4 = byArray[0] & 0xFF;
                    stringBuffer.append(n4);
                    break;
                }
                int n5 = 0;
                while (n5 < byArray.length) {
                    stringBuffer.append(TextUtil.byteToHexString((int)byArray[n5]).toUpperCase()).append(' ');
                    ++n5;
                }
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
        }
        return stringBuffer.toString();
    }

    public static final byte[] stringToBytes(int n, int n2, String string) {
        byte[] byArray;
        if (string == null || string.length() == 0 || string.equalsIgnoreCase("null")) {
            return null;
        }
        block0 : switch (n) {
            case 1: {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " :");
                if (stringTokenizer.countTokens() != 6) {
                    throw new IllegalArgumentException("Invalid Ethernet MAC Address!");
                }
                byArray = new byte[6];
                int n3 = 0;
                while (n3 < 6) {
                    byArray[n3] = (byte)Integer.parseInt(stringTokenizer.nextToken(), 16);
                    ++n3;
                }
                break;
            }
            case 2: {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".: ");
                if (stringTokenizer.countTokens() < n2) {
                    throw new IllegalArgumentException("Invalid BACnet/IP MAC Address!");
                }
                switch (n2) {
                    case 4: {
                        byArray = new byte[4];
                        int n4 = 0;
                        while (n4 < 4) {
                            byArray[n4] = (byte)Integer.decode(stringTokenizer.nextToken()).intValue();
                            ++n4;
                        }
                        break block0;
                    }
                    case 5: {
                        byArray = new byte[6];
                        int n5 = 0;
                        while (n5 < 4) {
                            byArray[n5] = (byte)Integer.decode(stringTokenizer.nextToken()).intValue();
                            ++n5;
                        }
                        n5 = Integer.decode(stringTokenizer.nextToken());
                        byArray[4] = (byte)(n5 >> 8 & 0xFF);
                        byArray[5] = (byte)(n5 & 0xFF);
                        break block0;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid length for conversion of BACnet/IP MAC address!");
                    }
                }
            }
            default: {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ": ");
                int n6 = stringTokenizer.countTokens();
                byArray = new byte[n6];
                if (n6 == 1) {
                    byArray[0] = Integer.decode(stringTokenizer.nextToken()).byteValue();
                    break;
                }
                int n7 = 0;
                while (n7 < byArray.length) {
                    byArray[n7] = (byte)Integer.parseInt(stringTokenizer.nextToken(), 16);
                    ++n7;
                }
                break block0;
            }
        }
        return byArray;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BBacnetAddress() {
    }

    public BBacnetAddress(int n, byte[] byArray) {
        this.setNetworkNumber(n);
        this.setMacAddress(BBacnetOctetString.make(byArray));
    }

    public BBacnetAddress(int n, BBacnetOctetString bBacnetOctetString) {
        this.setNetworkNumber(n);
        if (bBacnetOctetString != null) {
            this.setMacAddress(bBacnetOctetString);
        }
    }

    static {
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetAddress;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetAddress = BBacnetAddress.class("[Ljavax.baja.bacnet.datatypes.BBacnetAddress;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        GLOBAL_BROADCAST_ADDRESS = new BBacnetAddress((int)((char)-1), null);
        DEFAULT = LOCAL_BROADCAST_ADDRESS = new BBacnetAddress(0, null);
    }
}

