/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.config;

import com.tridium.bacnet.asn.AsnUtil;
import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BBacnetMultistate
extends BBacnetObject {
    public static final Property presentValue = BBacnetMultistate.newProperty((int)0, (BValue)BDynamicEnum.make((int)0), (BFacets)BBacnetMultistate.makeFacets(85, 2));
    public static final Property facets = BBacnetMultistate.newProperty((int)1, (BValue)BFacets.DEFAULT, null);
    public static final Property statusFlags = BBacnetMultistate.newProperty((int)1, (BValue)BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetStatusFlags")), (BFacets)BBacnetMultistate.makeFacets(111, 8, BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP));
    public static final Property eventState = BBacnetMultistate.newProperty((int)1, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BBacnetEventState.TYPE)), (BFacets)BBacnetMultistate.makeFacets(36, 9));
    public static final Property outOfService = BBacnetMultistate.newProperty((int)0, (boolean)false, (BFacets)BBacnetMultistate.makeFacets(81, 1));
    public static final Property numberOfStates = BBacnetMultistate.newProperty((int)0, (BValue)BBacnetUnsigned.DEFAULT, (BFacets)BBacnetMultistate.makeFacets(74, 2));
    public static final Type TYPE;
    static /* synthetic */ Class class$javax$baja$bacnet$config$BBacnetMultistate;

    public BEnum getPresentValue() {
        return (BEnum)this.get(presentValue);
    }

    public void setPresentValue(BEnum bEnum) {
        this.set(presentValue, (BValue)bEnum, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets bFacets) {
        this.set(facets, (BValue)bFacets, null);
    }

    public BBacnetBitString getStatusFlags() {
        return (BBacnetBitString)this.get(statusFlags);
    }

    public void setStatusFlags(BBacnetBitString bBacnetBitString) {
        this.set(statusFlags, (BValue)bBacnetBitString, null);
    }

    public BEnum getEventState() {
        return (BEnum)this.get(eventState);
    }

    public void setEventState(BEnum bEnum) {
        this.set(eventState, (BValue)bEnum, null);
    }

    public boolean getOutOfService() {
        return this.getBoolean(outOfService);
    }

    public void setOutOfService(boolean bl) {
        this.setBoolean(outOfService, bl, null);
    }

    public BBacnetUnsigned getNumberOfStates() {
        return (BBacnetUnsigned)this.get(numberOfStates);
    }

    public void setNumberOfStates(BBacnetUnsigned bBacnetUnsigned) {
        this.set(numberOfStates, (BValue)bBacnetUnsigned, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getObjectId().toString(context)).append(" = " + this.getPresentValue().toString(context));
        return stringBuffer.toString();
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == presentValue) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void setOutputFacets() {
        BBacnetArray bBacnetArray = (BBacnetArray)this.get(BBacnetPropertyIdentifier.stateText.getTag());
        if (bBacnetArray != null) {
            int[] nArray = new int[bBacnetArray.getSize()];
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = n + 1;
                ++n;
            }
            String[] stringArray = new String[nArray.length];
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2] = SlotPath.escape((String)bBacnetArray.getElement(n2 + 1).toString());
                ++n2;
            }
            this.setFacets(BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])nArray, (String[])stringArray)));
        }
    }

    public Property getPresentValueProperty() {
        return presentValue;
    }

    protected byte[] toEncodedValue(BBacnetObject.BacnetPropertyData bacnetPropertyData, Property property) {
        if (bacnetPropertyData.getPropertyId() == 85) {
            return AsnUtil.toAsnUnsigned(((BEnum)this.get(property)).getOrdinal());
        }
        return AsnUtil.toAsn(bacnetPropertyData.getAsnType(), this.get(property));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$bacnet$config$BBacnetMultistate;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$config$BBacnetMultistate = BBacnetMultistate.class("[Ljavax.baja.bacnet.config.BBacnetMultistate;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

