/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.config;

import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetSetpointReference;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetAction;
import javax.baja.bacnet.enums.BBacnetEngineeringUnits;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetLoop
extends BBacnetObject {
    public static final Property objectId = BBacnetLoop.newProperty((int)8, (BValue)BBacnetObjectIdentifier.make(12), (BFacets)BBacnetLoop.makeFacets(75, 12));
    public static final Property objectType = BBacnetLoop.newProperty((int)1, (BValue)BDynamicEnum.make((int)12, (BEnumRange)BEnumRange.make((Type)BBacnetObjectType.TYPE)), (BFacets)BBacnetLoop.makeFacets(79, 9));
    public static final Property presentValue = BBacnetLoop.newProperty((int)0, (int)0, (BFacets)BBacnetLoop.makeFacets(85, 4));
    public static final Property facets = BBacnetLoop.newProperty((int)1, (BValue)BFacets.DEFAULT, null);
    public static final Property statusFlags = BBacnetLoop.newProperty((int)1, (BValue)BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetStatusFlags")), (BFacets)BBacnetLoop.makeFacets(111, 8, BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP));
    public static final Property eventState = BBacnetLoop.newProperty((int)1, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BBacnetEventState.TYPE)), (BFacets)BBacnetLoop.makeFacets(36, 9));
    public static final Property outOfService = BBacnetLoop.newProperty((int)0, (boolean)false, (BFacets)BBacnetLoop.makeFacets(81, 1));
    public static final Property outputUnits = BBacnetLoop.newProperty((int)1, (BValue)BDynamicEnum.make((int)95, (BEnumRange)BEnumRange.make((Type)BBacnetEngineeringUnits.TYPE)), (BFacets)BBacnetLoop.makeFacets(82, 9));
    public static final Property manipulatedVariableReference = BBacnetLoop.newProperty((int)0, (BValue)new BBacnetObjectPropertyReference(), (BFacets)BBacnetLoop.makeFacets(60, -1));
    public static final Property controlledVariableReference = BBacnetLoop.newProperty((int)0, (BValue)new BBacnetObjectPropertyReference(), (BFacets)BBacnetLoop.makeFacets(19, -1));
    public static final Property controlledVariableValue = BBacnetLoop.newProperty((int)0, (int)0, (BFacets)BBacnetLoop.makeFacets(21, 4));
    public static final Property controlledVariableUnits = BBacnetLoop.newProperty((int)1, (BValue)BDynamicEnum.make((int)95, (BEnumRange)BEnumRange.make((Type)BBacnetEngineeringUnits.TYPE)), (BFacets)BBacnetLoop.makeFacets(20, 9));
    public static final Property setpointReference = BBacnetLoop.newProperty((int)0, (BValue)new BBacnetSetpointReference(), (BFacets)BBacnetLoop.makeFacets(109, -1));
    public static final Property setpoint = BBacnetLoop.newProperty((int)0, (int)0, (BFacets)BBacnetLoop.makeFacets(108, 4));
    public static final Property action = BBacnetLoop.newProperty((int)0, (BValue)BBacnetAction.direct, (BFacets)BBacnetLoop.makeFacets(2, 9));
    public static final Property priorityForWriting = BBacnetLoop.newProperty((int)0, (BValue)BBacnetUnsigned.make(16L), (BFacets)BBacnetLoop.makeFacets(88, 2));
    public static final Type TYPE;
    private static final String PROPORTIONAL_CONSTANT = "proportionalConstant";
    private static final String INTEGRAL_CONSTANT = "integralConstant";
    private static final String DERIVATIVE_CONSTANT = "derivativeConstant";
    private static final String PROPORTIONAL_CONSTANT_UNITS = "proportionalConstantUnits";
    private static final String INTEGRAL_CONSTANT_UNITS = "integralConstantUnits";
    private static final String DERIVATIVE_CONSTANT_UNITS = "derivativeConstantUnits";
    private BFacets proportionalFacets;
    private BFacets integralFacets;
    private BFacets derivativeFacets;
    static /* synthetic */ Class class$javax$baja$bacnet$config$BBacnetLoop;

    public float getPresentValue() {
        return this.getFloat(presentValue);
    }

    public void setPresentValue(float f) {
        this.setFloat(presentValue, f, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets bFacets) {
        this.set(facets, (BValue)bFacets, null);
    }

    public BBacnetBitString getStatusFlags() {
        return (BBacnetBitString)this.get(statusFlags);
    }

    public void setStatusFlags(BBacnetBitString bBacnetBitString) {
        this.set(statusFlags, (BValue)bBacnetBitString, null);
    }

    public BEnum getEventState() {
        return (BEnum)this.get(eventState);
    }

    public void setEventState(BEnum bEnum) {
        this.set(eventState, (BValue)bEnum, null);
    }

    public boolean getOutOfService() {
        return this.getBoolean(outOfService);
    }

    public void setOutOfService(boolean bl) {
        this.setBoolean(outOfService, bl, null);
    }

    public BEnum getOutputUnits() {
        return (BEnum)this.get(outputUnits);
    }

    public void setOutputUnits(BEnum bEnum) {
        this.set(outputUnits, (BValue)bEnum, null);
    }

    public BBacnetObjectPropertyReference getManipulatedVariableReference() {
        return (BBacnetObjectPropertyReference)this.get(manipulatedVariableReference);
    }

    public void setManipulatedVariableReference(BBacnetObjectPropertyReference bBacnetObjectPropertyReference) {
        this.set(manipulatedVariableReference, (BValue)bBacnetObjectPropertyReference, null);
    }

    public BBacnetObjectPropertyReference getControlledVariableReference() {
        return (BBacnetObjectPropertyReference)this.get(controlledVariableReference);
    }

    public void setControlledVariableReference(BBacnetObjectPropertyReference bBacnetObjectPropertyReference) {
        this.set(controlledVariableReference, (BValue)bBacnetObjectPropertyReference, null);
    }

    public float getControlledVariableValue() {
        return this.getFloat(controlledVariableValue);
    }

    public void setControlledVariableValue(float f) {
        this.setFloat(controlledVariableValue, f, null);
    }

    public BEnum getControlledVariableUnits() {
        return (BEnum)this.get(controlledVariableUnits);
    }

    public void setControlledVariableUnits(BEnum bEnum) {
        this.set(controlledVariableUnits, (BValue)bEnum, null);
    }

    public BBacnetSetpointReference getSetpointReference() {
        return (BBacnetSetpointReference)this.get(setpointReference);
    }

    public void setSetpointReference(BBacnetSetpointReference bBacnetSetpointReference) {
        this.set(setpointReference, (BValue)bBacnetSetpointReference, null);
    }

    public float getSetpoint() {
        return this.getFloat(setpoint);
    }

    public void setSetpoint(float f) {
        this.setFloat(setpoint, f, null);
    }

    public BBacnetAction getAction() {
        return (BBacnetAction)this.get(action);
    }

    public void setAction(BBacnetAction bBacnetAction) {
        this.set(action, (BValue)bBacnetAction, null);
    }

    public BBacnetUnsigned getPriorityForWriting() {
        return (BBacnetUnsigned)this.get(priorityForWriting);
    }

    public void setPriorityForWriting(BBacnetUnsigned bBacnetUnsigned) {
        this.set(priorityForWriting, (BValue)bBacnetUnsigned, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getObjectId().toString(context)).append(BacnetConst.nameContext.equals(context) ? (char)'_' : ':').append(this.getPresentValue());
        return stringBuffer.toString();
    }

    public void started() throws Exception {
        super.started();
        this.proportionalFacets = this.getFacetsFromUnits(PROPORTIONAL_CONSTANT_UNITS, 2);
        this.integralFacets = this.getFacetsFromUnits(INTEGRAL_CONSTANT_UNITS, 2);
        this.derivativeFacets = this.getFacetsFromUnits(DERIVATIVE_CONSTANT_UNITS, 2);
    }

    public void stopped() throws Exception {
        super.stopped();
        this.proportionalFacets = null;
        this.integralFacets = null;
        this.derivativeFacets = null;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.getName().equals(PROPORTIONAL_CONSTANT_UNITS)) {
            this.proportionalFacets = this.getFacetsFromUnits(PROPORTIONAL_CONSTANT_UNITS, 2);
        } else if (property.getName().equals(INTEGRAL_CONSTANT_UNITS)) {
            this.integralFacets = this.getFacetsFromUnits(INTEGRAL_CONSTANT_UNITS, 2);
        } else if (property.getName().equals(DERIVATIVE_CONSTANT_UNITS)) {
            this.derivativeFacets = this.getFacetsFromUnits(DERIVATIVE_CONSTANT_UNITS, 2);
        }
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.getName().equals(PROPORTIONAL_CONSTANT_UNITS)) {
            this.proportionalFacets = this.getFacetsFromUnits(PROPORTIONAL_CONSTANT_UNITS, 2);
        } else if (property.getName().equals(INTEGRAL_CONSTANT_UNITS)) {
            this.integralFacets = this.getFacetsFromUnits(INTEGRAL_CONSTANT_UNITS, 2);
        } else if (property.getName().equals(DERIVATIVE_CONSTANT_UNITS)) {
            this.derivativeFacets = this.getFacetsFromUnits(DERIVATIVE_CONSTANT_UNITS, 2);
        }
    }

    public void removed(Property property, BValue bValue, Context context) {
        super.removed(property, bValue, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.getName().equals(PROPORTIONAL_CONSTANT_UNITS)) {
            this.proportionalFacets = null;
        } else if (property.getName().equals(INTEGRAL_CONSTANT_UNITS)) {
            this.integralFacets = null;
        } else if (property.getName().equals(DERIVATIVE_CONSTANT_UNITS)) {
            this.derivativeFacets = null;
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)presentValue)) {
            return this.getFacets();
        }
        if (slot.getName().equals(PROPORTIONAL_CONSTANT)) {
            return this.proportionalFacets != null ? this.proportionalFacets : BFacets.DEFAULT;
        }
        if (slot.getName().equals(INTEGRAL_CONSTANT)) {
            return this.integralFacets != null ? this.integralFacets : BFacets.DEFAULT;
        }
        if (slot.getName().equals(DERIVATIVE_CONSTANT)) {
            return this.derivativeFacets != null ? this.derivativeFacets : BFacets.DEFAULT;
        }
        return super.getSlotFacets(slot);
    }

    public void setOutputFacets() {
        BUnit bUnit = null;
        try {
            bUnit = BBacnetEngineeringUnits.make(this.getOutputUnits().getOrdinal()).getNiagaraUnits();
        }
        catch (InvalidEnumException invalidEnumException) {
            System.out.println("Can't make BUnits from BacnetEngineeringUnits:" + this.getOutputUnits());
        }
        BFloat bFloat = (BFloat)this.get("minimumOutput");
        BFloat bFloat2 = (BFloat)this.get("maximumOutput");
        if (bFloat == null) {
            bFloat = BFloat.make((float)Float.NEGATIVE_INFINITY);
        }
        if (bFloat2 == null) {
            bFloat2 = BFloat.make((float)Float.POSITIVE_INFINITY);
        }
        if (bFloat.getFloat() == -3.4028235E38f) {
            bFloat = BFloat.make((float)Float.NEGATIVE_INFINITY);
        }
        if (bFloat2.getFloat() == Float.MAX_VALUE) {
            bFloat2 = BFloat.make((float)Float.POSITIVE_INFINITY);
        }
        BFacets bFacets = BFacets.makeNumeric((BUnit)bUnit, (BNumber)bFloat, (BNumber)bFloat2);
        this.setFacets(bFacets);
    }

    public Property getPresentValueProperty() {
        return presentValue;
    }

    private final BFacets getFacetsFromUnits(String string, int n) {
        BEnum bEnum = (BEnum)this.get(string);
        if (bEnum != null) {
            return BFacets.makeNumeric((BUnit)BBacnetEngineeringUnits.getNiagaraUnits(bEnum.getOrdinal()), (int)n);
        }
        return null;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$bacnet$config$BBacnetLoop;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$config$BBacnetLoop = BBacnetLoop.class("[Ljavax.baja.bacnet.config.BBacnetLoop;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

