/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.fe;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BMonth;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BSpinnerButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BMultiWildcardableFieldFE
extends BWbFieldEditor {
    public static final Action increment = BMultiWildcardableFieldFE.newAction((int)0, null);
    public static final Action decrement = BMultiWildcardableFieldFE.newAction((int)0, null);
    public static final Action wildcard = BMultiWildcardableFieldFE.newAction((int)0, null);
    public static final Type TYPE;
    static final double textViewFix = 4.0;
    protected static final UiLexicon lex;
    static final String LAST;
    static final String ODD;
    static final String EVEN;
    protected WCField[] fields;
    BSpinnerButton spinner;
    BButton wildcardButton;
    int selection;
    double charWidth;
    boolean paintNull;
    double prefHeight;
    static /* synthetic */ Class class$com$tridium$bacnet$ui$fe$BMultiWildcardableFieldFE;

    public void increment() {
        this.invoke(increment, null, null);
    }

    public void decrement() {
        this.invoke(decrement, null, null);
    }

    public void wildcard() {
        this.invoke(wildcard, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected void doSetReadonly(boolean bl) {
        this.relayout();
    }

    public void computePreferredSize() {
        BFont bFont = Theme.textField().getFont();
        this.charWidth = bFont.width("0");
        double d = 0.0;
        int n = 0;
        while (n < this.fields.length) {
            if (n > 0) {
                d += this.charWidth * (double)this.fields[n].prefix().length();
            }
            d += this.charWidth * (double)this.fields[n].length();
            ++n;
        }
        BInsets bInsets = Theme.textField().getInsets();
        double d2 = d + bInsets.left + bInsets.right + 13.0;
        double d3 = bFont.getHeight() - (double)4 + bInsets.top + bInsets.bottom;
        this.wildcardButton.computePreferredSize();
        d3 = Math.max(d3, this.wildcardButton.getPreferredHeight());
        this.setPreferredSize(d2 += this.wildcardButton.getPreferredWidth() + (double)3, d3);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        this.computePreferredSize();
        BFont bFont = Theme.textField().getFont();
        BInsets bInsets = Theme.textField().getInsets();
        this.charWidth = bFont.width("0");
        this.prefHeight = this.getPreferredHeight();
        if (this.isReadonly()) {
            this.spinner.setVisible(false);
            this.spinner.setBounds(-1.0, -1.0, 0.0, 0.0);
            this.wildcardButton.setVisible(false);
            this.wildcardButton.setBounds(-1.0, -1.0, 0.0, 0.0);
        } else {
            double d = this.getWidth();
            double d2 = this.getHeight();
            double d3 = 13.0;
            double d4 = bFont.getHeight() - (double)4 + bInsets.top + bInsets.bottom;
            this.wildcardButton.computePreferredSize();
            double d5 = this.wildcardButton.getPreferredWidth();
            this.wildcardButton.setVisible(true);
            this.wildcardButton.setBounds(d - d5, 0.0, d5, Math.min(d2, this.prefHeight));
            this.spinner.setVisible(true);
            this.spinner.setBounds(d - d3 - (d5 + (double)5), 0.0, d3, Math.min(d4, this.prefHeight));
        }
    }

    int fieldAt(double d, double d2) {
        int n = (int)(d / this.charWidth);
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.fields.length) {
            int n4 = 0;
            if (n3 != 0) {
                n4 = this.fields[n3].prefix().length();
            }
            int n5 = n4;
            int n6 = n2 + n5 + this.fields[n3].length();
            if (n2 <= n && n <= n6) {
                return n3;
            }
            n2 = n6;
            ++n3;
        }
        return -1;
    }

    public void paint(Graphics graphics) {
        BFont bFont = Theme.textField().getFont();
        BInsets bInsets = Theme.textField().getInsets();
        double d = this.getWidth();
        double d2 = d - this.spinner.getWidth();
        double d3 = bFont.getHeight() - (double)4 + bInsets.top + bInsets.bottom;
        boolean bl = this.isReadonly();
        boolean bl2 = this.hasFocus();
        d2 -= this.wildcardButton.getWidth() + (double)5;
        BBrush bBrush = this.isReadonly() ? Theme.widget().getControlForeground() : Theme.widget().getWindowForeground();
        BBrush bBrush2 = this.isReadonly() ? Theme.widget().getControlBackground() : Theme.widget().getWindowBackground();
        BBrush bBrush3 = Theme.widget().getSelectionForeground();
        BBrush bBrush4 = Theme.widget().getSelectionBackground();
        graphics.setFont(bFont);
        graphics.setBrush(bBrush2);
        graphics.fillRect(0.0, 0.0, d2, d3);
        graphics.setBrush(bBrush);
        double d4 = bInsets.left;
        double d5 = d3 - bInsets.bottom - (double)2;
        if (this.paintNull && bl) {
            graphics.drawString("null", d4, d5);
        } else {
            int n = 0;
            while (n < this.fields.length) {
                String string;
                WCField wCField = this.fields[n];
                if (n > 0) {
                    graphics.setBrush(bBrush);
                    string = wCField.prefix();
                    if (string == null) {
                        string = "?";
                    }
                    graphics.drawString(string, d4, d5);
                    d4 += this.charWidth * (double)string.length();
                }
                if ((string = wCField.string()) == null) {
                    string = "?";
                }
                double d6 = this.charWidth * (double)string.length();
                if (n == this.selection && bl2) {
                    graphics.setBrush(bBrush4);
                    graphics.fillRect(d4, bInsets.top, d6, d3 - bInsets.top - bInsets.bottom);
                    graphics.setBrush(bBrush3);
                }
                graphics.drawString(string, d4, d5);
                d4 += d6;
                graphics.setBrush(bBrush);
                ++n;
            }
        }
        Theme.textField().paintBorder(graphics, (BWidget)this, d2, d3);
        this.paintChildren(graphics);
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        super.mousePressed(bMouseEvent);
        if (this.isReadonly()) {
            return;
        }
        this.requestFocus();
        int n = this.fieldAt(bMouseEvent.getX(), bMouseEvent.getY());
        if (n != -1 && this.fields[n].isEditable()) {
            this.setSelection(n);
        }
    }

    public void keyTyped(BKeyEvent bKeyEvent) {
        char c = bKeyEvent.getKeyChar();
        if (c == '\n' || c == '\r') {
            this.fireActionPerformed(new BWidgetEvent(2, (BWidget)this));
            bKeyEvent.consume();
        } else if (this.fields[this.selection].keyTyped(c)) {
            this.timeModified();
            bKeyEvent.consume();
        }
    }

    public void keyPressed(BKeyEvent bKeyEvent) {
        if (bKeyEvent.getModifiers() != 0) {
            return;
        }
        int n = this.selection;
        switch (bKeyEvent.getKeyCode()) {
            case 39: {
                do {
                    if (++n < this.fields.length) continue;
                    n = 0;
                } while (!this.fields[n].isEditable());
                this.setSelection(n);
                bKeyEvent.consume();
                break;
            }
            case 37: {
                do {
                    if (--n >= 0) continue;
                    n = this.fields.length - 1;
                } while (!this.fields[n].isEditable());
                this.setSelection(n);
                bKeyEvent.consume();
                break;
            }
            case 38: {
                this.doIncrement();
                bKeyEvent.consume();
                break;
            }
            case 40: {
                this.doDecrement();
                bKeyEvent.consume();
                break;
            }
        }
    }

    public boolean isFocusTraversable() {
        return this.isReadonly() ^ true;
    }

    public void focusGained(BFocusEvent bFocusEvent) {
        this.repaint();
    }

    public void focusLost(BFocusEvent bFocusEvent) {
        this.repaint();
    }

    public void doIncrement() {
        this.fields[this.selection].increment();
        this.timeModified();
    }

    public void doDecrement() {
        this.fields[this.selection].decrement();
        this.timeModified();
    }

    public void doWildcard() {
        this.fields[this.selection].wildcard();
        this.timeModified();
    }

    void setSelection(int n) {
        if (!this.fields[n].isEditable()) {
            throw new IllegalStateException();
        }
        this.fields[this.selection].typeCount = 0;
        this.selection = n;
        this.repaint();
    }

    protected void timeModified() {
        this.setModified();
        this.repaint();
    }

    protected void d(String string) {
        System.out.println("WCFFE:" + string);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.selection = 0;
    }

    public BMultiWildcardableFieldFE() {
        this.this();
        this.spinner = new BSpinnerButton();
        this.add("spinner", (BValue)this.spinner);
        this.linkTo("incrementLink", (BComponent)this.spinner, (Slot)BSpinnerButton.increment, (Slot)increment);
        this.linkTo("decrementLink", (BComponent)this.spinner, (Slot)BSpinnerButton.decrement, (Slot)decrement);
        this.wildcardButton = new BButton("*");
        this.wildcardButton.setFocusTraversable(false);
        this.wildcardButton.setButtonStyle(BButtonStyle.toolBar);
        this.add("wc", (BValue)this.wildcardButton);
        this.linkTo("wcLink", (BComponent)this.wildcardButton, (Slot)BButton.actionPerformed, (Slot)wildcard);
    }

    static {
        Class clazz = class$com$tridium$bacnet$ui$fe$BMultiWildcardableFieldFE;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$ui$fe$BMultiWildcardableFieldFE = BMultiWildcardableFieldFE.class("[Lcom.tridium.bacnet.ui.fe.BMultiWildcardableFieldFE;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$bacnet$ui$fe$BMultiWildcardableFieldFE;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$bacnet$ui$fe$BMultiWildcardableFieldFE = BMultiWildcardableFieldFE.class("[Lcom.tridium.bacnet.ui.fe.BMultiWildcardableFieldFE;", false);
        }
        lex = new UiLexicon(clazz2);
        LAST = lex.getText("bacnetDate.dayOfMonth.last").substring(0, 2);
        ODD = lex.getText("bacnetDate.month.odd").substring(0, 3);
        EVEN = lex.getText("bacnetDate.month.even").substring(0, 3);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public abstract class WCField {
        public int value;
        String string;
        int typeCount;

        abstract String prefix();

        int min() {
            return 0;
        }

        abstract int max();

        abstract int length();

        void wildcard() {
            this.set(-1);
        }

        boolean isEditable() {
            return true;
        }

        String string() {
            return this.string;
        }

        public void set(int n) {
            if (n < 0) {
                this.value = -1;
                this.string = "*";
                while (this.string.length() < this.length()) {
                    this.string = this.string + '*';
                }
            } else {
                this.value = n;
                this.string = String.valueOf(n);
                int n2 = this.string.length();
                while (n2 < this.length()) {
                    this.string = "0" + this.string;
                    ++n2;
                }
            }
        }

        void increment() {
            int n = this.value + 1;
            if (n > this.max() || n < this.min()) {
                n = this.min();
            }
            this.set(n);
        }

        void decrement() {
            int n = this.value - 1;
            if (n < this.min() || n > this.max()) {
                n = this.max();
            }
            this.set(n);
        }

        boolean keyTyped(int n) {
            if (Character.isDigit((char)n)) {
                int n2;
                int n3 = n - 48;
                if (this.typeCount == 0) {
                    n2 = n3;
                } else {
                    int n4 = 1;
                    int n5 = 0;
                    while (n5 < this.length() - 1) {
                        n4 *= 10;
                        ++n5;
                    }
                    n2 = this.value % n4 * 10 + n3;
                }
                if (n2 <= this.max()) {
                    this.set(n2);
                }
                ++this.typeCount;
                return true;
            }
            return false;
        }

        WCField() {
            this.set(0);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class WeekdayField
    extends WCField {
        String prefix() {
            return " ";
        }

        int length() {
            return 3;
        }

        int max() {
            return 6;
        }

        public void set(int n) {
            if (n < 0) {
                this.value = -1;
                this.string = "***";
            } else {
                this.value = n;
                if (n == 7) {
                    n = 0;
                }
                BWeekday bWeekday = BWeekday.make((int)n);
                this.string = bWeekday.getShortDisplayTag(null);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class HundredthField
    extends WCField {
        String prefix() {
            return ".";
        }

        int length() {
            return 2;
        }

        int max() {
            return 99;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TimeZoneField
    extends WCField {
        String prefix() {
            return " ";
        }

        int length() {
            return this.string.length();
        }

        boolean isEditable() {
            return false;
        }

        int max() {
            return 1;
        }

        TimeZoneField() {
            this.string = "???";
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class YearField
    extends WCField {
        String prefix() {
            return " ";
        }

        int length() {
            return 4;
        }

        int max() {
            return 2154;
        }

        int min() {
            return 1900;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class MonthField
    extends WCField {
        String prefix() {
            return " ";
        }

        int length() {
            return 3;
        }

        int max() {
            return 13;
        }

        public void set(int n) {
            if (n < 0) {
                this.value = -1;
                this.string = "***";
            } else if (n == 12) {
                this.value = n;
                this.string = ODD;
            } else if (n == 13) {
                this.value = n;
                this.string = EVEN;
            } else {
                this.value = n;
                BMonth bMonth = BMonth.make((int)n);
                this.string = bMonth.getShortDisplayTag(null);
            }
        }

        boolean keyTyped(int n) {
            return false;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class DayField
    extends WCField {
        String prefix() {
            return " ";
        }

        int length() {
            return 2;
        }

        int max() {
            return 32;
        }

        public void set(int n) {
            if (n < 0) {
                this.value = -1;
                this.string = "**";
            } else if (n == 32) {
                this.value = n;
                this.string = LAST;
            } else {
                this.value = n;
                this.string = String.valueOf(n);
                int n2 = this.string.length();
                while (n2 < this.length()) {
                    this.string = "0" + this.string;
                    ++n2;
                }
            }
        }

        void increment() {
            int n = this.value + 1;
            if (n > this.max()) {
                n = 1;
            }
            if (n < 1) {
                n = 1;
            }
            this.set(n);
        }

        void decrement() {
            int n = this.value - 1;
            if (n < 1) {
                n = this.max();
            }
            this.set(n);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class MillisecondField
    extends WCField {
        String prefix() {
            return ".";
        }

        int length() {
            return 3;
        }

        int max() {
            return 999;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class SecondField
    extends WCField {
        String prefix() {
            return ":";
        }

        int length() {
            return 2;
        }

        int max() {
            return 59;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class MinuteField
    extends WCField {
        String prefix() {
            return ":";
        }

        int length() {
            return 2;
        }

        int max() {
            return 59;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class BigHourField
    extends WCField {
        String prefix() {
            return " ";
        }

        int length() {
            return 5;
        }

        int max() {
            return 99999;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class HourField
    extends WCField {
        String prefix() {
            return " ";
        }

        int length() {
            return 2;
        }

        int max() {
            return 23;
        }
    }
}

