/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.timers;

import com.tridium.bacnet.timers.TimerListener;
import javax.baja.nre.util.IntHashMap;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Clock;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Timers
implements Runnable {
    public static final int INVALID_TIMER_ID = -1;
    public static final long CANCEL_TIMER = 0L;
    private static Timers timers;
    private IntHashMap timerTable;
    private int nextTimerId;
    private boolean alive;
    private long nextDeadline;
    private Thread myThread;

    public static void start() {
        if (timers == null) {
            timers = new Timers();
        }
    }

    public static void stop() {
        if (timers != null && Timers.timers.myThread != null) {
            try {
                Timers.timers.myThread.interrupt();
            }
            catch (Exception exception) {}
            Timers.timers.myThread = null;
            Timers.timers.timerTable = null;
        }
        timers = null;
    }

    public static int add(TimerListener timerListener, long l) {
        return timers.addTimer(timerListener, l, null);
    }

    public static int add(TimerListener timerListener, long l, Object object) {
        return timers.addTimer(timerListener, l, object);
    }

    public static void cancel(TimerListener timerListener) {
        timers.cancelTimer(timerListener);
    }

    public static Object cancel(int n) {
        return timers.cancelTimer(n);
    }

    public static synchronized Object reset(int n, long l) {
        return timers.resetTimer(n, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps();
        spyWriter.trTitle((Object)"Timers", 2);
        Timers timers = Timers.timers;
        synchronized (timers) {
            spyWriter.prop((Object)"nextTimerId", Timers.timers.nextTimerId);
            spyWriter.prop((Object)"alive", Timers.timers.alive);
            spyWriter.prop((Object)"nextDeadline", (Object)("" + Timers.timers.nextDeadline));
            spyWriter.prop((Object)"timerTable size", Timers.timers.timerTable.size());
            IntHashMap.Iterator iterator = Timers.timers.timerTable.iterator();
            while (iterator.hasNext()) {
                TimerToken timerToken = (TimerToken)iterator.next();
                spyWriter.prop((Object)("" + iterator.key()), timerToken.userObject);
            }
        }
        spyWriter.endProps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int addTimer(TimerListener timerListener, long l, Object object) {
        TimerToken timerToken = null;
        long l2 = Clock.ticks() + l;
        if (this.nextTimerId++ == -1) {
            ++this.nextTimerId;
        }
        timerToken = new TimerToken(l2, this.nextTimerId, timerListener, object);
        Timers timers = this;
        synchronized (timers) {
            this.timerTable.put(timerToken.timerId, (Object)timerToken);
            if (timerToken.deadline < this.nextDeadline) {
                this.nextDeadline = timerToken.deadline;
            }
            this.notify();
            return timerToken.timerId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void cancelTimer(TimerListener timerListener) {
        Timers timers = this;
        synchronized (timers) {
            IntHashMap.Iterator iterator = this.timerTable.iterator();
            while (iterator.hasNext()) {
                TimerToken timerToken = (TimerToken)iterator.next();
                if (timerListener != timerToken.listener) continue;
                this.timerTable.remove(timerToken.timerId);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object cancelTimer(int n) {
        Timers timers = this;
        synchronized (timers) {
            TimerToken timerToken = (TimerToken)this.timerTable.get(n);
            if (timerToken == null) {
                return null;
            }
            this.timerTable.remove(n);
            return timerToken.userObject;
        }
    }

    private final synchronized Object resetTimer(int n, long l) {
        long l2;
        TimerToken timerToken = (TimerToken)this.timerTable.get(n);
        if (timerToken == null) {
            return null;
        }
        timerToken.deadline = l2 = Clock.ticks() + l;
        return timerToken.userObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.alive = true;
        while (this.alive) {
            try {
                Timers timers = this;
                synchronized (timers) {
                    while (true) {
                        if (this.timerTable == null || this.timerTable.size() >= 1) {
                            long l = this.nextDeadline - Clock.ticks();
                            if (l > 0L) {
                                this.wait(l);
                            }
                            break;
                        }
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            this.notifyListeners();
        }
    }

    private final synchronized void notifyListeners() {
        long l = Clock.ticks();
        this.nextDeadline = Long.MAX_VALUE;
        long l2 = 0L;
        if (this.timerTable == null) {
            return;
        }
        IntHashMap.Iterator iterator = this.timerTable.iterator();
        while (iterator.hasNext()) {
            TimerToken timerToken = (TimerToken)iterator.next();
            if (timerToken.deadline <= l) {
                l2 = timerToken.listener.timerExpired(timerToken.timerId, timerToken.userObject);
                if (l2 == 0L) {
                    this.timerTable.remove(timerToken.timerId);
                    continue;
                }
                timerToken.deadline = Clock.ticks() + l2;
                if (timerToken.deadline >= this.nextDeadline) continue;
                this.nextDeadline = timerToken.deadline;
                continue;
            }
            if (timerToken.deadline >= this.nextDeadline) continue;
            this.nextDeadline = timerToken.deadline;
        }
    }

    private final /* synthetic */ void this() {
        this.timerTable = new IntHashMap();
        this.nextTimerId = 0;
        this.alive = false;
        this.nextDeadline = Long.MAX_VALUE;
    }

    private Timers() {
        this.this();
        this.myThread = new Thread((Runnable)this, "BnTmrs");
        this.myThread.start();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TimerToken {
        public long deadline;
        public int timerId;
        public TimerListener listener;
        public Object userObject;

        public TimerToken(long l, int n, TimerListener timerListener, Object object) {
            this.deadline = l;
            this.timerId = n;
            this.listener = timerListener;
            this.userObject = object;
        }
    }
}

