/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.transport;

import com.tridium.bacnet.stack.BacnetStackException;
import com.tridium.bacnet.stack.network.BNetworkPriority;
import com.tridium.bacnet.stack.transport.ApplicationPdu;
import com.tridium.bacnet.stack.transport.InvalidApduTypeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.baja.bacnet.BacnetUnconfirmedServiceChoice;
import javax.baja.bacnet.datatypes.BBacnetAddress;

public class UnconfirmedRequestPdu
extends ApplicationPdu {
    private int serviceChoice;
    private byte[] serviceRequest;

    public int getServiceChoice() {
        return this.serviceChoice;
    }

    public byte[] getServiceRequest() {
        return this.serviceRequest;
    }

    public boolean isServerPDU() {
        return false;
    }

    public boolean isClientPDU() {
        return true;
    }

    public void writeNetworkBytes(ByteArrayOutputStream byteArrayOutputStream) {
        byteArrayOutputStream.write(16);
        byteArrayOutputStream.write(this.serviceChoice);
        byteArrayOutputStream.write(this.serviceRequest, 0, this.serviceRequest.length);
    }

    public void readNetworkBytes(ByteArrayInputStream byteArrayInputStream) throws BacnetStackException {
        int n = (byteArrayInputStream.read() & 0xF0) >> 4;
        if (n != 1) {
            throw new InvalidApduTypeException(1, n);
        }
        this.serviceChoice = byteArrayInputStream.read();
        this.serviceRequest = new byte[byteArrayInputStream.available()];
        byteArrayInputStream.read(this.serviceRequest, 0, this.serviceRequest.length);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("UnconfirmedRequestPdu:");
        stringBuffer.append("\n\tService Choice = " + BacnetUnconfirmedServiceChoice.TAGS[this.serviceChoice]);
        if (this.serviceRequest != null) {
            stringBuffer.append("\n\tService Request (length) = " + this.serviceRequest.length);
        }
        return stringBuffer.toString();
    }

    public UnconfirmedRequestPdu(BBacnetAddress bBacnetAddress, BNetworkPriority bNetworkPriority, int n, byte[] byArray) {
        super(null, bBacnetAddress, bNetworkPriority, 1);
        this.serviceChoice = n;
        this.serviceRequest = byArray;
    }

    public UnconfirmedRequestPdu(ByteArrayInputStream byteArrayInputStream) throws BacnetStackException {
        super(1);
        this.readNetworkBytes(byteArrayInputStream);
    }
}

