/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.transport;

import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.transport.ApplicationPdu;
import com.tridium.bacnet.stack.transport.BBacnetTransportLayer;
import com.tridium.bacnet.stack.transport.TransactionList;
import com.tridium.bacnet.timers.TimerListener;
import com.tridium.bacnet.timers.Timers;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.log.Log;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Transaction {
    public static final int IDLE = 0;
    public static final int SEGMENTED_REQUEST = 1;
    public static final int AWAIT_CONFIRMATION = 2;
    public static final int AWAIT_RESPONSE = 2;
    public static final int SEGMENTED_CONF = 3;
    public static final int SEGMENTED_RESPONSE = 3;
    private static SegmentTimer segmentTimer = new SegmentTimer();
    private static RequestTimer requestTimer = new RequestTimer();
    public static Log log = Log.getLog((String)"bacnet.transport");
    private int timerId;
    private int segmentTimerId;
    private int segmentSize;
    private int retryCount;
    private int segmentRetryCount;
    private volatile int duplicateCount;
    private boolean sentAllSegments;
    private int lastSequenceNumber;
    private int initialSequenceNumber;
    private int actualWindowSize;
    private int proposedWindowSize;
    private int numSegments;
    private int segmentCounter;
    private int state;
    public boolean segmentTimerExpired;
    public boolean requestTimerExpired;

    protected abstract ApplicationPdu getApdu();

    public abstract BBacnetAddress getClientAddress();

    public abstract BBacnetAddress getServerAddress();

    public abstract BBacnetAddress getAddress();

    public abstract int getInvokeId();

    public abstract boolean isServerTransaction();

    public void incrementDuplicateCount() {
        ++this.duplicateCount;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Transaction) {
            Transaction transaction = (Transaction)object;
            boolean bl2 = false;
            if (this.getInvokeId() == transaction.getInvokeId() && this.getAddress() == transaction.getAddress()) {
                bl2 = true;
            }
            bl = bl2;
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTag(this.getState())).append(':').append(this.getClientAddress()).append(" -> ").append(this.getServerAddress()).append(" id ").append(this.getInvokeId()).append(" t").append(this.getTimerId());
        return stringBuffer.toString();
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int n) {
        this.retryCount = n;
    }

    public int getSegmentRetryCount() {
        return this.segmentRetryCount;
    }

    public void setSegmentRetryCount(int n) {
        this.segmentRetryCount = n;
    }

    public void setDuplicateCount(int n) {
        this.duplicateCount = n;
    }

    public int getDuplicateCount() {
        return this.duplicateCount;
    }

    public boolean getSentAllSegments() {
        return this.sentAllSegments;
    }

    public void setSentAllSegments(boolean bl) {
        this.sentAllSegments = bl;
    }

    public int getLastSequenceNumber() {
        return this.lastSequenceNumber;
    }

    public void setLastSequenceNumber(int n) {
        this.lastSequenceNumber = n;
    }

    public int getInitialSequenceNumber() {
        return this.initialSequenceNumber;
    }

    public void setInitialSequenceNumber(int n) {
        this.initialSequenceNumber = n;
    }

    public int getActualWindowSize() {
        return this.actualWindowSize;
    }

    public void setActualWindowSize(int n) {
        this.actualWindowSize = n;
    }

    public int getProposedWindowSize() {
        return this.proposedWindowSize;
    }

    public void setProposedWindowSize(int n) {
        this.proposedWindowSize = n;
    }

    public int getSegmentSize() {
        return this.segmentSize;
    }

    public void setSegmentSize(int n) {
        this.segmentSize = n;
    }

    public int getNumSegments() {
        return this.numSegments;
    }

    public void setNumSegments(int n) {
        this.numSegments = n;
    }

    public int getSegmentCounter() {
        return this.segmentCounter;
    }

    public void setSegmentCounter(int n) {
        this.segmentCounter = n;
    }

    public int getTimerId() {
        return this.timerId;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        if (n != 0) {
            if (this.state == 0) {
                this.activeTransactions().add(this);
            }
        } else if (n == 0) {
            this.activeTransactions().remove(this);
        }
        if (log.isTraceOn()) {
            log.trace(this + " --> " + this.getTag(n));
        }
        this.state = n;
    }

    protected abstract TransactionList activeTransactions();

    protected abstract String getTag(int var1);

    public abstract long getHashCode();

    public static final long hash(BBacnetAddress bBacnetAddress, int n) {
        return (long)n << 32 | (long)bBacnetAddress.hash() & 0xFFFFFFFFL;
    }

    private static final BBacnetTransportLayer transport() {
        return ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getTransport();
    }

    public void startRequestTimer(int n) {
        this.timerId = requestTimer.start(this, n);
    }

    public void restartRequestTimer(int n) {
        requestTimer.stop(this.timerId);
        this.timerId = requestTimer.start(this, n);
    }

    public void stopRequestTimer() {
        requestTimer.stop(this.timerId);
    }

    public void startSegmentTimer(int n) {
        this.segmentTimerId = segmentTimer.start(this, n);
    }

    public void restartSegmentTimer(int n) {
        segmentTimer.stop(this.segmentTimerId);
        this.segmentTimerId = segmentTimer.start(this, n);
    }

    public void stopSegmentTimer() {
        segmentTimer.stop(this.segmentTimerId);
    }

    public void startSegmentWaitTimer(int n) {
        this.segmentTimerId = segmentTimer.start(this, n * 4);
    }

    public void restartSegmentWaitTimer(int n) {
        segmentTimer.stop(this.segmentTimerId);
        this.segmentTimerId = segmentTimer.start(this, n * 4);
    }

    private final /* synthetic */ void this() {
        this.segmentTimerExpired = false;
        this.requestTimerExpired = false;
    }

    protected Transaction() {
        this.this();
    }

    public static class RequestTimer
    implements TimerListener {
        public int start(Transaction transaction, int n) {
            int n2 = Timers.add(this, n, transaction);
            if (log.isTraceOn()) {
                log.trace((transaction.isServerTransaction() ? "Server Timer started:" : "Client Timer started:") + n2 + " x:" + transaction + " apdu:" + transaction.getApdu());
            }
            return n2;
        }

        public void stop(int n) {
            Timers.cancel(n);
            if (log.isTraceOn()) {
                log.trace("Timer stopped: " + n);
            }
        }

        public long timerExpired(int n, Object object) {
            Transaction transaction = (Transaction)object;
            if (log.isTraceOn()) {
                log.trace((transaction.isServerTransaction() ? "Server TIMER EXPIRED:" : "Client TIMER EXPIRED:") + n + " x:" + transaction + " apdu:" + transaction.getApdu());
            }
            transaction.requestTimerExpired = true;
            if (transaction.isServerTransaction()) {
                Transaction.transport().serverRequestTimeout(transaction.getApdu());
            } else {
                Transaction.transport().clientRequestTimeout(transaction.getApdu());
            }
            return 0L;
        }
    }

    public static class SegmentTimer
    implements TimerListener {
        public int start(Transaction transaction, int n) {
            return Timers.add(this, n, transaction);
        }

        public void stop(int n) {
            Timers.cancel(n);
        }

        public long timerExpired(int n, Object object) {
            Transaction transaction = (Transaction)object;
            transaction.segmentTimerExpired = true;
            if (transaction.isServerTransaction()) {
                Transaction.transport().serverSegmentTimeout(transaction.getApdu());
            } else {
                Transaction.transport().clientSegmentTimeout(transaction.getApdu());
            }
            return 0L;
        }
    }
}

