/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.transport;

import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.BacnetUnconfirmedRequest;
import com.tridium.bacnet.stack.network.BBacnetNetworkLayer;
import com.tridium.bacnet.stack.server.BBacnetServerLayer;
import com.tridium.bacnet.stack.transport.AbortPdu;
import com.tridium.bacnet.stack.transport.ApplicationPdu;
import com.tridium.bacnet.stack.transport.ComplexAckPdu;
import com.tridium.bacnet.stack.transport.ConfirmedRequestPdu;
import com.tridium.bacnet.stack.transport.RejectPdu;
import com.tridium.bacnet.stack.transport.SegmentAckPdu;
import com.tridium.bacnet.stack.transport.ServerTransaction;
import com.tridium.bacnet.stack.transport.TransportStateMachine;
import com.tridium.bacnet.stack.transport.UnconfirmedRequestPdu;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.io.RejectException;
import javax.baja.log.Log;

public class ServerStateMachine
extends TransportStateMachine {
    private static final int STACK_PROCESSING_TIME = 25;

    public String getName() {
        return "BacnetServerTSM";
    }

    public void route(ApplicationPdu applicationPdu) {
        ServerStateMachine.process(applicationPdu);
    }

    public static final void process(ApplicationPdu applicationPdu) {
        ServerTransaction serverTransaction = ServerTransaction.find(applicationPdu);
        if (serverTransaction == null) {
            Idle.process(applicationPdu);
            return;
        }
        switch (serverTransaction.getState()) {
            case 1: {
                SegmentedRequest.process(applicationPdu, serverTransaction);
                break;
            }
            case 2: {
                AwaitResponse.process(applicationPdu, serverTransaction);
                break;
            }
            case 3: {
                SegmentedResponse.process(applicationPdu, serverTransaction);
                break;
            }
            case 0: {
                break;
            }
            default: {
                Log.getLog((String)"bacnet.transport").message("SSM.process: Invalid state for transaction: " + serverTransaction + " apdu=" + applicationPdu);
            }
        }
    }

    private static final void sendAbort(ApplicationPdu applicationPdu, int n) {
        AbortPdu abortPdu = new AbortPdu(applicationPdu.getClientAddress(), applicationPdu.getPriority(), applicationPdu.getInvokeId(), n, true);
        ServerStateMachine.network().sendRequest(applicationPdu.getClientAddress(), abortPdu);
    }

    private static final void sendReject(ApplicationPdu applicationPdu, int n) {
        RejectPdu rejectPdu = new RejectPdu(applicationPdu.getClientAddress(), applicationPdu.getPriority(), applicationPdu.getInvokeId(), n);
        ServerStateMachine.network().sendRequest(applicationPdu.getClientAddress(), rejectPdu);
    }

    private static final void sendSegmentNak(ServerTransaction serverTransaction, int n) {
        ServerStateMachine.sendSegmentAck(serverTransaction, true, n);
    }

    private static final void sendSegmentAck(ServerTransaction serverTransaction, boolean bl, int n) {
        SegmentAckPdu segmentAckPdu = new SegmentAckPdu(bl, true, serverTransaction.getInvokeId(), n, serverTransaction.getActualWindowSize());
        ServerStateMachine.network().sendRequest(serverTransaction.getClientAddress(), segmentAckPdu);
    }

    private static final void fillWindow(ServerTransaction serverTransaction) {
        int n;
        int n2 = 0;
        int n3 = serverTransaction.getNumSegments() - 1;
        int n4 = serverTransaction.getInitialSequenceNumber();
        int n5 = serverTransaction.getSegmentSize();
        int n6 = n4;
        int n7 = n = serverTransaction.getSegmentCounter();
        ComplexAckPdu complexAckPdu = serverTransaction.getResponse();
        do {
            ComplexAckPdu complexAckPdu2;
            n6 = n4 + n2;
            n7 = n + n2;
            if (n7 >= n3) {
                complexAckPdu2 = new ComplexAckPdu(complexAckPdu, ServerStateMachine.modulo(n6, 256), n5, n7);
                complexAckPdu2.setSegmentedMessage(true);
                complexAckPdu2.setMoreFollows(false);
                complexAckPdu2.setProposedWindowSize(serverTransaction.getProposedWindowSize());
                ServerStateMachine.network().sendRequest(serverTransaction.getClientAddress(), complexAckPdu2);
                serverTransaction.setSentAllSegments(true);
                return;
            }
            complexAckPdu2 = new ComplexAckPdu(complexAckPdu, ServerStateMachine.modulo(n6, 256), n5, n7);
            complexAckPdu2.setSegmentedMessage(true);
            complexAckPdu2.setMoreFollows(true);
            complexAckPdu2.setProposedWindowSize(serverTransaction.getProposedWindowSize());
            ServerStateMachine.network().sendRequest(serverTransaction.getClientAddress(), complexAckPdu2);
        } while (++n2 < serverTransaction.getActualWindowSize());
    }

    private static final boolean commEnabled(ApplicationPdu applicationPdu) {
        int n;
        boolean bl = stack.isCommExecutionEnabled();
        if (!bl && applicationPdu != null && (n = applicationPdu.getType()) == 0) {
            ConfirmedRequestPdu confirmedRequestPdu = (ConfirmedRequestPdu)applicationPdu;
            boolean bl2 = false;
            if (confirmedRequestPdu.getServiceChoice() == 17 || confirmedRequestPdu.getServiceChoice() == 20) {
                bl2 = true;
            }
            bl = bl2;
        }
        return bl;
    }

    private static final BBacnetNetworkLayer network() {
        return stack.getNetwork();
    }

    private static final BBacnetServerLayer server() {
        return stack.getServer();
    }

    static /* synthetic */ int access$3() {
        return 25;
    }

    private static class Idle {
        private static final void process(ApplicationPdu applicationPdu) {
            switch (applicationPdu.getSource()) {
                case 0: {
                    Log.getLog((String)"bacnet.transport").message("Idle.process: Invalid apdu source: APPLICATION: apdu=" + applicationPdu);
                    break;
                }
                case 1: {
                    Idle.processNetworkIndication(applicationPdu);
                    break;
                }
                case 2: {
                    Log.getLog((String)"bacnet.transport").message("Idle.process: Invalid apdu source: REQUEST_TIMEOUT: apdu=" + applicationPdu);
                    break;
                }
                case 3: {
                    Log.getLog((String)"bacnet.transport").message("Idle.process: Invalid apdu source: SEGMENT_TIMEOUT: apdu=" + applicationPdu);
                    break;
                }
                default: {
                    Log.getLog((String)"bacnet.transport").message("Idle.process: Invalid apdu source:" + applicationPdu.getSource() + " apdu=" + applicationPdu);
                }
            }
        }

        private static final void processNetworkIndication(ApplicationPdu applicationPdu) {
            if (!ServerStateMachine.commEnabled(applicationPdu)) {
                return;
            }
            switch (applicationPdu.getType()) {
                case 1: {
                    BacnetUnconfirmedRequest bacnetUnconfirmedRequest = BacnetUnconfirmedRequest.parseAPDU((UnconfirmedRequestPdu)applicationPdu);
                    if (bacnetUnconfirmedRequest == null) break;
                    ServerStateMachine.server().receiveUnconfirmedRequest(applicationPdu.getClientAddress(), bacnetUnconfirmedRequest, applicationPdu.getPriority());
                    break;
                }
                case 0: {
                    ConfirmedRequestPdu confirmedRequestPdu = (ConfirmedRequestPdu)applicationPdu;
                    ServerTransaction serverTransaction = new ServerTransaction(confirmedRequestPdu);
                    if (!confirmedRequestPdu.isSegmentedMessage()) {
                        try {
                            BacnetConfirmedRequest bacnetConfirmedRequest = BacnetConfirmedRequest.parseAPDU(confirmedRequestPdu);
                            ServerStateMachine.server().receiveConfirmedRequest(applicationPdu.getClientAddress(), applicationPdu.getInvokeId(), bacnetConfirmedRequest, applicationPdu.getPriority());
                            serverTransaction.startRequestTimer(BBacnetNetwork.localDevice().getApduTimeout() - 25);
                            serverTransaction.setState(2);
                        }
                        catch (RejectException rejectException) {
                            ServerStateMachine.sendReject(applicationPdu, rejectException.getRejectReason());
                        }
                        return;
                    }
                    if (confirmedRequestPdu.getSequenceNumber() != 0) {
                        ServerStateMachine.sendAbort(applicationPdu, 2);
                        serverTransaction.setState(0);
                        return;
                    }
                    if (!BBacnetNetwork.localDevice().getSegmentationSupported().isSegmentedReceive()) {
                        ServerStateMachine.sendAbort(applicationPdu, 4);
                        serverTransaction.setState(0);
                        return;
                    }
                    serverTransaction.setActualWindowSize(confirmedRequestPdu.getProposedWindowSize());
                    serverTransaction.setLastSequenceNumber(0);
                    serverTransaction.setInitialSequenceNumber(0);
                    serverTransaction.setDuplicateCount(0);
                    ServerStateMachine.sendSegmentAck(serverTransaction, false, 0);
                    serverTransaction.startSegmentWaitTimer(BBacnetNetwork.localDevice().getApduSegmentTimeout());
                    serverTransaction.setState(1);
                    break;
                }
                case 7: {
                    break;
                }
                case 4: {
                    ServerStateMachine.sendAbort(applicationPdu, 2);
                    break;
                }
                default: {
                    Log.getLog((String)"bacnet.transport").message("Idle.processNetworkIndication: Invalid apdu type:" + applicationPdu.getType() + " apdu=" + applicationPdu);
                }
            }
        }

        private Idle() {
        }
    }

    private static class SegmentedRequest {
        public static final void process(ApplicationPdu applicationPdu, ServerTransaction serverTransaction) {
            switch (applicationPdu.getSource()) {
                case 0: {
                    SegmentedRequest.processApplication(applicationPdu, serverTransaction);
                    break;
                }
                case 1: {
                    SegmentedRequest.processNetworkIndication(applicationPdu, serverTransaction);
                    break;
                }
                case 3: {
                    SegmentedRequest.processSegmentTimeout(applicationPdu, serverTransaction);
                    break;
                }
                default: {
                    Log.getLog((String)"bacnet.transport").message("SegReq.process: Invalid apdu source:" + applicationPdu.getSource() + " apdu=" + applicationPdu);
                }
            }
        }

        private static final void processApplication(ApplicationPdu applicationPdu, ServerTransaction serverTransaction) {
            switch (applicationPdu.getType()) {
                case 7: {
                    serverTransaction.stopSegmentTimer();
                    ServerStateMachine.network().sendRequest(applicationPdu.getClientAddress(), applicationPdu);
                    serverTransaction.setState(0);
                    break;
                }
                default: {
                    Log.getLog((String)"bacnet.transport").message("SegReq.processApplication: Invalid apdu type:" + applicationPdu.getType() + " apdu=" + applicationPdu);
                }
            }
        }

        private static final void processNetworkIndication(ApplicationPdu applicationPdu, ServerTransaction serverTransaction) {
            if (!ServerStateMachine.commEnabled(applicationPdu)) {
                return;
            }
            switch (applicationPdu.getType()) {
                case 0: {
                    ConfirmedRequestPdu confirmedRequestPdu = (ConfirmedRequestPdu)applicationPdu;
                    if (!confirmedRequestPdu.isSegmentedMessage()) {
                        serverTransaction.stopSegmentTimer();
                        ServerStateMachine.sendAbort(applicationPdu, 2);
                        serverTransaction.setState(0);
                        return;
                    }
                    int n = serverTransaction.getLastSequenceNumber();
                    int n2 = confirmedRequestPdu.getSequenceNumber();
                    int n3 = serverTransaction.getInitialSequenceNumber();
                    int n4 = serverTransaction.getActualWindowSize();
                    if (n2 != ServerStateMachine.modulo(n + 1, 256)) {
                        if (ServerStateMachine.duplicateInWindow(n2, ServerStateMachine.modulo(n3 + 1, 256), n, n4)) {
                            serverTransaction.restartSegmentWaitTimer(BBacnetNetwork.localDevice().getApduSegmentTimeout());
                            if (serverTransaction.getDuplicateCount() < n4) {
                                serverTransaction.incrementDuplicateCount();
                            } else {
                                ServerStateMachine.sendSegmentNak(serverTransaction, n);
                                serverTransaction.setDuplicateCount(0);
                            }
                        } else {
                            ServerStateMachine.sendSegmentAck(serverTransaction, true, n);
                            serverTransaction.setInitialSequenceNumber(n);
                            serverTransaction.setDuplicateCount(0);
                            serverTransaction.restartSegmentWaitTimer(BBacnetNetwork.localDevice().getApduSegmentTimeout());
                            return;
                        }
                    }
                    if (confirmedRequestPdu.getMoreFollows()) {
                        if (n2 != ServerStateMachine.modulo(n3 + n4, 256)) {
                            serverTransaction.getRequest().appendSegment(confirmedRequestPdu);
                            serverTransaction.setLastSequenceNumber(ServerStateMachine.modulo(n + 1, 256));
                            serverTransaction.restartSegmentWaitTimer(BBacnetNetwork.localDevice().getApduSegmentTimeout());
                            return;
                        }
                        serverTransaction.getRequest().appendSegment(confirmedRequestPdu);
                        n = ServerStateMachine.modulo(n + 1, 256);
                        serverTransaction.setLastSequenceNumber(n);
                        serverTransaction.setInitialSequenceNumber(n);
                        serverTransaction.setDuplicateCount(0);
                        ServerStateMachine.sendSegmentAck(serverTransaction, false, n);
                        serverTransaction.restartSegmentWaitTimer(BBacnetNetwork.localDevice().getApduSegmentTimeout());
                        return;
                    }
                    serverTransaction.getRequest().appendSegment(confirmedRequestPdu);
                    serverTransaction.stopSegmentTimer();
                    n = ServerStateMachine.modulo(n + 1, 256);
                    serverTransaction.setLastSequenceNumber(n);
                    serverTransaction.setInitialSequenceNumber(n);
                    ServerStateMachine.sendSegmentAck(serverTransaction, false, n);
                    try {
                        BacnetConfirmedRequest bacnetConfirmedRequest = BacnetConfirmedRequest.parseAPDU(serverTransaction.getRequest());
                        ServerStateMachine.server().receiveConfirmedRequest(applicationPdu.getClientAddress(), applicationPdu.getInvokeId(), bacnetConfirmedRequest, applicationPdu.getPriority());
                        serverTransaction.startRequestTimer(BBacnetNetwork.localDevice().getApduTimeout() - 25);
                        serverTransaction.setState(2);
                    }
                    catch (RejectException rejectException) {
                        ServerStateMachine.sendReject(applicationPdu, rejectException.getRejectReason());
                    }
                    break;
                }
                case 7: {
                    serverTransaction.stopSegmentTimer();
                    serverTransaction.setState(0);
                    break;
                }
                case 4: {
                    ServerStateMachine.sendAbort(applicationPdu, 2);
                    break;
                }
                default: {
                    Log.getLog((String)"bacnet.transport").message("SegReq.processNetworkIndication: Invalid apdu type:" + applicationPdu.getType() + " apdu=" + applicationPdu);
                }
            }
        }

        private static final void processSegmentTimeout(ApplicationPdu applicationPdu, ServerTransaction serverTransaction) {
            serverTransaction.stopSegmentTimer();
            serverTransaction.setState(0);
        }

        private SegmentedRequest() {
        }
    }

    private static class AwaitResponse {
        private static final void process(ApplicationPdu applicationPdu, ServerTransaction serverTransaction) {
            switch (applicationPdu.getSource()) {
                case 0: {
                    AwaitResponse.processApplication(applicationPdu, serverTransaction);
                    break;
                }
                case 1: {
                    AwaitResponse.processNetwork(applicationPdu, serverTransaction);
                    break;
                }
                case 2: {
                    AwaitResponse.processRequestTimeout(applicationPdu, serverTransaction);
                    break;
                }
                default: {
                    Log.getLog((String)"bacnet.transport").message("AwResp.process: Invalid apdu source:" + applicationPdu.getSource() + " apdu=" + applicationPdu);
                }
            }
        }

        private static final void processApplication(ApplicationPdu applicationPdu, ServerTransaction serverTransaction) {
            if (serverTransaction.isClientAbort()) {
                return;
            }
            switch (applicationPdu.getType()) {
                case 2: {
                    serverTransaction.stopRequestTimer();
                    ServerStateMachine.network().sendRequest(applicationPdu.getClientAddress(), applicationPdu);
                    serverTransaction.setState(0);
                    break;
                }
                case 3: {
                    ComplexAckPdu complexAckPdu = (ComplexAckPdu)applicationPdu;
                    serverTransaction.stopRequestTimer();
                    serverTransaction.setComplexAck(complexAckPdu);
                    ConfirmedRequestPdu confirmedRequestPdu = serverTransaction.getRequest();
                    int n = confirmedRequestPdu.getMaxAPDULengthAccepted();
                    int n2 = BBacnetNetwork.localDevice().getMaxAPDULengthAccepted();
                    int n3 = Math.min(n, n2);
                    if (complexAckPdu.getLength() + 3 <= n3) {
                        complexAckPdu.setSegmentedMessage(false);
                        ServerStateMachine.network().sendRequest(applicationPdu.getClientAddress(), applicationPdu);
                        serverTransaction.setState(0);
                        return;
                    }
                    if (!BBacnetNetwork.localDevice().getSegmentationSupported().isSegmentedTransmit()) {
                        ServerStateMachine.sendAbort(confirmedRequestPdu, 4);
                        serverTransaction.setState(0);
                        return;
                    }
                    if (!confirmedRequestPdu.getSegmentedResponseAccepted()) {
                        ServerStateMachine.sendAbort(confirmedRequestPdu, 4);
                        serverTransaction.setState(0);
                        return;
                    }
                    int n4 = complexAckPdu.getLength() / n3 + 1;
                    int n5 = confirmedRequestPdu.getMaxSegmentsAccepted();
                    if (!ConfirmedRequestPdu.canFit(n5, n4)) {
                        ServerStateMachine.sendAbort(confirmedRequestPdu, 1);
                        serverTransaction.setState(0);
                        return;
                    }
                    ComplexAckPdu complexAckPdu2 = new ComplexAckPdu(complexAckPdu, 0, n3, 0);
                    serverTransaction.setSentAllSegments(false);
                    serverTransaction.setSegmentRetryCount(0);
                    serverTransaction.setDuplicateCount(0);
                    serverTransaction.setInitialSequenceNumber(0);
                    serverTransaction.setSegmentCounter(0);
                    serverTransaction.setProposedWindowSize(DEFAULT_SEGMENTATION_WINDOW_SIZE);
                    serverTransaction.setActualWindowSize(1);
                    serverTransaction.setSegmentSize(n3);
                    serverTransaction.setNumSegments(complexAckPdu.getLength() / (n3 - 5) + 1);
                    complexAckPdu2.setSegmentedMessage(true);
                    complexAckPdu2.setMoreFollows(true);
                    complexAckPdu2.setProposedWindowSize(serverTransaction.getProposedWindowSize());
                    ServerStateMachine.network().sendRequest(applicationPdu.getClientAddress(), complexAckPdu2);
                    serverTransaction.startSegmentTimer(BBacnetNetwork.localDevice().getApduSegmentTimeout());
                    serverTransaction.setState(3);
                    break;
                }
                case 5: {
                    serverTransaction.stopRequestTimer();
                    ServerStateMachine.network().sendRequest(applicationPdu.getClientAddress(), applicationPdu);
                    serverTransaction.setState(0);
                    break;
                }
                case 7: {
                    serverTransaction.stopRequestTimer();
                    ServerStateMachine.network().sendRequest(applicationPdu.getClientAddress(), applicationPdu);
                    serverTransaction.setState(0);
                    break;
                }
                case 6: {
                    serverTransaction.stopRequestTimer();
                    ServerStateMachine.network().sendRequest(applicationPdu.getClientAddress(), applicationPdu);
                    serverTransaction.setState(0);
                    break;
                }
                default: {
                    Log.getLog((String)"bacnet.transport").message("AwResp.processApplication: Invalid apdu type:" + applicationPdu.getType() + " apdu=" + applicationPdu);
                }
            }
        }

        private static final void processNetwork(ApplicationPdu applicationPdu, ServerTransaction serverTransaction) {
            switch (applicationPdu.getType()) {
                case 7: {
                    serverTransaction.stopRequestTimer();
                    serverTransaction.clientAbort();
                    serverTransaction.setState(0);
                    break;
                }
                case 0: {
                    ConfirmedRequestPdu confirmedRequestPdu = (ConfirmedRequestPdu)applicationPdu;
                    if (!confirmedRequestPdu.isSegmentedMessage()) {
                        return;
                    }
                    ServerStateMachine.sendSegmentAck(serverTransaction, false, serverTransaction.getLastSequenceNumber());
                    break;
                }
                case 4: {
                    ServerStateMachine.sendAbort(applicationPdu, 2);
                    serverTransaction.setState(0);
                    break;
                }
                default: {
                    Log.getLog((String)"bacnet.transport").message("AwResp.processNetwork: Invalid apdu type:" + applicationPdu.getType() + " apdu=" + applicationPdu);
                }
            }
        }

        private static final void processRequestTimeout(ApplicationPdu applicationPdu, ServerTransaction serverTransaction) {
            serverTransaction.clientAbort();
            ServerStateMachine.sendAbort(applicationPdu, 0);
            serverTransaction.setState(0);
        }

        private AwaitResponse() {
        }
    }

    private static class SegmentedResponse {
        public static final void process(ApplicationPdu applicationPdu, ServerTransaction serverTransaction) {
            switch (applicationPdu.getSource()) {
                case 0: {
                    SegmentedResponse.processApplication(applicationPdu, serverTransaction);
                    break;
                }
                case 1: {
                    SegmentedResponse.processNetworkIndication(applicationPdu, serverTransaction);
                    break;
                }
                case 3: {
                    SegmentedResponse.processSegmentTimeout(applicationPdu, serverTransaction);
                    break;
                }
                default: {
                    Log.getLog((String)"bacnet.transport").message("SegRsp.process: Invalid apdu source:" + applicationPdu.getSource() + " apdu=" + applicationPdu);
                }
            }
        }

        private static final void processApplication(ApplicationPdu applicationPdu, ServerTransaction serverTransaction) {
            switch (applicationPdu.getType()) {
                case 7: {
                    serverTransaction.stopSegmentTimer();
                    ServerStateMachine.network().sendRequest(applicationPdu.getClientAddress(), applicationPdu);
                    serverTransaction.setState(0);
                    break;
                }
                default: {
                    Log.getLog((String)"bacnet.transport").message("SegRsp.processApplication: Invalid apdu type:" + applicationPdu.getType() + " apdu=" + applicationPdu);
                }
            }
        }

        private static final void processNetworkIndication(ApplicationPdu applicationPdu, ServerTransaction serverTransaction) {
            switch (applicationPdu.getType()) {
                case 4: {
                    SegmentAckPdu segmentAckPdu = (SegmentAckPdu)applicationPdu;
                    if (!ServerStateMachine.inWindow(segmentAckPdu.getSequenceNumber(), serverTransaction.getInitialSequenceNumber(), segmentAckPdu.getActualWindowSize())) {
                        serverTransaction.restartSegmentTimer(BBacnetNetwork.localDevice().getApduSegmentTimeout());
                        return;
                    }
                    if (!serverTransaction.getSentAllSegments()) {
                        int n = serverTransaction.getSegmentCounter();
                        serverTransaction.setSegmentCounter(n + serverTransaction.getActualWindowSize());
                        serverTransaction.setInitialSequenceNumber(ServerStateMachine.modulo(segmentAckPdu.getSequenceNumber() + 1, 256));
                        serverTransaction.setActualWindowSize(segmentAckPdu.getActualWindowSize());
                        serverTransaction.setSegmentRetryCount(0);
                        ServerStateMachine.fillWindow(serverTransaction);
                        serverTransaction.restartSegmentTimer(BBacnetNetwork.localDevice().getApduSegmentTimeout());
                        return;
                    }
                    serverTransaction.stopSegmentTimer();
                    serverTransaction.setState(0);
                    break;
                }
                case 7: {
                    serverTransaction.stopSegmentTimer();
                    serverTransaction.clientAbort();
                    serverTransaction.setState(0);
                    break;
                }
                case 0: {
                    serverTransaction.stopSegmentTimer();
                    ServerStateMachine.sendAbort(applicationPdu, 2);
                    serverTransaction.setState(0);
                    break;
                }
                default: {
                    Log.getLog((String)"bacnet.transport").message("SegRsp.processNetworkIndication: Invalid apdu type:" + applicationPdu.getType() + " apdu=" + applicationPdu);
                }
            }
        }

        private static final void processSegmentTimeout(ApplicationPdu applicationPdu, ServerTransaction serverTransaction) {
            int n = serverTransaction.getSegmentRetryCount();
            if (n < BBacnetNetwork.localDevice().getNumberOfApduRetries()) {
                serverTransaction.setSegmentRetryCount(++n);
                ServerStateMachine.fillWindow(serverTransaction);
                serverTransaction.restartSegmentTimer(BBacnetNetwork.localDevice().getApduSegmentTimeout());
            } else {
                serverTransaction.stopSegmentTimer();
                serverTransaction.setState(0);
            }
        }

        private SegmentedResponse() {
        }
    }
}

