/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.transport;

import com.tridium.bacnet.stack.BacnetStackErrorCodes;
import com.tridium.bacnet.stack.BacnetStackException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.ListIterator;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IntHashMap;
import javax.baja.spy.SpyWriter;

public class IdManager
implements BacnetStackErrorCodes {
    public static final int MAX_INVOKE_ID = 255;
    public static final int INVALID_INVOKE_ID = -1;
    private static IntHashMap table = new IntHashMap();
    private int lastIndex = -1;
    private BBacnetAddress serverAddress;
    private BitSet ids = new BitSet(256);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getInvokeId(BBacnetAddress bBacnetAddress) throws BacnetStackException {
        IntHashMap intHashMap = table;
        synchronized (intHashMap) {
            IdManager idManager = IdManager.getIdManager(bBacnetAddress);
            if (idManager == null) {
                idManager = new IdManager(bBacnetAddress);
                IdManager.setIdManager(bBacnetAddress, idManager);
            }
            return idManager.nextId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void releaseId(BBacnetAddress bBacnetAddress, int n) {
        IntHashMap intHashMap = table;
        synchronized (intHashMap) {
            IdManager idManager = IdManager.getIdManager(bBacnetAddress);
            if (idManager != null) {
                idManager.release(n);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void dump(BBacnetAddress bBacnetAddress) {
        IntHashMap intHashMap = table;
        synchronized (intHashMap) {
            IdManager idManager = IdManager.getIdManager(bBacnetAddress);
            if (idManager != null) {
                idManager.dump();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void dumpTable() {
        IntHashMap intHashMap = table;
        synchronized (intHashMap) {
            IntHashMap.Iterator iterator = table.iterator();
            block3: while (iterator.hasNext()) {
                Array array = (Array)iterator.next();
                ListIterator listIterator = array.iterator();
                while (true) {
                    if (!listIterator.hasNext()) continue block3;
                    IdManager idManager = (IdManager)listIterator.next();
                    if (idManager == null) continue;
                    idManager.dump();
                }
                break;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IdManager getIdManager(BBacnetAddress bBacnetAddress) {
        if (bBacnetAddress == null) {
            return null;
        }
        if (bBacnetAddress.equals(BBacnetAddress.DEFAULT)) {
            return null;
        }
        IdManager idManager = null;
        IntHashMap intHashMap = table;
        synchronized (intHashMap) {
            block7: {
                int n = bBacnetAddress.getNetworkNumber();
                Array array = (Array)table.get(n);
                byte[] byArray = bBacnetAddress.getMacAddress().getAddr();
                if (array == null) break block7;
                int n2 = 0;
                while (n2 < array.size()) {
                    IdManager idManager2 = (IdManager)array.get(n2);
                    if (Arrays.equals(byArray, idManager2.getAddress().getMacAddress().getAddr())) {
                        return idManager2;
                    }
                    ++n2;
                }
            }
            return idManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setIdManager(BBacnetAddress bBacnetAddress, IdManager idManager) {
        IntHashMap intHashMap = table;
        synchronized (intHashMap) {
            int n = bBacnetAddress.getNetworkNumber();
            Array array = (Array)table.get(n);
            if (array == null) {
                array = new Array();
                table.put(n, (Object)array);
            }
            array.remove((Object)idManager);
            array.add((Object)idManager);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps();
        spyWriter.trTitle((Object)"IdManager", 2);
        IntHashMap intHashMap = table;
        synchronized (intHashMap) {
            spyWriter.prop((Object)"table size", table.size());
            IntHashMap.Iterator iterator = table.iterator();
            while (iterator.hasNext()) {
                IdManager idManager = (IdManager)iterator.next();
                if (idManager == null) continue;
                idManager.spyMgr(spyWriter);
            }
        }
        spyWriter.endProps();
    }

    public void spyMgr(SpyWriter spyWriter) throws Exception {
        spyWriter.prop((Object)"server", (Object)this.serverAddress);
        spyWriter.prop((Object)"server.hashCode", (Object)Integer.toHexString(this.serverAddress.hashCode()));
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n <= 255) {
            stringBuffer.append(this.ids.get(n) ? (char)'-' : 'X');
            if (n % 64 == 63) {
                stringBuffer.append(' ');
            }
            ++n;
        }
        spyWriter.prop((Object)"avail", (Object)stringBuffer.toString());
    }

    private final synchronized int nextId() throws BacnetStackException {
        int n;
        int n2 = n = this.lastIndex++;
        try {
            do {
                if (++n > 255) {
                    n = 0;
                }
                if (!this.ids.get(n)) continue;
                this.ids.clear(n);
                this.lastIndex = n;
                return n;
            } while (n != n2);
            throw new BacnetStackException("No Invoke IDs available");
        }
        catch (Exception exception) {
            throw new BacnetStackException("No Invoke IDs available");
        }
    }

    private final synchronized void release(int n) {
        if (n > 255 || n < 0) {
            throw new IllegalArgumentException();
        }
        if (this.ids.get(n)) {
            throw new IllegalStateException();
        }
        this.ids.set(n);
    }

    public BBacnetAddress getAddress() {
        return this.serverAddress;
    }

    public String toString() {
        return this.serverAddress.toString(null) + " lst=" + this.lastIndex;
    }

    public void dump() {
        System.out.println("Dump for " + this + " (hc:" + this.serverAddress + ')');
        int n = 0;
        while (n < 255) {
            System.out.print(this.ids.get(n) ? (char)'-' : 'X');
            if (n % 64 == 63) {
                System.out.println();
            }
            ++n;
        }
        System.out.println();
    }

    private IdManager(BBacnetAddress bBacnetAddress) {
        int n = 0;
        while (n < 256) {
            this.ids.set(n);
            ++n;
        }
        this.serverAddress = bBacnetAddress;
    }
}

