/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.transport;

import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.BacnetStackErrorCodes;
import com.tridium.bacnet.stack.BacnetStackException;
import com.tridium.bacnet.stack.network.BNetworkPriority;
import com.tridium.bacnet.stack.transport.ApplicationPdu;
import com.tridium.bacnet.stack.transport.InvalidApduTypeException;
import com.tridium.bacnet.stack.transport.TransactionException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConfirmedServiceChoice;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConfirmedRequestPdu
extends ApplicationPdu
implements BacnetStackErrorCodes {
    public static final int SEG_FLAG = 8;
    public static final int MOR_FLAG = 4;
    public static final int SA_FLAG = 2;
    public static final int MAX_SEGS_MASK = 112;
    public static final int MAX_APDU_LEN_MASK = 15;
    private static final int SEG_HDR_LENGTH = 6;
    public static final int MAX_APDU_LENGTH_UP_TO_MIN_MSG_SIZE = 50;
    public static final int MAX_APDU_LENGTH_UP_TO_128_OCTETS = 128;
    public static final int MAX_APDU_LENGTH_UP_TO_206_OCTETS = 206;
    public static final int MAX_APDU_LENGTH_UP_TO_480_OCTETS = 480;
    public static final int MAX_APDU_LENGTH_UP_TO_1024_OCTETS = 1024;
    public static final int MAX_APDU_LENGTH_UP_TO_1476_OCTETS = 1476;
    private static final int[] MAX_APDU_LENGTHS = new int[]{50, 128, 206, 480, 1024, 1476};
    public static final int MAX_SEGS_UNSPECIFIED = 0;
    public static final int MAX_SEGS_2 = 2;
    public static final int MAX_SEGS_4 = 4;
    public static final int MAX_SEGS_8 = 8;
    public static final int MAX_SEGS_16 = 16;
    public static final int MAX_SEGS_32 = 32;
    public static final int MAX_SEGS_64 = 64;
    public static final int MAX_SEGS_GREATER_THAN_64 = 255;
    private static final int[] MAX_SEGS;
    private boolean segmentedMessage;
    private boolean moreFollows;
    private boolean segmentedResponseAccepted;
    private int maxSegmentsAccepted;
    private int maxAPDULengthAccepted;
    private int invokeId;
    private int sequenceNumber;
    private int proposedWindowSize;
    private int serviceChoice;
    private byte[] serviceRequest;
    private int segmentLength;
    private int segmentOffset;
    private int protocolRevision;
    ApplicationPdu confirmationApdu;
    boolean timedOut;
    boolean abandon;
    boolean cannotSend;

    public int getLength() {
        return this.serviceRequest.length;
    }

    public boolean isSegmentedMessage() {
        return this.segmentedMessage;
    }

    public boolean getSegmentedMessage() {
        return this.segmentedMessage;
    }

    public void setSegmentedMessage(boolean bl) {
        this.segmentedMessage = bl;
    }

    public boolean isMoreFollows() {
        return this.moreFollows;
    }

    public boolean getMoreFollows() {
        return this.moreFollows;
    }

    public void setMoreFollows(boolean bl) {
        this.moreFollows = bl;
    }

    public boolean isSegmentedResponseAccepted() {
        return this.segmentedResponseAccepted;
    }

    public boolean getSegmentedResponseAccepted() {
        return this.segmentedResponseAccepted;
    }

    public void setSegmentedResponseAccepted(boolean bl) {
        this.segmentedResponseAccepted = bl;
    }

    public int getMaxAPDULengthAccepted() {
        return this.maxAPDULengthAccepted;
    }

    public void setMaxAPDULengthAccepted(int n) {
        this.maxAPDULengthAccepted = n;
    }

    public int getMaxSegmentsAccepted() {
        return this.maxSegmentsAccepted;
    }

    public void setMaxSegmentsAccepted(int n) {
        this.maxSegmentsAccepted = n;
    }

    public int getInvokeId() {
        return this.invokeId;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int n) {
        this.sequenceNumber = n;
        if (this.segmentLength != -1) {
            this.segmentOffset = this.segmentLength * n;
        }
    }

    public int getProposedWindowSize() {
        return this.proposedWindowSize;
    }

    public void setProposedWindowSize(int n) {
        this.proposedWindowSize = n;
    }

    public int getServiceChoice() {
        return this.serviceChoice;
    }

    public byte[] getServiceRequest() {
        return this.serviceRequest;
    }

    public void appendSegment(ConfirmedRequestPdu confirmedRequestPdu) {
        byte[] byArray = confirmedRequestPdu.serviceRequest;
        byte[] byArray2 = new byte[this.serviceRequest.length + byArray.length];
        System.arraycopy(this.serviceRequest, 0, byArray2, 0, this.serviceRequest.length);
        System.arraycopy(byArray, 0, byArray2, this.serviceRequest.length, byArray.length);
        this.serviceRequest = byArray2;
    }

    public boolean isServerPDU() {
        return false;
    }

    public boolean isClientPDU() {
        return true;
    }

    public String toString() {
        return this.msg();
    }

    public String trace() {
        StringBuffer stringBuffer = new StringBuffer("Confirmed-Request-PDU:");
        stringBuffer.append("\n\tSEG = " + this.segmentedMessage);
        stringBuffer.append("\n\tMOR = " + this.moreFollows);
        stringBuffer.append("\n\tSA = " + this.segmentedResponseAccepted);
        stringBuffer.append("\n\tMax Resp = " + this.maxAPDULengthAccepted);
        stringBuffer.append("\n\tInvoke ID = " + this.invokeId);
        if (this.segmentedMessage) {
            stringBuffer.append("\n\tSeq # = " + this.sequenceNumber);
            stringBuffer.append("\n\tPropWinSize = " + this.proposedWindowSize);
            stringBuffer.append("\n\tsegOff = " + this.segmentOffset);
            stringBuffer.append("\n\tsegLen = " + this.segmentLength);
        }
        stringBuffer.append("\n\tService Choice = " + BacnetConfirmedServiceChoice.TAGS[this.serviceChoice]);
        if (this.serviceRequest != null) {
            stringBuffer.append("\n\tService Request (length) = ").append(this.serviceRequest.length).append("\n\t");
            if (this.segmentedMessage) {
                int n = 0;
                if (this.segmentOffset >= 0) {
                    n = this.segmentOffset;
                }
                int n2 = 0;
                if (this.segmentLength >= 0) {
                    n2 = this.segmentLength;
                }
                stringBuffer.append(ByteArrayUtil.toHexString((byte[])this.serviceRequest, (int)n, (int)n2));
            } else {
                stringBuffer.append(ByteArrayUtil.toHexString((byte[])this.serviceRequest));
            }
        }
        this.addAPDUData(stringBuffer);
        return stringBuffer.toString();
    }

    public String msg() {
        StringBuffer stringBuffer = new StringBuffer("ConfReqPDU:");
        stringBuffer.append(this.segmentedMessage ? " SEG" : " ---");
        stringBuffer.append(this.moreFollows ? " MOR" : " ---");
        stringBuffer.append(this.segmentedResponseAccepted ? " SA" : " --");
        stringBuffer.append(' ').append(this.maxAPDULengthAccepted);
        stringBuffer.append(' ').append(this.invokeId);
        if (this.segmentedMessage) {
            stringBuffer.append(' ').append(this.sequenceNumber).append(' ').append(this.proposedWindowSize);
        }
        stringBuffer.append(' ').append(BacnetConfirmedServiceChoice.TAGS[this.serviceChoice]);
        this.addAPDUMsg(stringBuffer);
        return stringBuffer.toString();
    }

    public void writeNetworkBytes(ByteArrayOutputStream byteArrayOutputStream) {
        int n = 0;
        if (this.segmentedMessage) {
            n |= 8;
        }
        if (this.moreFollows) {
            n |= 4;
        }
        if (this.segmentedResponseAccepted) {
            n |= 2;
        }
        byteArrayOutputStream.write(n);
        int n2 = 0;
        if (this.protocolRevision >= 2) {
            n2 = ConfirmedRequestPdu.getMaxSegsCode(this.maxSegmentsAccepted) << 4;
        }
        byteArrayOutputStream.write(n2 |= ConfirmedRequestPdu.getMaxAPDULengthCode(this.maxAPDULengthAccepted));
        byteArrayOutputStream.write(this.invokeId);
        if (this.segmentedMessage) {
            byteArrayOutputStream.write(this.sequenceNumber);
            byteArrayOutputStream.write(this.proposedWindowSize);
        }
        byteArrayOutputStream.write(this.serviceChoice);
        if (this.segmentLength == -1) {
            byteArrayOutputStream.write(this.serviceRequest, 0, this.serviceRequest.length);
        } else {
            int n3 = this.segmentOffset + this.segmentLength - 6 < this.serviceRequest.length ? this.segmentLength - 6 : this.serviceRequest.length - this.segmentOffset;
            byteArrayOutputStream.write(this.serviceRequest, this.segmentOffset, n3);
        }
    }

    public void readNetworkBytes(ByteArrayInputStream byteArrayInputStream) throws BacnetStackException {
        int n = byteArrayInputStream.read();
        int n2 = (n & 0xF0) >> 4;
        if (n2 != 0) {
            throw new InvalidApduTypeException(0, n2);
        }
        if ((n & 8) != 0) {
            this.segmentedMessage = true;
        }
        if ((n & 4) != 0) {
            this.moreFollows = true;
        }
        if ((n & 2) != 0) {
            this.segmentedResponseAccepted = true;
        }
        int n3 = byteArrayInputStream.read();
        this.maxSegmentsAccepted = ConfirmedRequestPdu.getMaxSegs((n3 & 0x70) >> 4);
        this.maxAPDULengthAccepted = ConfirmedRequestPdu.getMaxAPDULength(n3 & 0xF);
        this.invokeId = byteArrayInputStream.read();
        if (this.segmentedMessage) {
            this.sequenceNumber = byteArrayInputStream.read();
            this.proposedWindowSize = byteArrayInputStream.read();
        }
        this.serviceChoice = byteArrayInputStream.read();
        this.serviceRequest = new byte[byteArrayInputStream.available()];
        byteArrayInputStream.read(this.serviceRequest, 0, this.serviceRequest.length);
    }

    private static final int getMaxAPDULengthCode(int n) {
        if (n > 1024) {
            return 5;
        }
        if (n > 480) {
            return 4;
        }
        if (n > 206) {
            return 3;
        }
        if (n > 128) {
            return 2;
        }
        if (n > 50) {
            return 1;
        }
        return 0;
    }

    private static final int getMaxAPDULength(int n) {
        try {
            return MAX_APDU_LENGTHS[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0;
        }
    }

    private static final int getMaxSegsCode(int n) {
        if (n > 64) {
            return 7;
        }
        if (n == 64) {
            return 6;
        }
        if (n >= 32) {
            return 5;
        }
        if (n >= 16) {
            return 4;
        }
        if (n >= 8) {
            return 3;
        }
        if (n >= 4) {
            return 2;
        }
        if (n >= 2) {
            return 1;
        }
        return 0;
    }

    private static final int getMaxSegs(int n) {
        try {
            return MAX_SEGS[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0;
        }
    }

    public static boolean canFit(int n, int n2) {
        if (n <= 0) {
            return true;
        }
        boolean bl = false;
        if (n >= n2) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApplicationPdu waitForConfirmation() throws BacnetStackException {
        ConfirmedRequestPdu confirmedRequestPdu = this;
        synchronized (confirmedRequestPdu) {
            try {
                if (this.cannotSend) {
                    throw new BacnetStackException("Cannot send packet: invoke ID " + this.invokeId);
                }
                this.wait(this.getLockupThreshold());
                if (this.confirmationApdu != null) {
                    return this.confirmationApdu;
                }
                if (this.abandon) {
                    throw new TransactionException("abandoned: invoke ID " + this.invokeId);
                }
                if (this.cannotSend) {
                    throw new BacnetStackException("Cannot send packet: invoke ID " + this.invokeId);
                }
                if (!this.timedOut) {
                    throw new TransactionException("lockup: invoke ID " + this.invokeId);
                }
                throw new TransactionException("timeout: invoke ID " + this.invokeId);
            }
            catch (InterruptedException interruptedException) {
                log.warning("Timeout due to interruption waiting for response!");
                throw new TransactionException("timeout: invoke ID " + this.invokeId);
            }
        }
    }

    public synchronized void postConfirmation(ApplicationPdu applicationPdu) {
        if (log.isTraceOn()) {
            log.trace("Post confirmation: " + applicationPdu.getInvokeId());
        }
        this.confirmationApdu = applicationPdu;
        this.notifyAll();
    }

    public synchronized void timeout() {
        log.error("Transaction Timed out! invokeId " + this.invokeId);
        this.timedOut = true;
        this.notifyAll();
    }

    public synchronized void abandon(Exception exception) {
        log.error("Transaction abandoned! invokeId " + this.invokeId + " exception:" + exception);
        this.abandon = true;
        this.notifyAll();
    }

    public synchronized void cannotSend(Exception exception) {
        log.error("Cannot send packet: invoke ID " + this.invokeId + ':' + exception.getMessage());
        this.cannotSend = true;
        this.notifyAll();
    }

    private final long getLockupThreshold() {
        return ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getTransport().getLockupThreshold().getMillis();
    }

    private final /* synthetic */ void this() {
        this.segmentLength = -1;
        this.segmentOffset = -1;
        this.protocolRevision = 0;
        this.confirmationApdu = null;
        this.timedOut = false;
        this.abandon = false;
        this.cannotSend = false;
    }

    public ConfirmedRequestPdu(BBacnetAddress bBacnetAddress, BBacnetAddress bBacnetAddress2, BNetworkPriority bNetworkPriority, int n, int n2, byte[] byArray, int n3) {
        super(bBacnetAddress, bBacnetAddress2, bNetworkPriority, 0);
        this.this();
        this.setDataExpectingReply(true);
        this.invokeId = n;
        this.serviceChoice = n2;
        this.serviceRequest = byArray;
        this.protocolRevision = n3;
    }

    public ConfirmedRequestPdu(ConfirmedRequestPdu confirmedRequestPdu, int n, int n2, int n3) {
        super(null, confirmedRequestPdu.getServerAddress(), confirmedRequestPdu.getPriority(), 0);
        this.this();
        this.invokeId = confirmedRequestPdu.invokeId;
        this.serviceChoice = confirmedRequestPdu.serviceChoice;
        this.serviceRequest = confirmedRequestPdu.serviceRequest;
        this.maxAPDULengthAccepted = confirmedRequestPdu.maxAPDULengthAccepted;
        this.maxSegmentsAccepted = confirmedRequestPdu.maxSegmentsAccepted;
        this.segmentedResponseAccepted = confirmedRequestPdu.segmentedResponseAccepted;
        this.protocolRevision = confirmedRequestPdu.protocolRevision;
        this.segmentedMessage = true;
        this.setDataExpectingReply(confirmedRequestPdu.getDataExpectingReply());
        this.segmentLength = n2;
        this.segmentOffset = (n2 - 6) * n3;
        this.sequenceNumber = n;
    }

    public ConfirmedRequestPdu(ByteArrayInputStream byteArrayInputStream) throws BacnetStackException {
        super(0);
        this.this();
        this.readNetworkBytes(byteArrayInputStream);
    }

    static {
        int[] nArray = new int[8];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 8;
        nArray[4] = 16;
        nArray[5] = 32;
        nArray[6] = 64;
        nArray[7] = 255;
        MAX_SEGS = nArray;
    }
}

