/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.transport;

import com.tridium.bacnet.stack.BacnetStackException;
import com.tridium.bacnet.stack.network.BNetworkPriority;
import com.tridium.bacnet.stack.transport.ApplicationPdu;
import com.tridium.bacnet.stack.transport.InvalidApduTypeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.baja.bacnet.BacnetConfirmedServiceChoice;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ComplexAckPdu
extends ApplicationPdu {
    public static final int SEG_FLAG_MASK = 8;
    public static final int MOR_FLAG_MASK = 4;
    public static final int SEG_FLAG = 8;
    public static final int MOR_FLAG = 4;
    private boolean segmentedMessage;
    private boolean moreFollows;
    private int originalInvokeId;
    private int sequenceNumber;
    private int proposedWindowSize;
    private int serviceAckChoice;
    private byte[] serviceAck;
    private int segmentLength;
    private int segmentOffset;

    public int getLength() {
        return this.serviceAck.length;
    }

    public boolean isSegmentedMessage() {
        return this.segmentedMessage;
    }

    public boolean getSegmentedMessage() {
        return this.segmentedMessage;
    }

    public void setSegmentedMessage(boolean bl) {
        this.segmentedMessage = bl;
    }

    public boolean isMoreFollows() {
        return this.moreFollows;
    }

    public boolean getMoreFollows() {
        return this.moreFollows;
    }

    public void setMoreFollows(boolean bl) {
        this.moreFollows = bl;
    }

    public int getInvokeId() {
        return this.originalInvokeId;
    }

    public void setInvokeId(int n) {
        this.originalInvokeId = n;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int n) {
        this.sequenceNumber = n;
        if (this.segmentLength != -1) {
            this.segmentOffset = this.segmentLength * n;
        }
    }

    public int getProposedWindowSize() {
        return this.proposedWindowSize;
    }

    public void setProposedWindowSize(int n) {
        this.proposedWindowSize = n;
    }

    public int getServiceAckChoice() {
        return this.serviceAckChoice;
    }

    public byte[] getServiceAck() {
        return this.serviceAck;
    }

    public void appendSegment(ComplexAckPdu complexAckPdu) {
        byte[] byArray = complexAckPdu.serviceAck;
        byte[] byArray2 = new byte[this.serviceAck.length + byArray.length];
        System.arraycopy(this.serviceAck, 0, byArray2, 0, this.serviceAck.length);
        System.arraycopy(byArray, 0, byArray2, this.serviceAck.length, byArray.length);
        this.serviceAck = byArray2;
    }

    public boolean isServerPDU() {
        return true;
    }

    public boolean isClientPDU() {
        return false;
    }

    public void writeNetworkBytes(ByteArrayOutputStream byteArrayOutputStream) {
        int n = 48;
        if (this.segmentedMessage) {
            n |= 8;
        }
        if (this.moreFollows) {
            n |= 4;
        }
        byteArrayOutputStream.write(n);
        byteArrayOutputStream.write(this.originalInvokeId);
        if (this.segmentedMessage) {
            byteArrayOutputStream.write(this.sequenceNumber);
            byteArrayOutputStream.write(this.proposedWindowSize);
        }
        byteArrayOutputStream.write(this.serviceAckChoice);
        if (this.segmentLength == -1) {
            byteArrayOutputStream.write(this.serviceAck, 0, this.serviceAck.length);
        } else {
            int n2 = this.segmentOffset + this.segmentLength - 5 < this.serviceAck.length ? this.segmentLength - 5 : this.serviceAck.length - this.segmentOffset;
            byteArrayOutputStream.write(this.serviceAck, this.segmentOffset, n2);
        }
    }

    public void readNetworkBytes(ByteArrayInputStream byteArrayInputStream) throws BacnetStackException {
        int n = byteArrayInputStream.read();
        int n2 = (n & 0xF0) >> 4;
        if (n2 != 3) {
            throw new InvalidApduTypeException(n2);
        }
        if ((n & 8) == 8) {
            this.segmentedMessage = true;
        }
        if ((n & 4) == 4) {
            this.moreFollows = true;
        }
        this.originalInvokeId = byteArrayInputStream.read();
        if (this.segmentedMessage) {
            this.sequenceNumber = byteArrayInputStream.read();
            this.proposedWindowSize = byteArrayInputStream.read();
        }
        this.serviceAckChoice = byteArrayInputStream.read();
        this.serviceAck = new byte[byteArrayInputStream.available()];
        byteArrayInputStream.read(this.serviceAck, 0, this.serviceAck.length);
    }

    public String toString() {
        return this.msg();
    }

    public String trace() {
        StringBuffer stringBuffer = new StringBuffer("Complex-ACK-PDU:");
        stringBuffer.append("\n\tSEG = " + this.segmentedMessage);
        stringBuffer.append("\n\tMOR = " + this.moreFollows);
        stringBuffer.append("\n\tOrig Invoke ID = " + this.originalInvokeId);
        if (this.segmentedMessage) {
            stringBuffer.append("\n\tSeq # = " + this.sequenceNumber);
            stringBuffer.append("\n\tPropWinSize = " + this.proposedWindowSize);
        }
        stringBuffer.append("\n\tServiceAck Choice = " + BacnetConfirmedServiceChoice.TAGS[this.serviceAckChoice]);
        if (this.serviceAck != null) {
            stringBuffer.append("\n\tService Ack (length) = ").append(this.serviceAck.length).append("\n\t");
            if (this.segmentedMessage) {
                stringBuffer.append(ByteArrayUtil.toHexString((byte[])this.serviceAck, (int)this.segmentOffset, (int)this.segmentLength));
            } else {
                stringBuffer.append(ByteArrayUtil.toHexString((byte[])this.serviceAck));
            }
        }
        this.addAPDUData(stringBuffer);
        return stringBuffer.toString();
    }

    public String msg() {
        StringBuffer stringBuffer = new StringBuffer("CxAckPDU:");
        stringBuffer.append(this.segmentedMessage ? " SEG" : " ---");
        stringBuffer.append(this.moreFollows ? " MOR" : " ---");
        stringBuffer.append(' ').append(this.originalInvokeId);
        if (this.segmentedMessage) {
            stringBuffer.append(' ').append(this.sequenceNumber).append(' ').append(this.proposedWindowSize);
        }
        stringBuffer.append(' ').append(BacnetConfirmedServiceChoice.TAGS[this.serviceAckChoice]);
        this.addAPDUMsg(stringBuffer);
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.segmentLength = -1;
        this.segmentOffset = -1;
    }

    public ComplexAckPdu(BBacnetAddress bBacnetAddress, BNetworkPriority bNetworkPriority, int n, int n2, byte[] byArray) {
        super(bBacnetAddress, null, bNetworkPriority, 3);
        this.this();
        this.serviceAckChoice = n2;
        this.originalInvokeId = n;
        this.serviceAck = byArray;
    }

    public ComplexAckPdu(ComplexAckPdu complexAckPdu, int n, int n2, int n3) {
        super(complexAckPdu.getClientAddress(), null, complexAckPdu.getPriority(), 3);
        this.this();
        this.serviceAckChoice = complexAckPdu.serviceAckChoice;
        this.originalInvokeId = complexAckPdu.originalInvokeId;
        this.serviceAck = complexAckPdu.serviceAck;
        this.segmentLength = n2;
        this.segmentOffset = (n2 - 5) * n3;
        this.sequenceNumber = n;
    }

    public ComplexAckPdu(ByteArrayInputStream byteArrayInputStream) throws BacnetStackException {
        super(3);
        this.this();
        this.readNetworkBytes(byteArrayInputStream);
    }
}

