/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.transport;

import com.tridium.bacnet.stack.transport.ApplicationPdu;
import com.tridium.bacnet.stack.transport.ComplexAckPdu;
import com.tridium.bacnet.stack.transport.ConfirmedRequestPdu;
import com.tridium.bacnet.stack.transport.Transaction;
import com.tridium.bacnet.stack.transport.TransactionList;
import javax.baja.bacnet.datatypes.BBacnetAddress;

public class ClientTransaction
extends Transaction {
    static TransactionList activeTransactions = new TransactionList();
    private ConfirmedRequestPdu apdu;
    private ComplexAckPdu complexAck;

    public ConfirmedRequestPdu getRequestPdu() {
        return this.apdu;
    }

    protected ApplicationPdu getApdu() {
        return this.apdu;
    }

    public BBacnetAddress getClientAddress() {
        return this.apdu.getClientAddress();
    }

    public BBacnetAddress getServerAddress() {
        return this.apdu.getServerAddress();
    }

    public BBacnetAddress getAddress() {
        return this.apdu.getServerAddress();
    }

    public int getInvokeId() {
        return this.apdu.getInvokeId();
    }

    public boolean isServerTransaction() {
        return false;
    }

    public void setComplexAck(ComplexAckPdu complexAckPdu) {
        this.complexAck = complexAckPdu;
    }

    public ComplexAckPdu getResponse() {
        return this.complexAck;
    }

    protected TransactionList activeTransactions() {
        return activeTransactions;
    }

    public long getHashCode() {
        return ClientTransaction.hash(this.getServerAddress(), this.getInvokeId());
    }

    public void postConfirmation(ApplicationPdu applicationPdu) {
        this.apdu.postConfirmation(applicationPdu);
    }

    public void timeout() {
        this.apdu.timeout();
    }

    public static ClientTransaction find(ApplicationPdu applicationPdu) {
        return (ClientTransaction)activeTransactions.get(applicationPdu.getServerAddress(), applicationPdu.getInvokeId());
    }

    protected String getTag(int n) {
        switch (n) {
            case 0: {
                return "IDLE";
            }
            case 1: {
                return "SEGMENTED_REQUEST";
            }
            case 2: {
                return "AWAIT_CONFIRMATION";
            }
            case 3: {
                return "SEGMENT_CONF";
            }
        }
        throw new IllegalStateException();
    }

    public ClientTransaction(ConfirmedRequestPdu confirmedRequestPdu) {
        this.apdu = confirmedRequestPdu;
    }
}

