/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.transport;

import com.tridium.bacnet.services.BacnetAbort;
import com.tridium.bacnet.services.BacnetComplexAck;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.BacnetError;
import com.tridium.bacnet.services.BacnetReject;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.BacnetSimpleAck;
import com.tridium.bacnet.services.BacnetUnconfirmedRequest;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.BacnetInputStream;
import com.tridium.bacnet.stack.BacnetStackErrorCodes;
import com.tridium.bacnet.stack.BacnetStackException;
import com.tridium.bacnet.stack.DeviceRegistry;
import com.tridium.bacnet.stack.network.BBacnetNetworkLayer;
import com.tridium.bacnet.stack.network.BNetworkPriority;
import com.tridium.bacnet.stack.transport.AbortPdu;
import com.tridium.bacnet.stack.transport.ApplicationPdu;
import com.tridium.bacnet.stack.transport.ClientStateMachine;
import com.tridium.bacnet.stack.transport.ClientTransaction;
import com.tridium.bacnet.stack.transport.ComplexAckPdu;
import com.tridium.bacnet.stack.transport.ConfirmedRequestPdu;
import com.tridium.bacnet.stack.transport.ErrorPdu;
import com.tridium.bacnet.stack.transport.IdManager;
import com.tridium.bacnet.stack.transport.InvalidApduTypeException;
import com.tridium.bacnet.stack.transport.RejectPdu;
import com.tridium.bacnet.stack.transport.ServerStateMachine;
import com.tridium.bacnet.stack.transport.ServerTransaction;
import com.tridium.bacnet.stack.transport.SimpleAckPdu;
import com.tridium.bacnet.stack.transport.TransportStateMachine;
import com.tridium.bacnet.stack.transport.UnconfirmedRequestPdu;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.io.AbortException;
import javax.baja.bacnet.io.ErrorException;
import javax.baja.bacnet.io.RejectException;
import javax.baja.log.Log;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;
import javax.baja.util.QueueFullException;
import javax.baja.util.Worker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetTransportLayer
extends BComponent
implements BacnetStackErrorCodes {
    public static final Property clientQueueSize = BBacnetTransportLayer.newProperty((int)0, (int)100, null);
    public static final Property serverQueueSize = BBacnetTransportLayer.newProperty((int)0, (int)100, null);
    public static final Property lockupThreshold = BBacnetTransportLayer.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)30), null);
    public static final Action dumpStats = BBacnetTransportLayer.newAction((int)0, null);
    public static final Action resetStats = BBacnetTransportLayer.newAction((int)0, null);
    public static final Type TYPE;
    public static final Log log;
    private TransportHelper server;
    private TransportHelper client;
    private ServerStateMachine ssm;
    private ClientStateMachine csm;
    static /* synthetic */ Class class$com$tridium$bacnet$stack$transport$BBacnetTransportLayer;

    public int getClientQueueSize() {
        return this.getInt(clientQueueSize);
    }

    public void setClientQueueSize(int n) {
        this.setInt(clientQueueSize, n, null);
    }

    public int getServerQueueSize() {
        return this.getInt(serverQueueSize);
    }

    public void setServerQueueSize(int n) {
        this.setInt(serverQueueSize, n, null);
    }

    public BRelTime getLockupThreshold() {
        return (BRelTime)this.get(lockupThreshold);
    }

    public void setLockupThreshold(BRelTime bRelTime) {
        this.set(lockupThreshold, (BValue)bRelTime, null);
    }

    public void dumpStats() {
        this.invoke(dumpStats, null, null);
    }

    public void resetStats() {
        this.invoke(resetStats, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        TransportStateMachine.startStack((BBacnetStack)this.getParent());
        this.ssm = new ServerStateMachine();
        this.csm = new ClientStateMachine();
        this.server = new TransportHelper("BnTSvr", this.ssm, new Queue(this.getServerQueueSize()));
        this.client = new TransportHelper("BnTCli", this.csm, new Queue(this.getClientQueueSize()));
        this.server.start();
        this.client.start();
    }

    public void stackStopped() {
        this.server.stop();
        this.client.stop();
        this.server = null;
        this.client = null;
        TransportStateMachine.stopStack();
        this.ssm = null;
        this.csm = null;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)clientQueueSize)) {
            this.client.stop();
            this.client = new TransportHelper("BnTCli", this.csm, new Queue(this.getClientQueueSize()));
            this.client.start();
        } else if (property.equals((Object)serverQueueSize)) {
            this.server.stop();
            this.server = new TransportHelper("BnTSvr", this.ssm, new Queue(this.getServerQueueSize()));
            this.server.start();
        } else if (property.equals((Object)lockupThreshold)) {
            if (context == BacnetConst.fallback) {
                return;
            }
            int n = BBacnetNetwork.localDevice().getNumberOfApduRetries();
            int n2 = BBacnetNetwork.localDevice().getApduTimeout();
            int n3 = n2 * (n + 1);
            if (this.getLockupThreshold().getMillis() < (long)n3) {
                log.message("Lockup Threshold set too short - resetting to minimum based on APDU_Timeout and Number_Of_APDU_Retries");
                this.set(lockupThreshold, (BValue)BRelTime.make((long)n3), BacnetConst.fallback);
            }
        }
    }

    public final boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BBacnetStack;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps("BACnet Transport Layer");
        spyWriter.trTitle((Object)"Client", 2);
        this.client.spy(spyWriter);
        spyWriter.trTitle((Object)"Server", 2);
        this.server.spy(spyWriter);
        spyWriter.endProps();
    }

    public BacnetSimpleAck sendConfirmedRequestSimple(BacnetConfirmedRequest bacnetConfirmedRequest, BBacnetAddress bBacnetAddress, BNetworkPriority bNetworkPriority) throws BacnetException {
        return (BacnetSimpleAck)this.sendConfirmedRequest(bacnetConfirmedRequest, bBacnetAddress, bNetworkPriority, 2);
    }

    public BacnetComplexAck sendConfirmedRequestComplex(BacnetConfirmedRequest bacnetConfirmedRequest, BBacnetAddress bBacnetAddress, BNetworkPriority bNetworkPriority) throws BacnetException {
        return (BacnetComplexAck)this.sendConfirmedRequest(bacnetConfirmedRequest, bBacnetAddress, bNetworkPriority, 3);
    }

    public void sendUnconfirmedRequest(BacnetUnconfirmedRequest bacnetUnconfirmedRequest, BBacnetAddress bBacnetAddress, BNetworkPriority bNetworkPriority) throws BacnetException {
        if (bBacnetAddress == null) {
            throw new BacnetStackException("Unresolved device address");
        }
        UnconfirmedRequestPdu unconfirmedRequestPdu = new UnconfirmedRequestPdu(bBacnetAddress, bNetworkPriority, bacnetUnconfirmedRequest.getServiceChoice(), bacnetUnconfirmedRequest.toEncodedBytes());
        this.client.queueApplication(unconfirmedRequestPdu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BacnetServicePrimitive sendConfirmedRequest(BacnetConfirmedRequest bacnetConfirmedRequest, BBacnetAddress bBacnetAddress, BNetworkPriority bNetworkPriority, int n) throws BacnetException {
        BacnetServicePrimitive bacnetServicePrimitive;
        if (bBacnetAddress == null) {
            throw new BacnetStackException("Unresolved device address");
        }
        if (bBacnetAddress.getMacAddress().equals((Object)BBacnetOctetString.DEFAULT)) {
            throw new BacnetStackException("Unresolved device address");
        }
        int n2 = IdManager.getInvokeId(bBacnetAddress);
        ApplicationPdu applicationPdu = null;
        try {
            int n3 = DeviceRegistry.getProtocolRevision(bBacnetAddress);
            ConfirmedRequestPdu confirmedRequestPdu = new ConfirmedRequestPdu(this.network().getAddress(bBacnetAddress.getNetworkNumber()), bBacnetAddress, bNetworkPriority, n2, bacnetConfirmedRequest.getServiceChoice(), bacnetConfirmedRequest.toEncodedBytes(), n3);
            confirmedRequestPdu.setMaxAPDULengthAccepted(BBacnetNetwork.localDevice().getMaxAPDULengthAccepted());
            confirmedRequestPdu.setSegmentedResponseAccepted(BBacnetNetwork.localDevice().getSegmentationSupported().isSegmentedReceive());
            this.client.queueApplication(confirmedRequestPdu);
            applicationPdu = confirmedRequestPdu.waitForConfirmation();
            BacnetServicePrimitive bacnetServicePrimitive2 = null;
            switch (applicationPdu.getType()) {
                case 2: {
                    if (n != 2) {
                        throw new InvalidApduTypeException("Invalid Response Type", n, 2);
                    }
                    bacnetServicePrimitive2 = bacnetConfirmedRequest.parseAck(((SimpleAckPdu)applicationPdu).getServiceAckChoice(), null);
                    break;
                }
                case 3: {
                    if (n != 3) {
                        throw new InvalidApduTypeException("Invalid Response Type", n, 3);
                    }
                    bacnetServicePrimitive2 = bacnetConfirmedRequest.parseAck(((ComplexAckPdu)applicationPdu).getServiceAckChoice(), ((ComplexAckPdu)applicationPdu).getServiceAck());
                    break;
                }
                case 5: {
                    BacnetError bacnetError = bacnetConfirmedRequest.parseError(((ErrorPdu)applicationPdu).getErrorChoice(), ((ErrorPdu)applicationPdu).getError());
                    log.trace("Error PDU received:" + bacnetError);
                    throw new ErrorException(bacnetError.getError(), bacnetError.getErrorParameters());
                }
                case 7: {
                    log.trace("Abort PDU received:" + applicationPdu);
                    throw new AbortException(((AbortPdu)applicationPdu).getAbortReason());
                }
                case 6: {
                    log.trace("Reject PDU received:" + applicationPdu);
                    throw new RejectException(((RejectPdu)applicationPdu).getRejectReason());
                }
                default: {
                    throw new BacnetStackException("Unknown PDU type received: " + applicationPdu.getType());
                }
            }
            bacnetServicePrimitive = bacnetServicePrimitive2;
            Object var8_12 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            try {
                IdManager.releaseId(bBacnetAddress, n2);
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            IdManager.releaseId(bBacnetAddress, n2);
        }
        catch (Exception exception) {}
        return bacnetServicePrimitive;
    }

    public void sendConfirmedResponse(BBacnetAddress bBacnetAddress, int n, BacnetSimpleAck bacnetSimpleAck, BNetworkPriority bNetworkPriority) {
        SimpleAckPdu simpleAckPdu = new SimpleAckPdu(bBacnetAddress, bNetworkPriority, n, bacnetSimpleAck.getServiceChoice());
        this.server.queueApplication(simpleAckPdu);
    }

    public void sendConfirmedResponse(BBacnetAddress bBacnetAddress, int n, BacnetComplexAck bacnetComplexAck, BNetworkPriority bNetworkPriority) {
        ComplexAckPdu complexAckPdu = new ComplexAckPdu(bBacnetAddress, bNetworkPriority, n, bacnetComplexAck.getServiceChoice(), bacnetComplexAck.toEncodedBytes());
        this.server.queueApplication(complexAckPdu);
    }

    public void sendConfirmedResponse(BBacnetAddress bBacnetAddress, int n, BacnetError bacnetError, BNetworkPriority bNetworkPriority) {
        ErrorPdu errorPdu = new ErrorPdu(bBacnetAddress, bNetworkPriority, bacnetError.getServiceChoice(), n, bacnetError.toEncodedBytes());
        this.server.queueApplication(errorPdu);
    }

    public void sendConfirmedResponse(BBacnetAddress bBacnetAddress, int n, BacnetAbort bacnetAbort, BNetworkPriority bNetworkPriority) {
        AbortPdu abortPdu = new AbortPdu(bBacnetAddress, bNetworkPriority, n, bacnetAbort.getServiceChoice(), true);
        this.server.queueApplication(abortPdu);
    }

    public void sendConfirmedResponse(BBacnetAddress bBacnetAddress, int n, BacnetReject bacnetReject, BNetworkPriority bNetworkPriority) {
        RejectPdu rejectPdu = new RejectPdu(bBacnetAddress, bNetworkPriority, n, bacnetReject.getServiceChoice());
        this.server.queueApplication(rejectPdu);
    }

    public void receiveIndication(BBacnetAddress bBacnetAddress, BBacnetAddress bBacnetAddress2, BacnetInputStream bacnetInputStream, BNetworkPriority bNetworkPriority, boolean bl) {
        try {
            ApplicationPdu applicationPdu = ApplicationPdu.parseEncodedBytes(bBacnetAddress, bBacnetAddress2, bacnetInputStream, bNetworkPriority, bl);
            bacnetInputStream.release();
            if (applicationPdu.isClientPDU()) {
                this.server.queueNetwork(applicationPdu);
            } else {
                this.client.queueNetwork(applicationPdu);
            }
        }
        catch (BacnetException bacnetException) {
            log.error("Unable to parse incoming APDU!", (Throwable)((Object)bacnetException));
            return;
        }
    }

    void serverRequestTimeout(ApplicationPdu applicationPdu) {
        if (((BBacnetStack)this.getParent()).isCommExecutionEnabled()) {
            this.server.queueRequestTimeout(applicationPdu);
        }
    }

    void clientRequestTimeout(ApplicationPdu applicationPdu) {
        this.client.queueRequestTimeout(applicationPdu);
    }

    void serverSegmentTimeout(ApplicationPdu applicationPdu) {
        if (((BBacnetStack)this.getParent()).isCommExecutionEnabled()) {
            this.server.queueSegmentTimeout(applicationPdu);
        }
    }

    void clientSegmentTimeout(ApplicationPdu applicationPdu) {
        this.client.queueSegmentTimeout(applicationPdu);
    }

    private final BBacnetNetworkLayer network() {
        return ((BBacnetStack)this.getParent()).getNetwork();
    }

    public void doDumpStats() {
        System.out.println("Client Transaction List:");
        ClientTransaction.activeTransactions.dump();
        System.out.println("\n\nServer Transaction List:");
        ServerTransaction.activeTransactions.dump();
    }

    public void doResetStats() {
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$bacnet$stack$transport$BBacnetTransportLayer;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$stack$transport$BBacnetTransportLayer = BBacnetTransportLayer.class("[Lcom.tridium.bacnet.stack.transport.BBacnetTransportLayer;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"bacnet.transport");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TransportHelper
    extends Worker {
        TransportStateMachine tsm;
        String name;
        Queue q;

        public String getName() {
            return this.name;
        }

        public void start() {
            this.start(this.name);
        }

        public void queueApplication(ApplicationPdu applicationPdu) {
            this.enqueue(applicationPdu, 0);
        }

        public void queueNetwork(ApplicationPdu applicationPdu) {
            this.enqueue(applicationPdu, 1);
        }

        public void queueSegmentTimeout(ApplicationPdu applicationPdu) {
            this.enqueue(applicationPdu, 3);
        }

        public void queueRequestTimeout(ApplicationPdu applicationPdu) {
            this.enqueue(applicationPdu, 2);
        }

        private final void enqueue(ApplicationPdu applicationPdu, int n) {
            applicationPdu.setSource(n);
            applicationPdu.setTSM(this.tsm);
            try {
                this.q.enqueue((Object)applicationPdu);
            }
            catch (QueueFullException queueFullException) {
                log.message("Transport Queue Overflow:" + this.getName() + " apdu=" + applicationPdu);
            }
        }

        public TransportHelper(String string, TransportStateMachine transportStateMachine, Queue queue) {
            super((Worker.ITodo)queue);
            this.q = queue;
            this.name = string;
            this.tsm = transportStateMachine;
        }
    }
}

