/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.transport;

import com.tridium.bacnet.stack.BacnetStackException;
import com.tridium.bacnet.stack.network.BNetworkPriority;
import com.tridium.bacnet.stack.transport.AbortPdu;
import com.tridium.bacnet.stack.transport.ComplexAckPdu;
import com.tridium.bacnet.stack.transport.ConfirmedRequestPdu;
import com.tridium.bacnet.stack.transport.ErrorPdu;
import com.tridium.bacnet.stack.transport.InvalidApduTypeException;
import com.tridium.bacnet.stack.transport.RejectPdu;
import com.tridium.bacnet.stack.transport.SegmentAckPdu;
import com.tridium.bacnet.stack.transport.SimpleAckPdu;
import com.tridium.bacnet.stack.transport.TransportStateMachine;
import com.tridium.bacnet.stack.transport.UnconfirmedRequestPdu;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.log.Log;

public abstract class ApplicationPdu
implements Runnable {
    public static final int CONFIRMED_REQUEST = 0;
    public static final int UNCONFIRMED_REQUEST = 1;
    public static final int SIMPLE_ACK = 2;
    public static final int COMPLEX_ACK = 3;
    public static final int SEGMENT_ACK = 4;
    public static final int ERROR = 5;
    public static final int REJECT = 6;
    public static final int ABORT = 7;
    private static final int PDU_TYPE_MASK = 240;
    public static final int APPLICATION = 0;
    public static final int NETWORK = 1;
    public static final int REQUEST_TIMEOUT = 2;
    public static final int SEGMENT_TIMEOUT = 3;
    public static final Log log = Log.getLog((String)"bacnet.transport");
    private int type;
    private int source;
    private BBacnetAddress clientAddress;
    private BBacnetAddress serverAddress;
    private BNetworkPriority priority;
    private boolean dataExpectingReply;
    private TransportStateMachine tsm;

    public void run() {
        if (this.tsm != null) {
            if (log.isTraceOn()) {
                switch (this.source) {
                    case 0: {
                        log.trace(this.tsm.getName() + ":application msg processed: " + this);
                        break;
                    }
                    case 1: {
                        log.trace(this.tsm.getName() + ":network msg processed: " + this);
                        break;
                    }
                    case 2: {
                        log.trace(this.tsm.getName() + ":request timeout processed: " + this);
                        break;
                    }
                    case 3: {
                        log.trace(this.tsm.getName() + ":segment timeout processed: " + this);
                        break;
                    }
                }
            }
            this.tsm.route(this);
        }
    }

    public int getType() {
        return this.type;
    }

    public int getSource() {
        return this.source;
    }

    public void setSource(int n) {
        this.source = n;
    }

    public int getInvokeId() {
        return -1;
    }

    public BBacnetAddress getClientAddress() {
        return this.clientAddress;
    }

    public BBacnetAddress getServerAddress() {
        return this.serverAddress;
    }

    public BNetworkPriority getPriority() {
        return this.priority;
    }

    public void setPriority(BNetworkPriority bNetworkPriority) {
        this.priority = bNetworkPriority;
    }

    public boolean getDataExpectingReply() {
        return this.dataExpectingReply;
    }

    public void setDataExpectingReply(boolean bl) {
        this.dataExpectingReply = bl;
    }

    public abstract boolean isServerPDU();

    public abstract boolean isClientPDU();

    public abstract void writeNetworkBytes(ByteArrayOutputStream var1);

    public TransportStateMachine getTSM() {
        return this.tsm;
    }

    public void setTSM(TransportStateMachine transportStateMachine) {
        this.tsm = transportStateMachine;
    }

    public static ApplicationPdu parseEncodedBytes(BBacnetAddress bBacnetAddress, BBacnetAddress bBacnetAddress2, ByteArrayInputStream byteArrayInputStream, BNetworkPriority bNetworkPriority, boolean bl) throws BacnetStackException {
        ApplicationPdu applicationPdu = null;
        byteArrayInputStream.mark(0);
        int n = (byteArrayInputStream.read() & 0xF0) >> 4;
        byteArrayInputStream.reset();
        switch (n) {
            case 0: {
                applicationPdu = new ConfirmedRequestPdu(byteArrayInputStream);
                break;
            }
            case 1: {
                applicationPdu = new UnconfirmedRequestPdu(byteArrayInputStream);
                break;
            }
            case 2: {
                applicationPdu = new SimpleAckPdu(byteArrayInputStream);
                break;
            }
            case 3: {
                applicationPdu = new ComplexAckPdu(byteArrayInputStream);
                break;
            }
            case 4: {
                applicationPdu = new SegmentAckPdu(byteArrayInputStream);
                break;
            }
            case 5: {
                applicationPdu = new ErrorPdu(byteArrayInputStream);
                break;
            }
            case 6: {
                applicationPdu = new RejectPdu(byteArrayInputStream);
                break;
            }
            case 7: {
                applicationPdu = new AbortPdu(byteArrayInputStream);
                break;
            }
            default: {
                throw new InvalidApduTypeException(n);
            }
        }
        if (applicationPdu.isServerPDU()) {
            applicationPdu.clientAddress = bBacnetAddress2;
            applicationPdu.serverAddress = bBacnetAddress;
        } else {
            applicationPdu.clientAddress = bBacnetAddress;
            applicationPdu.serverAddress = bBacnetAddress2;
        }
        applicationPdu.priority = bNetworkPriority;
        applicationPdu.dataExpectingReply = bl;
        return applicationPdu;
    }

    public String toString() {
        return "ApplicationPdu " + this.type;
    }

    public String trace() {
        return this.toString();
    }

    protected void addAPDUData(StringBuffer stringBuffer) {
        stringBuffer.append("\n\tcadr=" + this.clientAddress).append("\n\tsadr=" + this.serverAddress).append("\n\tsrc=" + this.source).append("\n\tpri=" + (Object)((Object)this.priority)).append("\n\tder=" + this.dataExpectingReply);
    }

    protected void addAPDUMsg(StringBuffer stringBuffer) {
        stringBuffer.append(" c" + this.clientAddress).append(" s" + this.serverAddress).append(' ').append(this.source);
    }

    protected ApplicationPdu(int n) {
        this.type = n;
        this.priority = BNetworkPriority.normal;
    }

    protected ApplicationPdu(BBacnetAddress bBacnetAddress, BBacnetAddress bBacnetAddress2, BNetworkPriority bNetworkPriority, int n) {
        this.clientAddress = bBacnetAddress;
        this.serverAddress = bBacnetAddress2;
        this.priority = bNetworkPriority;
        this.type = n;
    }
}

