/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.server;

import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.unconfirmed.TimeSynchronizationRequest;
import com.tridium.bacnet.services.unconfirmed.UtcTimeSynchronizationRequest;
import com.tridium.bacnet.stack.server.BBacnetServerLayer;
import com.tridium.bacnet.stack.server.ServiceHandler;
import com.tridium.history.audit.BAuditHistoryService;
import javax.baja.bacnet.BacnetUnconfirmedServiceChoice;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TimeSyncHandler
implements ServiceHandler,
BacnetUnconfirmedServiceChoice {
    private static final Log log = Log.getLog((String)"bacnet.server");
    private static final BFacets TIME_FACETS = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"showMilliseconds", (BIDataValue)BBoolean.TRUE);
    private BBacnetServerLayer server;

    public BacnetServicePrimitive receiveRequest(int n, BacnetServicePrimitive bacnetServicePrimitive, BBacnetAddress bBacnetAddress) {
        switch (n) {
            case 6: {
                this.processTimeSynchRequest((TimeSynchronizationRequest)bacnetServicePrimitive, bBacnetAddress);
                return null;
            }
            case 9: {
                this.processUTCTimeSynchRequest((UtcTimeSynchronizationRequest)bacnetServicePrimitive, bBacnetAddress);
                return null;
            }
        }
        log.message("TimeSyncHandler.reqceiveRequest:Unknown request! " + bacnetServicePrimitive);
        return null;
    }

    private final void processTimeSynchRequest(TimeSynchronizationRequest timeSynchronizationRequest, BBacnetAddress bBacnetAddress) {
        if (log.isTraceOn()) {
            log.trace("TimeSyncHandler: TimeSynchronizationRequest received: " + timeSynchronizationRequest + "\n from address " + bBacnetAddress);
        }
        if (this.server.getTimeSynchAllowed()) {
            BAbsTime bAbsTime = Clock.time((int)10);
            BAbsTime bAbsTime2 = timeSynchronizationRequest.getBAbsTime();
            Clock.setTime((BAbsTime)bAbsTime2);
            try {
                Auditor auditor = Sys.getAuditor();
                AuditEvent auditEvent = new AuditEvent("Changed", "Station", "Time Synch", bAbsTime.toString((Context)TIME_FACETS), bAbsTime2.toString((Context)TIME_FACETS), bBacnetAddress.toString());
                auditor.audit(auditEvent);
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                serviceNotFoundException.printStackTrace();
            }
        } else {
            log.message("Time Synchronization not allowed for this station!");
        }
    }

    private final void processUTCTimeSynchRequest(UtcTimeSynchronizationRequest utcTimeSynchronizationRequest, BBacnetAddress bBacnetAddress) {
        if (log.isTraceOn()) {
            log.trace("TimeSyncHandler: UtcTimeSynchronizationRequest received: " + utcTimeSynchronizationRequest + "\n from address " + bBacnetAddress);
        }
        if (this.server.getTimeSynchAllowed()) {
            BAbsTime bAbsTime = Clock.time((int)10);
            BAbsTime bAbsTime2 = utcTimeSynchronizationRequest.getBAbsTime();
            int n = BAbsTime.make().getTimeZoneOffset();
            BRelTime bRelTime = BRelTime.make((long)n);
            BAbsTime bAbsTime3 = bAbsTime2.add(bRelTime);
            Clock.setTime((BAbsTime)bAbsTime3);
            try {
                BAuditHistoryService bAuditHistoryService = (BAuditHistoryService)Sys.getService((Type)BAuditHistoryService.TYPE);
                AuditEvent auditEvent = new AuditEvent("Changed", "Station", "UTC Time Synch", bAbsTime.toString((Context)TIME_FACETS), bAbsTime3.toString((Context)TIME_FACETS), bBacnetAddress.toString());
                bAuditHistoryService.audit(auditEvent);
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                serviceNotFoundException.printStackTrace();
            }
        } else {
            log.message("UTC Time Synchronization not allowed for this station!");
        }
    }

    private final /* synthetic */ void this() {
        this.server = null;
    }

    TimeSyncHandler(BBacnetServerLayer bBacnetServerLayer) {
        this.this();
        this.server = bBacnetServerLayer;
    }
}

