/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.server;

import com.tridium.bacnet.asn.NBacnetPropertyReference;
import com.tridium.bacnet.asn.NBacnetPropertyValue;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadAccessResult;
import com.tridium.bacnet.asn.NReadAccessSpec;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.asn.NWriteAccessSpec;
import com.tridium.bacnet.services.BacnetAbort;
import com.tridium.bacnet.services.BacnetReject;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.BacnetSimpleAck;
import com.tridium.bacnet.services.confirmed.AddListElementRequest;
import com.tridium.bacnet.services.confirmed.ReadPropertyAck;
import com.tridium.bacnet.services.confirmed.ReadPropertyMultipleAck;
import com.tridium.bacnet.services.confirmed.ReadPropertyMultipleRequest;
import com.tridium.bacnet.services.confirmed.ReadPropertyRequest;
import com.tridium.bacnet.services.confirmed.ReadRangeRequest;
import com.tridium.bacnet.services.confirmed.RemoveListElementRequest;
import com.tridium.bacnet.services.confirmed.WritePropertyMultipleRequest;
import com.tridium.bacnet.services.confirmed.WritePropertyRequest;
import com.tridium.bacnet.services.error.NChangeListError;
import com.tridium.bacnet.services.error.SimpleError;
import com.tridium.bacnet.services.error.WritePropertyMultipleError;
import com.tridium.bacnet.stack.server.BBacnetServerLayer;
import com.tridium.bacnet.stack.server.ServiceHandler;
import java.util.ListIterator;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConfirmedServiceChoice;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetObjectPropertyReference;
import javax.baja.bacnet.enums.BBacnetBackupState;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.AbortException;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RejectException;
import javax.baja.log.Log;

public class PropertyHandler
implements ServiceHandler,
BacnetConfirmedServiceChoice {
    private static final Log log = Log.getLog((String)"bacnet.server");
    private BBacnetServerLayer server;

    public BacnetServicePrimitive receiveRequest(int n, BacnetServicePrimitive bacnetServicePrimitive, BBacnetAddress bBacnetAddress) {
        switch (n) {
            case 12: {
                return this.processReadPropertyRequest((ReadPropertyRequest)bacnetServicePrimitive);
            }
            case 14: {
                return this.processReadPropertyMultipleRequest((ReadPropertyMultipleRequest)bacnetServicePrimitive);
            }
            case 26: {
                return this.processReadRangeRequest((ReadRangeRequest)bacnetServicePrimitive);
            }
            case 15: {
                return this.processWritePropertyRequest((WritePropertyRequest)bacnetServicePrimitive);
            }
            case 16: {
                return this.processWritePropertyMultipleRequest((WritePropertyMultipleRequest)bacnetServicePrimitive);
            }
            case 8: {
                return this.processAddListElementRequest((AddListElementRequest)bacnetServicePrimitive);
            }
            case 9: {
                return this.processRemoveListElementRequest((RemoveListElementRequest)bacnetServicePrimitive);
            }
        }
        log.message("PropertyHandler.receiveRequest:Unknown request! " + bacnetServicePrimitive);
        return new BacnetReject(9);
    }

    private final BacnetServicePrimitive processReadPropertyRequest(ReadPropertyRequest readPropertyRequest) {
        PropertyValue propertyValue;
        BIBacnetExportObject bIBacnetExportObject;
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        BBacnetObjectIdentifier bBacnetObjectIdentifier = readPropertyRequest.getObjectId();
        if (log.isTraceOn()) {
            log.trace("PropertyHandler.ReadPropertyRequest received: " + readPropertyRequest);
        }
        if ((bIBacnetExportObject = bLocalBacnetDevice.lookupBacnetObject(bBacnetObjectIdentifier)) == null) {
            if (bBacnetObjectIdentifier.getObjectType() == 8 && bBacnetObjectIdentifier.getInstanceNumber() == 0x3FFFFF) {
                bIBacnetExportObject = bLocalBacnetDevice;
                bBacnetObjectIdentifier = bLocalBacnetDevice.getObjectId();
            } else {
                return new SimpleError(12, new NErrorType(1, 31));
            }
        }
        if (bBacnetObjectIdentifier.equals((Object)this.server.backupFileId) && bLocalBacnetDevice.getBackupAndRestoreState() != BBacnetBackupState.idle) {
            this.server.updateLastBackupCommunicationTime();
        }
        try {
            propertyValue = bIBacnetExportObject.readProperty(new NBacnetPropertyReference(readPropertyRequest.getPropertyId(), readPropertyRequest.getPropertyArrayIndex()));
        }
        catch (RejectException rejectException) {
            return new BacnetReject(rejectException.getRejectReason());
        }
        if (propertyValue.isError()) {
            return new SimpleError(12, new NErrorType(propertyValue.getErrorClass(), propertyValue.getErrorCode()));
        }
        return new ReadPropertyAck(bBacnetObjectIdentifier, readPropertyRequest.getPropertyId(), readPropertyRequest.getPropertyArrayIndex(), propertyValue.getPropertyValue());
    }

    private final BacnetServicePrimitive processReadPropertyMultipleRequest(ReadPropertyMultipleRequest readPropertyMultipleRequest) {
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        ReadPropertyMultipleAck readPropertyMultipleAck = new ReadPropertyMultipleAck();
        ListIterator listIterator = readPropertyMultipleRequest.getReadAccessSpecs();
        if (log.isTraceOn()) {
            log.trace("PropertyHandler.ReadPropertyMultipleRequest received: " + readPropertyMultipleRequest);
        }
        boolean bl = false;
        boolean bl2 = false;
        try {
            while (listIterator.hasNext()) {
                PropertyValue[] propertyValueArray;
                PropertyReference[] propertyReferenceArray;
                NReadAccessSpec nReadAccessSpec = (NReadAccessSpec)listIterator.next();
                BBacnetObjectIdentifier bBacnetObjectIdentifier = nReadAccessSpec.getObjectId();
                BIBacnetExportObject bIBacnetExportObject = bLocalBacnetDevice.lookupBacnetObject(bBacnetObjectIdentifier);
                if (bIBacnetExportObject == null && bBacnetObjectIdentifier.getObjectType() == 8 && bBacnetObjectIdentifier.getInstanceNumber() == 0x3FFFFF) {
                    bIBacnetExportObject = bLocalBacnetDevice;
                    bBacnetObjectIdentifier = bLocalBacnetDevice.getObjectId();
                }
                NReadAccessResult nReadAccessResult = new NReadAccessResult(bBacnetObjectIdentifier);
                if (bIBacnetExportObject == null) {
                    propertyReferenceArray = nReadAccessSpec.getPropertyReferences();
                    while (propertyReferenceArray.hasNext()) {
                        propertyValueArray = (PropertyValue[])propertyReferenceArray.next();
                        nReadAccessResult.addResult(new NReadPropertyResult(propertyValueArray.getPropertyId(), propertyValueArray.getPropertyArrayIndex(), new NErrorType(1, 31)));
                    }
                } else {
                    bl = true;
                    if (bBacnetObjectIdentifier.equals((Object)this.server.backupFileId)) {
                        this.server.updateLastBackupCommunicationTime();
                    }
                    propertyReferenceArray = nReadAccessSpec.getListOfPropertyReferences();
                    propertyValueArray = bIBacnetExportObject.readPropertyMultiple(propertyReferenceArray);
                    int n = 0;
                    while (n < propertyValueArray.length) {
                        if (!bl2 && !propertyValueArray[n].isError()) {
                            bl2 = true;
                        }
                        nReadAccessResult.addResult(propertyValueArray[n]);
                        ++n;
                    }
                }
                readPropertyMultipleAck.addReadAccessResult(nReadAccessResult);
            }
        }
        catch (RejectException rejectException) {
            return new BacnetReject(rejectException.getRejectReason());
        }
        if (bl) {
            return readPropertyMultipleAck;
        }
        return new SimpleError(14, new NErrorType(1, 31));
    }

    private final BacnetServicePrimitive processReadRangeRequest(ReadRangeRequest readRangeRequest) {
        RangeData rangeData;
        BIBacnetExportObject bIBacnetExportObject;
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        BBacnetObjectIdentifier bBacnetObjectIdentifier = readRangeRequest.getObjectId();
        if (log.isTraceOn()) {
            log.trace("PropertyHandler.ReadRangeRequest received: " + readRangeRequest);
        }
        if ((bIBacnetExportObject = bLocalBacnetDevice.lookupBacnetObject(bBacnetObjectIdentifier)) == null) {
            return new SimpleError(26, new NErrorType(1, 31));
        }
        try {
            rangeData = bIBacnetExportObject.readRange(readRangeRequest);
        }
        catch (RejectException rejectException) {
            return new BacnetReject(rejectException.getRejectReason());
        }
        if (rangeData.isError()) {
            return new SimpleError(26, (NErrorType)rangeData.getError());
        }
        return (BacnetServicePrimitive)((Object)rangeData);
    }

    private final BacnetServicePrimitive processWritePropertyRequest(WritePropertyRequest writePropertyRequest) {
        BIBacnetExportObject bIBacnetExportObject;
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        BBacnetObjectIdentifier bBacnetObjectIdentifier = writePropertyRequest.getObjectId();
        if (log.isTraceOn()) {
            log.trace("PropertyHandler.WritePropertyRequest received: " + writePropertyRequest);
        }
        if ((bIBacnetExportObject = bLocalBacnetDevice.lookupBacnetObject(bBacnetObjectIdentifier)) == null) {
            return new SimpleError(15, new NErrorType(1, 31));
        }
        try {
            ErrorType errorType;
            if (bBacnetObjectIdentifier.equals((Object)this.server.backupFileId) && bLocalBacnetDevice.getBackupAndRestoreState() != BBacnetBackupState.idle) {
                this.server.updateLastBackupCommunicationTime();
            }
            if ((errorType = bIBacnetExportObject.writeProperty(new NBacnetPropertyValue(writePropertyRequest.getPropertyId(), writePropertyRequest.getPropertyArrayIndex(), writePropertyRequest.getEncodedValue(), writePropertyRequest.getPriority()))) == null) {
                return new BacnetSimpleAck(15);
            }
            return new SimpleError(15, (NErrorType)errorType);
        }
        catch (RejectException rejectException) {
            return new BacnetReject(rejectException.getRejectReason());
        }
        catch (AbortException abortException) {
            return new BacnetAbort(abortException.getAbortReason());
        }
        catch (AsnException asnException) {
            return new BacnetReject(4);
        }
        catch (BacnetException bacnetException) {
            return new SimpleError(15, new NErrorType(1, 0));
        }
        catch (Exception exception) {
            log.message("Exception in processWritePropertyRequest:" + exception, (Throwable)exception);
            return new SimpleError(15, new NErrorType(5, 0));
        }
    }

    private final BacnetServicePrimitive processWritePropertyMultipleRequest(WritePropertyMultipleRequest writePropertyMultipleRequest) {
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        ListIterator listIterator = writePropertyMultipleRequest.getWriteAccessSpecs();
        if (log.isTraceOn()) {
            log.trace("PropertyHandler.WritePropertyMultipleRequest received: " + writePropertyMultipleRequest);
        }
        BBacnetObjectIdentifier bBacnetObjectIdentifier = null;
        NBacnetPropertyValue nBacnetPropertyValue = null;
        try {
            while (listIterator.hasNext()) {
                NWriteAccessSpec nWriteAccessSpec = (NWriteAccessSpec)listIterator.next();
                bBacnetObjectIdentifier = nWriteAccessSpec.getObjectId();
                BIBacnetExportObject bIBacnetExportObject = bLocalBacnetDevice.lookupBacnetObject(bBacnetObjectIdentifier);
                ListIterator listIterator2 = nWriteAccessSpec.getPropertyValues();
                while (listIterator2.hasNext()) {
                    ErrorType errorType;
                    nBacnetPropertyValue = (NBacnetPropertyValue)listIterator2.next();
                    if (bIBacnetExportObject == null) {
                        return new WritePropertyMultipleError(new NErrorType(1, 31), new BBacnetObjectPropertyReference(bBacnetObjectIdentifier, nBacnetPropertyValue.getPropertyId(), nBacnetPropertyValue.getPropertyArrayIndex()));
                    }
                    if (bBacnetObjectIdentifier.equals((Object)this.server.backupFileId)) {
                        this.server.updateLastBackupCommunicationTime();
                    }
                    if ((errorType = bIBacnetExportObject.writeProperty(nBacnetPropertyValue)) == null) continue;
                    return new WritePropertyMultipleError((NErrorType)errorType, new BBacnetObjectPropertyReference(bBacnetObjectIdentifier, nBacnetPropertyValue.getPropertyId(), nBacnetPropertyValue.getPropertyArrayIndex()));
                }
            }
            return new BacnetSimpleAck(16);
        }
        catch (RejectException rejectException) {
            return new BacnetReject(rejectException.getRejectReason());
        }
        catch (AbortException abortException) {
            return new BacnetAbort(abortException.getAbortReason());
        }
        catch (AsnException asnException) {
            return new BacnetReject(4);
        }
        catch (BacnetException bacnetException) {
            if (bBacnetObjectIdentifier == null) {
                bBacnetObjectIdentifier = BBacnetObjectIdentifier.DEFAULT;
            }
            if (nBacnetPropertyValue == null) {
                nBacnetPropertyValue = new NBacnetPropertyValue();
            }
            return new WritePropertyMultipleError(new NErrorType(1, 0), new BBacnetObjectPropertyReference(bBacnetObjectIdentifier, nBacnetPropertyValue.getPropertyId(), nBacnetPropertyValue.getPropertyArrayIndex()));
        }
        catch (Exception exception) {
            log.message("Exception in processWritePropertyMultipleRequest:" + exception, (Throwable)exception);
            if (bBacnetObjectIdentifier == null) {
                bBacnetObjectIdentifier = BBacnetObjectIdentifier.DEFAULT;
            }
            if (nBacnetPropertyValue == null) {
                nBacnetPropertyValue = new NBacnetPropertyValue();
            }
            return new WritePropertyMultipleError(new NErrorType(5, 0), new BBacnetObjectPropertyReference(bBacnetObjectIdentifier, nBacnetPropertyValue.getPropertyId(), nBacnetPropertyValue.getPropertyArrayIndex()));
        }
    }

    private final BacnetServicePrimitive processAddListElementRequest(AddListElementRequest addListElementRequest) {
        BIBacnetExportObject bIBacnetExportObject;
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        BBacnetObjectIdentifier bBacnetObjectIdentifier = addListElementRequest.getObjectId();
        if (log.isTraceOn()) {
            log.trace("PropertyHandler.AddListElementRequest received: " + addListElementRequest);
        }
        if ((bIBacnetExportObject = bLocalBacnetDevice.lookupBacnetObject(bBacnetObjectIdentifier)) == null) {
            return new NChangeListError(8, new NErrorType(1, 31), 1L);
        }
        try {
            ChangeListError changeListError = bIBacnetExportObject.addListElements(new NBacnetPropertyValue(addListElementRequest.getPropertyId(), addListElementRequest.getPropertyArrayIndex(), addListElementRequest.getListOfElements()));
            if (changeListError == null) {
                return new BacnetSimpleAck(8);
            }
            return (NChangeListError)changeListError;
        }
        catch (RejectException rejectException) {
            return new BacnetReject(rejectException.getRejectReason());
        }
        catch (AbortException abortException) {
            return new BacnetAbort(abortException.getAbortReason());
        }
        catch (AsnException asnException) {
            return new BacnetReject(4);
        }
        catch (BacnetException bacnetException) {
            return new NChangeListError(8, new NErrorType(1, 0), 1L);
        }
        catch (Exception exception) {
            log.message("Exception in addListElementRequest:" + exception, (Throwable)exception);
            return new NChangeListError(8, new NErrorType(5, 0), 1L);
        }
    }

    private final BacnetServicePrimitive processRemoveListElementRequest(RemoveListElementRequest removeListElementRequest) {
        BIBacnetExportObject bIBacnetExportObject;
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        BBacnetObjectIdentifier bBacnetObjectIdentifier = removeListElementRequest.getObjectId();
        if (log.isTraceOn()) {
            log.trace("PropertyHandler.RemoveListElementRequest received: " + removeListElementRequest);
        }
        if ((bIBacnetExportObject = bLocalBacnetDevice.lookupBacnetObject(bBacnetObjectIdentifier)) == null) {
            return new NChangeListError(9, new NErrorType(1, 31), 1L);
        }
        try {
            ChangeListError changeListError = bIBacnetExportObject.removeListElements(new NBacnetPropertyValue(removeListElementRequest.getPropertyId(), removeListElementRequest.getPropertyArrayIndex(), removeListElementRequest.getListOfElements()));
            if (changeListError == null) {
                return new BacnetSimpleAck(9);
            }
            return (NChangeListError)changeListError;
        }
        catch (RejectException rejectException) {
            return new BacnetReject(rejectException.getRejectReason());
        }
        catch (AbortException abortException) {
            return new BacnetAbort(abortException.getAbortReason());
        }
        catch (AsnException asnException) {
            return new BacnetReject(4);
        }
        catch (BacnetException bacnetException) {
            return new NChangeListError(9, new NErrorType(1, 0), 1L);
        }
        catch (Exception exception) {
            log.message("Exception in removeListElementRequest:" + exception, (Throwable)exception);
            return new NChangeListError(9, new NErrorType(5, 0), 1L);
        }
    }

    PropertyHandler(BBacnetServerLayer bBacnetServerLayer) {
        this.server = bBacnetServerLayer;
    }
}

