/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.server;

import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.services.BacnetAbort;
import com.tridium.bacnet.services.BacnetReject;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.confirmed.ConfirmedPrivateTransferAck;
import com.tridium.bacnet.services.confirmed.ConfirmedPrivateTransferRequest;
import com.tridium.bacnet.services.error.SimpleError;
import com.tridium.bacnet.services.unconfirmed.UnconfirmedPrivateTransferRequest;
import com.tridium.bacnet.stack.server.BBacnetServerLayer;
import com.tridium.bacnet.stack.server.ServiceHandler;
import javax.baja.bacnet.BacnetConfirmedServiceChoice;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.BacnetUnconfirmedServiceChoice;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.io.AbortException;
import javax.baja.bacnet.io.ErrorException;
import javax.baja.bacnet.io.PrivateTransferListener;
import javax.baja.bacnet.io.RejectException;
import javax.baja.log.Log;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.IntHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PrivateTransferHandler
implements ServiceHandler,
BacnetUnconfirmedServiceChoice,
BacnetConfirmedServiceChoice {
    private static final Log log = Log.getLog((String)"bacnet.server");
    private static final byte[] CANNED_CPT_RESPONSE;
    IntHashMap confirmedListeners;
    IntHashMap unconfirmedListeners;

    public BacnetServicePrimitive receiveRequest(int n, BacnetServicePrimitive bacnetServicePrimitive, BBacnetAddress bBacnetAddress) {
        switch (n) {
            case 4: {
                this.processUnconfirmedPrivateTransferRequest((UnconfirmedPrivateTransferRequest)bacnetServicePrimitive, bBacnetAddress);
                return null;
            }
            case 18: {
                return this.processConfirmedPrivateTransferRequest((ConfirmedPrivateTransferRequest)bacnetServicePrimitive, bBacnetAddress);
            }
        }
        log.message("PrivateTransferHandler.reqceiveRequest:Unknown request! " + bacnetServicePrimitive);
        return null;
    }

    private final void processUnconfirmedPrivateTransferRequest(UnconfirmedPrivateTransferRequest unconfirmedPrivateTransferRequest, BBacnetAddress bBacnetAddress) {
        if (log.isTraceOn()) {
            log.trace("PrivateTransferHandler: UnconfirmedPrivateTransferRequest received: " + unconfirmedPrivateTransferRequest);
        }
        try {
            this.routeToListener(unconfirmedPrivateTransferRequest, bBacnetAddress);
        }
        catch (Exception exception) {
            log.message("Error handling Unconfirmed Private Transfer request:" + exception, (Throwable)exception);
        }
    }

    private final BacnetServicePrimitive processConfirmedPrivateTransferRequest(ConfirmedPrivateTransferRequest confirmedPrivateTransferRequest, BBacnetAddress bBacnetAddress) {
        if (log.isTraceOn()) {
            log.trace("PrivateTransferHandler: ConfirmedPrivateTransferRequest received: " + confirmedPrivateTransferRequest);
        }
        try {
            byte[] byArray = this.routeToListener(confirmedPrivateTransferRequest, bBacnetAddress);
            return new ConfirmedPrivateTransferAck(confirmedPrivateTransferRequest.getVendorId(), confirmedPrivateTransferRequest.getServiceNumber(), byArray);
        }
        catch (ErrorException errorException) {
            return new SimpleError(18, errorException.getErrorType());
        }
        catch (RejectException rejectException) {
            return new BacnetReject(rejectException.getRejectReason());
        }
        catch (AbortException abortException) {
            return new BacnetAbort(abortException.getAbortReason());
        }
        catch (BacnetException bacnetException) {
            return new SimpleError(18, new NErrorType(5, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void addListener(PrivateTransferListener privateTransferListener, boolean bl) {
        if (log.isTraceOn()) {
            log.trace("PTHandler.addListener(" + privateTransferListener + (bl ? ", confirmed)" : ", unconfirmed)"));
        }
        if (bl) {
            IntHashMap intHashMap = this.confirmedListeners;
            synchronized (intHashMap) {
                this.confirmedListeners.put(privateTransferListener.getVendorId(), (Object)privateTransferListener);
                return;
            }
        }
        IntHashMap intHashMap = this.unconfirmedListeners;
        synchronized (intHashMap) {
            this.unconfirmedListeners.put(privateTransferListener.getVendorId(), (Object)privateTransferListener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeListener(PrivateTransferListener privateTransferListener, boolean bl) {
        if (log.isTraceOn()) {
            log.trace("PTHandler.removeListener(" + privateTransferListener + (bl ? ", confirmed)" : ", unconfirmed)"));
        }
        int n = privateTransferListener.getVendorId();
        if (bl) {
            IntHashMap intHashMap = this.confirmedListeners;
            synchronized (intHashMap) {
                PrivateTransferListener privateTransferListener2 = (PrivateTransferListener)this.confirmedListeners.get(n);
                if (privateTransferListener2 == null) throw new IllegalArgumentException("Incorrect listener provided to removeListener: " + privateTransferListener + " != " + privateTransferListener2);
                if (privateTransferListener2 != privateTransferListener) throw new IllegalArgumentException("Incorrect listener provided to removeListener: " + privateTransferListener + " != " + privateTransferListener2);
                this.confirmedListeners.remove(n);
                return;
            }
        }
        IntHashMap intHashMap = this.unconfirmedListeners;
        synchronized (intHashMap) {
            PrivateTransferListener privateTransferListener3 = (PrivateTransferListener)this.unconfirmedListeners.get(n);
            if (privateTransferListener3 == null) throw new IllegalArgumentException("Incorrect listener provided to removeListener: " + privateTransferListener + " != " + privateTransferListener3);
            if (privateTransferListener3 != privateTransferListener) throw new IllegalArgumentException("Incorrect listener provided to removeListener: " + privateTransferListener + " != " + privateTransferListener3);
            this.unconfirmedListeners.remove(n);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final byte[] routeToListener(ConfirmedPrivateTransferRequest confirmedPrivateTransferRequest, BBacnetAddress bBacnetAddress) throws BacnetException {
        if (log.isTraceOn()) {
            log.trace("routeToListener:" + confirmedPrivateTransferRequest + " from " + bBacnetAddress);
        }
        PrivateTransferListener privateTransferListener = null;
        IntHashMap intHashMap = this.confirmedListeners;
        synchronized (intHashMap) {
            privateTransferListener = (PrivateTransferListener)this.confirmedListeners.get((int)confirmedPrivateTransferRequest.getVendorId());
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var4_4
            if (privateTransferListener != null) {
                return privateTransferListener.receiveConfirmedPrivateTransfer(confirmedPrivateTransferRequest.getVendorId(), confirmedPrivateTransferRequest.getServiceNumber(), confirmedPrivateTransferRequest.getServiceParameters(), bBacnetAddress);
            }
        }
        log.trace("Received ConfirmedPrivateTransfer (vID " + confirmedPrivateTransferRequest.getVendorId() + ", svcNum " + confirmedPrivateTransferRequest.getServiceNumber() + "); no listeners for this vendorId!");
        throw new ErrorException(new NErrorType(5, 45));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void routeToListener(UnconfirmedPrivateTransferRequest unconfirmedPrivateTransferRequest, BBacnetAddress bBacnetAddress) throws BacnetException {
        if (log.isTraceOn()) {
            log.trace("routeToListener:" + unconfirmedPrivateTransferRequest + " from " + bBacnetAddress);
        }
        PrivateTransferListener privateTransferListener = null;
        IntHashMap intHashMap = this.unconfirmedListeners;
        synchronized (intHashMap) {
            privateTransferListener = (PrivateTransferListener)this.unconfirmedListeners.get((int)unconfirmedPrivateTransferRequest.getVendorId());
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var4_4
            if (privateTransferListener != null) {
                privateTransferListener.receiveUnconfirmedPrivateTransfer(unconfirmedPrivateTransferRequest.getVendorId(), unconfirmedPrivateTransferRequest.getServiceNumber(), unconfirmedPrivateTransferRequest.getServiceParameters(), bBacnetAddress);
                return;
            }
        }
        log.trace("Received UnconfirmedPrivateTransfer (vID " + unconfirmedPrivateTransferRequest.getVendorId() + ", svcNum " + unconfirmedPrivateTransferRequest.getServiceNumber() + "); no listeners for this vendorId!");
    }

    private static final void d(String string) {
        System.out.println(string);
    }

    private final /* synthetic */ void this() {
        this.confirmedListeners = new IntHashMap();
        this.unconfirmedListeners = new IntHashMap();
    }

    PrivateTransferHandler(BBacnetServerLayer bBacnetServerLayer) {
        this.this();
    }

    static {
        byte[] byArray = new byte[11];
        byArray[0] = 117;
        byArray[1] = 9;
        byArray[3] = 67;
        byArray[4] = 80;
        byArray[5] = 84;
        byArray[6] = 32;
        byArray[7] = 82;
        byArray[8] = 69;
        byArray[9] = 83;
        byArray[10] = 80;
        CANNED_CPT_RESPONSE = byArray;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DebugPTListener
    implements PrivateTransferListener {
        private int vendorId;

        public int getVendorId() {
            return this.vendorId;
        }

        public byte[] receiveConfirmedPrivateTransfer(long l, long l2, byte[] byArray, BBacnetAddress bBacnetAddress) throws BacnetException {
            PrivateTransferHandler.d("\n\n*****\n\nDebugPTListener: received Confirmed PT Request: vId " + l + ", svcNum " + l2 + " from " + bBacnetAddress + ':');
            ByteArrayUtil.hexDump((byte[])byArray);
            PrivateTransferHandler.d("\n\n*****\n\n");
            PrivateTransferHandler.d("Returning " + ByteArrayUtil.toHexString((byte[])CANNED_CPT_RESPONSE));
            return CANNED_CPT_RESPONSE;
        }

        public void receiveUnconfirmedPrivateTransfer(long l, long l2, byte[] byArray, BBacnetAddress bBacnetAddress) throws BacnetException {
            PrivateTransferHandler.d("\n\n*****\n\nDebugPTListener: received Unconfirmed PT Request: vId " + l + ", svcNum " + l2 + " from " + bBacnetAddress + ':');
            ByteArrayUtil.hexDump((byte[])byArray);
            PrivateTransferHandler.d("\n\n*****\n\n");
        }

        public DebugPTListener(int n) {
            this.vendorId = n;
        }
    }
}

