/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.server;

import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.services.BacnetReject;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.confirmed.AtomicReadFileAck;
import com.tridium.bacnet.services.confirmed.AtomicReadFileRequest;
import com.tridium.bacnet.services.confirmed.AtomicWriteFileAck;
import com.tridium.bacnet.services.confirmed.AtomicWriteFileRequest;
import com.tridium.bacnet.services.error.SimpleError;
import com.tridium.bacnet.stack.server.BBacnetServerLayer;
import com.tridium.bacnet.stack.server.ServiceHandler;
import java.io.IOException;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConfirmedServiceChoice;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetBackupState;
import javax.baja.bacnet.export.BBacnetFileDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.log.Log;

public class FileHandler
implements ServiceHandler,
BacnetConfirmedServiceChoice {
    private static final Log log = Log.getLog((String)"bacnet.server");
    private BBacnetServerLayer server;

    public BacnetServicePrimitive receiveRequest(int n, BacnetServicePrimitive bacnetServicePrimitive, BBacnetAddress bBacnetAddress) {
        switch (n) {
            case 6: {
                return this.processAtomicReadFileRequest((AtomicReadFileRequest)bacnetServicePrimitive);
            }
            case 7: {
                return this.processAtomicWriteFileRequest((AtomicWriteFileRequest)bacnetServicePrimitive);
            }
        }
        log.message("FileHandler.reqceiveRequest:Unknown request! " + bacnetServicePrimitive);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final BacnetServicePrimitive processAtomicReadFileRequest(AtomicReadFileRequest atomicReadFileRequest) {
        BBacnetFileDescriptor bBacnetFileDescriptor;
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        BBacnetObjectIdentifier bBacnetObjectIdentifier = atomicReadFileRequest.getFileId();
        if (log.isTraceOn()) {
            log.trace("FileHandler.AtomicReadFileRequest received: " + atomicReadFileRequest);
        }
        if ((bBacnetFileDescriptor = (BBacnetFileDescriptor)bLocalBacnetDevice.lookupBacnetObject(bBacnetObjectIdentifier)) == null) {
            return new SimpleError(6, new NErrorType(1, 31));
        }
        if (bBacnetObjectIdentifier.equals((Object)this.server.backupFileId) && bLocalBacnetDevice.getBackupAndRestoreState() != BBacnetBackupState.idle) {
            this.server.updateLastBackupCommunicationTime();
        }
        if (!atomicReadFileRequest.isStreamAccess()) {
            return new SimpleError(6, new NErrorType(5, 10));
        }
        int n = atomicReadFileRequest.getFileStartPosition();
        if (n < 0 || (long)n > bBacnetFileDescriptor.getFileSize()) {
            return new SimpleError(6, new NErrorType(5, 11));
        }
        long l = atomicReadFileRequest.getRequestedOctetCount();
        if (l > Integer.MAX_VALUE) {
            return new BacnetReject(6);
        }
        byte[] byArray = null;
        boolean bl = false;
        try {
            BBacnetFileDescriptor bBacnetFileDescriptor2 = bBacnetFileDescriptor;
            synchronized (bBacnetFileDescriptor2) {
                byArray = bBacnetFileDescriptor.read(atomicReadFileRequest.getFileStartPosition(), (int)l);
                bl = bBacnetFileDescriptor.isEOF();
            }
        }
        catch (IOException iOException) {
            log.message("IOException attempting to read file " + bBacnetFileDescriptor.getFileOrd() + " in response to Bacnet AtomicReadFileRequest!", (Throwable)iOException);
        }
        if (byArray == null) {
            return new SimpleError(6, new NErrorType(5, 5));
        }
        return new AtomicReadFileAck(bl, atomicReadFileRequest.getFileStartPosition(), byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final BacnetServicePrimitive processAtomicWriteFileRequest(AtomicWriteFileRequest atomicWriteFileRequest) {
        BBacnetFileDescriptor bBacnetFileDescriptor;
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        BBacnetObjectIdentifier bBacnetObjectIdentifier = atomicWriteFileRequest.getFileId();
        if (log.isTraceOn()) {
            log.trace("FileHandler.AtomicWriteFileRequest received: " + atomicWriteFileRequest);
        }
        if ((bBacnetFileDescriptor = (BBacnetFileDescriptor)bLocalBacnetDevice.lookupBacnetObject(bBacnetObjectIdentifier)) == null) {
            return new SimpleError(7, new NErrorType(1, 31));
        }
        if (bBacnetObjectIdentifier.equals((Object)this.server.backupFileId) && bLocalBacnetDevice.getBackupAndRestoreState() != BBacnetBackupState.idle) {
            this.server.updateLastBackupCommunicationTime();
        }
        if (!atomicWriteFileRequest.isStreamAccess()) {
            return new SimpleError(7, new NErrorType(5, 10));
        }
        int n = atomicWriteFileRequest.getFileStart();
        if (n < 0 || (long)n > bBacnetFileDescriptor.getFileSize()) {
            return new SimpleError(6, new NErrorType(5, 11));
        }
        int n2 = -1;
        try {
            BBacnetFileDescriptor bBacnetFileDescriptor2 = bBacnetFileDescriptor;
            synchronized (bBacnetFileDescriptor2) {
                n2 = bBacnetFileDescriptor.write(atomicWriteFileRequest.getFileStart(), atomicWriteFileRequest.getFileData());
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl20 : MonitorExitStatement: MONITOREXIT : var7_7
                if (n2 >= 0) return new SimpleError(7, new NErrorType(5, n2));
                return new AtomicWriteFileAck(0, atomicWriteFileRequest.getFileStart());
            }
        }
        catch (IOException iOException) {
            log.message("IOException attempting to write file " + bBacnetFileDescriptor.getFileOrd() + " in response to Bacnet AtomicWriteFileRequest!", (Throwable)iOException);
            return new SimpleError(7, new NErrorType(5, 5));
        }
    }

    FileHandler(BBacnetServerLayer bBacnetServerLayer) {
        this.server = bBacnetServerLayer;
    }
}

