/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.server;

import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.services.BacnetReject;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.BacnetSimpleAck;
import com.tridium.bacnet.services.confirmed.DeviceCommunicationControlRequest;
import com.tridium.bacnet.services.confirmed.ReinitializeDeviceRequest;
import com.tridium.bacnet.services.error.SimpleError;
import com.tridium.bacnet.services.unconfirmed.IAmRequest;
import com.tridium.bacnet.services.unconfirmed.IHaveRequest;
import com.tridium.bacnet.services.unconfirmed.WhoHasRequest;
import com.tridium.bacnet.services.unconfirmed.WhoIsRequest;
import com.tridium.bacnet.stack.DeviceRegistry;
import com.tridium.bacnet.stack.IAmListener;
import com.tridium.bacnet.stack.IHaveListener;
import com.tridium.bacnet.stack.server.BBacnetExportTable;
import com.tridium.bacnet.stack.server.BBacnetServerLayer;
import com.tridium.bacnet.stack.server.RestoreBackup;
import com.tridium.bacnet.stack.server.ServiceHandler;
import com.tridium.platform.BOperatingSystemEnum;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.sys.station.Station;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;
import javax.baja.backup.BBackupService;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConfirmedServiceChoice;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetUnconfirmedServiceChoice;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetBackupState;
import javax.baja.bacnet.export.BBacnetFileDescriptor;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.BBacnetComm;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DeviceHandler
implements ServiceHandler,
BacnetUnconfirmedServiceChoice,
BacnetConfirmedServiceChoice {
    private static Boolean supportsWarmRestart = null;
    private static final Log log = Log.getLog((String)"bacnet.server");
    private BBacnetServerLayer server;
    private Vector iAmListeners;
    private Vector iHaveListeners;
    private Clock.Ticket ticket;
    BIFile backupFile;
    BBacnetFileDescriptor exportFile;
    private int databaseRevision;

    public BacnetServicePrimitive receiveRequest(int n, BacnetServicePrimitive bacnetServicePrimitive, BBacnetAddress bBacnetAddress) {
        switch (n) {
            case 8: {
                this.processWhoIsRequest((WhoIsRequest)bacnetServicePrimitive);
                return null;
            }
            case 0: {
                this.processIAmRequest((IAmRequest)bacnetServicePrimitive, bBacnetAddress);
                return null;
            }
            case 7: {
                this.processWhoHasRequest((WhoHasRequest)bacnetServicePrimitive);
                return null;
            }
            case 1: {
                this.processIHaveRequest((IHaveRequest)bacnetServicePrimitive, bBacnetAddress);
                return null;
            }
            case 17: {
                return this.processDeviceCommunicationControlRequest((DeviceCommunicationControlRequest)bacnetServicePrimitive, bBacnetAddress);
            }
            case 20: {
                return this.processReinitializeDeviceRequest((ReinitializeDeviceRequest)bacnetServicePrimitive, bBacnetAddress);
            }
        }
        log.message("DeviceHandler.reqceiveRequest:Unknown request! " + bacnetServicePrimitive);
        return null;
    }

    private final void processWhoIsRequest(WhoIsRequest whoIsRequest) {
        if (log.isTraceOn()) {
            log.trace("DeviceHandler: WhoIsRequest received: " + whoIsRequest);
        }
        if (!whoIsRequest.useLimits()) {
            this.server.iAm();
            return;
        }
        int n = BBacnetNetwork.localDevice().getObjectId().getInstanceNumber();
        if (n >= whoIsRequest.getDeviceInstanceRangeLowLimit() && n <= whoIsRequest.getDeviceInstanceRangeHighLimit()) {
            this.server.iAm();
            return;
        }
    }

    private final void processIAmRequest(IAmRequest iAmRequest, BBacnetAddress bBacnetAddress) {
        if (log.isTraceOn()) {
            log.trace("DeviceHandler: IAmRequest received: " + iAmRequest);
        }
        DeviceRegistry.update(iAmRequest.getObjectId(), bBacnetAddress, iAmRequest.getMaxAPDULengthAccepted(), iAmRequest.getSegmentationSupported());
        this.routeToIAmListeners(iAmRequest, bBacnetAddress);
    }

    private final void processWhoHasRequest(WhoHasRequest whoHasRequest) {
        if (log.isTraceOn()) {
            log.trace("DeviceHandler: WhoHasRequest received: " + whoHasRequest);
        }
        BIBacnetExportObject bIBacnetExportObject = null;
        if (!whoHasRequest.useLimits()) {
            bIBacnetExportObject = whoHasRequest.getObjectId() != null ? BBacnetNetwork.localDevice().lookupBacnetObject(whoHasRequest.getObjectId()) : BBacnetNetwork.localDevice().lookupBacnetObject(whoHasRequest.getObjectName());
        } else {
            int n = BBacnetNetwork.localDevice().getObjectId().getInstanceNumber();
            if (n >= whoHasRequest.getDeviceInstanceRangeLowLimit() && n <= whoHasRequest.getDeviceInstanceRangeHighLimit()) {
                bIBacnetExportObject = whoHasRequest.getObjectId() != null ? BBacnetNetwork.localDevice().lookupBacnetObject(whoHasRequest.getObjectId()) : BBacnetNetwork.localDevice().lookupBacnetObject(whoHasRequest.getObjectName());
            }
        }
        if (bIBacnetExportObject != null) {
            this.server.iHave(bIBacnetExportObject.getObjectId(), bIBacnetExportObject.getObjectName(), whoHasRequest.getEncoding());
        }
    }

    private final void processIHaveRequest(IHaveRequest iHaveRequest, BBacnetAddress bBacnetAddress) {
        if (log.isTraceOn()) {
            log.trace("DeviceHandler: IHaveRequest received: " + iHaveRequest);
        }
        this.routeToIHaveListeners(iHaveRequest, bBacnetAddress);
    }

    private final BacnetServicePrimitive processDeviceCommunicationControlRequest(DeviceCommunicationControlRequest deviceCommunicationControlRequest, BBacnetAddress bBacnetAddress) {
        String string;
        NErrorType nErrorType;
        if (log.isTraceOn()) {
            log.trace("DeviceHandler: DeviceCommunicationControlRequest received: " + deviceCommunicationControlRequest);
        }
        if ((nErrorType = this.checkUserPassword(string = deviceCommunicationControlRequest.getPassword())) != null) {
            return new SimpleError(17, nErrorType);
        }
        boolean bl = false;
        switch (deviceCommunicationControlRequest.getEnableDisable().getOrdinal()) {
            case 0: {
                this.server.stack().enableComm();
                bl = true;
                break;
            }
            case 1: {
                log.message(" Disabling Bacnet Communications per DCC request from address " + bBacnetAddress);
                this.server.stack().disableComm();
                break;
            }
            case 2: {
                log.message(" Disabling Bacnet Communications Initiation per DCC request from address " + bBacnetAddress);
                this.server.stack().disableInitiation();
                break;
            }
            default: {
                return new BacnetReject(6);
            }
        }
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        if (!bl && deviceCommunicationControlRequest.isDurationUsed() && !deviceCommunicationControlRequest.isIndefinite()) {
            this.ticket = Clock.schedule((BComponent)this.server.stack(), (BRelTime)deviceCommunicationControlRequest.getDuration(), (Action)BBacnetComm.enableComm, null);
        }
        return new BacnetSimpleAck(17);
    }

    private final BacnetServicePrimitive processReinitializeDeviceRequest(ReinitializeDeviceRequest reinitializeDeviceRequest, BBacnetAddress bBacnetAddress) {
        Feature feature;
        boolean bl;
        if (log.isTraceOn()) {
            log.trace("DeviceHandler: ReinitializeDeviceRequest received: " + reinitializeDeviceRequest);
        }
        if (!(bl = (feature = this.server.bacnet().getLicenseFeature()).getb("export", false))) {
            return new SimpleError(20, new NErrorType(5, 45));
        }
        String string = reinitializeDeviceRequest.getPassword();
        NErrorType nErrorType = this.checkUserPassword(string);
        if (nErrorType != null) {
            return new SimpleError(20, nErrorType);
        }
        if (!this.server.getReinitializeAllowed()) {
            return new SimpleError(20, new NErrorType(5, 29));
        }
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        BBacnetExportTable bBacnetExportTable = (BBacnetExportTable)bLocalBacnetDevice.getExportTable();
        BacnetServicePrimitive bacnetServicePrimitive = null;
        switch (reinitializeDeviceRequest.getReinitializedStateOfDevice().getOrdinal()) {
            case 1: {
                if (DeviceHandler.supportsWarmRestart()) {
                    return this.processRestart(1);
                }
            }
            case 0: {
                return this.processRestart(0);
            }
            case 2: {
                bacnetServicePrimitive = this.checkCommDisabled();
                if (bacnetServicePrimitive != null) {
                    return bacnetServicePrimitive;
                }
                switch (bLocalBacnetDevice.getSystemStatus().getOrdinal()) {
                    case 3: 
                    case 5: {
                        return new SimpleError(20, new NErrorType(0, 2));
                    }
                }
                log.message("BACnet device at address " + bBacnetAddress + " has initiated a BACKUP...");
                bLocalBacnetDevice.setBackupMode(BBoolean.TRUE);
                this.server.backupRestoreClientAddress = bBacnetAddress;
                BBacnetNetwork.bacnet().postAsync(new StartBackup());
                return new BacnetSimpleAck(20);
            }
            case 3: {
                bacnetServicePrimitive = this.checkCommDisabled();
                if (bacnetServicePrimitive != null) {
                    return bacnetServicePrimitive;
                }
                if (this.backupFile != null) {
                    try {
                        this.backupFile.delete();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    this.backupFile = null;
                }
                if (this.exportFile != null) {
                    bBacnetExportTable.remove((BComplex)this.exportFile);
                    bLocalBacnetDevice.getConfigurationFiles().setSize(0);
                    this.exportFile = null;
                }
                bLocalBacnetDevice.setBackupMode(BBoolean.FALSE);
                this.server.backupRestoreClientAddress = null;
                return new BacnetSimpleAck(20);
            }
            case 4: {
                bacnetServicePrimitive = this.checkCommDisabled();
                if (bacnetServicePrimitive != null) {
                    return bacnetServicePrimitive;
                }
                switch (bLocalBacnetDevice.getSystemStatus().getOrdinal()) {
                    case 3: 
                    case 5: {
                        return new SimpleError(20, new NErrorType(0, 2));
                    }
                }
                log.message("BACnet device at address " + bBacnetAddress + " has initiated a RESTORE...");
                bLocalBacnetDevice.setRestoreMode(BBoolean.TRUE);
                this.server.backupRestoreClientAddress = bBacnetAddress;
                BBacnetNetwork.bacnet().postAsync(new StartRestore());
                return new BacnetSimpleAck(20);
            }
            case 5: {
                bacnetServicePrimitive = this.checkCommDisabled();
                if (bacnetServicePrimitive != null) {
                    return bacnetServicePrimitive;
                }
                if (this.backupFile != null) {
                    BBacnetNetwork.bacnet().postAsync(new EndRestore());
                }
                return new BacnetSimpleAck(20);
            }
            case 6: {
                bacnetServicePrimitive = this.checkCommDisabled();
                if (bacnetServicePrimitive != null) {
                    return bacnetServicePrimitive;
                }
                if (this.backupFile != null) {
                    try {
                        this.backupFile.delete();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    this.backupFile = null;
                }
                if (this.exportFile != null) {
                    bBacnetExportTable.remove((BComplex)this.exportFile);
                    bLocalBacnetDevice.getConfigurationFiles().setSize(0);
                    this.exportFile = null;
                }
                bLocalBacnetDevice.setRestoreMode(BBoolean.FALSE);
                return new BacnetSimpleAck(20);
            }
        }
        return new BacnetReject(6);
    }

    private final BacnetServicePrimitive checkCommDisabled() {
        if (!this.server.stack().isCommExecutionEnabled()) {
            return new SimpleError(20, new NErrorType(5, 83));
        }
        return null;
    }

    private final BacnetServicePrimitive processRestart(int n) {
        try {
            BSystemPlatformService bSystemPlatformService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            Runnable runnable = null;
            if (n == 1) {
                runnable = new WarmStart(bSystemPlatformService);
            } else if (n == 0) {
                runnable = new ColdStart(bSystemPlatformService);
            }
            BBacnetNetwork.bacnet().postAsync(runnable);
            return new BacnetSimpleAck(20);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            log.error("Cannot find System Platform Service!!", (Throwable)serviceNotFoundException);
            return new SimpleError(20, new NErrorType(0, 25));
        }
    }

    private static final boolean supportsWarmRestart() {
        if (supportsWarmRestart == null) {
            supportsWarmRestart = BOperatingSystemEnum.isOS((BOperatingSystemEnum)BOperatingSystemEnum.qnx) ? Boolean.FALSE : Boolean.TRUE;
        }
        return supportsWarmRestart;
    }

    private final NErrorType checkUserPassword(String string) {
        BUserService bUserService = null;
        try {
            bUserService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            log.error("Unable to locate User Service; password cannot be verified!");
            return new NErrorType(5, 0);
        }
        BUser bUser = bUserService.getUser("BACnet");
        if (bUser == null) {
            log.error("BACnet User required for validation of Device Management request!");
            return new NErrorType(5, 29);
        }
        if (string == null) {
            return new NErrorType(4, 26);
        }
        if (bUser.getPassword().validate(string)) {
            log.message("Password validated for BACnet User");
            return null;
        }
        log.error("Incorrect Password for BACnet Device Management Request!");
        return new NErrorType(4, 26);
    }

    void addIAmListener(IAmListener iAmListener) {
        this.iAmListeners.addElement(iAmListener);
    }

    void removeIAmListener(IAmListener iAmListener) {
        this.iAmListeners.removeElement(iAmListener);
    }

    private final void routeToIAmListeners(IAmRequest iAmRequest, BBacnetAddress bBacnetAddress) {
        int n = 0;
        while (n < this.iAmListeners.size()) {
            ((IAmListener)this.iAmListeners.elementAt(n)).receiveIAm(iAmRequest, bBacnetAddress);
            ++n;
        }
    }

    void addIHaveListener(IHaveListener iHaveListener) {
        this.iHaveListeners.addElement(iHaveListener);
    }

    void removeIHaveListener(IHaveListener iHaveListener) {
        this.iHaveListeners.removeElement(iHaveListener);
    }

    private final void routeToIHaveListeners(IHaveRequest iHaveRequest, BBacnetAddress bBacnetAddress) {
        int n = 0;
        while (n < this.iHaveListeners.size()) {
            ((IHaveListener)this.iHaveListeners.elementAt(n)).receiveIHave(iHaveRequest, bBacnetAddress);
            ++n;
        }
    }

    private static final void d(String string) {
        System.out.println(string);
    }

    private final /* synthetic */ void this() {
        this.iAmListeners = new Vector();
        this.iHaveListeners = new Vector();
        this.ticket = null;
        this.backupFile = null;
        this.exportFile = null;
        this.databaseRevision = -1;
    }

    DeviceHandler(BBacnetServerLayer bBacnetServerLayer) {
        this.this();
        this.server = bBacnetServerLayer;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class StartBackup
    implements Runnable {
        public void run() {
            BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
            BBacnetExportTable bBacnetExportTable = (BBacnetExportTable)bLocalBacnetDevice.getExportTable();
            try {
                BBacnetObjectIdentifier bBacnetObjectIdentifier;
                long l = Clock.ticks();
                Station.saveSync();
                long l2 = Clock.ticks();
                BBackupService bBackupService = (BBackupService)Sys.getService((Type)BBackupService.TYPE);
                BFileSystem bFileSystem = BFileSystem.INSTANCE;
                String string = Sys.getStation().getStationName();
                String string2 = "backup_" + string + ".dist";
                String string3 = "!backups/" + string2;
                FilePath filePath = new FilePath(string3);
                DeviceHandler.this.backupFile = bFileSystem.makeFile(filePath, null);
                OutputStream outputStream = DeviceHandler.this.backupFile.getOutputStream();
                long l3 = Clock.ticks();
                bBackupService.zip(null, outputStream, true);
                long l4 = Clock.ticks();
                int n = bBacnetExportTable.getNextInstance(10);
                ((DeviceHandler)DeviceHandler.this).server.backupFileId = bBacnetObjectIdentifier = BBacnetObjectIdentifier.make(10, n);
                DeviceHandler.this.server.scheduleBackupRestoreFailure();
                DeviceHandler.this.exportFile = new BBacnetFileDescriptor();
                DeviceHandler.this.exportFile.setObjectId(bBacnetObjectIdentifier);
                DeviceHandler.this.exportFile.setFileOrd(BOrd.make((OrdQuery)filePath));
                DeviceHandler.this.exportFile.setObjectName(string2);
                DeviceHandler.this.exportFile.setDescription("Station backup file");
                bBacnetExportTable.add(bBacnetObjectIdentifier.toString(BacnetConst.nameContext), (BValue)DeviceHandler.this.exportFile);
                long l5 = Clock.ticks();
                DeviceHandler.d("timing: tSave=" + (l2 - l) + " tPrep=" + (l3 - l2) + " tBackup=" + (l4 - l3) + " tExport=" + (l5 - l4) + " total=" + (l5 - l));
                bLocalBacnetDevice.getConfigurationFiles().addElement((BValue)bBacnetObjectIdentifier);
                bLocalBacnetDevice.setBackupAndRestoreState(BBacnetBackupState.performingABackup);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bLocalBacnetDevice.setBackupAndRestoreState(BBacnetBackupState.backupFailure);
                if (DeviceHandler.this.exportFile != null) {
                    bBacnetExportTable.remove((BComplex)DeviceHandler.this.exportFile);
                    DeviceHandler.this.exportFile = null;
                }
                bLocalBacnetDevice.getConfigurationFiles().setSize(0);
                bLocalBacnetDevice.setBackupMode(BBoolean.FALSE);
            }
        }

        StartBackup() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class StartRestore
    implements Runnable {
        public void run() {
            BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
            DeviceHandler.this.databaseRevision = bLocalBacnetDevice.getDatabaseRevision();
            BBacnetExportTable bBacnetExportTable = (BBacnetExportTable)bLocalBacnetDevice.getExportTable();
            try {
                BBacnetObjectIdentifier bBacnetObjectIdentifier;
                BFileSystem bFileSystem = BFileSystem.INSTANCE;
                String string = Sys.getStation().getStationName();
                String string2 = "backup_" + string + ".dist";
                String string3 = "!backups/" + string2;
                FilePath filePath = new FilePath(string3);
                DeviceHandler.this.backupFile = bFileSystem.makeFile(filePath, null);
                DeviceHandler.this.backupFile.write(new byte[0]);
                int n = bBacnetExportTable.getNextInstance(10);
                ((DeviceHandler)DeviceHandler.this).server.backupFileId = bBacnetObjectIdentifier = BBacnetObjectIdentifier.make(10, n);
                DeviceHandler.this.server.scheduleBackupRestoreFailure();
                DeviceHandler.this.exportFile = new BBacnetFileDescriptor();
                DeviceHandler.this.exportFile.setObjectId(bBacnetObjectIdentifier);
                DeviceHandler.this.exportFile.setFileOrd(BOrd.make((OrdQuery)filePath));
                DeviceHandler.this.exportFile.setObjectName(string2);
                DeviceHandler.this.exportFile.setDescription("Station backup file");
                bBacnetExportTable.add(bBacnetObjectIdentifier.toString(BacnetConst.nameContext), (BValue)DeviceHandler.this.exportFile);
                bLocalBacnetDevice.getConfigurationFiles().addElement((BValue)bBacnetObjectIdentifier);
                bLocalBacnetDevice.setBackupAndRestoreState(BBacnetBackupState.performingARestore);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bLocalBacnetDevice.setBackupAndRestoreState(BBacnetBackupState.restoreFailure);
                if (DeviceHandler.this.exportFile != null) {
                    bBacnetExportTable.remove((BComplex)DeviceHandler.this.exportFile);
                    DeviceHandler.this.exportFile = null;
                }
                bLocalBacnetDevice.getConfigurationFiles().setSize(0);
                bLocalBacnetDevice.setRestoreMode(BBoolean.FALSE);
            }
        }

        StartRestore() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class EndRestore
    implements Runnable {
        public void run() {
            try {
                BFileSystem bFileSystem = BFileSystem.INSTANCE;
                FilePath filePath = new FilePath("!backups/lastRestoreTime");
                BIFile bIFile = bFileSystem.makeFile(filePath, null);
                PrintStream printStream = new PrintStream(bIFile.getOutputStream());
                printStream.print(Clock.time().encodeToString() + '\n');
                printStream.print("" + DeviceHandler.this.databaseRevision + '\n');
                RestoreBackup.INSTANCE.restore(DeviceHandler.this.backupFile);
            }
            catch (Exception exception) {
                log.error("Unable to complete restore procedure:" + exception, (Throwable)exception);
                BBacnetNetwork.localDevice().setBackupAndRestoreState(BBacnetBackupState.restoreFailure);
            }
        }

        EndRestore() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class WarmStart
    implements Runnable {
        BSystemPlatformService sps;

        public void run() {
            if (this.sps != null) {
                log.warning("Restarting station from BACnet ReinitializeDevice Request...");
                this.sps.restartStation();
            } else {
                log.message("SystemPlatformService not found!  Cannot execute BACnet Warm Start.");
            }
        }

        private final /* synthetic */ void this() {
            this.sps = null;
        }

        WarmStart(BSystemPlatformService bSystemPlatformService) {
            this.this();
            this.sps = bSystemPlatformService;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ColdStart
    implements Runnable {
        BSystemPlatformService sps;

        public void run() {
            if (this.sps != null) {
                log.warning("Rebooting station from BACnet ReinitializeDevice Request...");
                this.sps.reboot();
            } else {
                log.message("SystemPlatformService not found!  Cannot execute BACnet Cold Start.");
            }
        }

        private final /* synthetic */ void this() {
            this.sps = null;
        }

        ColdStart(BSystemPlatformService bSystemPlatformService) {
            this.this();
            this.sps = bSystemPlatformService;
        }
    }
}

