/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.server;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.CovNotificationParameters;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.services.BacnetReject;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.BacnetSimpleAck;
import com.tridium.bacnet.services.confirmed.ConfirmedCovNotificationRequest;
import com.tridium.bacnet.services.confirmed.SubscribeCovPropertyRequest;
import com.tridium.bacnet.services.confirmed.SubscribeCovRequest;
import com.tridium.bacnet.services.error.SimpleError;
import com.tridium.bacnet.services.unconfirmed.UnconfirmedCovNotificationRequest;
import com.tridium.bacnet.stack.server.ServiceHandler;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConfirmedServiceChoice;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetUnconfirmedServiceChoice;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetCovSubscription;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.enums.BBacnetRestartReason;
import javax.baja.bacnet.export.BIBacnetCovSource;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.point.BBacnetPointDeviceExt;
import javax.baja.bacnet.point.BBacnetProxyExt;
import javax.baja.bacnet.point.PointCmd;
import javax.baja.control.BControlPoint;
import javax.baja.log.Log;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;

public class CovHandler
implements ServiceHandler,
BacnetConfirmedServiceChoice,
BacnetUnconfirmedServiceChoice {
    private static final Log log = Log.getLog((String)"bacnet.server");

    public BacnetServicePrimitive receiveRequest(int n, BacnetServicePrimitive bacnetServicePrimitive, BBacnetAddress bBacnetAddress) {
        switch (n) {
            case 5: {
                return this.processSubscribeCovRequest((SubscribeCovRequest)bacnetServicePrimitive, bBacnetAddress);
            }
            case 1: {
                return this.processConfirmedCovNotificationRequest((ConfirmedCovNotificationRequest)bacnetServicePrimitive);
            }
            case 2: {
                this.processUnconfirmedCovNotificationRequest((UnconfirmedCovNotificationRequest)bacnetServicePrimitive);
                return null;
            }
            case 28: {
                return this.processSubscribeCovPropertyRequest((SubscribeCovPropertyRequest)bacnetServicePrimitive, bBacnetAddress);
            }
        }
        log.message("CovHandler.receiveRequest:Unknown request! " + bacnetServicePrimitive);
        return new BacnetReject(9);
    }

    private final BacnetServicePrimitive processSubscribeCovRequest(SubscribeCovRequest subscribeCovRequest, BBacnetAddress bBacnetAddress) {
        if (log.isTraceOn()) {
            log.trace("CovHandler.SubscribeCovRequest received: " + subscribeCovRequest);
        }
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        BBacnetObjectIdentifier bBacnetObjectIdentifier = subscribeCovRequest.getMonitoredObjectId();
        long l = subscribeCovRequest.getSubscriberProcessId();
        long l2 = subscribeCovRequest.getLifetime();
        BIBacnetExportObject bIBacnetExportObject = bLocalBacnetDevice.lookupBacnetObject(bBacnetObjectIdentifier);
        BIBacnetCovSource bIBacnetCovSource = null;
        if (bIBacnetExportObject == null) {
            return new SimpleError(5, new NErrorType(1, 31));
        }
        if (bIBacnetExportObject.getObject() == null) {
            return new SimpleError(5, new NErrorType(1, 1000));
        }
        if (!(bIBacnetExportObject instanceof BIBacnetCovSource)) {
            log.message("Attempt to subscribeCov for non-Cov object " + (Object)((Object)bBacnetObjectIdentifier));
            return new SimpleError(5, new NErrorType(5, 29));
        }
        bIBacnetCovSource = (BIBacnetCovSource)((Object)bIBacnetExportObject);
        if (l2 > Integer.MAX_VALUE) {
            return new SimpleError(5, new NErrorType(5, 37));
        }
        BBacnetCovSubscription bBacnetCovSubscription = bIBacnetCovSource.findCovSubscription(bBacnetAddress, l, bBacnetObjectIdentifier);
        if (subscribeCovRequest.isCancellation()) {
            if (bBacnetCovSubscription != null) {
                bIBacnetCovSource.removeCovSubscription(bBacnetCovSubscription);
            }
            return new BacnetSimpleAck(5);
        }
        if (bBacnetCovSubscription != null) {
            bBacnetCovSubscription.setIssueConfirmedNotifications(subscribeCovRequest.getIssueConfirmedNotifications());
            bIBacnetCovSource.startCovTimer(bBacnetCovSubscription, l2);
        } else {
            bBacnetCovSubscription = new BBacnetCovSubscription(bBacnetAddress, l, bBacnetObjectIdentifier, subscribeCovRequest.getIssueConfirmedNotifications());
            bBacnetCovSubscription.setLastValue(((BControlPoint)bIBacnetCovSource.getObject()).getOutStatusValue());
            bIBacnetCovSource.startCovTimer(bBacnetCovSubscription, l2);
            bIBacnetCovSource.addCovSubscription(bBacnetCovSubscription);
        }
        return new BacnetSimpleAck(5);
    }

    private final BacnetServicePrimitive processSubscribeCovPropertyRequest(SubscribeCovPropertyRequest subscribeCovPropertyRequest, BBacnetAddress bBacnetAddress) {
        if (log.isTraceOn()) {
            log.trace("CovHandler.SubscribeCovPropertyRequest received: " + subscribeCovPropertyRequest);
        }
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        BBacnetObjectIdentifier bBacnetObjectIdentifier = subscribeCovPropertyRequest.getMonitoredObjectId();
        long l = subscribeCovPropertyRequest.getSubscriberProcessId();
        long l2 = subscribeCovPropertyRequest.getLifetime();
        PropertyReference propertyReference = subscribeCovPropertyRequest.getMonitoredPropertyId();
        BIBacnetExportObject bIBacnetExportObject = bLocalBacnetDevice.lookupBacnetObject(bBacnetObjectIdentifier);
        BIBacnetCovSource bIBacnetCovSource = null;
        if (bIBacnetExportObject == null) {
            return new SimpleError(28, new NErrorType(1, 31));
        }
        if (bIBacnetExportObject.getObject() == null) {
            return new SimpleError(28, new NErrorType(1, 1000));
        }
        if (!(bIBacnetExportObject instanceof BIBacnetCovSource)) {
            log.message("Attempt to subscribeCovProperty for non-Cov object " + (Object)((Object)bBacnetObjectIdentifier));
            return new SimpleError(28, new NErrorType(1, 45));
        }
        bIBacnetCovSource = (BIBacnetCovSource)((Object)bIBacnetExportObject);
        BBacnetCovSubscription bBacnetCovSubscription = bIBacnetCovSource.findCovPropertySubscription(bBacnetAddress, l, bBacnetObjectIdentifier, propertyReference.getPropertyId(), propertyReference.getPropertyArrayIndex());
        if (subscribeCovPropertyRequest.isCancellation()) {
            if (bBacnetCovSubscription != null) {
                bIBacnetCovSource.removeCovSubscription(bBacnetCovSubscription);
            }
            return new BacnetSimpleAck(28);
        }
        if (bBacnetCovSubscription != null) {
            bBacnetCovSubscription.setIssueConfirmedNotifications(subscribeCovPropertyRequest.getIssueConfirmedNotifications());
            if (l2 > 0L) {
                bIBacnetCovSource.startCovTimer(bBacnetCovSubscription, l2);
                BDouble bDouble = subscribeCovPropertyRequest.getCovIncrement();
                if (bDouble != null) {
                    bBacnetCovSubscription.setCovIncrement(bDouble.getFloat());
                }
            }
        } else {
            bBacnetCovSubscription = new BBacnetCovSubscription(bBacnetAddress, l, bBacnetObjectIdentifier, propertyReference, subscribeCovPropertyRequest.getIssueConfirmedNotifications(), (BNumber)subscribeCovPropertyRequest.getCovIncrement());
            bBacnetCovSubscription.setCovProperty(true);
            bBacnetCovSubscription.setLastPropValue(bIBacnetCovSource.getCurrentCovValue(bBacnetCovSubscription));
            if (l2 > 0L) {
                bIBacnetCovSource.startCovTimer(bBacnetCovSubscription, l2);
            }
            bIBacnetCovSource.addCovSubscription(bBacnetCovSubscription);
        }
        return new BacnetSimpleAck(28);
    }

    private final BacnetServicePrimitive processConfirmedCovNotificationRequest(ConfirmedCovNotificationRequest confirmedCovNotificationRequest) {
        if (log.isTraceOn()) {
            log.trace("CovHandler.ConfirmedCovNotificationRequest received: " + confirmedCovNotificationRequest);
        }
        this.processCov(confirmedCovNotificationRequest.getCovNotificationParameters());
        return new BacnetSimpleAck(1);
    }

    private final void processUnconfirmedCovNotificationRequest(UnconfirmedCovNotificationRequest unconfirmedCovNotificationRequest) {
        if (log.isTraceOn()) {
            log.trace("CovHandler.UnconfirmedCovNotificationRequest received: " + unconfirmedCovNotificationRequest);
        }
        this.processCov(unconfirmedCovNotificationRequest.getCovNotificationParameters());
    }

    private final void processCov(CovNotificationParameters covNotificationParameters) {
        BBacnetDevice bBacnetDevice = BBacnetNetwork.bacnet().doLookupDeviceById(covNotificationParameters.getInitiatingDeviceId());
        if (bBacnetDevice == null) {
            if (log.isTraceOn()) {
                log.trace("Cov Notification from unmapped device:" + (Object)((Object)covNotificationParameters.getInitiatingDeviceId()));
            }
            return;
        }
        BBacnetObjectIdentifier bBacnetObjectIdentifier = covNotificationParameters.getMonitoredObjectId();
        PropertyValue[] propertyValueArray = covNotificationParameters.getListOfValues();
        bBacnetDevice.pingOk();
        BStatus bStatus = null;
        int n = 0;
        while (n < propertyValueArray.length) {
            try {
                BacnetConst bacnetConst;
                if (propertyValueArray[n].getPropertyId() == 111) {
                    bStatus = AsnUtil.asnStatusFlagsToBStatus(propertyValueArray[n].getPropertyValue());
                } else if (propertyValueArray[n].getPropertyId() == 196) {
                    bacnetConst = (BBacnetRestartReason)AsnUtil.fromAsnEnumerated((BEnum)BBacnetRestartReason.DEFAULT, propertyValueArray[n].getPropertyValue());
                    CovHandler.updateDevice(bBacnetDevice, "lastRestartReason", (BValue)bacnetConst);
                } else if (propertyValueArray[n].getPropertyId() == 203) {
                    bacnetConst = new BBacnetTimeStamp();
                    AsnUtil.fromAsn(propertyValueArray[n].getPropertyValue(), (BValue)bacnetConst);
                    CovHandler.updateDevice(bBacnetDevice, "timeOfDeviceRestart", (BValue)bacnetConst);
                } else {
                    CovHandler.updatePointValue(bBacnetDevice, bBacnetObjectIdentifier, propertyValueArray[n]);
                }
            }
            catch (AsnException asnException) {
                asnException.printStackTrace();
                log.trace("Error parsing property: " + asnException.getMessage());
            }
            ++n;
        }
        CovHandler.updateStatusFlags(bBacnetDevice, bBacnetObjectIdentifier, bStatus);
    }

    private static final void updatePointValue(BBacnetDevice bBacnetDevice, BBacnetObjectIdentifier bBacnetObjectIdentifier, PropertyValue propertyValue) {
        BBacnetPointDeviceExt bBacnetPointDeviceExt = bBacnetDevice.getPoints();
        BControlPoint[] bControlPointArray = bBacnetPointDeviceExt.findPoints(bBacnetObjectIdentifier, propertyValue.getPropertyId(), propertyValue.getPropertyArrayIndex());
        int n = 0;
        while (n < bControlPointArray.length) {
            BBacnetProxyExt bBacnetProxyExt = (BBacnetProxyExt)bControlPointArray[n].getProxyExt();
            bBacnetProxyExt.fromEncodedValue(propertyValue.getPropertyValue(), null, BBacnetProxyExt.covContext);
            ++n;
        }
    }

    private static final void updateStatusFlags(BBacnetDevice bBacnetDevice, BBacnetObjectIdentifier bBacnetObjectIdentifier, BStatus bStatus) {
        BControlPoint[] bControlPointArray = bBacnetDevice.getPoints().findPoints(bBacnetObjectIdentifier);
        int n = 0;
        while (n < bControlPointArray.length) {
            BBacnetProxyExt bBacnetProxyExt = (BBacnetProxyExt)bControlPointArray[n].getProxyExt();
            if (bBacnetProxyExt.useStatusFlags()) {
                if (bStatus == null) {
                    BBacnetNetwork.bacnet().postAsync(new PointCmd(0x10000000, bBacnetProxyExt));
                } else {
                    bBacnetProxyExt.fromEncodedValue(null, bStatus, BBacnetProxyExt.covContext);
                }
            }
            ++n;
        }
    }

    private static final void updateDevice(BBacnetDevice bBacnetDevice, String string, BValue bValue) {
        BacUtil.setOrAdd((BComponent)bBacnetDevice.getConfig().getDeviceObject(), string, bValue, 1, null, null);
    }
}

