/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.server;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.BacnetNotificationParameters;
import com.tridium.bacnet.asn.EventNotificationParameters;
import com.tridium.bacnet.asn.NAlarmSummary;
import com.tridium.bacnet.asn.NEnrollmentSummary;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NEventSummary;
import com.tridium.bacnet.datatypes.BPriorityFilter;
import com.tridium.bacnet.enums.BAcknowledgmentFilter;
import com.tridium.bacnet.enums.BEventStateFilter;
import com.tridium.bacnet.history.BBacnetHistoryDeviceExt;
import com.tridium.bacnet.history.BBacnetHistoryImport;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.BacnetSimpleAck;
import com.tridium.bacnet.services.confirmed.AcknowledgeAlarmRequest;
import com.tridium.bacnet.services.confirmed.ConfirmedEventNotificationRequest;
import com.tridium.bacnet.services.confirmed.GetAlarmSummaryAck;
import com.tridium.bacnet.services.confirmed.GetAlarmSummaryRequest;
import com.tridium.bacnet.services.confirmed.GetEnrollmentSummaryAck;
import com.tridium.bacnet.services.confirmed.GetEnrollmentSummaryRequest;
import com.tridium.bacnet.services.confirmed.GetEventInformationAck;
import com.tridium.bacnet.services.confirmed.GetEventInformationRequest;
import com.tridium.bacnet.services.error.SimpleError;
import com.tridium.bacnet.services.unconfirmed.UnconfirmedEventNotificationRequest;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.DeviceRegistry;
import com.tridium.bacnet.stack.client.AckAlarmRequest;
import com.tridium.bacnet.stack.network.BBacnetNetworkLayer;
import com.tridium.bacnet.stack.network.BNetworkPort;
import com.tridium.bacnet.stack.server.BBacnetExportTable;
import com.tridium.bacnet.stack.server.BHashedEventBuffer;
import com.tridium.bacnet.stack.server.ServiceHandler;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetAlarmConst;
import javax.baja.bacnet.BacnetConfirmedServiceChoice;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetUnconfirmedServiceChoice;
import javax.baja.bacnet.alarm.BBacnetAlarmDeviceExt;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDestination;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetRecipient;
import javax.baja.bacnet.datatypes.BBacnetRecipientProcess;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetNotifyType;
import javax.baja.bacnet.export.BBacnetEventSource;
import javax.baja.bacnet.export.BBacnetNotificationClassDescriptor;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.BBacnetComm;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.EventNotificationListener;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.alarm.BAlarmDeviceExt;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Cursor;
import javax.baja.sys.NoSuchSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.BUuid;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BEventHandler
extends BComponent
implements ServiceHandler,
BIAlarmSource,
BacnetConfirmedServiceChoice,
BacnetUnconfirmedServiceChoice,
BacnetAlarmConst,
BacnetConst {
    public static final Property silenceSupported = BEventHandler.newProperty((int)1, (boolean)false, null);
    public static final Property eventSummaryAlarmClass = BEventHandler.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE")));
    public static final Property eventSummaryProcessId = BEventHandler.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)Integer.MAX_VALUE));
    public static final Property toOffnormalBuffer = BEventHandler.newProperty((int)4, (BValue)new BHashedEventBuffer(), null);
    public static final Property toFaultBuffer = BEventHandler.newProperty((int)4, (BValue)new BHashedEventBuffer(), null);
    public static final Property toNormalBuffer = BEventHandler.newProperty((int)4, (BValue)new BHashedEventBuffer(), null);
    public static final Property eventSummaries = BEventHandler.newProperty((int)4, (BValue)new BComponent(), null);
    public static final Action ackAlarm = BEventHandler.newAction((int)5, (BValue)new BAlarmRecord(), null);
    public static final Action dumpBuffers = BEventHandler.newAction((int)4, null);
    public static final Action clearBuffers = BEventHandler.newAction((int)0, null);
    public static final Type TYPE;
    private static final Log log;
    private Vector confirmedEventListeners;
    private Vector unconfirmedEventListeners;
    static /* synthetic */ Class class$com$tridium$bacnet$stack$server$BEventHandler;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetObjectIdentifier;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmRecord;

    public boolean getSilenceSupported() {
        return this.getBoolean(silenceSupported);
    }

    public void setSilenceSupported(boolean bl) {
        this.setBoolean(silenceSupported, bl, null);
    }

    public String getEventSummaryAlarmClass() {
        return this.getString(eventSummaryAlarmClass);
    }

    public void setEventSummaryAlarmClass(String string) {
        this.setString(eventSummaryAlarmClass, string, null);
    }

    public int getEventSummaryProcessId() {
        return this.getInt(eventSummaryProcessId);
    }

    public void setEventSummaryProcessId(int n) {
        this.setInt(eventSummaryProcessId, n, null);
    }

    public BHashedEventBuffer getToOffnormalBuffer() {
        return (BHashedEventBuffer)this.get(toOffnormalBuffer);
    }

    public void setToOffnormalBuffer(BHashedEventBuffer bHashedEventBuffer) {
        this.set(toOffnormalBuffer, (BValue)bHashedEventBuffer, null);
    }

    public BHashedEventBuffer getToFaultBuffer() {
        return (BHashedEventBuffer)this.get(toFaultBuffer);
    }

    public void setToFaultBuffer(BHashedEventBuffer bHashedEventBuffer) {
        this.set(toFaultBuffer, (BValue)bHashedEventBuffer, null);
    }

    public BHashedEventBuffer getToNormalBuffer() {
        return (BHashedEventBuffer)this.get(toNormalBuffer);
    }

    public void setToNormalBuffer(BHashedEventBuffer bHashedEventBuffer) {
        this.set(toNormalBuffer, (BValue)bHashedEventBuffer, null);
    }

    public BComponent getEventSummaries() {
        return (BComponent)this.get(eventSummaries);
    }

    public void setEventSummaries(BComponent bComponent) {
        this.set(eventSummaries, (BValue)bComponent, null);
    }

    public BBoolean ackAlarm(BAlarmRecord bAlarmRecord) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)bAlarmRecord, null);
    }

    public void dumpBuffers() {
        this.invoke(dumpBuffers, null, null);
    }

    public void clearBuffers() {
        this.invoke(clearBuffers, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBoolean doAckAlarm(BAlarmRecord bAlarmRecord) {
        if (log.isTraceOn()) {
            log.trace("BEventHandler.doAckAlarm():" + bAlarmRecord);
        }
        if (this.checkRecordByTimestamp(bAlarmRecord)) {
            AckAlarmRequest ackAlarmRequest = new AckAlarmRequest(bAlarmRecord);
            BBacnetNetwork.bacnet().postAsync(ackAlarmRequest);
            return BBoolean.TRUE;
        }
        log.trace("Stale ack received from Alarm Service!");
        try {
            BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            bAlarmRecord.ackAlarm();
            bAlarmRecord.setAckState(BAckState.acked);
            bAlarmService.routeAlarm(bAlarmRecord);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            log.error("BEventHandler.doAckAlarm:Unable to find Alarm Service!", (Throwable)serviceNotFoundException);
            serviceNotFoundException.printStackTrace();
        }
        return BBoolean.FALSE;
    }

    public void doDumpBuffers() {
    }

    public void doClearBuffers() {
        this.getToOffnormalBuffer().removeAll();
        this.getToFaultBuffer().removeAll();
        this.getToNormalBuffer().removeAll();
        this.getEventSummaries().removeAll();
    }

    public BacnetServicePrimitive receiveRequest(int n, BacnetServicePrimitive bacnetServicePrimitive, BBacnetAddress bBacnetAddress) {
        BacnetServicePrimitive bacnetServicePrimitive2 = null;
        try {
            if (bacnetServicePrimitive.getServiceType() == 0) {
                switch (n) {
                    case 0: {
                        bacnetServicePrimitive2 = this.processAcknowledgeAlarmRequest((AcknowledgeAlarmRequest)bacnetServicePrimitive, bBacnetAddress);
                        break;
                    }
                    case 2: {
                        bacnetServicePrimitive2 = this.processConfirmedEventNotificationRequest((ConfirmedEventNotificationRequest)bacnetServicePrimitive);
                        this.routeToConfirmedListeners((ConfirmedEventNotificationRequest)bacnetServicePrimitive, bBacnetAddress);
                        break;
                    }
                    case 3: {
                        bacnetServicePrimitive2 = this.processGetAlarmSummaryRequest((GetAlarmSummaryRequest)bacnetServicePrimitive);
                        break;
                    }
                    case 4: {
                        bacnetServicePrimitive2 = this.processGetEnrollmentSummaryRequest((GetEnrollmentSummaryRequest)bacnetServicePrimitive);
                        break;
                    }
                    case 29: {
                        bacnetServicePrimitive2 = this.processGetEventInformationRequest((GetEventInformationRequest)bacnetServicePrimitive);
                        break;
                    }
                    default: {
                        log.message("BEventHandler.receiveRequest:Unknown request! " + bacnetServicePrimitive);
                        break;
                    }
                }
            } else {
                switch (n) {
                    case 3: {
                        this.processUnconfirmedEventNotificationRequest((UnconfirmedEventNotificationRequest)bacnetServicePrimitive);
                        this.routeToUnconfirmedListeners((UnconfirmedEventNotificationRequest)bacnetServicePrimitive, bBacnetAddress);
                        break;
                    }
                    default: {
                        log.message("BEventHandler.receiveRequest:Unknown request! " + bacnetServicePrimitive);
                    }
                }
            }
        }
        catch (Exception exception) {
            log.error("Server error in event handler: " + exception + " processing request " + bacnetServicePrimitive + " from " + bBacnetAddress, (Throwable)exception);
        }
        return bacnetServicePrimitive2;
    }

    protected BacnetServicePrimitive processAcknowledgeAlarmRequest(AcknowledgeAlarmRequest acknowledgeAlarmRequest, BBacnetAddress bBacnetAddress) {
        boolean bl = log.isTraceOn();
        if (bl) {
            log.trace("BEventHandler: AcknowledgeAlarmRequest received: " + acknowledgeAlarmRequest);
        }
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        ErrorType errorType = null;
        try {
            BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            BBacnetObjectIdentifier bBacnetObjectIdentifier = bLocalBacnetDevice.getObjectId();
            BBacnetObjectIdentifier bBacnetObjectIdentifier2 = acknowledgeAlarmRequest.getEventObjectId();
            BIBacnetExportObject bIBacnetExportObject = bLocalBacnetDevice.lookupBacnetObject(bBacnetObjectIdentifier2);
            if (bIBacnetExportObject == null) {
                return new SimpleError(0, new NErrorType(1, 31));
            }
            if (!(bIBacnetExportObject instanceof BBacnetEventSource)) {
                return new SimpleError(0, new NErrorType(1, 74));
            }
            BEnum bEnum = acknowledgeAlarmRequest.getEventStateAcknowledged();
            BAlarmRecord bAlarmRecord = this.getRecordFromEventBuffer(bEnum.getOrdinal(), bBacnetObjectIdentifier, bBacnetObjectIdentifier2, 0L, false);
            if (bl) {
                System.out.println("\nstateAcked:" + bEnum + ", ordinal=" + bEnum.getOrdinal());
            }
            if ((errorType = this.validateAcknowledgement(acknowledgeAlarmRequest, bAlarmRecord, bAlarmService, bBacnetAddress, (BBacnetEventSource)bIBacnetExportObject)) == null) {
                BAlarmRecord[] bAlarmRecordArray;
                if (bl) {
                    log.trace("\n\nacknowledgement validated (but not yet acked!) record=" + bAlarmRecord + "\nalarmData=" + bAlarmRecord.getAlarmData() + "\nuuid:" + bAlarmRecord.getUuid() + '\n');
                }
                bAlarmRecord.setUser(acknowledgeAlarmRequest.getAcknowledgementSource());
                bAlarmRecord.setAckState(BAckState.ackPending);
                int n = 0;
                BInteger bInteger = (BInteger)bAlarmRecord.getAlarmFacet("bacnetAcksRequired");
                if (bInteger != null) {
                    n = bInteger.getInt();
                }
                if (BBacnetEventState.isOffnormal(bEnum)) {
                    bAlarmRecord.addAlarmFacet("offnormalAcked", (BIDataValue)BBoolean.TRUE);
                    n &= 0xFFFFFFFB;
                } else if (BBacnetEventState.isFault(bEnum)) {
                    n &= 0xFFFFFFFD;
                } else if (BBacnetEventState.isNormal(bEnum)) {
                    n &= 0xFFFFFFFE;
                }
                if (bl) {
                    System.out.println("bacnetAcksRequired=" + n);
                }
                bAlarmRecord.addAlarmFacet("bacnetAcksRequired", (BIDataValue)BInteger.make((int)n));
                bAlarmRecord.addAlarmFacet("stateAcked", (BIDataValue)BInteger.make((int)bEnum.getOrdinal()));
                if (n == 0) {
                    if (bl) {
                        System.out.println("BEventHandler.processAckAlarmReq: no more acks req'd - ackAlarm(): user=" + bAlarmRecord.getUser() + " stateAcked=" + bEnum + "...");
                    }
                    bAlarmService.ackAlarm(bAlarmRecord);
                } else {
                    if (bl) {
                        System.out.println("\nBEventHandler.processAckAlarmReq: more acks req'd - routeAlarm(): user=" + bAlarmRecord.getUser() + " stateAcked=" + bEnum + "; adjusting ackedTransitions...");
                    }
                    bAlarmRecordArray = bAlarmRecord.getSource().get(0).get((BObject)this);
                    BAlarmSourceExt bAlarmSourceExt = (BAlarmSourceExt)bAlarmRecordArray;
                    int n2 = bAlarmSourceExt.getAckedTransitions().getBits();
                    bAlarmSourceExt.setAckedTransitions(BAlarmTransitionBits.make((int)(n2 |= BEventHandler.getAlarmTransitionBit(acknowledgeAlarmRequest.getEventStateAcknowledged()))));
                    bAlarmService.getAlarmDb().update(bAlarmRecord);
                    bAlarmService.routeAlarm(bAlarmRecord);
                }
                bAlarmRecordArray = this.getOtherUnackeds(bAlarmRecord);
                int n3 = 0;
                while (n3 < bAlarmRecordArray.length) {
                    this.ackNiagara(bAlarmRecordArray[n3], bEnum);
                    bAlarmService.routeAlarm(bAlarmRecordArray[n3]);
                    ++n3;
                }
                return new BacnetSimpleAck(0);
            }
            return new SimpleError(0, errorType);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            log.error("BEventHandler.processAcknowledgeAlarmRequest:Unable to find Alarm Service!", (Throwable)serviceNotFoundException);
            serviceNotFoundException.printStackTrace();
            return new SimpleError(0, new NErrorType(3, 0));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new SimpleError(0, new NErrorType(3, 0));
        }
    }

    protected BacnetServicePrimitive processConfirmedEventNotificationRequest(ConfirmedEventNotificationRequest confirmedEventNotificationRequest) {
        if (log.isTraceOn()) {
            log.trace("BEventHandler: ConfirmedEventNotificationRequest received: " + confirmedEventNotificationRequest);
        }
        NErrorType nErrorType = null;
        try {
            nErrorType = this.processEvent(confirmedEventNotificationRequest.getEventNotificationParameters(), true);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            log.error("Can't find Alarm Service!");
            nErrorType = new NErrorType(0, 25);
        }
        catch (Exception exception) {
            log.error("Error processing BACnet Event Notification:" + exception, (Throwable)exception);
            nErrorType = new NErrorType(0, 25);
        }
        if (nErrorType == null) {
            return new BacnetSimpleAck(2);
        }
        return new SimpleError(2, nErrorType);
    }

    protected void processUnconfirmedEventNotificationRequest(UnconfirmedEventNotificationRequest unconfirmedEventNotificationRequest) {
        if (log.isTraceOn()) {
            log.trace("BEventHandler: UnconfirmedEventNotificationRequest received: " + unconfirmedEventNotificationRequest);
        }
        try {
            this.processEvent(unconfirmedEventNotificationRequest.getEventNotificationParameters(), false);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            log.error("Can't find Alarm Service!");
        }
        catch (Exception exception) {
            log.error("Error processing BACnet Event Notification:" + exception, (Throwable)exception);
        }
    }

    protected BacnetServicePrimitive processGetAlarmSummaryRequest(GetAlarmSummaryRequest getAlarmSummaryRequest) {
        int n;
        if (log.isTraceOn()) {
            log.trace("BEventHandler: GetAlarmSummaryRequest received: " + getAlarmSummaryRequest);
        }
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        Vector<NAlarmSummary> vector = new Vector<NAlarmSummary>();
        BComponent bComponent = this.getEventSummaries();
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetObjectIdentifier;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetObjectIdentifier = BEventHandler.class("[Ljavax.baja.bacnet.datatypes.BBacnetObjectIdentifier;", false);
        }
        BBacnetObjectIdentifier[] bBacnetObjectIdentifierArray = (BBacnetObjectIdentifier[])bComponent.getChildren(clazz);
        int n2 = bBacnetObjectIdentifierArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            BEnum bEnum;
            BBacnetObjectIdentifier bBacnetObjectIdentifier = bBacnetObjectIdentifierArray[n3];
            BBacnetEventSource bBacnetEventSource = (BBacnetEventSource)bLocalBacnetDevice.lookupBacnetObject(bBacnetObjectIdentifier);
            if (bBacnetEventSource == null) {
                this.getEventSummaries().remove(bBacnetObjectIdentifier.toString(BacnetConst.nameContext));
            } else if (bBacnetEventSource.getNotifyType() == BBacnetNotifyType.alarm && (bEnum = bBacnetEventSource.getEventState()).getOrdinal() != 0) {
                NAlarmSummary nAlarmSummary = new NAlarmSummary(bBacnetObjectIdentifier, bEnum, bBacnetEventSource.getAckedTransitions());
                vector.add(nAlarmSummary);
            }
            ++n3;
        }
        return new GetAlarmSummaryAck(vector);
    }

    protected BacnetServicePrimitive processGetEnrollmentSummaryRequest(GetEnrollmentSummaryRequest getEnrollmentSummaryRequest) {
        if (log.isTraceOn()) {
            log.trace("BEventHandler: GetEnrollmentSummaryRequest received: " + getEnrollmentSummaryRequest);
        }
        BBacnetExportTable bBacnetExportTable = (BBacnetExportTable)BBacnetNetwork.localDevice().getExportTable();
        BIBacnetExportObject[] bIBacnetExportObjectArray = bBacnetExportTable.getExportedObjects(BBacnetEventSource.TYPE);
        BBacnetEventSource bBacnetEventSource = null;
        Vector<NEnrollmentSummary> vector = new Vector<NEnrollmentSummary>();
        BAcknowledgmentFilter bAcknowledgmentFilter = getEnrollmentSummaryRequest.getAcknowledgmentFilter();
        BBacnetRecipientProcess bBacnetRecipientProcess = getEnrollmentSummaryRequest.getEnrollmentFilter();
        BEventStateFilter bEventStateFilter = getEnrollmentSummaryRequest.getEventStateFilter();
        BEnum bEnum = getEnrollmentSummaryRequest.getEventTypeFilter();
        BPriorityFilter bPriorityFilter = getEnrollmentSummaryRequest.getPriorityFilter();
        long l = getEnrollmentSummaryRequest.getNotificationClassFilter();
        int n = 0;
        while (n < bIBacnetExportObjectArray.length) {
            block9: {
                block10: {
                    bBacnetEventSource = (BBacnetEventSource)bIBacnetExportObjectArray[n];
                    if (!bBacnetEventSource.isEventInitiationEnabled() || !bAcknowledgmentFilter.filter(bBacnetEventSource.getAckedTransitions())) break block9;
                    if (!getEnrollmentSummaryRequest.isEnrollmentFilter()) break block10;
                    BBacnetNotificationClassDescriptor bBacnetNotificationClassDescriptor = bBacnetEventSource.getNotificationClass();
                    BBacnetDestination[] bBacnetDestinationArray = bBacnetNotificationClassDescriptor.getRecipientList();
                    boolean bl = false;
                    int n2 = 0;
                    while (n2 < bBacnetDestinationArray.length) {
                        if (bBacnetDestinationArray[n2].getProcessIdentifier().equals((Object)bBacnetRecipientProcess.getProcessIdentifier()) && bBacnetDestinationArray[n2].getRecipient().equivalent(bBacnetRecipientProcess.getRecipient())) {
                            bl = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!bl) break block9;
                }
                if (!(getEnrollmentSummaryRequest.isEventStateFilter() && !bEventStateFilter.filter(bBacnetEventSource.getEventState()) || getEnrollmentSummaryRequest.isEventTypeFilter() && bEnum.getOrdinal() != bBacnetEventSource.getEventType().getOrdinal())) {
                    int n3 = BEventHandler.getNiagaraSourceState(bBacnetEventSource.getEventState().getOrdinal());
                    int n4 = bBacnetEventSource.getEventPriorities()[n3];
                    if (!(getEnrollmentSummaryRequest.isPriorityFilter() && !bPriorityFilter.filter(n4) || getEnrollmentSummaryRequest.isNotificationClassFilter() && (long)bBacnetEventSource.getNotificationClass().getNotificationClass() != l)) {
                        vector.add(new NEnrollmentSummary(bBacnetEventSource.getObjectId(), bBacnetEventSource.getEventType(), bBacnetEventSource.getEventState(), n4, getEnrollmentSummaryRequest.isNotificationClassFilter() ? bBacnetEventSource.getNotificationClass().getNotificationClass() : -1));
                    }
                }
            }
            ++n;
        }
        return new GetEnrollmentSummaryAck(vector);
    }

    protected BacnetServicePrimitive processGetEventInformationRequest(GetEventInformationRequest getEventInformationRequest) {
        if (log.isTraceOn()) {
            log.trace("BEventHandler: GetEventInformationRequest received: " + getEventInformationRequest);
        }
        int n = getEventInformationRequest.getMaxDataLength();
        n -= 4;
        int n2 = -1;
        BBacnetObjectIdentifier bBacnetObjectIdentifier = getEventInformationRequest.getLastReceivedObjectId();
        if (bBacnetObjectIdentifier != null) {
            n2 = bBacnetObjectIdentifier.hashCode();
        }
        Vector<NEventSummary> vector = new Vector<NEventSummary>();
        int n3 = 0;
        boolean bl = false;
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        BComponent bComponent = this.getEventSummaries();
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetObjectIdentifier;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetObjectIdentifier = BEventHandler.class("[Ljavax.baja.bacnet.datatypes.BBacnetObjectIdentifier;", false);
        }
        BBacnetObjectIdentifier[] bBacnetObjectIdentifierArray = (BBacnetObjectIdentifier[])bComponent.getChildren(clazz);
        int n4 = bBacnetObjectIdentifierArray.length;
        int n5 = 0;
        if (bBacnetObjectIdentifier != null) {
            while (n5 < n4) {
                if (bBacnetObjectIdentifierArray[n5++].hashCode() == n2) break;
            }
        }
        int n6 = n5;
        while (n6 < n4) {
            BBacnetObjectIdentifier bBacnetObjectIdentifier2 = bBacnetObjectIdentifierArray[n6];
            BBacnetEventSource bBacnetEventSource = (BBacnetEventSource)bLocalBacnetDevice.lookupBacnetObject(bBacnetObjectIdentifier2);
            if (bBacnetEventSource == null || bBacnetEventSource.getEventState() == null) {
                this.getEventSummaries().remove(bBacnetObjectIdentifier2.toString(BacnetConst.nameContext));
            } else {
                NEventSummary nEventSummary = new NEventSummary(bBacnetObjectIdentifier2, bBacnetEventSource.getEventState(), bBacnetEventSource.getAckedTransitions(), bBacnetEventSource.getEventTimeStamps(), bBacnetEventSource.getNotifyType(), bBacnetEventSource.getEventEnable(), bBacnetEventSource.getEventPriorities());
                if (n > 0 && (n3 += nEventSummary.getEncodedSize()) > n) {
                    bl = true;
                    break;
                }
                vector.add(nEventSummary);
            }
            ++n6;
        }
        return new GetEventInformationAck(vector, bl);
    }

    public void putRecordToEventBuffer(int n, BBacnetObjectIdentifier bBacnetObjectIdentifier, BBacnetObjectIdentifier bBacnetObjectIdentifier2, long l, BAlarmRecord bAlarmRecord) {
        BHashedEventBuffer bHashedEventBuffer = this.getEventBuffer(n);
        bHashedEventBuffer.putRecord(bBacnetObjectIdentifier, bBacnetObjectIdentifier2, l, bAlarmRecord);
    }

    public BAlarmRecord getRecordFromEventBuffer(int n, BBacnetObjectIdentifier bBacnetObjectIdentifier, BBacnetObjectIdentifier bBacnetObjectIdentifier2, long l, boolean bl) {
        return this.getRecordFromEventBuffer(n, bBacnetObjectIdentifier, bBacnetObjectIdentifier2, l, null, bl);
    }

    public BAlarmRecord getRecordFromEventBuffer(int n, BBacnetObjectIdentifier bBacnetObjectIdentifier, BBacnetObjectIdentifier bBacnetObjectIdentifier2, long l, BUuid bUuid, boolean bl) {
        BHashedEventBuffer bHashedEventBuffer = this.getEventBuffer(n);
        return bHashedEventBuffer.getRecord(bBacnetObjectIdentifier, bBacnetObjectIdentifier2, l, bUuid, bl);
    }

    public boolean checkRecordByTimestamp(BAlarmRecord bAlarmRecord) {
        BHashedEventBuffer bHashedEventBuffer = this.getEventBuffer(bAlarmRecord.getSourceState());
        return bHashedEventBuffer.checkRecord(bAlarmRecord);
    }

    public void addEventSummary(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        String string = bBacnetObjectIdentifier.toString(BacnetConst.nameContext);
        if (this.getEventSummaries().get(string) == null) {
            this.getEventSummaries().add(string, (BValue)bBacnetObjectIdentifier, 1);
        }
    }

    public void removeEventSummary(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        try {
            this.getEventSummaries().remove(bBacnetObjectIdentifier.toString(BacnetConst.nameContext));
        }
        catch (NoSuchSlotException noSuchSlotException) {}
    }

    public void processEventSummary(NEventSummary nEventSummary, BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        try {
            BBacnetNetwork bBacnetNetwork = BBacnetNetwork.bacnet();
            BBacnetDevice bBacnetDevice = bBacnetNetwork.doLookupDeviceById(bBacnetObjectIdentifier);
            BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            BBacnetObjectIdentifier bBacnetObjectIdentifier2 = nEventSummary.getObjectId();
            BComponent bComponent = this.findLocalAlarmSource(bBacnetDevice, nEventSummary);
            int n = nEventSummary.getEventState().getOrdinal();
            BBacnetBitString bBacnetBitString = nEventSummary.getAcknowledgedTransitions();
            int n2 = 0;
            while (n2 < 3) {
                long l = this.getProcessIdForEvent(bBacnetObjectIdentifier, nEventSummary);
                int n3 = this.getEventStateFromTransition(n2);
                BAlarmRecord bAlarmRecord = this.getRecordFromEventBuffer(n3, bBacnetObjectIdentifier, bBacnetObjectIdentifier2, l, false);
                if (this.shouldBuildAlarm(nEventSummary, n2, bAlarmRecord)) {
                    BSourceState bSourceState;
                    BFacets bFacets = this.buildAlarmData(nEventSummary, bBacnetObjectIdentifier, n2);
                    BAlarmRecord bAlarmRecord2 = new BAlarmRecord((BComponent)this, this.getEventSummaryAlarmClass(), bFacets);
                    switch (n) {
                        case 1: {
                            bSourceState = BSourceState.fault;
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            bSourceState = BSourceState.offnormal;
                            break;
                        }
                        default: {
                            bSourceState = BSourceState.normal;
                        }
                    }
                    bAlarmRecord2.setSourceState(bSourceState);
                    BBacnetTimeStamp bBacnetTimeStamp = nEventSummary.getEventTimeStamps()[n2];
                    bAlarmRecord2.setTimestamp(bBacnetTimeStamp.toBAbsTime());
                    bAlarmRecord2.setPriority(nEventSummary.getEventPriorities()[n2]);
                    if (!bBacnetBitString.getBit(n2)) {
                        bAlarmRecord2.addAlarmFacet("bacnetAcksRequired", (BIDataValue)BString.make((String)(BBacnetEventState.tag(n2) + '@' + bBacnetTimeStamp.toString(BacnetConst.facetsContext))));
                    }
                    this.addLocalSource(bComponent, bAlarmRecord2);
                    if (log.isTraceOn()) {
                        log.trace("Routing alarm from GetEventInfo:" + bAlarmRecord2);
                    }
                    this.putRecordToEventBuffer(n, bBacnetObjectIdentifier, bBacnetObjectIdentifier2, l, bAlarmRecord2);
                    bAlarmService.routeAlarm(bAlarmRecord2);
                }
                ++n2;
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            log.error("BEventHandler.processEventSummary:Unable to find Alarm Service!", (Throwable)serviceNotFoundException);
            serviceNotFoundException.printStackTrace();
        }
    }

    protected NErrorType processEvent(EventNotificationParameters eventNotificationParameters, boolean bl) {
        BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BAlarmDatabase bAlarmDatabase = bAlarmService.getAlarmDb();
        BAlarmRecord bAlarmRecord = null;
        BBacnetObjectIdentifier bBacnetObjectIdentifier = eventNotificationParameters.getInitiatingDeviceId();
        BBacnetObjectIdentifier bBacnetObjectIdentifier2 = eventNotificationParameters.getEventObjectId();
        long l = eventNotificationParameters.getProcessId();
        BBacnetNetwork bBacnetNetwork = BBacnetNetwork.bacnet();
        BBacnetDevice bBacnetDevice = bBacnetNetwork.doLookupDeviceById(bBacnetObjectIdentifier);
        if (bBacnetDevice == null) {
            log.message("Bacnet alarm received from unknown device!  Ignoring...");
            return new NErrorType(1, 31);
        }
        bBacnetDevice.getAlarms().setLastReceivedTime(BAbsTime.make());
        BControlPoint bControlPoint = (BControlPoint)bBacnetDevice.lookupBacnetObject(bBacnetObjectIdentifier2, 85, -1, "point");
        BBacnetNotifyType bBacnetNotifyType = eventNotificationParameters.getNotifyType();
        if (bBacnetNotifyType.getOrdinal() == 2) {
            bAlarmRecord = this.processAckNotification(eventNotificationParameters, bBacnetDevice.getAlarms(), bAlarmDatabase);
        } else {
            bAlarmRecord = this.processEventNotification(eventNotificationParameters, bBacnetDevice.getAlarms(), bControlPoint);
            bAlarmRecord.addAlarmFacet("confirmed", (BIDataValue)BBoolean.make((boolean)bl));
            this.putRecordToEventBuffer(eventNotificationParameters.getToState().getOrdinal(), bBacnetObjectIdentifier, bBacnetObjectIdentifier2, l, bAlarmRecord);
        }
        if (bAlarmRecord != null) {
            if (log.isTraceOn()) {
                log.trace("processEvent...record:" + bAlarmRecord + "\n data=" + bAlarmRecord.getAlarmData());
            }
            this.addSourceAndRoute(bAlarmRecord, bControlPoint, bBacnetDevice.getAlarms());
            this.checkForBufferReady(eventNotificationParameters.getEventType().getOrdinal(), bBacnetDevice, bBacnetObjectIdentifier2);
            return null;
        }
        log.message("Unable to generate or match alarm for routing: " + eventNotificationParameters + "\n toState=" + eventNotificationParameters.getToState() + ", notifyType=" + (Object)((Object)bBacnetNotifyType));
        return new NErrorType(5, 0);
    }

    protected BAlarmRecord processAckNotification(EventNotificationParameters eventNotificationParameters, BAlarmDeviceExt bAlarmDeviceExt, BAlarmDatabase bAlarmDatabase) {
        BAlarmRecord bAlarmRecord = null;
        bAlarmRecord = this.getRecordFromEventBuffer(eventNotificationParameters.getToState().getOrdinal(), eventNotificationParameters.getInitiatingDeviceId(), eventNotificationParameters.getEventObjectId(), eventNotificationParameters.getProcessId(), false);
        if (bAlarmRecord != null) {
            this.ackNiagara(bAlarmRecord, eventNotificationParameters.getToState());
        }
        BAlarmRecord[] bAlarmRecordArray = this.getOtherUnackeds(bAlarmRecord);
        int n = 0;
        while (n < bAlarmRecordArray.length) {
            this.ackNiagara(bAlarmRecordArray[n], eventNotificationParameters.getToState());
            bAlarmDeviceExt.routeAlarm(bAlarmRecordArray[n]);
            ++n;
        }
        return bAlarmRecord;
    }

    protected BAlarmRecord processEventNotification(EventNotificationParameters eventNotificationParameters, BAlarmDeviceExt bAlarmDeviceExt, BControlPoint bControlPoint) {
        BAlarmRecord bAlarmRecord = null;
        BEnum bEnum = eventNotificationParameters.getToState();
        if (BBacnetEventState.isNormal(bEnum)) {
            BEnum bEnum2 = eventNotificationParameters.getFromState();
            if (BBacnetEventState.isFault(bEnum2)) {
                bAlarmRecord = this.getRecordFromEventBuffer(bEnum2.getOrdinal(), eventNotificationParameters.getInitiatingDeviceId(), eventNotificationParameters.getEventObjectId(), eventNotificationParameters.getProcessId(), false);
            } else if (BBacnetEventState.isOffnormal(bEnum2)) {
                bAlarmRecord = this.getRecordFromEventBuffer(bEnum2.getOrdinal(), eventNotificationParameters.getInitiatingDeviceId(), eventNotificationParameters.getEventObjectId(), eventNotificationParameters.getProcessId(), false);
            }
        }
        boolean bl = true;
        if (bAlarmRecord == null) {
            if (bControlPoint != null) {
                bAlarmRecord = new BAlarmRecord((BComponent)bControlPoint.getProxyExt(), bAlarmDeviceExt.getAlarmClass(), this.buildAlarmData(eventNotificationParameters));
                bl = false;
            } else {
                bAlarmRecord = new BAlarmRecord((BComponent)bAlarmDeviceExt, bAlarmDeviceExt.getAlarmClass(), this.buildAlarmData(eventNotificationParameters));
            }
            bAlarmRecord.setTimestamp(eventNotificationParameters.getTimeStamp().toBAbsTime());
        } else {
            if (!bl && BBacnetEventState.isNormal(bEnum)) {
                BAlarmRecord[] bAlarmRecordArray = this.getOtherNonNormals(bAlarmRecord);
                this.updateAlarmsToNormal(bAlarmRecordArray, eventNotificationParameters, bControlPoint, bAlarmDeviceExt);
            }
            this.updateAlarm(bAlarmRecord, eventNotificationParameters);
        }
        this.setBacnetData(bAlarmRecord, eventNotificationParameters);
        return bAlarmRecord;
    }

    protected long getProcessIdForEvent(BBacnetObjectIdentifier bBacnetObjectIdentifier, NEventSummary nEventSummary) {
        long l = 0L;
        try {
            BBacnetAddress bBacnetAddress = DeviceRegistry.getDeviceAddress(bBacnetObjectIdentifier);
            int n = AsnUtil.fromAsnUnsignedInt(this.comm().readProperty(bBacnetAddress, nEventSummary.getObjectId(), 17));
            byte[] byArray = this.comm().readProperty(bBacnetAddress, BBacnetObjectIdentifier.make(15, n), 102);
            AsnInputStream asnInputStream = new AsnInputStream(byArray);
            BBacnetDestination bBacnetDestination = new BBacnetDestination();
            while (asnInputStream.available() > 0) {
                bBacnetDestination.readAsn(asnInputStream);
                BBacnetRecipient bBacnetRecipient = bBacnetDestination.getRecipient();
                if (bBacnetRecipient.isAddress()) {
                    int n2 = bBacnetRecipient.getAddress().getNetworkNumber();
                    BBacnetNetworkLayer bBacnetNetworkLayer = ((BBacnetStack)this.comm()).getNetwork();
                    BNetworkPort bNetworkPort = bBacnetNetworkLayer.getPortByNetwork(n2);
                    if (bNetworkPort == null) continue;
                    byte[] byArray2 = bNetworkPort.getLink().getMacAddress();
                    if (!bBacnetRecipient.getAddress().equals(n2, byArray2)) continue;
                    l = bBacnetDestination.getProcessIdentifier().getLong();
                } else {
                    if (!bBacnetRecipient.getDevice().equals((Object)BBacnetNetwork.localDevice().getObjectId())) continue;
                    l = bBacnetDestination.getProcessIdentifier().getLong();
                }
                break;
            }
        }
        catch (Exception exception) {
            log.trace("Cannot determine processId for Event Summary:" + nEventSummary + ':' + exception + ";\n -- Using local processId...", (Throwable)exception);
        }
        return l;
    }

    protected BComponent findLocalAlarmSource(BBacnetDevice bBacnetDevice, NEventSummary nEventSummary) {
        return (BControlPoint)bBacnetDevice.lookupBacnetObject(nEventSummary.getObjectId(), 85, -1, "point");
    }

    protected boolean shouldBuildAlarm(NEventSummary nEventSummary, int n, BAlarmRecord bAlarmRecord) {
        boolean bl = nEventSummary.getEventEnable().getBit(n);
        boolean bl2 = nEventSummary.getAcknowledgedTransitions().getBit(n);
        if (!bl || bl2) {
            return false;
        }
        BBacnetTimeStamp bBacnetTimeStamp = nEventSummary.getEventTimeStamps()[n];
        if (this.isNull(bBacnetTimeStamp)) {
            return false;
        }
        if (bAlarmRecord == null) {
            return true;
        }
        BAbsTime bAbsTime = bAlarmRecord.getTimestamp();
        if (n == 2) {
            bAbsTime = bAlarmRecord.getNormalTime();
        }
        if (bAbsTime.equals((Object)BAbsTime.DEFAULT)) {
            return true;
        }
        return bBacnetTimeStamp.toBAbsTime().isAfter(bAbsTime);
    }

    private final boolean isNull(BBacnetTimeStamp bBacnetTimeStamp) {
        switch (bBacnetTimeStamp.getChoice()) {
            case 0: {
                return bBacnetTimeStamp.getTime().isAnyUnspecified();
            }
            case 2: {
                return bBacnetTimeStamp.getDateTime().isAnyUnspecified();
            }
        }
        return false;
    }

    private final int getEventStateFromTransition(int n) {
        switch (n) {
            case 2: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }

    protected void addLocalSource(BComponent bComponent, BAlarmRecord bAlarmRecord) {
        if (bComponent != null) {
            bAlarmRecord.addAlarmFacet("sourceName", (BIDataValue)BString.make((String)bComponent.getName()));
        }
    }

    protected final ErrorType validateAcknowledgement(AcknowledgeAlarmRequest acknowledgeAlarmRequest, BAlarmRecord bAlarmRecord, BAlarmService bAlarmService, BBacnetAddress bBacnetAddress, BBacnetEventSource bBacnetEventSource) {
        BEnum bEnum = acknowledgeAlarmRequest.getEventStateAcknowledged();
        int n = bEnum.getOrdinal();
        if (bAlarmRecord == null) {
            return new NErrorType(5, 73);
        }
        if (BBacnetEventState.isOffnormal(bEnum) && n != 2) {
            int n2 = 2;
            BInteger bInteger = (BInteger)bAlarmRecord.getAlarmFacet("offnormalToState");
            if (bInteger != null) {
                n2 = bInteger.getInt();
            }
            if (n != n2) {
                return new NErrorType(5, 73);
            }
        }
        if (!BEventHandler.timesMatch(acknowledgeAlarmRequest.getTimeStamp(), BEventHandler.getTimestamp(bAlarmRecord, bEnum))) {
            return new NErrorType(5, 14);
        }
        return null;
    }

    protected static final BAbsTime getTimestamp(BAlarmRecord bAlarmRecord, BEnum bEnum) {
        if (BBacnetEventState.isNormal(bEnum)) {
            return bAlarmRecord.getNormalTime();
        }
        return bAlarmRecord.getTimestamp();
    }

    protected static final boolean timesMatch(BBacnetTimeStamp bBacnetTimeStamp, BAbsTime bAbsTime) {
        if (bBacnetTimeStamp.getChoice() != 2) {
            return false;
        }
        BAbsTime bAbsTime2 = bBacnetTimeStamp.toBAbsTime();
        int n = 10;
        long l = bAbsTime2.getMillis() / (long)n;
        long l2 = bAbsTime.getMillis() / (long)n;
        boolean bl = false;
        if (l == l2) {
            bl = true;
        }
        return bl;
    }

    protected void checkForBufferReady(int n, BBacnetDevice bBacnetDevice, BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        BBacnetHistoryImport[] bBacnetHistoryImportArray;
        if (n == 10 && (bBacnetHistoryImportArray = ((BBacnetHistoryDeviceExt)bBacnetDevice.getTrendLogs()).findImportDescriptors(bBacnetObjectIdentifier)) != null) {
            int n2 = 0;
            while (n2 < bBacnetHistoryImportArray.length) {
                bBacnetHistoryImportArray[n2].setBufferReady(true);
                bBacnetHistoryImportArray[n2].execute();
                bBacnetHistoryImportArray[n2].setBufferReady(false);
                ++n2;
            }
        }
    }

    protected void updateAlarm(BAlarmRecord bAlarmRecord, EventNotificationParameters eventNotificationParameters) {
        String string = eventNotificationParameters.getTimeStamp().toString(BacnetConst.facetsContext);
        BEnum bEnum = eventNotificationParameters.getToState();
        BEnum bEnum2 = eventNotificationParameters.getFromState();
        bAlarmRecord.addAlarmFacet("toState", (BIDataValue)BString.make((String)bEnum.getTag()));
        bAlarmRecord.addAlarmFacet("fromState", (BIDataValue)BString.make((String)bEnum2.getTag()));
        bAlarmRecord.addAlarmFacet("BacnetTimestamp", (BIDataValue)BString.make((String)string));
        String string2 = eventNotificationParameters.getMessageText();
        if (string2 != null && string2.length() > 0) {
            bAlarmRecord.addAlarmFacet("msgText", (BIDataValue)BString.make((String)string2));
        }
        if (eventNotificationParameters.getAckRequired()) {
            BString bString = (BString)bAlarmRecord.getAlarmData().getFacet("bacnetAcksRequired");
            if (bString != null) {
                String string3 = bString.getString();
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ";");
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = false;
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    if (string4.startsWith(bEnum.getTag())) {
                        string4 = string4.substring(0, string4.indexOf("@") + 1) + string;
                        bl = true;
                    }
                    stringBuffer.append(string4).append(';');
                }
                bString = !bl ? BString.make((String)stringBuffer.append(bEnum.getTag()).append('@').append(string).toString()) : BString.make((String)stringBuffer.substring(0, stringBuffer.length() - 1));
            } else {
                bString = BString.make((String)(bEnum.getTag() + '@' + string));
            }
            bAlarmRecord.addAlarmFacet("bacnetAcksRequired", (BIDataValue)bString);
        } else {
            bAlarmRecord.setAckRequired(false);
        }
    }

    protected void setBacnetData(BAlarmRecord bAlarmRecord, EventNotificationParameters eventNotificationParameters) {
        BEnum bEnum = eventNotificationParameters.getToState();
        switch (bEnum.getOrdinal()) {
            case 1: {
                bAlarmRecord.setSourceState(BSourceState.fault);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                bAlarmRecord.setSourceState(BSourceState.offnormal);
                break;
            }
            default: {
                bAlarmRecord.setNormalTime(eventNotificationParameters.getTimeStamp().toBAbsTime());
                bAlarmRecord.setSourceState(BSourceState.normal);
            }
        }
        bAlarmRecord.setPriority(eventNotificationParameters.getPriority());
        if (eventNotificationParameters.getAckRequired()) {
            bAlarmRecord.setAckState(BAckState.unacked);
        }
    }

    private final void ackNiagara(BAlarmRecord bAlarmRecord, BEnum bEnum) {
        bAlarmRecord.ackAlarm();
        bAlarmRecord.setAckState(BAckState.acked);
        BObject bObject = bAlarmRecord.getAlarmData().getFacet("bacnetAcksRequired");
        if (bObject == null) {
            return;
        }
        if (bObject instanceof BString) {
            String string = ((BString)bObject).getString();
            int n = string.indexOf(bEnum.getTag());
            if (n >= 0) {
                int n2 = string.indexOf(";", n);
                if (n2 < 0) {
                    n2 = string.length();
                }
                if ((string = new StringBuffer(string).delete(n, n2).toString()).startsWith(";")) {
                    string = string.substring(1);
                }
                bAlarmRecord.addAlarmFacet("bacnetAcksRequired", (BIDataValue)BString.make((String)string));
            }
        } else if (bObject instanceof BInteger) {
            int n = ((BInteger)bObject).getInt();
            if (BBacnetEventState.isOffnormal(bEnum)) {
                n &= 0xFFFFFFFB;
            }
            if (BBacnetEventState.isFault(bEnum)) {
                n &= 0xFFFFFFFD;
            }
            if (BBacnetEventState.isNormal(bEnum)) {
                n &= 0xFFFFFFFE;
            }
            bAlarmRecord.addAlarmFacet("bacnetAcksRequired", (BIDataValue)BInteger.make((int)n));
        }
    }

    private final BBacnetComm comm() {
        return BBacnetNetwork.bacnet().getBacnetComm();
    }

    static void dumpAlarm(BAlarmRecord bAlarmRecord, boolean bl) {
        if (bAlarmRecord == null) {
            return;
        }
        System.out.println("\n" + bAlarmRecord);
        if (bl) {
            System.out.println("      Facets:" + bAlarmRecord.getAlarmData());
        }
    }

    protected static int getAlarmTransitionBit(BEnum bEnum) {
        switch (bEnum.getOrdinal()) {
            case 0: {
                return 4;
            }
            case 1: {
                return 2;
            }
        }
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final BAlarmRecord[] getOtherUnackeds(BAlarmRecord bAlarmRecord) {
        Class clazz = class$javax$baja$alarm$BAlarmRecord;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$BAlarmRecord = BEventHandler.class("[Ljavax.baja.alarm.BAlarmRecord;", false);
        }
        Array array = new Array(clazz);
        try {
            BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            BAlarmDatabase bAlarmDatabase = bAlarmService.getAlarmDb();
            BObject bObject = bAlarmRecord.getSource().get(0).get((BObject)this);
            if (bObject instanceof BBacnetAlarmDeviceExt) return (BAlarmRecord[])array.trim();
            Cursor cursor = bAlarmDatabase.getAlarmsForSource(bAlarmRecord.getSource());
            BUuid bUuid = bAlarmRecord.getUuid();
            while (true) {
                Class clazz2;
                if ((clazz2 = class$javax$baja$alarm$BAlarmRecord) == null) {
                    clazz2 = BEventHandler.class("[Ljavax.baja.alarm.BAlarmRecord;", false);
                }
                if (!cursor.next(clazz2)) {
                    return (BAlarmRecord[])array.trim();
                }
                BAlarmRecord bAlarmRecord2 = (BAlarmRecord)cursor.get().asComplex().newCopy();
                if (bUuid.equals((Object)bAlarmRecord2.getUuid()) || bAlarmRecord2.getAckState() == BAckState.acked) continue;
                array.add((Object)bAlarmRecord2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return (BAlarmRecord[])array.trim();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final BAlarmRecord[] getOtherNonNormals(BAlarmRecord bAlarmRecord) {
        Class clazz = class$javax$baja$alarm$BAlarmRecord;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$BAlarmRecord = BEventHandler.class("[Ljavax.baja.alarm.BAlarmRecord;", false);
        }
        Array array = new Array(clazz);
        try {
            BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            BAlarmDatabase bAlarmDatabase = bAlarmService.getAlarmDb();
            Cursor cursor = bAlarmDatabase.getAlarmsForSource(bAlarmRecord.getSource());
            BUuid bUuid = bAlarmRecord.getUuid();
            while (true) {
                Class clazz2;
                if ((clazz2 = class$javax$baja$alarm$BAlarmRecord) == null) {
                    clazz2 = BEventHandler.class("[Ljavax.baja.alarm.BAlarmRecord;", false);
                }
                if (!cursor.next(clazz2)) {
                    return (BAlarmRecord[])array.trim();
                }
                BAlarmRecord bAlarmRecord2 = (BAlarmRecord)cursor.get().asComplex().newCopy();
                if (bUuid.equals((Object)bAlarmRecord2.getUuid()) || bAlarmRecord2.isNormal()) continue;
                array.add((Object)bAlarmRecord2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return (BAlarmRecord[])array.trim();
    }

    private final void updateAlarmsToNormal(BAlarmRecord[] bAlarmRecordArray, EventNotificationParameters eventNotificationParameters, BControlPoint bControlPoint, BAlarmDeviceExt bAlarmDeviceExt) {
        int n = 0;
        while (n < bAlarmRecordArray.length) {
            this.updateAlarm(bAlarmRecordArray[n], eventNotificationParameters);
            this.setBacnetData(bAlarmRecordArray[n], eventNotificationParameters);
            this.addSourceAndRoute(bAlarmRecordArray[n], bControlPoint, bAlarmDeviceExt);
            ++n;
        }
    }

    private final void addSourceAndRoute(BAlarmRecord bAlarmRecord, BControlPoint bControlPoint, BAlarmDeviceExt bAlarmDeviceExt) {
        if (bControlPoint != null) {
            bAlarmRecord.addAlarmFacet("sourceName", (BIDataValue)BString.make((String)bControlPoint.getName()));
        }
        bAlarmDeviceExt.routeAlarm(bAlarmRecord);
    }

    protected static final int getNiagaraSourceState(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
        }
        return 1;
    }

    private final BHashedEventBuffer getEventBuffer(int n) {
        switch (n) {
            case 1: {
                return this.getToFaultBuffer();
            }
            case 0: {
                return this.getToNormalBuffer();
            }
        }
        return this.getToOffnormalBuffer();
    }

    private final BHashedEventBuffer getEventBuffer(BSourceState bSourceState) {
        switch (bSourceState.getOrdinal()) {
            case 1: {
                return this.getToOffnormalBuffer();
            }
            case 2: {
                return this.getToFaultBuffer();
            }
            case 0: {
                return this.getToNormalBuffer();
            }
        }
        log.error("Unknown source state! " + bSourceState);
        throw new IllegalArgumentException("Invalid source state:" + bSourceState);
    }

    private final BFacets buildAlarmData(EventNotificationParameters eventNotificationParameters) {
        BacnetNotificationParameters bacnetNotificationParameters;
        BEnum bEnum;
        String string;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("processId", BString.make((String)Long.toString(eventNotificationParameters.getProcessId())));
        hashMap.put("deviceId", BString.make((String)eventNotificationParameters.getInitiatingDeviceId().toString(BacnetConst.facetsContext)));
        hashMap.put("objectId", BString.make((String)eventNotificationParameters.getEventObjectId().toString(BacnetConst.facetsContext)));
        hashMap.put("NC", BString.make((String)Long.toString(eventNotificationParameters.getNotificationClass())));
        hashMap.put("eventType", BString.make((String)eventNotificationParameters.getEventType().getTag()));
        hashMap.put("notifyType", BString.make((String)eventNotificationParameters.getNotifyType().getTag()));
        hashMap.put("toState", BString.make((String)eventNotificationParameters.getToState().getTag()));
        hashMap.put("BacnetTimestamp", BString.make((String)eventNotificationParameters.getTimeStamp().toString(BacnetConst.facetsContext)));
        hashMap.put("priority", BInteger.make((int)eventNotificationParameters.getPriority()));
        if (eventNotificationParameters.getAckRequired()) {
            hashMap.put("bacnetAcksRequired", BString.make((String)(eventNotificationParameters.getToState().getTag() + '@' + eventNotificationParameters.getTimeStamp().toString(BacnetConst.facetsContext))));
        }
        if ((string = eventNotificationParameters.getMessageText()) != null && string.length() > 0) {
            hashMap.put("msgText", BString.make((String)string));
        }
        if ((bEnum = eventNotificationParameters.getFromState()) != null) {
            hashMap.put("fromState", BString.make((String)bEnum.getTag()));
        }
        if ((bacnetNotificationParameters = eventNotificationParameters.getEventValues()) != null) {
            bacnetNotificationParameters.addAlarmData(hashMap);
        }
        return BFacets.make(hashMap);
    }

    private final BFacets buildAlarmData(NEventSummary nEventSummary, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n) {
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("processId", BString.make((String)String.valueOf(this.getEventSummaryProcessId())));
        hashMap.put("deviceId", BString.make((String)bBacnetObjectIdentifier.toString(BacnetConst.facetsContext)));
        hashMap.put("objectId", BString.make((String)nEventSummary.getObjectId().toString(BacnetConst.facetsContext)));
        hashMap.put("toState", BString.make((String)nEventSummary.getEventState().getTag()));
        hashMap.put("BacnetTimestamp", BString.make((String)nEventSummary.getEventTimeStamps()[n].toString(BacnetConst.facetsContext)));
        hashMap.put("notifyType", BString.make((String)nEventSummary.getNotifyType().getTag()));
        hashMap.put("ackedTransitions", BString.make((String)nEventSummary.getAcknowledgedTransitions().toString(BacnetBitStringUtil.BacnetEventTransitionBits)));
        BBacnetTimeStamp[] bBacnetTimeStampArray = nEventSummary.getEventTimeStamps();
        hashMap.put("eventTimeStamps", BString.make((String)(bBacnetTimeStampArray[0].toString(BacnetConst.facetsContext) + ',' + bBacnetTimeStampArray[1].toString(BacnetConst.facetsContext) + ',' + bBacnetTimeStampArray[2].toString(BacnetConst.facetsContext))));
        hashMap.put("eventEnable", BString.make((String)nEventSummary.getEventEnable().toString(BacnetBitStringUtil.BacnetEventTransitionBits)));
        int[] nArray = nEventSummary.getEventPriorities();
        hashMap.put("eventPriorities", BString.make((String)("" + nArray[0] + ',' + nArray[1] + ',' + nArray[2])));
        return BFacets.make(hashMap);
    }

    void addListener(EventNotificationListener eventNotificationListener, int n) {
        switch (n) {
            case 2: {
                this.confirmedEventListeners.add(eventNotificationListener);
                break;
            }
            case 29: {
                this.unconfirmedEventListeners.add(eventNotificationListener);
                break;
            }
        }
    }

    void removeListener(EventNotificationListener eventNotificationListener, int n) {
        try {
            switch (n) {
                case 2: {
                    this.confirmedEventListeners.remove(eventNotificationListener);
                    break;
                }
                case 29: {
                    this.unconfirmedEventListeners.remove(eventNotificationListener);
                    break;
                }
            }
        }
        catch (Exception exception) {}
    }

    private final void routeToConfirmedListeners(ConfirmedEventNotificationRequest confirmedEventNotificationRequest, BBacnetAddress bBacnetAddress) {
        int n = this.confirmedEventListeners.size();
        if (n == 0) {
            return;
        }
        EventNotificationParameters eventNotificationParameters = confirmedEventNotificationRequest.getEventNotificationParameters();
        int n2 = 0;
        while (n2 < n) {
            ((EventNotificationListener)this.confirmedEventListeners.get(n2)).receiveConfirmedEventNotification(bBacnetAddress, eventNotificationParameters.getProcessId(), eventNotificationParameters.getInitiatingDeviceId(), eventNotificationParameters.getEventObjectId(), eventNotificationParameters.getTimeStamp(), eventNotificationParameters.getNotificationClass(), eventNotificationParameters.getPriority(), eventNotificationParameters.getEventType(), eventNotificationParameters.getMessageText(), eventNotificationParameters.getNotifyType(), eventNotificationParameters.getAckRequired(), eventNotificationParameters.getFromState(), eventNotificationParameters.getToState(), eventNotificationParameters.getRawEventValues(), eventNotificationParameters.getEncoding());
            ++n2;
        }
    }

    private final void routeToUnconfirmedListeners(UnconfirmedEventNotificationRequest unconfirmedEventNotificationRequest, BBacnetAddress bBacnetAddress) {
        int n = this.unconfirmedEventListeners.size();
        if (n == 0) {
            return;
        }
        EventNotificationParameters eventNotificationParameters = unconfirmedEventNotificationRequest.getEventNotificationParameters();
        int n2 = 0;
        while (n2 < n) {
            ((EventNotificationListener)this.unconfirmedEventListeners.get(n2)).receiveUnconfirmedEventNotification(bBacnetAddress, eventNotificationParameters.getProcessId(), eventNotificationParameters.getInitiatingDeviceId(), eventNotificationParameters.getEventObjectId(), eventNotificationParameters.getTimeStamp(), eventNotificationParameters.getNotificationClass(), eventNotificationParameters.getPriority(), eventNotificationParameters.getEventType(), eventNotificationParameters.getMessageText(), eventNotificationParameters.getNotifyType(), eventNotificationParameters.getAckRequired(), eventNotificationParameters.getFromState(), eventNotificationParameters.getToState(), eventNotificationParameters.getRawEventValues(), eventNotificationParameters.getEncoding());
            ++n2;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.confirmedEventListeners = new Vector();
        this.unconfirmedEventListeners = new Vector();
    }

    public BEventHandler() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$bacnet$stack$server$BEventHandler;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$stack$server$BEventHandler = BEventHandler.class("[Lcom.tridium.bacnet.stack.server.BEventHandler;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"bacnet.server");
    }
}

