/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.server;

import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.services.BacnetAbort;
import com.tridium.bacnet.services.BacnetComplexAck;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.BacnetError;
import com.tridium.bacnet.services.BacnetReject;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.BacnetSimpleAck;
import com.tridium.bacnet.services.BacnetUnconfirmedRequest;
import com.tridium.bacnet.services.error.SimpleError;
import com.tridium.bacnet.services.unconfirmed.IAmRequest;
import com.tridium.bacnet.services.unconfirmed.IHaveRequest;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.IAmListener;
import com.tridium.bacnet.stack.IHaveListener;
import com.tridium.bacnet.stack.network.BNetworkPriority;
import com.tridium.bacnet.stack.server.BEventHandler;
import com.tridium.bacnet.stack.server.CovHandler;
import com.tridium.bacnet.stack.server.DeviceHandler;
import com.tridium.bacnet.stack.server.FileHandler;
import com.tridium.bacnet.stack.server.PrivateTransferHandler;
import com.tridium.bacnet.stack.server.PropertyHandler;
import com.tridium.bacnet.stack.server.TimeSyncHandler;
import com.tridium.bacnet.stack.transport.BBacnetTransportLayer;
import java.io.IOException;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConfirmedServiceChoice;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.BacnetUnconfirmedServiceChoice;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetDeviceStatus;
import javax.baja.bacnet.enums.BCharacterSetEncoding;
import javax.baja.bacnet.export.BBacnetFileDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.BacnetServiceListener;
import javax.baja.bacnet.io.EventNotificationListener;
import javax.baja.bacnet.io.PrivateTransferListener;
import javax.baja.bacnet.io.RejectException;
import javax.baja.bacnet.util.BBacnetWorker;
import javax.baja.bacnet.util.worker.IBacnetAddress;
import javax.baja.file.BIFile;
import javax.baja.log.Log;
import javax.baja.nre.util.IntHashMap;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.util.QueueFullException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetServerLayer
extends BComponent
implements BacnetConfirmedServiceChoice,
BacnetUnconfirmedServiceChoice {
    public static final Property worker = BBacnetServerLayer.newProperty((int)0, (BValue)new BBacnetWorker("BacnetServer:worker"), null);
    public static final Property eventHandler = BBacnetServerLayer.newProperty((int)0, (BValue)new BEventHandler(), null);
    public static final Property reinitializeAllowed = BBacnetServerLayer.newProperty((int)4, (boolean)false, null);
    public static final Property timeSynchAllowed = BBacnetServerLayer.newProperty((int)4, (boolean)true, null);
    public static final Property confirmedWorker = BBacnetServerLayer.newProperty((int)0, (BValue)new BBacnetWorker("BacnetServer:confirmedWorker"), null);
    public static final Action checkBackupComm = BBacnetServerLayer.newAction((int)4, null);
    public static final Type TYPE;
    public static final String BACNET_USER = "Bacnet";
    public static final int NO_INVOKE_ID = -1;
    private static Log log;
    private Object lock;
    private DeviceHandler deviceHandler;
    private PropertyHandler propertyHandler;
    private FileHandler fileHandler;
    private CovHandler covHandler;
    private TimeSyncHandler timeSyncHandler;
    private PrivateTransferHandler privateTransferHandler;
    private Lexicon lex;
    BBacnetObjectIdentifier backupFileId;
    Clock.Ticket exitBackupTicket;
    BBacnetAddress backupRestoreClientAddress;
    long lastBackupCommTime;
    static /* synthetic */ Class class$com$tridium$bacnet$stack$server$BBacnetServerLayer;

    public BBacnetWorker getWorker() {
        return (BBacnetWorker)this.get(worker);
    }

    public void setWorker(BBacnetWorker bBacnetWorker) {
        this.set(worker, (BValue)bBacnetWorker, null);
    }

    public BEventHandler getEventHandler() {
        return (BEventHandler)this.get(eventHandler);
    }

    public void setEventHandler(BEventHandler bEventHandler) {
        this.set(eventHandler, (BValue)bEventHandler, null);
    }

    public boolean getReinitializeAllowed() {
        return this.getBoolean(reinitializeAllowed);
    }

    public void setReinitializeAllowed(boolean bl) {
        this.setBoolean(reinitializeAllowed, bl, null);
    }

    public boolean getTimeSynchAllowed() {
        return this.getBoolean(timeSynchAllowed);
    }

    public void setTimeSynchAllowed(boolean bl) {
        this.setBoolean(timeSynchAllowed, bl, null);
    }

    public BBacnetWorker getConfirmedWorker() {
        return (BBacnetWorker)this.get(confirmedWorker);
    }

    public void setConfirmedWorker(BBacnetWorker bBacnetWorker) {
        this.set(confirmedWorker, (BValue)bBacnetWorker, null);
    }

    public void checkBackupComm() {
        this.invoke(checkBackupComm, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.deviceHandler = new DeviceHandler(this);
        this.propertyHandler = new PropertyHandler(this);
        this.fileHandler = new FileHandler(this);
        this.covHandler = new CovHandler();
        this.timeSyncHandler = new TimeSyncHandler(this);
        this.privateTransferHandler = new PrivateTransferHandler(this);
    }

    public void stackStopped() {
        this.deviceHandler = null;
        this.propertyHandler = null;
        this.fileHandler = null;
        this.covHandler = null;
        this.timeSyncHandler = null;
        this.privateTransferHandler = null;
    }

    public final boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BBacnetStack;
    }

    final BBacnetStack stack() {
        return (BBacnetStack)this.getParent();
    }

    void scheduleBackupRestoreFailure() {
        if (this.exitBackupTicket != null) {
            this.exitBackupTicket.cancel();
        }
        this.exitBackupTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)30), (Action)checkBackupComm, null);
    }

    public void doCheckBackupComm() {
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        long l = Clock.ticks() - this.lastBackupCommTime;
        log.trace("Checking backup comms: lastBackupCommTime=" + this.lastBackupCommTime + "; time since last comm=" + l);
        if (l > bLocalBacnetDevice.getBackupFailureTimeout().getMillis()) {
            log.message("Last comm time was " + l + " ms ago; Backup_Failure_Timeout is " + bLocalBacnetDevice.getBackupFailureTimeout() + "; exiting Backup/Restore mode...");
            if (bLocalBacnetDevice.getSystemStatus() == BBacnetDeviceStatus.backupInProgress) {
                bLocalBacnetDevice.setBackupMode(BBoolean.FALSE);
            } else if (bLocalBacnetDevice.getSystemStatus() == BBacnetDeviceStatus.downloadInProgress) {
                bLocalBacnetDevice.setRestoreMode(BBoolean.FALSE);
            }
            if (this.exitBackupTicket != null) {
                this.exitBackupTicket.cancel();
            }
            this.exitBackupTicket = null;
        }
    }

    void updateLastBackupCommunicationTime() {
        this.lastBackupCommTime = Clock.ticks();
    }

    public void cleanupBackupMode() {
        this.backupRestoreClientAddress = null;
        BIFile bIFile = this.deviceHandler.backupFile;
        BBacnetFileDescriptor bBacnetFileDescriptor = this.deviceHandler.exportFile;
        if (bIFile != null) {
            try {
                bIFile.delete();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.deviceHandler.backupFile = null;
        }
        if (bBacnetFileDescriptor != null) {
            BBacnetNetwork.localDevice().getExportTable().remove((BComplex)bBacnetFileDescriptor);
            BBacnetNetwork.localDevice().getConfigurationFiles().setSize(0);
            this.deviceHandler.exportFile = null;
        }
    }

    public void iAm() {
        if (!this.stack().isCommExecutionEnabled()) {
            return;
        }
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        IAmRequest iAmRequest = new IAmRequest(bLocalBacnetDevice.getObjectId(), bLocalBacnetDevice.getMaxAPDULengthAccepted(), bLocalBacnetDevice.getSegmentationSupported(), bLocalBacnetDevice.getVendorId());
        if (log.isTraceOn()) {
            log.trace("Server.Sending I-Am....\n" + iAmRequest);
        }
        try {
            this.transport().sendUnconfirmedRequest(iAmRequest, BBacnetAddress.GLOBAL_BROADCAST_ADDRESS, BNetworkPriority.normal);
        }
        catch (BacnetException bacnetException) {
            log.error("Exception sending I-Have service!", (Throwable)((Object)bacnetException));
        }
    }

    public void iHave(BBacnetObjectIdentifier bBacnetObjectIdentifier, String string, BCharacterSetEncoding bCharacterSetEncoding) {
        if (!this.stack().isCommExecutionEnabled()) {
            return;
        }
        IHaveRequest iHaveRequest = new IHaveRequest(this.bacnet().getObjectId(), bBacnetObjectIdentifier, string, bCharacterSetEncoding);
        if (log.isTraceOn()) {
            log.trace("Server.Sending I-Have....\n" + iHaveRequest);
        }
        try {
            this.transport().sendUnconfirmedRequest(iHaveRequest, BBacnetAddress.GLOBAL_BROADCAST_ADDRESS, BNetworkPriority.normal);
        }
        catch (BacnetException bacnetException) {
            log.error("Exception sending I-Have service!", (Throwable)((Object)bacnetException));
        }
    }

    public void receiveConfirmedRequest(BBacnetAddress bBacnetAddress, int n, BacnetConfirmedRequest bacnetConfirmedRequest, BNetworkPriority bNetworkPriority) {
        ServerRequest serverRequest = new ServerRequest(bBacnetAddress, n, bacnetConfirmedRequest, bNetworkPriority);
        try {
            this.getConfirmedWorker().post(serverRequest);
        }
        catch (QueueFullException queueFullException) {
            queueFullException.printStackTrace();
        }
    }

    public void receiveUnconfirmedRequest(BBacnetAddress bBacnetAddress, BacnetUnconfirmedRequest bacnetUnconfirmedRequest, BNetworkPriority bNetworkPriority) {
        ServerRequest serverRequest = new ServerRequest(bBacnetAddress, -1, bacnetUnconfirmedRequest, bNetworkPriority);
        try {
            this.getWorker().post(serverRequest);
        }
        catch (QueueFullException queueFullException) {
            queueFullException.printStackTrace();
        }
    }

    protected void process(ServerRequest serverRequest) {
        try {
            switch (serverRequest.getType()) {
                case 0: {
                    this.processConfirmedRequest(serverRequest);
                    break;
                }
                case 1: {
                    this.processUnconfirmedRequest(serverRequest);
                    break;
                }
                default: {
                    log.message("Bacnet server request ignored: " + serverRequest.getType());
                    break;
                }
            }
        }
        catch (RejectException rejectException) {
            this.transport().sendConfirmedResponse(serverRequest.getSrcAddr(), serverRequest.getInvokeId(), new BacnetReject(rejectException.getRejectReason()), serverRequest.getNetworkPriority());
        }
        catch (Exception exception) {
            log.error("Bacnet Server Error!", (Throwable)exception);
            exception.printStackTrace();
        }
    }

    private final void processUnconfirmedRequest(ServerRequest serverRequest) {
        BBacnetAddress bBacnetAddress;
        BacnetUnconfirmedRequest bacnetUnconfirmedRequest = (BacnetUnconfirmedRequest)serverRequest.getRequest();
        BacnetUnconfirmedServiceChoice bacnetUnconfirmedServiceChoice = null;
        if (this.backupRestoreClientAddress != null && !this.backupRestoreClientAddress.equals((bBacnetAddress = serverRequest.getAddress()).getNetworkNumber(), bBacnetAddress.getMacAddress().getBytes()) && log.isTraceOn()) {
            log.trace("Unconfirmed Request from non-backup client ignored...");
        }
        int n = bacnetUnconfirmedRequest.getServiceChoice();
        switch (n) {
            case 0: 
            case 1: 
            case 7: 
            case 8: {
                bacnetUnconfirmedServiceChoice = this.deviceHandler;
                break;
            }
            case 3: {
                bacnetUnconfirmedServiceChoice = this.getEventHandler();
                break;
            }
            case 2: {
                bacnetUnconfirmedServiceChoice = this.covHandler;
                break;
            }
            case 6: 
            case 9: {
                bacnetUnconfirmedServiceChoice = this.timeSyncHandler;
                break;
            }
            case 4: {
                bacnetUnconfirmedServiceChoice = this.privateTransferHandler;
                break;
            }
            default: {
                log.message("BBacnetServerLayer:Unknown unconfirmed service choice encountered " + n);
            }
        }
        if (bacnetUnconfirmedServiceChoice != null) {
            bacnetUnconfirmedServiceChoice.receiveRequest(n, bacnetUnconfirmedRequest, serverRequest.getSrcAddr());
        } else {
            log.warning("BBacnetServerLayer: No handler for request! " + bacnetUnconfirmedRequest);
        }
    }

    private final void processConfirmedRequest(ServerRequest serverRequest) throws RejectException {
        BacnetConfirmedRequest bacnetConfirmedRequest = (BacnetConfirmedRequest)serverRequest.getRequest();
        BacnetConfirmedServiceChoice bacnetConfirmedServiceChoice = null;
        if (this.checkBackupRestoreState(serverRequest, bacnetConfirmedRequest)) {
            return;
        }
        int n = bacnetConfirmedRequest.getServiceChoice();
        boolean bl = BBacnetNetwork.localDevice().getProtocolServicesSupported().getBit(bacnetConfirmedRequest.getServiceBitIndex());
        if (!bl) {
            log.trace("Throwing reject for unsupported service:" + n + " [" + BacnetConfirmedServiceChoice.TAGS[n] + ']');
            throw new RejectException(9);
        }
        switch (n) {
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 26: {
                bacnetConfirmedServiceChoice = this.propertyHandler;
                break;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 29: {
                bacnetConfirmedServiceChoice = this.getEventHandler();
                break;
            }
            case 1: 
            case 5: 
            case 28: {
                bacnetConfirmedServiceChoice = this.covHandler;
                break;
            }
            case 6: 
            case 7: {
                bacnetConfirmedServiceChoice = this.fileHandler;
                break;
            }
            case 17: 
            case 20: {
                bacnetConfirmedServiceChoice = this.deviceHandler;
                break;
            }
            case 18: {
                bacnetConfirmedServiceChoice = this.privateTransferHandler;
                break;
            }
            default: {
                log.message("BBacnetServerLayer:Unknown confirmed service choice encountered " + n);
                throw new RejectException(9);
            }
        }
        if (bacnetConfirmedServiceChoice == null) {
            log.warning("BBacnetServerLayer: No handler for request! " + bacnetConfirmedRequest);
        } else {
            BacnetServicePrimitive bacnetServicePrimitive = bacnetConfirmedServiceChoice.receiveRequest(n, bacnetConfirmedRequest, serverRequest.getSrcAddr());
            switch (bacnetServicePrimitive.getServiceType()) {
                case 3: {
                    this.transport().sendConfirmedResponse(serverRequest.getSrcAddr(), serverRequest.getInvokeId(), (BacnetComplexAck)bacnetServicePrimitive, serverRequest.getNetworkPriority());
                    break;
                }
                case 2: {
                    this.transport().sendConfirmedResponse(serverRequest.getSrcAddr(), serverRequest.getInvokeId(), (BacnetSimpleAck)bacnetServicePrimitive, serverRequest.getNetworkPriority());
                    break;
                }
                case 5: {
                    this.transport().sendConfirmedResponse(serverRequest.getSrcAddr(), serverRequest.getInvokeId(), (BacnetError)bacnetServicePrimitive, serverRequest.getNetworkPriority());
                    break;
                }
                case 7: {
                    this.transport().sendConfirmedResponse(serverRequest.getSrcAddr(), serverRequest.getInvokeId(), (BacnetAbort)bacnetServicePrimitive, serverRequest.getNetworkPriority());
                    break;
                }
                case 6: {
                    this.transport().sendConfirmedResponse(serverRequest.getSrcAddr(), serverRequest.getInvokeId(), (BacnetReject)bacnetServicePrimitive, serverRequest.getNetworkPriority());
                    break;
                }
                default: {
                    log.error("BBacnetServerLayer:Unknown response type from handler! " + bacnetServicePrimitive.getServiceType());
                }
            }
        }
    }

    private final boolean checkBackupRestoreState(ServerRequest serverRequest, BacnetConfirmedRequest bacnetConfirmedRequest) {
        BBacnetAddress bBacnetAddress;
        if (this.backupRestoreClientAddress != null && !this.backupRestoreClientAddress.equals((bBacnetAddress = serverRequest.getAddress()).getNetworkNumber(), bBacnetAddress.getMacAddress().getBytes())) {
            if (log.isTraceOn()) {
                System.out.println("Source Address:" + serverRequest.getSrcAddr() + ", backupRestoreClientAddress:" + this.backupRestoreClientAddress);
                log.trace("Confirmed Request from non-backup client rejected...");
            }
            this.transport().sendConfirmedResponse(serverRequest.getSrcAddr(), serverRequest.getInvokeId(), new SimpleError(bacnetConfirmedRequest.getServiceChoice(), new NErrorType(0, 2)), serverRequest.getNetworkPriority());
            return true;
        }
        return false;
    }

    public void registerBacnetServiceListener(BacnetServiceListener bacnetServiceListener, int n) {
        if (bacnetServiceListener == null) {
            return;
        }
        String string = this.lex.getText("BacnetServicesSupported.bit" + n);
        boolean bl = false;
        try {
            switch (n) {
                case 2: {
                    if (bacnetServiceListener instanceof EventNotificationListener) {
                        this.getEventHandler().addListener((EventNotificationListener)bacnetServiceListener, n);
                        break;
                    }
                    bl = true;
                    break;
                }
                case 18: {
                    if (bacnetServiceListener instanceof PrivateTransferListener) {
                        this.privateTransferHandler.addListener((PrivateTransferListener)bacnetServiceListener, true);
                        break;
                    }
                    bl = true;
                    break;
                }
                case 26: {
                    if (bacnetServiceListener instanceof IAmListener) {
                        this.deviceHandler.addIAmListener((IAmListener)bacnetServiceListener);
                        break;
                    }
                    bl = true;
                    break;
                }
                case 27: {
                    if (bacnetServiceListener instanceof IHaveListener) {
                        this.deviceHandler.addIHaveListener((IHaveListener)bacnetServiceListener);
                        break;
                    }
                    bl = true;
                    break;
                }
                case 29: {
                    if (bacnetServiceListener instanceof EventNotificationListener) {
                        this.getEventHandler().addListener((EventNotificationListener)bacnetServiceListener, n);
                        break;
                    }
                    bl = true;
                    break;
                }
                case 30: {
                    if (bacnetServiceListener instanceof PrivateTransferListener) {
                        this.privateTransferHandler.addListener((PrivateTransferListener)bacnetServiceListener, false);
                        break;
                    }
                    bl = true;
                    break;
                }
            }
        }
        catch (Exception exception) {
            log.warning("Unable to register " + bacnetServiceListener.getClass() + " for service " + string + ':' + exception, (Throwable)exception);
        }
        if (bl) {
            log.warning("Listener/Service mismatch: attempt to register " + bacnetServiceListener.getClass() + " for service " + string);
        } else {
            log.message("Listener " + bacnetServiceListener + " registered for service:" + string);
        }
    }

    public void unregisterBacnetServiceListener(BacnetServiceListener bacnetServiceListener, int n) {
        if (bacnetServiceListener == null) {
            return;
        }
        String string = this.lex.getText("BacnetServicesSupported.bit" + n);
        boolean bl = false;
        switch (n) {
            case 2: {
                if (bacnetServiceListener instanceof EventNotificationListener) {
                    this.getEventHandler().removeListener((EventNotificationListener)bacnetServiceListener, n);
                    break;
                }
                bl = true;
                break;
            }
            case 18: {
                if (bacnetServiceListener instanceof PrivateTransferListener) {
                    this.privateTransferHandler.removeListener((PrivateTransferListener)bacnetServiceListener, true);
                    break;
                }
                bl = true;
                break;
            }
            case 26: {
                if (bacnetServiceListener instanceof IAmListener) {
                    this.deviceHandler.removeIAmListener((IAmListener)bacnetServiceListener);
                    break;
                }
                bl = true;
                break;
            }
            case 27: {
                if (bacnetServiceListener instanceof IHaveListener) {
                    this.deviceHandler.removeIHaveListener((IHaveListener)bacnetServiceListener);
                    break;
                }
                bl = true;
                break;
            }
            case 29: {
                if (bacnetServiceListener instanceof EventNotificationListener) {
                    this.getEventHandler().removeListener((EventNotificationListener)bacnetServiceListener, n);
                    break;
                }
                bl = true;
                break;
            }
            case 30: {
                if (bacnetServiceListener instanceof PrivateTransferListener) {
                    this.privateTransferHandler.removeListener((PrivateTransferListener)bacnetServiceListener, false);
                    break;
                }
                bl = true;
                break;
            }
        }
        if (bl) {
            log.warning("Listener/Service mismatch: attempt to unregister " + bacnetServiceListener.getClass() + " for service " + string);
        } else {
            log.message("Listener " + bacnetServiceListener + " unregistered for service:" + string);
        }
    }

    public void registerPrivateTransferListener(PrivateTransferListener privateTransferListener) {
        System.out.println("This method is deprecated! Use registerBacnetServiceListener() instead.");
    }

    public void unregisterPrivateTransferListener(PrivateTransferListener privateTransferListener) {
        System.out.println("This method is deprecated! Use unregisterBacnetServiceListener() instead.");
    }

    public void registerIAmListener(IAmListener iAmListener) {
        this.deviceHandler.addIAmListener(iAmListener);
    }

    public void unregisterIAmListener(IAmListener iAmListener) {
        this.deviceHandler.removeIAmListener(iAmListener);
    }

    public void registerIHaveListener(IHaveListener iHaveListener) {
        this.deviceHandler.addIHaveListener(iHaveListener);
    }

    public void unregisterIHaveListener(IHaveListener iHaveListener) {
        this.deviceHandler.removeIHaveListener(iHaveListener);
    }

    BBacnetNetwork bacnet() {
        return (BBacnetNetwork)this.getParent().getParent();
    }

    private final BBacnetTransportLayer transport() {
        return ((BBacnetStack)this.getParent()).getTransport();
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        Object object;
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetServerLayer", 2);
        spyWriter.prop((Object)"deviceHandler", (Object)this.deviceHandler);
        spyWriter.prop((Object)"propertyHandler", (Object)this.propertyHandler);
        spyWriter.prop((Object)"fileHandler", (Object)this.fileHandler);
        spyWriter.prop((Object)"covHandler", (Object)this.covHandler);
        spyWriter.prop((Object)"timeSyncHandler", (Object)this.timeSyncHandler);
        spyWriter.prop((Object)"privateTransferHandler", (Object)this.privateTransferHandler);
        spyWriter.trTitle((Object)("Private Transfer ConfirmedListeners:" + this.privateTransferHandler.confirmedListeners.size()), 2);
        IntHashMap.Iterator iterator = this.privateTransferHandler.confirmedListeners.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            spyWriter.prop((Object)("  " + iterator.key()), object);
        }
        spyWriter.trTitle((Object)("Private Transfer UnconfirmedListeners:" + this.privateTransferHandler.unconfirmedListeners.size()), 2);
        iterator = this.privateTransferHandler.unconfirmedListeners.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            spyWriter.prop((Object)("  " + iterator.key()), object);
        }
        spyWriter.prop((Object)"backupFileId", (Object)this.backupFileId);
        spyWriter.prop((Object)"exitBackupTicket", (Object)this.exitBackupTicket);
        spyWriter.prop((Object)"now", (double)Clock.ticks());
        spyWriter.prop((Object)"lastBackupCommTime", (double)this.lastBackupCommTime);
        spyWriter.prop((Object)"backupRestoreClientAddress", (Object)this.backupRestoreClientAddress);
        spyWriter.endProps();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lock = new Object();
        this.lex = Lexicon.make((String)"bacnet");
        this.backupFileId = null;
        this.backupRestoreClientAddress = null;
        this.lastBackupCommTime = 0L;
    }

    public BBacnetServerLayer() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$bacnet$stack$server$BBacnetServerLayer;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$stack$server$BBacnetServerLayer = BBacnetServerLayer.class("[Lcom.tridium.bacnet.stack.server.BBacnetServerLayer;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"bacnet.server");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ServerRequest
    implements IBacnetAddress,
    Runnable {
        private BBacnetAddress srcAddr;
        private int invokeId;
        private BacnetServicePrimitive request;
        private BNetworkPriority networkPriority;

        public int getServiceType() {
            return this.getType();
        }

        public int getType() {
            return this.request.getServiceType();
        }

        public BacnetServicePrimitive getRequest() {
            return this.request;
        }

        public BBacnetAddress getAddress() {
            return this.srcAddr;
        }

        public BBacnetAddress getSrcAddr() {
            return this.srcAddr;
        }

        public int getInvokeId() {
            return this.invokeId;
        }

        public BNetworkPriority getNetworkPriority() {
            return this.networkPriority;
        }

        public void run() {
            BBacnetServerLayer.this.process(this);
        }

        public ServerRequest(BBacnetAddress bBacnetAddress, int n, BacnetServicePrimitive bacnetServicePrimitive, BNetworkPriority bNetworkPriority) {
            this.srcAddr = bBacnetAddress;
            this.invokeId = n;
            this.request = bacnetServicePrimitive;
            this.networkPriority = bNetworkPriority;
        }
    }
}

